{
  WLX Delphi Tutorial Plugin
  (c) 2004 Mutex Ltd. mutex@nm.ru
}

library ListSimple;
{$R *.res} //DLL version info

uses
  SysUtils,
  Windows,
  unMain in 'unMain.pas' {fmMain},
  unAbout in 'unAbout.pas' {fmAbout};

{$E wlx}

const
  PARSE_FUNCTION = 'FORCE | EXT="RTF"';
  SUPPORT_EXT = '.RTF';

procedure ListGetDetectString(DetectString: PChar; MaxLen: integer); stdcall;
begin
  StrLCopy(DetectString, PChar(PARSE_FUNCTION), MaxLen);
end;

function ListLoad(ListerWin: HWND; FileToLoad: PChar; ShowFlags: integer): HWND; stdcall;
begin
  Result := 0;
  if UpperCase(ExtractFileExt(FileToLoad)) <> SUPPORT_EXT then
    exit
  else
    Result := ShowRTF(ListerWin, FileToLoad);
end;

procedure ListCloseWindow(PluginWin: HWND); stdcall;
begin
  HideRTF(PluginWin);
end;

exports
  ListGetDetectString,
  ListLoad,
  ListCloseWindow;

end.
 
