{
  WLX Delphi Tutorial Plugin
  (c) 2004 Mutex Ltd. mutex@nm.ru
}

unit unMain;

interface

uses
  Windows, Messages, Controls, StdCtrls, ComCtrls, Classes, Menus, Forms,
  AppEvnts, SysUtils;

type
  TfmMain = class(TForm)
    RichEdit1: TRichEdit;
    PopupMenu1: TPopupMenu;
    Help1: TMenuItem;
    N1: TMenuItem;
    About1: TMenuItem;
    procedure RichEdit1KeyDown(Sender: TObject; var Key: Word; Shift: TShiftState);
    procedure Help1Click(Sender: TObject);
    procedure About1Click(Sender: TObject);
  private
    TotCmdWin: HWND;    //handle of TC window
    ParentWin: HWND;    //handle of Lister window
    QuickView: boolean; //Ctrl+Q panel
    procedure AppException(Sender: TObject; E: Exception);
  protected
    procedure CreateParams(var Params: TCreateParams); override;
  public
    //our constructor
    constructor CreateParented(ParentWindow: HWND; const FileToView: string); reintroduce;
  end;

function ShowRTF(ListerWin: HWND; FileToLoad: string): HWND;
procedure HideRTF(PluginWin: HWND);

implementation

uses unAbout;

{$R *.dfm}

procedure wMsgBox(hWnd: HWND; Msg: string);
begin
  MessageBox(hWnd, PChar(Msg), 'Message', MB_OK+MB_ICONINFORMATION);
end;

procedure TfmMain.RichEdit1KeyDown(Sender: TObject; var Key: Word; Shift: TShiftState);
begin
  //Alt+X -> TC close:
  if (Shift = [ssAlt]) and (Chr(Lo(Key)) = 'X') then begin
    Application.Handle := 0; //C++ GPF (Delphi AV)
    Application.RemoveComponent(Self);
    PostMessage(TotCmdWin, WM_SYSCOMMAND, SC_CLOSE, 0);
    exit;
  end;
  //hot keys of Lister:
  if Shift = [] then begin
    if Key = VK_ESCAPE then begin                 //File -> Exit (ESC)
      if not QuickView then
        PostMessage(ParentWin, WM_KEYDOWN, VK_ESCAPE, 0)
      else
        PostMessage(ParentWin, WM_KEYDOWN, VK_TAB, 0);
      Key := 0;
    end
    else if Chr(Lo(Key)) in ['N', 'P'] then begin
      PostMessage(ParentWin, WM_KEYDOWN, Key, 0); //File -> Next (N) or Prev (P)
      Key := 0;
    end
    else if Chr(Lo(Key)) in ['1'..'7'] then begin
      PostMessage(ParentWin, WM_KEYDOWN, Key, 0); //Options -> 1..7
      Key := 0;
    end
  end;
  //own dialogs:
  if (Shift = []) and (Key = VK_F1) then  //F1
    Help1.Click;
  if (Shift = []) and (Key = VK_F2) then  //F2
    About1.Click;
  RichEdit1.SetFocus;
end;

procedure TfmMain.Help1Click(Sender: TObject);
begin
  wMsgBox(Handle, 'Simple Lister plugin');
  RichEdit1.SetFocus;
end;

procedure TfmMain.About1Click(Sender: TObject);
var fmAbout: TfmAbout;
begin
  fmAbout := TfmAbout.Create(Self);
  try
    fmAbout.ShowModal;
  finally
    fmAbout.Free;
  end;
  RichEdit1.SetFocus;
end;

procedure TfmMain.AppException(Sender: TObject; E: Exception);
begin
  wMsgBox(Handle, 'Plugin Error:' + #13 + E.Message);
end;

procedure TfmMain.CreateParams(var Params: TCreateParams);
begin
  inherited CreateParams(Params);
  Params.Style := (WS_CHILD or WS_MAXIMIZE) and not WS_CAPTION and not WS_BORDER;
  Params.WindowClass.cbWndExtra := SizeOf(Pointer); //4 bytes for address of form
end;

constructor TfmMain.CreateParented(ParentWindow: HWND; const FileToView: string);
const WinCmdClassName = 'TTOTAL_CMD';
begin //non standard constructor
  inherited CreateParented(ParentWindow); //our window is child window
  TotCmdWin := FindWindow(WinCmdClassName, nil);
  ParentWin := ParentWindow;
  QuickView := GetParent(ParentWin) <> 0;
  RichEdit1.Lines.LoadFromFile(FileToView);
end;
{end of form}
//----------------------------------------------------------------------------------
{initialization and finalization}
type
  TPlugInfo = record
    PlugWinProc: Pointer; //callback function of our form
    PlugForm: TfmMain;    //our form
  end;

function HookDestroy(PluginWin: HWND; Msg, wParam, lParam: LongInt): LongInt; stdcall;
var p: ^TPlugInfo;
begin //hook destroy our window
  p := Pointer(GetWindowLong(PluginWin, GWL_USERDATA));
  if Msg <> WM_DESTROY then
    Result := CallWindowProc(p^.PlugWinProc, PluginWin, Msg, wParam, lParam)
  else begin //plugin close
    HideRTF(PluginWin);
    Result := 0;
  end;
end;

procedure HideRTF(PluginWin: HWND);
var p: ^TPlugInfo;
begin //finalization
  p := Pointer(GetWindowLong(PluginWin, GWL_USERDATA));
  with p^.PlugForm do begin
    try
      Application.RemoveComponent(p^.PlugForm);
      Application.Handle := 0;
      //restore callback function
      SetWindowLong(Handle, GWL_WNDPROC, Integer(p^.PlugWinProc));
      Free;
    except
      on E: Exception do
        wMsgBox(0, 'DestroyWindow error:' + #13 + E.Message);
    end;
  end;
  Dispose(p);
end;

function ShowRTF(ListerWin: HWND; FileToLoad: string): HWND;
var fmMain: TfmMain; s: string; p: ^TPlugInfo;
begin //initialization
  try
    s := ExtractFilePath(FileToLoad);
    if not SetCurrentDir(s) then  //folder of RTF
      raise Exception.Create('Error of SetCurrentDir() for Folder: ' + s);
    fmMain := TfmMain.CreateParented(ListerWin, FileToLoad);
    fmMain.Show;
    //synchronize our form and Lister
    Application.Handle := ListerWin;
    Application.OnException := fmMain.AppException;
    Application.InsertComponent(fmMain);
    //substitution callback function
    New(p);
    SetWindowLong(fmMain.Handle, GWL_USERDATA, Integer(p));
    p^.PlugForm := fmMain;
    p^.PlugWinProc := Pointer(SetWindowLong(fmMain.Handle, GWL_WNDPROC, Integer(@HookDestroy)));
    //set focus to our window
    if not fmMain.QuickView then begin
      PostMessage(fmMain.Handle, WM_SETFOCUS, 0, 0);
      fmMain.RichEdit1.SetFocus;
    end;
    Result := fmMain.Handle;
  except
    on E: Exception do begin
      wMsgBox(ListerWin, 'Open error:' + #13 + E.Message);
      Result := 0;
    end;
  end;
end;

end.

