/*
  WLX Delphi Tutorial Plugin
  (c) 2004 Mutex Ltd. mutex@nm.ru
*/
//---------------------------------------------------------------------------
#include <vcl.h>
#pragma hdrstop

#include "unMain.h"
#include "unAbout.h"
//---------------------------------------------------------------------------
#pragma package(smart_init)
#pragma resource "*.dfm"
//---------------------------------------------------------------------------
void wMsgBox(HWND hWnd, AnsiString Msg)
{
  MessageBox(hWnd, Msg.c_str(), "Message", MB_OK+MB_ICONINFORMATION);
}
//---------------------------------------------------------------------------
void __fastcall TfmMain::RichEdit1KeyDown(TObject *Sender, WORD &Key, TShiftState Shift)
{
  TShiftState wShift;
  //Alt+X -> TC close:
  wShift.Clear();
  wShift << ssAlt;
  if (Shift == wShift && Key == 'X')
  {
    Application->Handle = 0;
    Application->RemoveComponent(this);
    PostMessage(TotCmdWin, WM_SYSCOMMAND, SC_CLOSE, 0);
    return;
  }
  //hot keys of Lister:
  wShift.Clear();
  if (Shift == wShift)
  {
    if (Key == VK_ESCAPE)
    {                                             //File -> Exit (ESC)
      if (!QuickView)
        PostMessage(ParentWin, WM_KEYDOWN, VK_ESCAPE, 0);
      else
        PostMessage(ParentWin, WM_KEYDOWN, VK_TAB, 0);
      Key = 0;
    }
    else if (Key == 'N' || Key == 'P')
    {
      PostMessage(ParentWin, WM_KEYDOWN, Key, 0); //File -> Next (N) or Prev (P)
      Key = 0;
    }
    else if (Key >='1' && Key <= '7')
    {
      PostMessage(ParentWin, WM_KEYDOWN, Key, 0); //Options -> 1..7
      Key = 0;
    }
  }
  //own dialogs:
  if (Shift == wShift && Key == VK_F1) //F1
    Help1->Click();
  if (Shift == wShift && Key == VK_F2) //F2
    About1->Click();
  RichEdit1->SetFocus();
}
//---------------------------------------------------------------------------
void __fastcall TfmMain::Help1Click(TObject *Sender)
{
  wMsgBox(this->Handle, "Simple Lister plugin");
  RichEdit1->SetFocus();
}
//---------------------------------------------------------------------------
void __fastcall TfmMain::About1Click(TObject *Sender)
{
  TfmAbout *fmAbout = new TfmAbout(this);
  try
  {
    fmAbout->ShowModal();
  }
  __finally
  {
    fmAbout->Free();
  }
  RichEdit1->SetFocus();
}
//---------------------------------------------------------------------------
void __fastcall TfmMain::AppException(TObject *Sender, Exception *E)
{
  wMsgBox(this->Handle, "Plugin Error:\n" + E->Message);
}
//---------------------------------------------------------------------------
void __fastcall TfmMain::CreateParams(Controls::TCreateParams &Params)
{
  TCustomForm::CreateParams(Params);
  Params.Style = WS_CHILD | WS_MAXIMIZE & !WS_CAPTION & !WS_BORDER;
  Params.WindowClass.cbWndExtra = sizeof(void *); //for address of form
}
//end of form
//===========================================================================
/* initialization and finalization */
struct TPlugInfo
{
  WNDPROC PlugWinProc; //callback function of our form
  TfmMain *PlugForm;   //our form
};
//---------------------------------------------------------------------------
LRESULT CALLBACK HookDestroy(HWND PluginWin, UINT Msg, WPARAM wParam, LPARAM lParam)
{ //hook destroy our window
  TPlugInfo *p;
  p = (TPlugInfo *)(GetWindowLong(PluginWin, GWL_USERDATA));
  if (Msg != WM_DESTROY)
    return CallWindowProc((FARPROC)p->PlugWinProc, PluginWin, Msg, wParam, lParam);
  else //plugin close
  {
    HideRTF(PluginWin);
    return 0;
  }
}
//---------------------------------------------------------------------------
void HideRTF(HWND PluginWin)
{ //finalization
  TPlugInfo *p;
  p = (TPlugInfo *)(GetWindowLong(PluginWin, GWL_USERDATA));
  try
  {
    Application->RemoveComponent(p->PlugForm);
    Application->Handle = NULL;
    //restore callback function
    SetWindowLong(p->PlugForm->Handle, GWL_WNDPROC, (LONG)(p->PlugWinProc));
    p->PlugForm->Free();
  }
  catch(Exception &E)
  {
    wMsgBox(NULL, "DestroyWindow error:\n" + E.Message);
  }
  free(p);
}
//---------------------------------------------------------------------------
HWND ShowRTF(HWND ListerWin, char* FileToLoad)
{ //initialization
  try
  {
    TfmMain *fmMain;
    TPlugInfo *p;
    SetCurrentDir(ExtractFilePath(FileToLoad));
    //create our window and initialize
    fmMain = (TfmMain *)(TWinControl::CreateParentedControl(__classid(TfmMain), ListerWin));
    fmMain->TotCmdWin = FindWindow(WinCmdClassName, NULL);
    fmMain->ParentWin = ListerWin;
    fmMain->QuickView = GetParent(ListerWin) != NULL;
    fmMain->RichEdit1->Lines->LoadFromFile(FileToLoad);
    fmMain->Show();
    //synchronize our form and Lister
    Application->Handle = ListerWin;
    Application->OnException = fmMain->AppException;
    Application->InsertComponent(fmMain);
    //substitution callback function
    p = (TPlugInfo *)malloc(sizeof(TPlugInfo));
    SetWindowLong(fmMain->Handle, GWL_USERDATA, (LONG)p);
    p->PlugForm = fmMain;
    p->PlugWinProc = (WNDPROC)(SetWindowLong(fmMain->Handle, GWL_WNDPROC, (LONG)HookDestroy));
    //set focus to our window
    if (!fmMain->QuickView)
    {
      PostMessage(fmMain->Handle, WM_SETFOCUS, 0, 0);
      fmMain->RichEdit1->SetFocus();
      ShowCursor(1);
    }
    return fmMain->Handle;
  }
  catch(Exception &E)
  {
    wMsgBox(ListerWin, "Open error:\n" + E.Message);
    return NULL;
  }
}
//---------------------------------------------------------------------------



