//Version 26/01/04
unit ContentPlug;

interface
uses
  Windows;

const
  FT_NOMOREFIELDS = 0;
  FT_NUMERIC_32 = 1;
  FT_NUMERIC_64 = 2;
  FT_NUMERIC_FLOATING = 3;
  FT_DATE = 4;
  FT_TIME = 5;
  FT_BOOLEAN = 6;
  FT_MULTIPLECHOICE = 7;
  FT_STRING = 8;
  FT_FULLTEXT = 9;
  FT_DATETIME = 10;
  FT_STRINGW = 11;

  // for ContentGetValue
  FT_NOSUCHFIELD  = -1;
  FT_FILEERROR    = -2;
  FT_FIELDEMPTY   = -3;
  FT_ONDEMAND     = -4;
  FT_NOTSUPPORTED = -5;
  FT_SETCANCEL    = -6;
  FT_DELAYED      =  0;

  // for ContentGetSupportedFieldFlags
  contFlags_Edit                   = 1;
  contFlags_SubstSize              = 2;
  contFlags_SubstDateTime          = 4;
  contFlags_SubstDate              = 6;
  contFlags_SubstTime              = 8;
  contFlags_SubstAttributes        = 10;
  contFlags_SubstAttributeStr      = 12;
  contFlags_PassThrough_Size_Float = 14;
  contFlags_SubstMask              = 14;
  contFlags_FieldEdit              = 16;

  // for ContentSendStateInformation
  contst_ReadNewDir        = 1;
  contst_RefreshPressed    = 2;
  contst_ShowHint          = 4;

  setflags_First_Attribute = 1;  // First attribute of this file
  setflags_Last_Attribute  = 2;  // Last attribute of this file
  setflags_Only_Date       = 4;  // Only set the date of the datetime value!

  CONTENT_DELAYIFSLOW      = 1;  // ContentGetValue called in foreground
  CONTENT_PASSTHROUGH      = 2;  { If requested via contflags_passthrough_size_float: The size
                                  is passed in as floating value, TC expects correct value
                                  from the given units value, and optionally a text string}

type
  TContentDefaultParamStruct = record
    size,
    PluginInterfaceVersionLow,
    PluginInterfaceVersionHi: longint;
    DefaultIniName: array[0..MAX_PATH-1] of char;
    end;
  PContentDefaultParamStruct = ^TContentDefaultParamStruct;

  TDateFormat = packed record
    Year: Word;
    Month: Word;
    Day: Word;
  end;
  PDateFormat = ^TDateFormat;

  TTimeFormat = packed record
    Hour: Word;
    Minute: Word;
    Second: Word;
  end;
  PTimeFormat = ^TTimeFormat;

implementation

(*
procedure ContentGetDetectString(DetectString: pchar; maxlen: integer); stdcall;

function ContentGetSupportedField(FieldIndex: integer;
                                  FieldName: pchar;
                                  Units: pchar;
                                  MaxLen: integer): integer; stdcall;

function ContentGetValue(FileName: pchar;
                         FieldIndex, UnitIndex: integer;
                         FieldValue: pointer;
                         MaxLen, Flags: integer): integer; stdcall;

procedure ContentSetDefaultParams(dps: pContentDefaultParamStruct); stdcall;

procedure ContentStopGetValue(FileName: pchar); stdcall;
procedure ContentStopGetValueW(FileName: pchar); stdcall;
*)

end.
