{$MODE Delphi}
// "Tempus" content plugin by Sasha Slobodenyuk (sasha@mypersonalsite.ru)
// with only russian comments so far, sorry guys.
library Tempus;

uses
  Windows,
  SysUtils,
  Dialogs,
  ContentPlug,
  TempusProcs;


const
  // Fields:
  FieldNames: array[0..6] of String = ('Age', 'Age (Update Dirs)', 'Age Sort', 'Type', 'Type Sort', 'Group Name', 'Update Dirs Only');
  FIELD_INDEX_AGE = 0;          // Age
  FIELD_INDEX_AGE_UPTODATE = 1; // Age (Update Dirs)
  FIELD_INDEX_AGE_SORT = 2;     // Age Sort — not cached
  FIELD_INDEX_ATTR = 3;         // Type
  FIELD_INDEX_ATTR_SORT = 4;    // Type Sort
  FIELD_INDEX_GROUP_NAME = 5;   // Group Name
  FIELD_INDEX_UPTODATE = 6;     // Update Dirs Only

  DEFAULT_LANG = 'eng';

type
  TGroupRecord = record
    NameOrExt: String;
    FullMatch: Boolean;       // False — искать не полное совпадение имени/расширения, а сравнивать только начала
    GroupNum: integer;
  end;

  TArrayOfGroupNames = array of TGroupRecord;

var
  FilesExts: TArrayOfGroupNames;
  FilesNames: TArrayOfGroupNames;
  FileGroupNames: array of String;
  MaxFileGroupsCount: integer;

  DirsNames: TArrayOfGroupNames;
  DirGroupNames: array of String;
  MaxDirGroupsCount: integer;
  MiddleGroupNum: integer = 50;


  // TempCachedCounter: integer = 0;
  // TempFoundInCache: integer = 0;
  ReloadIniOnCtrlR: Boolean = false;                              // Перечитывать ли настройки из ини-файла при обновлении по Ctrl+R
  UseCacheForAttributes: Boolean = true;                          // Использовать ли кеш для поля атрибутов


  // Обновление времени изменения папок
  TryToSaveCreationDate: integer = 2;                             // 0 — не трогать дату создания папки вообще;
                                                                  // 1 — корректировать дату создания папки, если она больше даты изменения папки.
                                                                  //     После этого дата изменения папки не устанавливается меньше даты создания (даже если внутри файлы, которые старше папки).
                                                                  // 2 — также корректировать дату создания папки, но с возможностью установки даты изменения папки меньше, чем дата создания.
                                                                  //     (если дата изменения получается меньше даты создания, то 'кодируем' дату изменения количеством секунд кратным 10, и 700 мс)
  ShowUptodateStatuses: Boolean = true;                           // Показывать ли статусы перерасчёта папок
  UptodateStatusAddToEndOfLine: Boolean = false;                  // Добавлять строку слева или справа от выводимого возраста файлов
  UptodateStatusCalculating: String = '·_';                       // Статус: ведётся расчёт
  UptodateStatusDateChangedYng: String = '+_';                    // Статус: дата папки изменилась на более свежую (вычислили новую дату/время)
  UptodateStatusDateChangedOld: String = '–_';
  UptodateStatusDirLocked: String = 'x_';                         // Статус: папка занята каким-либо процессом (заблокирована для изменения даты)
  UptodateStatusNoChanges: String = '';                           // Статус: изменений в дате не было
  UptodateStatusNoChangesOnDemand: String = 'ok_';
  UptodateStatusExcludedOnDemand: String = 'skip_';

  DepthLevels: integer = 1;
  MaxFilesToCheck: integer = 1500;                                // -1 — без ограничения
  AllowDriveCDRom: Boolean = false;
  AllowDriveNetwork: Boolean = false;
  AllowDriveRemovable: Boolean = false;

  OnDemandDepthLevels: integer = 100;
  OnDemandMaxFilesToCheck: integer = -1;
  OnDemandAllowDriveCDRom: Boolean = false;
  OnDemandAllowDriveNetwork: Boolean = true;
  OnDemandAllowDriveRemovable: Boolean = true;

  ProcessDirsOnChangeDir: Boolean = true;
  ProcessDirsOnCtrlR: Boolean = true;
  ProcessDirsOnDemand: Boolean = true;                            // Прочёсываем папки по пробелу
  BeepOnDemand: Boolean = false;                                  // Звук при расчёте папки по нажатию пробела
  AgeOrUptodateCacheTTL: Double = ONE_SECOND * 600;               // Время актуальности кеша полей 'Age' и 'Update Dirs Only'
                                                                  //   (кеш необходим для повторного обновления папок при изменении их времени)
  AgeOrUptodateCacheTTLForUpdatedDirs: Double = ONE_SECOND * 5;   // Время актуальности кеша для папок, у которых мы поменяли дату
                                                                  //   (фактически, сколько секунд будут видны статусы '+', '—' и т.п. около папок)
  AgeOrUptodateCacheTTLWhenCtrlR: Double = ONE_SECOND * 2;        // [CONST] Время ... при обновлении по Ctrl+R
  Language: string = DEFAULT_LANG;


  // Временные переменные
  AttrSortField_FilesCounter: integer = 0;                        // Счётчик файлов при очередном апдейте панели (для поля сортировки по атрибутам)
  LastUpdatingPath: WideString = '';                              // Папка, в которой последний раз обновлялись файлы
  UseCacheOnThisUpdateForAttrField: Boolean = false;              // False — временно не использовать кеш (например, при нажатии Ctrl+R)
  UseCacheAndProcessDirsOnThisUpdate: Boolean = true;             // False — временно не перерасчитывать дату папок в течение текущего обновления панели (для переключения режимов отображения поля Age)
  PanelRefreshingByCtrlR: Boolean = false;                        // Текущее обновление панели вызвано с помощью Ctrl+R
  RefreshPressedAMomentAgo: Boolean = false;                      // Только что обновилась панель (костыль, изза того что при обновлении по Ctrl+R ContentSendStateInformationW
                                                                  //   вызывается дважды, сначала ContSt_RefreshPressed, затем ContSt_ReadNewdir
  CurrentAgeOrUptodateCacheTTL: Double;
  LastActivityTimeForAgeField: TDateTime;                         // Время любого последнего действия/запроса для возможности отличать вызов расчёта по
                                                                  //   нажатию пробела (для поля Age) от вызова расчёта для очередного файла в отдельном потоке.
                                                                  //   Т.к. TCacheType.LastResult не всегда помагает (например, при включенной сортировке по полю Age);
  LastActivityThreshold: Double = ONE_SECOND * 0.5;               // Сколько времени должно пройти с момента последней активности, чтобы мы решили, что запрос выполнен пробелом;

  PluginInterfaceVersion: Double = 0;                             // Текущая версия плагинного интерфейса (например, TC 7.01 возвращает версию 1.5, TC 8.0 и выше — версию 2.10)
  AllowSecondOnDemandStatus: Boolean = true;                      // Разрешить ли выставление повторного статуса ON_DEMAND для файлов, по которым уже был отложенный запрос
                                                                  //   (не работает в TC версии меньше 7.55);

  {---------------------------------------------------------------}

  // AGE FIELDS:
  // Пороги перехода от секунд к минутам, от минут к часам и т.п. (1 = сутки)
  // (пересчитываются после загрузки ini-файла из переменных IniThresholdSec, ...)
  ThresholdSec: array [1..3] of Double = (0.0006944, 0, 0);       // 1/(24*60), либо 60 сек./86400 — порог перехода от секунд к минутам (если время >60 секунд, показываем уже в минутах),
  ThresholdMin: array [1..3] of Double = (0.41667, 0, 0);         // 1/24, либо 3600 сек./86400  — от минут к часам,
  ThresholdHour: array [1..3] of Double = (1, 0, 0);              // от часов к суткам
  ThresholdDay: array [1..3] of Double = (90, 0, 0);              // от суток к месяцам (3 месяца)
  ThresholdMonth: array [1..3] of Double = (0, 0, 0);             // от месяцев к годам (если годы не используются, то 0)
  ThresholdYear: array [1..3] of Double = (0, 0, 0);              // от годов к полному режиму

  SuffixSec: array [1..3] of TypeSuffixes = (('_s', '_s', '_s'), ('_s', '_s', '_s'), ('_s', '_s', '_s'));
  SuffixMin: array [1..3] of TypeSuffixes = (('_m', '_m', '_m'), ('_m', '_m', '_m'), ('_m', '_m', '_m'));
  SuffixHour: array [1..3] of TypeSuffixes = (('_h', '_h', '_h'), ('_h', '_h', '_h'), ('_h', '_h', '_h'));
  SuffixDay: array [1..3] of TypeSuffixes = (('_day', '_days', '_days'), ('_d', '_d', '_d'), ('_d', '_d', '_d'));
  SuffixMonth: array [1..3] of TypeSuffixes = (('_M', '_M', '_M'), ('_M', '_M', '_M'), ('_M', '_M', '_M'));
  SuffixYear: array [1..3] of TypeSuffixes = (('_Y', '_Y', '_Y'), ('_Y', '_Y', '_Y'), ('_Y', '_Y', '_Y'));
  SuffixFull: array [1..3] of String = ('', '', '');
  FullDateTimeFormat: array [1..3] of String = ('yyyy.mm', 'yyyy.mm.dd', 'hh:nn');   // 'mmm yy' — Aug 13

  StrNoDateTime: String = '—';

  WhichDateUseForFiles: integer = 2;                // Какую дату использовать: 1 — создания файла, 2 — изменения (установка по умолчанию), 3 — большую из обоих дат, 4 — меньшую;
  WhichDateUseForDirs: integer = 2;                 // Какую дату использовать: 1 — создания папки, 2 — изменения, 3 — большую из обоих дат, 4 — меньшую;
  // P.S. иногда дата создания может быть больше, чем дата изменения: например, при распаковке архива дата
  // изменения сохранится, а дата создания выставится заново.

  // Переключение режимов отображения дат:
  ModeCurrent: integer = 1;
  ModesUsed: integer = 3;
  ModeResetWhenDirChanged: Boolean = true;
  ModeResetAfterTCRestart: Boolean = true;
  UseCTRLForChangeMode: Boolean = false;            // Переключение режима при обновлении панели с нажатой одной из клавиш (shift, alt, ctrl) или их комбинации
  UseALTForChangeMode: Boolean = false;
  UseSHIFTForChangeMode: Boolean = true;



  // AGE SORT FIELDS:
  AgeField_ReverseSort: Boolean = true;             // True (по умолчанию) — при первом нажатии на кнопку сортировки по полю Age — TC будет сортировать колонку в обратном порядке (свежие — сверху). Активно только при включенной сортировке папок по времени (AgeField_SortDirsByTime = True).
  AgeField_SortByGroupEnabled: Boolean = true;      // True — сортировать по группам (помимо сортировки по времени);
  AgeField_SortByAttrEnabled: Boolean = true;       // True — сортировать по атрибутам (помимо сортировки по времени);
  // (P.S. Если оба значения для папок False, то сортируем только файлы, а папки продолжаем сортировать по имени)
  AgeField_SortDirsByAttr: Boolean = true;          // True — сортировать папки по атрибутам (затем по времени, если установлено);
  AgeField_SortDirsByTime: Boolean = true;          // True — сортировать папки по времени;
  AgeField_AddFileNameForSort: Boolean = true;      // True — добавлять в конец строки имя файла (на случай, если используется формат вывода [=plugin.Age Sort:0][=plugin.age])



  // ATTRIBUTES FIELDS:
  DontShowAttrArchive: Boolean = true;              // Не показывать атрибут "архивный" для папок и файлов
  NoAttributeChar: String = '–';
  GroupedShowMode: integer = 1;                     // 0 — не показывать группу, 1 — показывать группы символом, 2 — подписывать имена групп;
  GroupedStrRaised: String =  '·__';   // ° ·
  GroupedStrLowered: String = '';



  // ATTRIBUTES SORT FIELDS:
  AttrField_SortByGroupEnabled: Boolean = true;     // Включить сортировку по типам файлов
  AttrField_SortByAttrEnabled: Boolean = true;      // Включить сортировку по атрибутам
  AttrField_SortDirsByAttr: Boolean = true;         // True — сортировать папки по атрибутам, как и файлы. False — сортировка всегда по имени; (имеет значение, если в TC включена опция сортировки папок не по имени)
  LowerFoldersAttr: Integer = 2;                    // Папки с этими флагами будут поставлены в конец списка
  LowerFilesAttr: Integer = 2;                      // Файлы ...
  RiseFoldersAttr: Integer = 0;
  RiseFilesAttr: Integer = 0;
  AttrField_AddFileNameForSort: Boolean = true;     // True — добавлять в конец строки имя файла (на случай, если используется формат вывода [=plugin.Age Sort:0][=plugin.age])



  // OTHER FIELDS VARS:
  UnderscoreRiseHack: Boolean = true;               // В кастомных полях TC сортирует "_" ниже цифровых символов. При true — сортируем "_" выше цифр
  GroupsSortPriorityForDirs: Boolean = true;        // True — сортируем папки сначала по группам, затем по атрибутам
  GroupsSortPriorityForFiles: Boolean = false;      // True — сортируем файлы сначала по группам, затем по атрибутам



  // Format strings:
  // y 	 = Year last 2 digits
  // yy 	 = Year last 2 digits
  // yyyy 	 = Year as 4 digits
  // m 	 = Month number no-leading 0
  // mm 	 = Month number as 2 digits
  // mmm 	 = Month using ShortDayNames (Jan)
  // mmmm 	 = Month using LongDayNames (January)
  // d 	 = Day number no-leading 0
  // dd 	 = Day number as 2 digits
  // ddd 	 = Day using ShortDayNames (Sun)
  // dddd 	 = Day using LongDayNames  (Sunday)
  // ddddd 	 = Day in ShortDateFormat
  // dddddd 	 = Day in LongDateFormat

  // c 	 = Use ShortDateFormat + LongTimeFormat
  // h 	 = Hour number no-leading 0
  // hh 	 = Hour number as 2 digits
  // n 	 = Minute number no-leading 0
  // nn 	 = Minute number as 2 digits
  // s 	 = Second number no-leading 0
  // ss 	 = Second number as 2 digits
  // z 	 = Milli-sec number no-leading 0s
  // zzz 	 = Milli-sec number as 3 digits
  // t 	 = Use ShortTimeFormat
  // tt 	 = Use LongTimeFormat

  // am/pm 	 = Use after h : gives 12 hours + am/pm
  // a/p 	 = Use after h : gives 12 hours + a/p
  // ampm 	 = As a/p but TimeAMString,TimePMString
  // / 	 = Substituted by DateSeparator value
  // : 	 = Substituted by TimeSeparator value

{----------------------------------------------------------------------------------------------}

// Загрузка настроек из ini-файла:
procedure LoadIniFile;

  procedure LoadSuffixStr(IniSection: String;
                          SuffixBase: String;
                          LangPrefix: String;
                          var Suffixes: TypeSuffixes);
  begin
    // Сначала проверяем — существует ли перевод параметра:
    if (LangPrefix <> '') then
      if (not IniValueExists(IniSection, LangPrefix + SuffixBase)) and
         (not IniValueExists(IniSection, LangPrefix + SuffixBase + '1')) then
        // Если не нашли параметр на указанном языке — убираем префикс, и ниже читаем дефолтные настройки
        LangPrefix := '';


    // Читаем параметр
    Suffixes[1] := IniLoadStrKey(IniSection, LangPrefix + SuffixBase, 'EMPTY');
    if (Suffixes[1] <> 'EMPTY') then
    begin
      Suffixes[2] := Suffixes[1];
      Suffixes[3] := Suffixes[1];
    end
    else
    begin
      Suffixes[1] := IniLoadStrKey(IniSection, LangPrefix + SuffixBase + '1', '');
      Suffixes[2] := IniLoadStrKey(IniSection, LangPrefix + SuffixBase + '2', 'EMPTY');
      if Suffixes[2] = 'EMPTY' then Suffixes[2] := Suffixes[1];
      Suffixes[3] := IniLoadStrKey(IniSection, LangPrefix + SuffixBase + '3', 'EMPTY');
      if Suffixes[3] = 'EMPTY' then Suffixes[3] := Suffixes[2];
    end;
  end;


  // Парсим строку с группой расширений/имён папок и разбиваем её на отдельные расширения/имена
  procedure ParseGroupStr(GroupStr: String; Delimiter: Char; GroupNum: integer; IsFolder: Boolean);
  var
    TmpPos: integer;
    TmpStr: String;
    FullMatch: Boolean;

  begin
    // Разбираем строку с расширениями на отдельные расширения
    while length(GroupStr) > 0 do
    begin
      TmpPos := AnsiPos(Delimiter, GroupStr);
      if (TmpPos > 0) then
      begin
        TmpStr := Copy(GroupStr, 1, TmpPos-1);
        GroupStr := Copy(GroupStr, TmpPos+1, MaxInt);
      end
      else
      begin
        TmpStr := GroupStr;
        GroupStr := '';
      end;

      // Проверяем наличие * в найденной строке
      FullMatch := true;
      TmpPos := AnsiPos('*', TmpStr);
      if (TmpPos > 0) then
      begin
        TmpStr := Copy(TmpStr, 1, TmpPos-1);
        FullMatch := false;
      end;

      TmpStr := Trim(AnsiLowerCase(TmpStr));
      // Убираем возможную точку в конце строки
      if (length(TmpStr) > 0) and (TmpStr[length(TmpStr)] = '.') then
        TmpStr := Copy(TmpStr, 1, length(TmpStr)-1);

      // Записываем новое найденное расширение в массив расширений файлов
      if length(TmpStr) > 0 then
      begin
        if IsFolder then
        begin
          // Массив имен папок
          SetLength(DirsNames, length(DirsNames) + 1);
          DirsNames[length(DirsNames) - 1].NameOrExt := TmpStr;
          DirsNames[length(DirsNames) - 1].GroupNum := GroupNum;
          DirsNames[length(DirsNames) - 1].FullMatch := FullMatch;
        end

        else
        begin
          if TmpStr[1] = '.' then
          begin
            TmpStr := Copy(TmpStr, 2, MaxInt);
            if length(TmpStr) > 0 then
            begin
              // Массив расширений
              SetLength(FilesExts, length(FilesExts) + 1);
              FilesExts[length(FilesExts) - 1].NameOrExt := TmpStr;
              FilesExts[length(FilesExts) - 1].GroupNum := GroupNum;
              FilesExts[length(FilesExts) - 1].FullMatch := FullMatch;
            end;
          end

          else
          begin
            // Массив имён файлов
            SetLength(FilesNames, length(FilesNames) + 1);
            FilesNames[length(FilesNames) - 1].NameOrExt := TmpStr;
            FilesNames[length(FilesNames) - 1].GroupNum := GroupNum;
            FilesNames[length(FilesNames) - 1].FullMatch := FullMatch;
          end;
        end;
      end;
    end;
  end;


  // Отсортировать массив с расширениями/именами по имени
  procedure SortGroupArray(var GroupArray: TArrayOfGroupNames);
  var
    i: integer;
    WasChanges: Boolean;
    TmpSlot: TGroupRecord;
    EmergencyVar: integer;

  begin
    WasChanges := true;
    EmergencyVar := 100000;

    while WasChanges and (EmergencyVar > 0) do
    begin
      WasChanges := false;
      dec(EmergencyVar);

      for i := 0 to length(GroupArray)-2 do
      begin
        if AnsiCompareStr(GroupArray[i].NameOrExt, GroupArray[i+1].NameOrExt) > 0 then
        begin
          TmpSlot := GroupArray[i+1];
          GroupArray[i+1] := GroupArray[i];
          GroupArray[i] := TmpSlot;
          WasChanges := true;
        end;
      end;
    end;
  end;


  procedure LoadFileGroups;
  var
    i: integer;
    GroupStr: String;
    AddGroupNumberToName: Boolean;

  begin
    SetLength(FilesExts, 0);
    SetLength(FilesNames, 0);
    SetLength(DirsNames, 0);
    SetLength(FileGroupNames, 0);
    SetLength(DirGroupNames, 0);

    MiddleGroupNum := IniLoadIntKey('FileGroups', 'MiddleGroupNum', 50);
    MaxFileGroupsCount := IniLoadIntKey('FileGroups', 'MaxGroupsCount', 100);
    MaxDirGroupsCount := IniLoadIntKey('DirGroups', 'MaxGroupsCount', 100);
    if (MaxFileGroupsCount < MiddleGroupNum) then MaxFileGroupsCount := MiddleGroupNum;
    if (MaxDirGroupsCount < MiddleGroupNum) then MaxDirGroupsCount := MiddleGroupNum;
    AddGroupNumberToName := IniLoadBoolKey('FileGroups', 'AddGroupNumberToName', false);

    // Читаем группы файлов
    for i := 1 to MaxFileGroupsCount do
    begin
      GroupStr := IniLoadStrKey('FileGroups', IntToStrFixed(i), '');
      if Length(GroupStr) > 0 then
      begin
        ParseGroupStr(GroupStr, ';', i, false);

        // Название группы
        if i + 1 > Length(FileGroupNames) then
          SetLength(FileGroupNames, i + 1);
        FileGroupNames[i] := IniLoadStrKey('FileGroups', IntToStrFixed(i) + '_name', '');
        if (AddGroupNumberToName) then
          FileGroupNames[i] := Trim(IntToStrFixed(i) + ' ' + FileGroupNames[i]);
      end;
    end;
    SortGroupArray(FilesExts);
    SortGroupArray(FilesNames);

    // Читаем группы папок
    for i := 1 to MaxDirGroupsCount do
    begin
      GroupStr := IniLoadStrKey('DirGroups', IntToStrFixed(i), '');
      if Length(GroupStr) > 0 then
      begin
        ParseGroupStr(GroupStr, ';', i, true);

        // Название группы
        if i + 1 > Length(DirGroupNames) then
          SetLength(DirGroupNames, i + 1);
        DirGroupNames[i] := IniLoadStrKey('DirGroups', IntToStrFixed(i) + '_name', '');
        if (AddGroupNumberToName) then
          DirGroupNames[i] := Trim(IntToStrFixed(i) + ' ' + DirGroupNames[i]);
      end;
    end;
    SortGroupArray(DirsNames);
  end;


  // Разбить строку с папками, разделённую ';' на отдельные папки
  procedure ParseExcludedDirs(ExcludedDirsStr: string);
  var
    TmpPos: integer;
    Delimiter: char;
    TmpStr: string;

    // Проверка — является ли строка именем папки или путём из нескольких папок
    function IsPath(Str: String): Boolean;
    begin
      // Убираем крайние слеши, если есть
      Str := TrimChar(Str, '\');
      Result := Pos('\', Str) > 0;
    end;

  begin
    SetLength(ExcludedDirs, 0);
    Delimiter := ';';

    while length(ExcludedDirsStr) > 0 do
    begin
      TmpPos := AnsiPos(Delimiter, ExcludedDirsStr);
      if (TmpPos > 0) then
      begin
        TmpStr := Copy(ExcludedDirsStr, 1, TmpPos-1);
        ExcludedDirsStr := Copy(ExcludedDirsStr, TmpPos+1, MaxInt);
      end
      else
      begin
        TmpStr := ExcludedDirsStr;
        ExcludedDirsStr := '';
      end;

      TmpStr := Trim(AnsiLowerCase(TmpStr));

      // Записываем новое найденное расширение в массив расширений файлов
      if length(TmpStr) > 0 then
      begin
        if IsPath(TmpStr) then
        begin
          // Массив имен путей
          SetLength(ExcludedPaths, length(ExcludedPaths) + 1);
          ExcludedPaths[length(ExcludedPaths) - 1] := TmpStr;
        end
        else
        begin
          // Массив имен папок
          TmpStr := TrimChar(TmpStr, '\');
          if length(TmpStr) > 0 then
          begin
            SetLength(ExcludedDirs, length(ExcludedDirs) + 1);
            ExcludedDirs[length(ExcludedDirs) - 1] := TmpStr;
          end;
        end
      end;
    end;
  end;



var
  TempStr: String;
  LangPrefix: String;

begin
  // OPTIONS
  CacheArrLength := IniLoadIntKey('Options', 'CacheArrLength', 65535); // 65535
  ReloadIniOnCtrlR := IniLoadBoolKey('Options', 'ReloadIniOnCtrlR', false);
  UseCacheForAttributes := IniLoadBoolKey('Options', 'UseCacheForAttributes', false);
  Language := IniLoadStrKey('Options', 'Language', 'eng');

  // PROCESS DIRS
  TryToSaveCreationDate := IniLoadIntKey('Process Directories', 'TryToSaveCreationDate', 2);
  ShowUptodateStatuses := IniLoadBoolKey('Process Directories', 'ShowUptodateStatuses', true);
  UptodateStatusAddToEndOfLine := IniLoadBoolKey('Process Directories', 'UptodateStatusAddToEndOfLine', false);

  UptodateStatusCalculating := IniLoadStrKey('Process Directories', 'UptodateStatusCalculating', '·_');
  UptodateStatusDateChangedYng := IniLoadStrKey('Process Directories', 'UptodateStatusDateChangedYng', '+_');
  UptodateStatusDateChangedOld := IniLoadStrKey('Process Directories', 'UptodateStatusDateChangedOld', '–_');
  UptodateStatusDirLocked := IniLoadStrKey('Process Directories', 'UptodateStatusDirLocked', 'x_');
  UptodateStatusNoChanges := IniLoadStrKey('Process Directories', 'UptodateStatusNoChanges', '');
  UptodateStatusNoChangesOnDemand := IniLoadStrKey('Process Directories', 'UptodateStatusNoChangesOnDemand', 'ok_');
  UptodateStatusExcludedOnDemand := IniLoadStrKey('Process Directories', 'UptodateStatusExcludedOnDemand', 'skip_');

  ProcessDirsOnChangeDir := IniLoadBoolKey('Process Directories', 'ProcessDirsOnChangeDir', true);
  ProcessDirsOnCtrlR := IniLoadBoolKey('Process Directories', 'ProcessDirsOnCtrlR', true);
  ProcessDirsOnDemand := IniLoadBoolKey('Process Directories', 'ProcessDirsOnDemand', true);
  BeepOnDemand := IniLoadBoolKey('Process Directories', 'BeepOnDemand', false);
  MarginForChangeDateTime := IniLoadIntKey('Process Directories', 'MarginForChangeDateTime', 60) / 86400;

  DepthLevels := IniLoadIntKey('Process Directories', 'DepthLevels', 1);
  MaxFilesToCheck := IniLoadIntKey('Process Directories', 'MaxFilesToCheck', 1500);
  AllowDriveCDRom := IniLoadBoolKey('Process Directories', 'AllowDriveCDRom', false);
  AllowDriveNetwork := IniLoadBoolKey('Process Directories', 'AllowDriveNetwork', false);
  AllowDriveRemovable := IniLoadBoolKey('Process Directories', 'AllowDriveRemovable', false);

  OnDemandDepthLevels := IniLoadIntKey('Process Directories', 'OnDemandDepthLevels', 100);
  OnDemandMaxFilesToCheck := IniLoadIntKey('Process Directories', 'OnDemandMaxFilesToCheck', -1);
  OnDemandAllowDriveCDRom := IniLoadBoolKey('Process Directories', 'OnDemandAllowDriveCDRom', false);
  OnDemandAllowDriveNetwork := IniLoadBoolKey('Process Directories', 'OnDemandAllowDriveNetwork', true);
  OnDemandAllowDriveRemovable := IniLoadBoolKey('Process Directories', 'OnDemandAllowDriveRemovable', true);

  AgeOrUptodateCacheTTLForUpdatedDirs := IniLoadIntKey('Process Directories', 'CacheTTLSecForUpdatedDirs', 5) / 86400;
  AgeOrUptodateCacheTTL := IniLoadIntKey('Process Directories', 'CacheTTLSec', 600) / 86400;
  if AgeOrUptodateCacheTTL < AgeOrUptodateCacheTTLForUpdatedDirs then
    AgeOrUptodateCacheTTL := AgeOrUptodateCacheTTLForUpdatedDirs;

  TempStr := IniLoadStrKey('Process Directories', 'ExcludeDirs', '');
  if TempStr<>'' then ParseExcludedDirs(TempStr);


  // AGE FIELDS:
  WhichDateUseForFiles := IniLoadIntKey('Age Field', 'WhichDateUseForFiles', 2);
  WhichDateUseForDirs := IniLoadIntKey('Age Field', 'WhichDateUseForDirs', 2);
  StrNoDateTime := IniLoadStrKey('Age Field', 'StrNoDateTime', '—');

  // Age Field (Mode Switch). Переключение режимов отображения дат:
  ModeCurrent := IniLoadIntKey('Age Field (Mode Switch)', 'ModeCurrent', 1);
  ModesUsed := IniLoadIntKey('Age Field (Mode Switch)', 'ModesUsed', 3);
  ModeResetWhenDirChanged := IniLoadBoolKey('Age Field (Mode Switch)', 'ModeResetWhenDirChanged', true);
  ModeResetAfterTCRestart := IniLoadBoolKey('Age Field (Mode Switch)', 'ModeResetAfterTCRestart', true);
  UseCTRLForChangeMode := IniLoadBoolKey('Age Field (Mode Switch)', 'UseCTRLForChangeMode', false);
  UseALTForChangeMode := IniLoadBoolKey('Age Field (Mode Switch)', 'UseALTForChangeMode', false);
  UseSHIFTForChangeMode := IniLoadBoolKey('Age Field (Mode Switch)', 'UseSHIFTForChangeMode', true);


  // Age Field (Mode 1, 2, 3):
  // (с учётом языков)
  LangPrefix := Language;
  if LangPrefix = DEFAULT_LANG then LangPrefix := ''
                               else LangPrefix := LangPrefix + '_';

  ThresholdSec[1] :=   INILoadIntKeyWithPrefix('Age Field (Mode 1)', 'ThresholdSec',   LangPrefix, 60) / 86400;
  ThresholdMin[1] :=   INILoadIntKeyWithPrefix('Age Field (Mode 1)', 'ThresholdMin',   LangPrefix, 60) / 1440;
  ThresholdHour[1] :=  INILoadIntKeyWithPrefix('Age Field (Mode 1)', 'ThresholdHour',  LangPrefix, 24) / 24;
  ThresholdDay[1] :=   INILoadIntKeyWithPrefix('Age Field (Mode 1)', 'ThresholdDay',   LangPrefix, 90);
  ThresholdMonth[1] := INILoadIntKeyWithPrefix('Age Field (Mode 1)', 'ThresholdMonth', LangPrefix, 0);
  ThresholdYear[1] :=  INILoadIntKeyWithPrefix('Age Field (Mode 1)', 'ThresholdYear',  LangPrefix, 0);

  ThresholdSec[2] :=   INILoadIntKeyWithPrefix('Age Field (Mode 2)', 'ThresholdSec',   LangPrefix, 0) / 86400;
  ThresholdMin[2] :=   INILoadIntKeyWithPrefix('Age Field (Mode 2)', 'ThresholdMin',   LangPrefix, 0) / 1440;
  ThresholdHour[2] :=  INILoadIntKeyWithPrefix('Age Field (Mode 2)', 'ThresholdHour',  LangPrefix, 0) / 24;
  ThresholdDay[2] :=   INILoadIntKeyWithPrefix('Age Field (Mode 2)', 'ThresholdDay',   LangPrefix, 0);
  ThresholdMonth[2] := INILoadIntKeyWithPrefix('Age Field (Mode 2)', 'ThresholdMonth', LangPrefix, 0);
  ThresholdYear[2] :=  INILoadIntKeyWithPrefix('Age Field (Mode 2)', 'ThresholdYear',  LangPrefix, 0);

  ThresholdSec[3] :=   INILoadIntKeyWithPrefix('Age Field (Mode 3)', 'ThresholdSec',   LangPrefix, 0) / 86400;
  ThresholdMin[3] :=   INILoadIntKeyWithPrefix('Age Field (Mode 3)', 'ThresholdMin',   LangPrefix, 0) / 1440;
  ThresholdHour[3] :=  INILoadIntKeyWithPrefix('Age Field (Mode 3)', 'ThresholdHour',  LangPrefix, 0) / 24;
  ThresholdDay[3] :=   INILoadIntKeyWithPrefix('Age Field (Mode 3)', 'ThresholdDay',   LangPrefix, 0);
  ThresholdMonth[3] := INILoadIntKeyWithPrefix('Age Field (Mode 3)', 'ThresholdMonth', LangPrefix, 0);
  ThresholdYear[3] :=  INILoadIntKeyWithPrefix('Age Field (Mode 3)', 'ThresholdYear',  LangPrefix, 0);

  LoadSuffixStr('Age Field (Mode 1)', 'SuffixSec',   LangPrefix, SuffixSec[1]);
  LoadSuffixStr('Age Field (Mode 1)', 'SuffixMin',   LangPrefix, SuffixMin[1]);
  LoadSuffixStr('Age Field (Mode 1)', 'SuffixHour',  LangPrefix, SuffixHour[1]);
  LoadSuffixStr('Age Field (Mode 1)', 'SuffixDay',   LangPrefix, SuffixDay[1]);
  LoadSuffixStr('Age Field (Mode 1)', 'SuffixMonth', LangPrefix, SuffixMonth[1]);
  LoadSuffixStr('Age Field (Mode 1)', 'SuffixYear',  LangPrefix, SuffixYear[1]);
  FullDateTimeFormat[1] := INILoadStrKeyWithPrefix('Age Field (Mode 1)', 'FullDateTimeFormat', LangPrefix, 'yyyy.mm');
  SuffixFull[1] := INILoadStrKeyWithPrefix('Age Field (Mode 1)', 'SuffixFull', LangPrefix, '');

  LoadSuffixStr('Age Field (Mode 2)', 'SuffixSec',   LangPrefix, SuffixSec[2]);
  LoadSuffixStr('Age Field (Mode 2)', 'SuffixMin',   LangPrefix, SuffixMin[2]);
  LoadSuffixStr('Age Field (Mode 2)', 'SuffixHour',  LangPrefix, SuffixHour[2]);
  LoadSuffixStr('Age Field (Mode 2)', 'SuffixDay',   LangPrefix, SuffixDay[2]);
  LoadSuffixStr('Age Field (Mode 2)', 'SuffixMonth', LangPrefix, SuffixMonth[2]);
  LoadSuffixStr('Age Field (Mode 2)', 'SuffixYear',  LangPrefix, SuffixYear[2]);
  FullDateTimeFormat[2] := INILoadStrKeyWithPrefix('Age Field (Mode 2)', 'FullDateTimeFormat', LangPrefix, 'yyyy.mm.dd');
  SuffixFull[2] := INILoadStrKeyWithPrefix('Age Field (Mode 2)', 'SuffixFull', LangPrefix, '');

  LoadSuffixStr('Age Field (Mode 3)', 'SuffixSec',   LangPrefix, SuffixSec[3]);
  LoadSuffixStr('Age Field (Mode 3)', 'SuffixMin',   LangPrefix, SuffixMin[3]);
  LoadSuffixStr('Age Field (Mode 3)', 'SuffixHour',  LangPrefix, SuffixHour[3]);
  LoadSuffixStr('Age Field (Mode 3)', 'SuffixDay',   LangPrefix, SuffixDay[3]);
  LoadSuffixStr('Age Field (Mode 3)', 'SuffixMonth', LangPrefix, SuffixMonth[3]);
  LoadSuffixStr('Age Field (Mode 3)', 'SuffixYear',  LangPrefix, SuffixYear[3]);
  FullDateTimeFormat[3] := INILoadStrKeyWithPrefix('Age Field (Mode 3)', 'FullDateTimeFormat', LangPrefix, 'hh:nn');
  SuffixFull[3] := INILoadStrKeyWithPrefix('Age Field (Mode 3)', 'SuffixFull', LangPrefix, '');


  // AGE SORT FIELDS:
  AgeField_SortByGroupEnabled := IniLoadBoolKey('Age Sort Field', 'AgeField_SortByGroupEnabled', true);
  AgeField_SortByAttrEnabled := IniLoadBoolKey('Age Sort Field', 'AgeField_SortByAttrEnabled', true);
  AgeField_SortDirsByAttr := IniLoadBoolKey('Age Sort Field', 'AgeField_SortDirsByAttr', true);
  AgeField_SortDirsByTime := IniLoadBoolKey('Age Sort Field', 'AgeField_SortDirsByTime', true);
  AgeField_AddFileNameForSort := IniLoadBoolKey('Age Sort Field', 'AgeField_AddFileNameForSort', true);
  AgeField_ReverseSort := IniLoadBoolKey('Age Sort Field', 'AgeField_ReverseSort', true);
  if (AgeField_SortDirsByTime = false) then
    AgeField_ReverseSort := false;


  // ATTRIBUTES FIELDS:
  DontShowAttrArchive := IniLoadBoolKey('Type Field', 'DontShowAttrArchive', true);
  TempStr := IniLoadStrKey('Type Field', 'NoAttributeChar', '–');
  if (length(TempStr) > 0) then NoAttributeChar := TempStr[1]
                           else NoAttributeChar := ' ';
  GroupedShowMode := IniLoadIntKey('Type Field', 'GroupedShowMode', 1);
  GroupedStrRaised := IniLoadStrKey('Type Field', 'GroupedStrRaised', '·  ');
  GroupedStrLowered := IniLoadStrKey('Type Field', 'GroupedStrLowered', '');


  // ATTRIBUTES SORT FIELDS:
  AttrField_SortByGroupEnabled := IniLoadBoolKey('Type Sort Field', 'TypeField_SortByGroupEnabled', true);
  AttrField_SortByAttrEnabled := IniLoadBoolKey('Type Sort Field', 'TypeField_SortByAttrEnabled', true);
  AttrField_SortDirsByAttr := IniLoadBoolKey('Type Sort Field', 'TypeField_SortDirsByAttr', true);
  LowerFoldersAttr := IniLoadIntKey('Type Sort Field', 'LowerFoldersAttr', 2);
  LowerFilesAttr := IniLoadIntKey('Type Sort Field', 'LowerFilesAttr', 2);
  RiseFoldersAttr := IniLoadIntKey('Type Sort Field', 'RiseFoldersAttr', 0);
  RiseFilesAttr := IniLoadIntKey('Type Sort Field', 'RiseFilesAttr', 0);
  AttrField_AddFileNameForSort := IniLoadBoolKey('Type Sort Field', 'TypeField_AddFileNameForSort', true);


  // Global sort:
  UnderscoreRiseHack := IniLoadBoolKey('Type Sort Field', 'UnderscoreRiseHack', true);
  GroupsSortPriorityForDirs := IniLoadBoolKey('Type Sort Field', 'GroupsSortPriorityForDirs', true);
  GroupsSortPriorityForFiles := IniLoadBoolKey('Type Sort Field', 'GroupsSortPriorityForFiles', false);

  LoadFileGroups;
end;

{----------------------------------------------------------------------------------------------}

// Сохранение дефолтных натсроек в ini-файл (если ini-файл не найден):
procedure CreateNewIniFile;
begin
  // OPTIONS
  IniSaveIntKey('Options', 'CacheArrLength', CacheArrLength); // 65535
  IniSaveBoolKey('Options', 'ReloadIniOnCtrlR', ReloadIniOnCtrlR);
  IniSaveBoolKey('Options', 'UseCacheForAttributes', UseCacheForAttributes);
  IniSaveStrKey('Options', 'Language', Language);


  // PROCESS DIRS
  IniSaveIntKey('Process Directories', 'TryToSaveCreationDate', TryToSaveCreationDate);
  IniSaveBoolKey('Process Directories', 'ShowUptodateStatuses', ShowUptodateStatuses);
  IniSaveBoolKey('Process Directories', 'UptodateStatusAddToEndOfLine', UptodateStatusAddToEndOfLine);

  IniSaveStrKey('Process Directories', 'UptodateStatusCalculating', UptodateStatusCalculating);
  IniSaveStrKey('Process Directories', 'UptodateStatusDateChangedYng', UptodateStatusDateChangedYng);
  IniSaveStrKey('Process Directories', 'UptodateStatusDateChangedOld', UptodateStatusDateChangedOld);
  IniSaveStrKey('Process Directories', 'UptodateStatusDirLocked', UptodateStatusDirLocked);
  IniSaveStrKey('Process Directories', 'UptodateStatusNoChanges', UptodateStatusNoChanges);
  IniSaveStrKey('Process Directories', 'UptodateStatusNoChangesOnDemand', UptodateStatusNoChangesOnDemand);
  IniSaveStrKey('Process Directories', 'UptodateStatusExcludedOnDemand', UptodateStatusExcludedOnDemand);

  IniSaveBoolKey('Process Directories', 'ProcessDirsOnChangeDir', ProcessDirsOnChangeDir);
  IniSaveBoolKey('Process Directories', 'ProcessDirsOnCtrlR', ProcessDirsOnCtrlR);
  IniSaveBoolKey('Process Directories', 'ProcessDirsOnDemand', ProcessDirsOnDemand);
  IniSaveBoolKey('Process Directories', 'BeepOnDemand', BeepOnDemand);
  IniSaveIntKey('Process Directories', 'MarginForChangeDateTime', round(MarginForChangeDateTime * 86400));

  IniSaveIntKey('Process Directories', 'DepthLevels', DepthLevels);
  IniSaveIntKey('Process Directories', 'MaxFilesToCheck', MaxFilesToCheck);
  IniSaveBoolKey('Process Directories', 'AllowDriveCDRom', AllowDriveCDRom);
  IniSaveBoolKey('Process Directories', 'AllowDriveNetwork', AllowDriveNetwork);
  IniSaveBoolKey('Process Directories', 'AllowDriveRemovable', AllowDriveRemovable);

  IniSaveIntKey('Process Directories', 'OnDemandDepthLevels', OnDemandDepthLevels);
  IniSaveIntKey('Process Directories', 'OnDemandMaxFilesToCheck', OnDemandMaxFilesToCheck);
  IniSaveBoolKey('Process Directories', 'OnDemandAllowDriveCDRom', OnDemandAllowDriveCDRom);
  IniSaveBoolKey('Process Directories', 'OnDemandAllowDriveNetwork', OnDemandAllowDriveNetwork);
  IniSaveBoolKey('Process Directories', 'OnDemandAllowDriveRemovable', OnDemandAllowDriveRemovable);

  IniSaveIntKey('Process Directories', 'CacheTTLSecForUpdatedDirs', round(AgeOrUptodateCacheTTLForUpdatedDirs * 86400));
  IniSaveIntKey('Process Directories', 'CacheTTLSec', round(AgeOrUptodateCacheTTL * 86400));

  IniSaveStrKey('Process Directories', 'ExcludeDirs', '');



  // AGE FIELDS:
  IniSaveIntKey('Age Field', 'WhichDateUseForFiles', WhichDateUseForFiles);
  IniSaveIntKey('Age Field', 'WhichDateUseForDirs', WhichDateUseForDirs);
  IniSaveStrKey('Age Field', 'StrNoDateTime', StrNoDateTime);

  // Age Field (Mode Switch). Переключение режимов отображения дат:
  IniSaveIntKey('Age Field (Mode Switch)', 'ModeCurrent', ModeCurrent);
  IniSaveIntKey('Age Field (Mode Switch)', 'ModesUsed', ModesUsed);
  IniSaveBoolKey('Age Field (Mode Switch)', 'ModeResetWhenDirChanged', ModeResetWhenDirChanged);
  IniSaveBoolKey('Age Field (Mode Switch)', 'ModeResetAfterTCRestart', ModeResetAfterTCRestart);
  IniSaveBoolKey('Age Field (Mode Switch)', 'UseCTRLForChangeMode', UseCTRLForChangeMode);
  IniSaveBoolKey('Age Field (Mode Switch)', 'UseALTForChangeMode', UseALTForChangeMode);
  IniSaveBoolKey('Age Field (Mode Switch)', 'UseSHIFTForChangeMode', UseSHIFTForChangeMode);

  // Age Field (Mode 1, 2, 3):
  IniSaveIntKey('Age Field (Mode 1)', 'ThresholdSec', round(ThresholdSec[1] * 86400));
  IniSaveIntKey('Age Field (Mode 1)', 'ThresholdMin', round(ThresholdMin[1] * 1440));
  IniSaveIntKey('Age Field (Mode 1)', 'ThresholdHour', round(ThresholdHour[1] * 24));
  IniSaveIntKey('Age Field (Mode 1)', 'ThresholdDay', round(ThresholdDay[1]));
  IniSaveIntKey('Age Field (Mode 1)', 'ThresholdMonth', round(ThresholdMonth[1]));
  IniSaveIntKey('Age Field (Mode 1)', 'ThresholdYear', round(ThresholdYear[1]));

  IniSaveIntKey('Age Field (Mode 2)', 'ThresholdSec', round(ThresholdSec[2] * 86400));
  IniSaveIntKey('Age Field (Mode 2)', 'ThresholdMin', round(ThresholdMin[2] * 1440));
  IniSaveIntKey('Age Field (Mode 2)', 'ThresholdHour', round(ThresholdHour[2] * 24));
  IniSaveIntKey('Age Field (Mode 2)', 'ThresholdDay', round(ThresholdDay[2]));
  IniSaveIntKey('Age Field (Mode 2)', 'ThresholdMonth', round(ThresholdMonth[2]));
  IniSaveIntKey('Age Field (Mode 2)', 'ThresholdYear', round(ThresholdYear[2]));

  IniSaveIntKey('Age Field (Mode 3)', 'ThresholdSec', round(ThresholdSec[3] * 86400));
  IniSaveIntKey('Age Field (Mode 3)', 'ThresholdMin', round(ThresholdMin[3] * 1440));
  IniSaveIntKey('Age Field (Mode 3)', 'ThresholdHour', round(ThresholdHour[3] * 24));
  IniSaveIntKey('Age Field (Mode 3)', 'ThresholdDay', round(ThresholdDay[3]));
  IniSaveIntKey('Age Field (Mode 3)', 'ThresholdMonth', round(ThresholdMonth[3]));
  IniSaveIntKey('Age Field (Mode 3)', 'ThresholdYear', round(ThresholdYear[3]));

  IniSaveStrKey('Age Field (Mode 1)', 'SuffixSec1', SuffixSec[1, 1]);
  IniSaveStrKey('Age Field (Mode 1)', 'SuffixSec2', SuffixSec[1, 2]);
  IniSaveStrKey('Age Field (Mode 1)', 'SuffixSec3', SuffixSec[1, 3]);
  IniSaveStrKey('Age Field (Mode 1)', 'SuffixMin1', SuffixMin[1, 1]);
  IniSaveStrKey('Age Field (Mode 1)', 'SuffixMin2', SuffixMin[1, 2]);
  IniSaveStrKey('Age Field (Mode 1)', 'SuffixMin3', SuffixMin[1, 3]);
  IniSaveStrKey('Age Field (Mode 1)', 'SuffixHour1', SuffixHour[1, 1]);
  IniSaveStrKey('Age Field (Mode 1)', 'SuffixHour2', SuffixHour[1, 2]);
  IniSaveStrKey('Age Field (Mode 1)', 'SuffixHour3', SuffixHour[1, 3]);
  IniSaveStrKey('Age Field (Mode 1)', 'SuffixDay1', SuffixDay[1, 1]);
  IniSaveStrKey('Age Field (Mode 1)', 'SuffixDay2', SuffixDay[1, 2]);
  IniSaveStrKey('Age Field (Mode 1)', 'SuffixDay3', SuffixDay[1, 3]);
  IniSaveStrKey('Age Field (Mode 1)', 'SuffixMonth1', SuffixMonth[1, 1]);
  IniSaveStrKey('Age Field (Mode 1)', 'SuffixMonth2', SuffixMonth[1, 2]);
  IniSaveStrKey('Age Field (Mode 1)', 'SuffixMonth3', SuffixMonth[1, 3]);
  IniSaveStrKey('Age Field (Mode 1)', 'SuffixYear1', SuffixYear[1, 1]);
  IniSaveStrKey('Age Field (Mode 1)', 'SuffixYear2', SuffixYear[1, 2]);
  IniSaveStrKey('Age Field (Mode 1)', 'SuffixYear3', SuffixYear[1, 3]);
  IniSaveStrKey('Age Field (Mode 1)', 'FullDateTimeFormat', FullDateTimeFormat[1]);
  IniSaveStrKey('Age Field (Mode 1)', 'SuffixFull', SuffixFull[1]);

  IniSaveStrKey('Age Field (Mode 2)', 'SuffixSec', SuffixSec[2, 1]);
  IniSaveStrKey('Age Field (Mode 2)', 'SuffixMin', SuffixMin[2, 1]);
  IniSaveStrKey('Age Field (Mode 2)', 'SuffixHour', SuffixHour[2, 1]);
  IniSaveStrKey('Age Field (Mode 2)', 'SuffixDay', SuffixDay[2, 1]);
  IniSaveStrKey('Age Field (Mode 2)', 'SuffixMonth', SuffixMonth[2, 1]);
  IniSaveStrKey('Age Field (Mode 2)', 'SuffixYear', SuffixYear[2, 1]);
  IniSaveStrKey('Age Field (Mode 2)', 'FullDateTimeFormat', FullDateTimeFormat[2]);
  IniSaveStrKey('Age Field (Mode 2)', 'SuffixFull', SuffixFull[2]);

  IniSaveStrKey('Age Field (Mode 3)', 'SuffixSec', SuffixSec[3, 1]);
  IniSaveStrKey('Age Field (Mode 3)', 'SuffixMin', SuffixMin[3, 1]);
  IniSaveStrKey('Age Field (Mode 3)', 'SuffixHour', SuffixHour[3, 1]);
  IniSaveStrKey('Age Field (Mode 3)', 'SuffixDay', SuffixDay[3, 1]);
  IniSaveStrKey('Age Field (Mode 3)', 'SuffixMonth', SuffixMonth[3, 1]);
  IniSaveStrKey('Age Field (Mode 3)', 'SuffixYear', SuffixYear[3, 1]);
  IniSaveStrKey('Age Field (Mode 3)', 'FullDateTimeFormat', FullDateTimeFormat[3]);
  IniSaveStrKey('Age Field (Mode 3)', 'SuffixFull', SuffixFull[3]);


  // AGE SORT FIELDS:
  IniSaveBoolKey('Age Sort Field', 'AgeField_SortByGroupEnabled', AgeField_SortByGroupEnabled);
  IniSaveBoolKey('Age Sort Field', 'AgeField_SortByAttrEnabled', AgeField_SortByAttrEnabled);
  IniSaveBoolKey('Age Sort Field', 'AgeField_SortDirsByAttr', AgeField_SortDirsByAttr);
  IniSaveBoolKey('Age Sort Field', 'AgeField_SortDirsByTime', AgeField_SortDirsByTime);
  IniSaveBoolKey('Age Sort Field', 'AgeField_AddFileNameForSort', AgeField_AddFileNameForSort);
  IniSaveBoolKey('Age Sort Field', 'AgeField_ReverseSort', AgeField_ReverseSort);


  // ATTRIBUTES FIELDS:
  IniSaveBoolKey('Type Field', 'DontShowAttrArchive', DontShowAttrArchive);
  IniSaveStrKey('Type Field', 'NoAttributeChar', String(NoAttributeChar));
  IniSaveIntKey('Type Field', 'GroupedShowMode', GroupedShowMode);
  IniSaveStrKey('Type Field', 'GroupedStrRaised', GroupedStrRaised);
  IniSaveStrKey('Type Field', 'GroupedStrLowered', GroupedStrLowered);


  // ATTRIBUTES SORT FIELDS:
  IniSaveBoolKey('Type Sort Field', 'TypeField_SortByGroupEnabled', AttrField_SortByGroupEnabled);
  IniSaveBoolKey('Type Sort Field', 'TypeField_SortByAttrEnabled', AttrField_SortByAttrEnabled);
  IniSaveBoolKey('Type Sort Field', 'TypeField_SortDirsByAttr', AttrField_SortDirsByAttr);
  IniSaveIntKey('Type Sort Field', 'LowerFoldersAttr', LowerFoldersAttr);
  IniSaveIntKey('Type Sort Field', 'LowerFilesAttr', LowerFilesAttr);
  IniSaveIntKey('Type Sort Field', 'RiseFoldersAttr', RiseFoldersAttr);
  IniSaveIntKey('Type Sort Field', 'RiseFilesAttr', RiseFilesAttr);
  IniSaveBoolKey('Type Sort Field', 'TypeField_AddFileNameForSort', AttrField_AddFileNameForSort);


  // Global sort:
  IniSaveBoolKey('Type Sort Field', 'UnderscoreRiseHack', UnderscoreRiseHack);
  IniSaveBoolKey('Type Sort Field', 'GroupsSortPriorityForDirs', GroupsSortPriorityForDirs);
  IniSaveBoolKey('Type Sort Field', 'GroupsSortPriorityForFiles', GroupsSortPriorityForFiles);


  // Groups
  IniSaveIntKey('FileGroups', 'MaxGroupsCount', 100);
  IniSaveIntKey('FileGroups', 'MiddleGroupNum', 50);
  IniSaveStrKey('FileGroups', '01', 'ext1, ext2, ext3');
  IniSaveStrKey('FileGroups', '01_name', 'Test file group');

  IniSaveIntKey('DirGroups', 'MaxGroupsCount', 100);
  IniSaveStrKey('DirGroups', '01', 'Folder_name_1; Folder_name_2');
end;

{----------------------------------------------------------------------------------------------}

procedure Init;
var
  i, j: integer;

begin
  IniPath := ExtractFilePath(GetModuleName(HInstance));
  // Debug info:
  // ShowMessage(IniPath); // Path to TotalCmd.exe: ExtractFilePath(ParamStr(0));


  if (FileExists(IniPath + INIFILENAME)) then
    LoadIniFile
  else
    CreateNewIniFile;


  // Заменяем подчёркивания на пробелы в загруженных строках:
  GroupedStrRaised := StringReplace(GroupedStrRaised, '_', ' ', [rfReplaceAll]);
  GroupedStrLowered := StringReplace(GroupedStrLowered, '_', ' ', [rfReplaceAll]);
  StrNoDateTime := StringReplace(StrNoDateTime, '_', ' ', [rfReplaceAll]);

  for i := 1 to 3 do
  for j := 1 to 3 do
  begin
    SuffixSec[i, j] := StringReplace(SuffixSec[i, j], '_', ' ', [rfReplaceAll]);
    SuffixMin[i, j] := StringReplace(SuffixMin[i, j], '_', ' ', [rfReplaceAll]);
    SuffixHour[i, j] := StringReplace(SuffixHour[i, j], '_', ' ', [rfReplaceAll]);
    SuffixDay[i, j] := StringReplace(SuffixDay[i, j], '_', ' ', [rfReplaceAll]);
    SuffixMonth[i, j] := StringReplace(SuffixMonth[i, j], '_', ' ', [rfReplaceAll]);
    SuffixYear[i, j] := StringReplace(SuffixYear[i, j], '_', ' ', [rfReplaceAll]);
  end;

  for i := 1 to 3 do
  begin
    SuffixFull[i] := StringReplace(SuffixFull[i], '_', ' ', [rfReplaceAll]);
    FullDateTimeFormat[i] := StringReplace(FullDateTimeFormat[i], '_', ' ', [rfReplaceAll]);
  end;

  UptodateStatusCalculating := StringReplace(UptodateStatusCalculating, '_', ' ', [rfReplaceAll]);
  UptodateStatusDateChangedYng := StringReplace(UptodateStatusDateChangedYng, '_', ' ', [rfReplaceAll]);
  UptodateStatusDateChangedOld := StringReplace(UptodateStatusDateChangedOld, '_', ' ', [rfReplaceAll]);
  UptodateStatusDirLocked := StringReplace(UptodateStatusDirLocked, '_', ' ', [rfReplaceAll]);
  UptodateStatusNoChanges := StringReplace(UptodateStatusNoChanges, '_', ' ', [rfReplaceAll]);
  UptodateStatusNoChangesOnDemand := StringReplace(UptodateStatusNoChangesOnDemand, '_', ' ', [rfReplaceAll]);
  UptodateStatusExcludedOnDemand := StringReplace(UptodateStatusExcludedOnDemand, '_', ' ', [rfReplaceAll]);


  // Готовим массив для кеширования
  SetLength(CacheArr, CacheArrLength);
  for i := 0 to CacheArrLength - 1 do
  begin
    CacheArr[i].FileNameWithPath := '';
    CacheArr[i].Flags := 0;
    CacheArr[i].LastResult := 0;
    CacheArr[i].AgeOrUptodateTime := 0;
    CacheArr[i].AgeMode := 0;
  end;
end;


// Двоичный поиск группы в массиве групп
function GetGroupNumByName(Name: String; GroupArray: TArrayOfGroupNames; DefaultGroup: integer): integer;
var
  CeilSlot, FloorSlot: integer;
  CurSlot: integer;
  CompareResult: integer;

begin
  Result := DefaultGroup;
  if Length(GroupArray) = 0 then
    Exit;

  FloorSlot := 0;
  CeilSlot := length(GroupArray) - 1;

  // Поиск в массиве делением пополам
  while (FloorSlot < CeilSlot) do
  begin
    CurSlot := (FloorSlot + CeilSlot) div 2;
    if (GroupArray[CurSlot].FullMatch) then
      CompareResult := AnsiCompareText(Name, GroupArray[CurSlot].NameOrExt)
    else
      CompareResult := AnsiCompareText(Copy(Name, 1, length(GroupArray[CurSlot].NameOrExt)), GroupArray[CurSlot].NameOrExt);

    if (CompareResult = 0) then
    begin
      Result := GroupArray[CurSlot].GroupNum;
      break;
    end

    else
    begin
      if (CompareResult > 0) then
        FloorSlot := CurSlot + 1
      else
        CeilSlot := CurSlot;
    end;
  end;

  // Последняя проверка при FloorSlot = CeilSlot (или единственная, если в массиве всего один элемент)
  if (GroupArray[CeilSlot].FullMatch) then
    CompareResult := AnsiCompareText(Name, GroupArray[CeilSlot].NameOrExt)
  else
    CompareResult := AnsiCompareText(Copy(Name, 1, length(GroupArray[CeilSlot].NameOrExt)), GroupArray[CeilSlot].NameOrExt);

  if (CompareResult = 0) then
    Result := GroupArray[CeilSlot].GroupNum;
end;


{----------------------------------------------------------------------------------------------}
{                                                                                              }
{----------------------------------------------------------------------------------------------}


function ContentGetSupportedField(FieldIndex: integer;
                                  FieldName, Units: pAnsiChar;
                                  MaxLen: integer): integer; stdcall;
begin
  if (FieldIndex < 0) or (FieldIndex >= length(FieldNames)) then
  begin
    Result := FT_NOMOREFIELDS;
    Exit;
  end;

  lstrcpynA(FieldName, PAnsiChar(AnsiString(FieldNames[FieldIndex])), MaxLen);
  lstrcpynA(Units, '', MaxLen); // 'unit1|unit2'

  Result := FT_STRINGW;
end;

{----------------------------------------------------------------------------------------------}

// FileName — имя файла (с путём)
// FieldIndex — номер поля
// UnitIndex — номер вложенного поля ("единицы измерения")
// FieldValue — сюда возвращаем результат
// Result — FT_NOSUCHFIELD, FT_FILEERROR, FT_FIELDEMPTY, FT_STRING...
function ContentGetValueW(FileNameWithPath: pWideChar;
                          FieldIndex, UnitIndex: integer;
                          FieldValue: PWideChar;
                          MaxLen, Flags: integer): integer; stdcall;
var
  ResultStr: string;
  DelayedResult: Boolean;             // True — текущая возвращаемая строка временная, и будет повторный вызов функции в отдельном потоке
  FileAttributes : Cardinal;
  FileDateTime: TDatetime;
  FileAgeDays: TDateTime;
  FileAgeDaysAbs: TDateTime;

  FullDateTimeWasUsed: Boolean;

  FileName: String;                   // Оригинальное имя файла с расширением (без пути к нему)
  FileNameChanged: String;            // Обработанное имя файла (без расширения, с заменой подчёркивания и т.п.)
  FileNameWithBaseDir: String;        // Имя файла с папкой уровнем выше (например, 'Folder\Filename.exe')
  FileExt: String;                    // Расширение без точки
  AttrSortPrefixFrw: integer;         // Префикс для сортировки по атрибутам ("1_", "2_", "3_")
  AttrSortPrefixBck: integer;         // Инвертированный префикс (для обратной сортировки по дате)
  GroupSortPrefixFrw: integer;        // Сортировочный префикс для групировки по типам файлов (1 — exe, com, bat; 2 — zip, rar и т.п.)
  GroupSortPrefixBck: integer;

  ThisIsFolder: Boolean;              // Файл или папку обрабатываем
  AtLeastOneAttr: Boolean;
  DateInFuture: Boolean;
  TempInt: integer;
  TempStr: String;
  TempCacheNum: LongWord;

  ResultStrFoundInCache: Boolean;
  CurGroupName: String;               // Название группы, к которой принадлежит файл/папка

  MaxFilesToCheckTemp: integer;
  DepthLevelsTemp: integer;
  AllowCalculateOnThisDrive: Boolean;
  DirDateTimeWasChanged: integer;     // Дату/время папки изменили на новое
  CalculatedOk: Boolean;              // Обработка папки прошла норм
  AllowUptodateDirsByAgeField: Boolean;


  LastResultFromCache: integer;       // Предыдущий результат из кеша для обрабатываемого файла (только для полей 'Age' и 'Update Dirs Only')
  DemandBySpace: Boolean;             // True — запрос был сделан с помощью пробела (вычисляем косвенно по предыдущему результату для
                                      //    файла и прошедшему с момента последнего запроса времени)
  UseShortTTLFlag: Boolean;           // Если для полей 'Age' или 'Update Dirs Only' вывели статус ('+', '—' и т.п.),
                                      //    то используем уменьшенное время актуальности в кеше
  CurTTL: double;

begin
  if (FieldIndex < 0) or (FieldIndex >= length(FieldNames)) then
  begin
    Result := FT_NOSUCHFIELD;
    Exit;
  end;


  try
    Result := FT_FIELDEMPTY;
    ResultStr := '';
    CurGroupName := '@';
    DelayedResult := false;
    AllowUptodateDirsByAgeField := true;
    FileName := ExtractFileName(FileNameWithPath);
    FileNameWithBaseDir := '';
    LastResultFromCache := 0;
    DemandBySpace := false;
    UseShortTTLFlag := false;

    // Счётчик файлов при текущем обновлении
    if (FieldIndex = FIELD_INDEX_ATTR) then
      inc(AttrSortField_FilesCounter);


    // ---------------------------------
    // Пробуем найти нужную строку в кеше
    ResultStrFoundInCache := false;
    if CacheArrLength > 0 then
    if (UseCacheAndProcessDirsOnThisUpdate and (FieldIndex in [FIELD_INDEX_AGE_UPTODATE, FIELD_INDEX_UPTODATE])) or
       (UseCacheOnThisUpdateForAttrField and
        UseCacheForAttributes and
        (FieldIndex in [FIELD_INDEX_ATTR, FIELD_INDEX_ATTR_SORT, FIELD_INDEX_GROUP_NAME])) then
    begin
      FileNameWithBaseDir := ExtractFileNameWithBaseDir(FileNameWithPath);
      TempCacheNum := FastHashCount(FileNameWithBaseDir, CacheArrLength);

      if CacheArr[TempCacheNum].FileNameWithPath = FileNameWithPath then
      begin
        // Нашли файл в кеше
        ThisIsFolder := (CacheArr[TempCacheNum].Flags and 128 <> 0);
        LastResultFromCache := CacheArr[TempCacheNum].LastResult;
        DemandBySpace := (LastResultFromCache = FT_ONDEMAND) and (Now - LastActivityTimeForAgeField > LastActivityThreshold);

        if FieldIndex in [FIELD_INDEX_AGE_UPTODATE, FIELD_INDEX_UPTODATE] then
        begin
          if (CacheArr[TempCacheNum].Flags and 64 <> 0) and
             (CurrentAgeOrUptodateCacheTTL = AgeOrUptodateCacheTTL) then CurTTL := AgeOrUptodateCacheTTLForUpdatedDirs
                                                                    else CurTTL := CurrentAgeOrUptodateCacheTTL;
        end;


        case FieldIndex of
          FIELD_INDEX_ATTR:
            if CacheArr[TempCacheNum].Flags and 1 <> 0 then
            begin
              ResultStr := CacheArr[TempCacheNum].AttrResult;
              ResultStrFoundInCache := true;
            end;

          FIELD_INDEX_ATTR_SORT:
            if CacheArr[TempCacheNum].Flags and 2 <> 0 then
            begin
              ResultStr := CacheArr[TempCacheNum].AttrSortResult;
              ResultStrFoundInCache := true;
            end;

          FIELD_INDEX_GROUP_NAME:
            if CacheArr[TempCacheNum].Flags and 4 <> 0 then
            begin
              ResultStr := CacheArr[TempCacheNum].GroupName;
              ResultStrFoundInCache := true;
            end;

          FIELD_INDEX_AGE_UPTODATE:
            if (CacheArr[TempCacheNum].Flags and 24 <> 0) and
               (Now - CacheArr[TempCacheNum].AgeOrUptodateTime < CurTTL) and
               // Не используем кеш, если запрос был по нажатию пробела:
               (not DemandBySpace) then
            begin
              if (CacheArr[TempCacheNum].Flags and 8 <> 0) then
              begin
                if CacheArr[TempCacheNum].AgeMode = ModeCurrent then
                begin
                  ResultStr := CacheArr[TempCacheNum].AgeOrUptodate;
                  ResultStrFoundInCache := true;
                end;
              end
              else
                // На случай, если пользователь случайно использует оба поля одновременно ('Age' и 'UpToDate Dirs'), и у нас уже есть
                // кеш поля 'UpToDate Dirs' — то сбрасываем флаг, чтобы не перерасчитывать папку второй раз
                AllowUptodateDirsByAgeField := false;
            end;

          FIELD_INDEX_UPTODATE:
            if (CacheArr[TempCacheNum].Flags and 24 <> 0) and
               (Now - CacheArr[TempCacheNum].AgeOrUptodateTime < CurTTL) and
               // Не используем кеш, если запрос был по нажатию пробела:
               (not DemandBySpace) then
            begin
              if (CacheArr[TempCacheNum].Flags and 16 <> 0) then
                ResultStr := CacheArr[TempCacheNum].AgeOrUptodate
              else
                // На случай, если пользователь случайно использует оба поля одновременно ('Age' и 'UpToDate Dirs'), и у нас уже есть
                // кеш поля Age — то делаем вид, что нашли папку (чтобы не перерасчитывать её второй раз)
                ResultStr := '';
              ResultStrFoundInCache := true;
            end;
        end; // case

      end;
    end;


    // ---------------------------------
    // Если файл в кеше не найден, или сейчас обрабатываем некешируемый столбец — то вычисляем строку
    if (not ResultStrFoundInCache) then
    begin
      // (1) Читаем атрибуты файла, и заодно дату создания/изменения
      if (not GetFileDateTimeAndAttr(FileNameWithPath, WhichDateUseForFiles, WhichDateUseForDirs, FileAttributes, FileDateTime)) then
      begin
        // Если не удалось прочитать атрибуты (файл заблокирован) — читаем с помощью GetFileAttributesW
        FileAttributes := GetFileAttributesW(FileNameWithPath);
        FileDateTime := GetFileDateTime(FileNameWithPath, WhichDateUseForFiles);
      end;
      ThisIsFolder := ((FileAttributes and FILE_ATTRIBUTES_DIRECTORY) = FILE_ATTRIBUTES_DIRECTORY);


      // (2) Расчёт даты папки по файлам внутри папки
      // (только если у нас вызов функции в отдельном потоке — нет флага CONTENT_DELAYIFSLOW)
      if ThisIsFolder and
         UseCacheAndProcessDirsOnThisUpdate and
         ((FieldIndex = FIELD_INDEX_UPTODATE) or
         ((FieldIndex = FIELD_INDEX_AGE_UPTODATE) and AllowUptodateDirsByAgeField)) then
      begin
        if (Flags and CONTENT_DELAYIFSLOW) = 0 then
        begin
          // Вычисление по запросу 'в отдельном потоке';
          // Пытаемся проверить — по нажатию пробела, или просто запрос очередного файла:
          if DemandBySpace then
          begin
            if BeepOnDemand then
              Windows.Beep(100, 20);

            // Параметры для вычисления по запросу в отдельном потоке (по нажатию пробела)
            MaxFilesToCheckTemp := OnDemandMaxFilesToCheck;
            DepthLevelsTemp := OnDemandDepthLevels;
            case GetDriveType(PAnsiChar(AnsiString(ExtractFileDrive(FileNameWithPath)+'\'))) of
              DRIVE_REMOVABLE: AllowCalculateOnThisDrive := OnDemandAllowDriveRemovable;
              DRIVE_REMOTE:    AllowCalculateOnThisDrive := OnDemandAllowDriveNetwork;
              DRIVE_CDROM:     AllowCalculateOnThisDrive := OnDemandAllowDriveCDRom;
              else             AllowCalculateOnThisDrive := true;
            end;
          end
          else
          begin
            // Параметры для обычного вычисления в отдельном потоке
            MaxFilesToCheckTemp := MaxFilesToCheck;
            DepthLevelsTemp := DepthLevels;
            case GetDriveType(PAnsiChar(AnsiString(ExtractFileDrive(FileNameWithPath)+'\'))) of
              DRIVE_REMOVABLE: AllowCalculateOnThisDrive := AllowDriveRemovable;
              DRIVE_REMOTE:    AllowCalculateOnThisDrive := AllowDriveNetwork;
              DRIVE_CDROM:     AllowCalculateOnThisDrive := AllowDriveCDRom;
              else             AllowCalculateOnThisDrive := true;
            end;
          end;

          // Проводим вычисление внутри папки
          StopProcessFolders := False;
          if AllowCalculateOnThisDrive then
          begin
            CalculatedOk := ProcessFolder(FileNameWithPath,
                                          DepthLevelsTemp,
                                          MaxFilesToCheckTemp,
                                          TryToSaveCreationDate,
                                          FileDateTime,
                                          DirDateTimeWasChanged,
                                          False);

            if DemandBySpace and BeepOnDemand then
            begin
              Sleep(50);
              Windows.Beep(200, 20);
            end;
          end
          else
          begin
            CalculatedOk := true;
            DirDateTimeWasChanged := RESULT_DATETIME_DIR_WAS_SKIPPED;
          end;
        end
        else
          // Если флаг CONTENT_DELAYIFSLOW установлен — возводим переменную DelayedResult:
          // значит, что в этот раз выводим 'временный' результат, до последующего вызова функции в отдельном потоке
          DelayedResult := true;
      end;


      // (3) Готовим сортировку по атрибутам
      AttrSortPrefixFrw := 0;
      AttrSortPrefixBck := 0;
      if ((FieldIndex = FIELD_INDEX_ATTR_SORT) and AttrField_SortByAttrEnabled) or
         ((FieldIndex = FIELD_INDEX_AGE_SORT) and AgeField_SortByAttrEnabled) then
      begin
        // Папки
        if ThisIsFolder then
        begin
          if ((FieldIndex = FIELD_INDEX_ATTR_SORT) and AttrField_SortDirsByAttr) or
             ((FieldIndex = FIELD_INDEX_AGE_SORT) and AgeField_SortDirsByAttr) then
          begin
            if (FileAttributes and LowerFoldersAttr) > 0 then
            begin
              AttrSortPrefixFrw := 3;
              if (AgeField_ReverseSort) then AttrSortPrefixBck := 1 else AttrSortPrefixBck := 3;
            end
            else
            if (FileAttributes and RiseFoldersAttr) > 0 then
            begin
              AttrSortPrefixFrw := 1;
              if (AgeField_ReverseSort) then AttrSortPrefixBck := 3 else AttrSortPrefixBck := 1;
            end
            else
            begin
              AttrSortPrefixFrw := 2;
              AttrSortPrefixBck := 2;
            end;
          end;
        end
        else
        // Файлы
        begin
          if (FileAttributes and LowerFilesAttr) > 0 then
          begin
            AttrSortPrefixFrw := 3;
            if (AgeField_ReverseSort) then AttrSortPrefixBck := 1 else AttrSortPrefixBck := 3;
          end
          else
          if (FileAttributes and RiseFilesAttr) > 0 then
          begin
            AttrSortPrefixFrw := 1;
            if (AgeField_ReverseSort) then AttrSortPrefixBck := 3 else AttrSortPrefixBck := 1;
          end
          else
          begin
            AttrSortPrefixFrw := 2;
            AttrSortPrefixBck := 2;
          end;
        end;
      end;


      // (4) Готовим сортировку по группам файлов
      GroupSortPrefixFrw := 0;
      GroupSortPrefixBck := 0;
      if ((FieldIndex = FIELD_INDEX_ATTR_SORT) and AttrField_SortByGroupEnabled) or
         ((FieldIndex = FIELD_INDEX_AGE_SORT) and AgeField_SortByGroupEnabled) or
         (FieldIndex = FIELD_INDEX_GROUP_NAME) or
         ((GroupedShowMode > 0) and (FieldIndex = FIELD_INDEX_ATTR) and AttrField_SortByGroupEnabled) then
      begin
        if ThisIsFolder then
        begin
          GroupSortPrefixFrw := GetGroupNumByName(FileName, DirsNames, MiddleGroupNum);
          GroupSortPrefixBck := MaxDirGroupsCount - GroupSortPrefixFrw;
          if (GroupSortPrefixFrw <= length(DirGroupNames)) then
            CurGroupName := DirGroupNames[GroupSortPrefixFrw];
        end

        else
        begin
          GroupSortPrefixFrw := GetGroupNumByName(FileName, FilesNames, MiddleGroupNum);
          if (GroupSortPrefixFrw = MiddleGroupNum) then
          begin
            // Расширение файла (убираем точку из расширения)
            FileExt := AnsiLowerCase(ExtractFileExt(FileNameWithPath));
            if (length(FileExt) > 0) and (FileExt[1] = '.') then FileExt := copy(FileExt, 2, MaxInt);
            GroupSortPrefixFrw := GetGroupNumByName(FileExt, FilesExts, MiddleGroupNum);
          end;

          GroupSortPrefixBck := MaxFileGroupsCount - GroupSortPrefixFrw;
          if (GroupSortPrefixFrw <= length(FileGroupNames)) then
            CurGroupName := FileGroupNames[GroupSortPrefixFrw];
        end;
      end;


      // (5) Сортировка файлов, начинающихся с подчёркивания выше файлов, начинающихся с цифр:
      if (FieldIndex = FIELD_INDEX_ATTR_SORT) or
         (FieldIndex = FIELD_INDEX_AGE_SORT) then
      begin
        // Для файлов избавляемся от расширения (для корректной сортировки по имени)
        if (not ThisIsFolder) then
          FileNameChanged := ChangeFileExt(FileName, '')
        else
          FileNameChanged := FileName;

        if UnderscoreRiseHack and (copy(FileNameChanged, 1, 1) = '_') then
          FileNameChanged[1] := '-';
      end;


      // ---------------------------------
      // (6) Вывод полей
      case FieldIndex of
        // Поле для вывода даты (давности) файла
        FIELD_INDEX_AGE,
        FIELD_INDEX_AGE_UPTODATE:
          begin

            if (FileDateTime <> 0) then
            begin
              DateInFuture := false;
              FullDateTimeWasUsed := false;

              // Количество дней (возраст файла/папки)
              FileAgeDays := Now - FileDateTime;
              FileAgeDaysAbs := abs(FileAgeDays);
              // DecodeDateTime(FileDateTime, TmpYear, TmpMonth, TmpDay, TmpHour, TmpMin, TmpSec, TmpMilli);

              if (FileAgeDays < 0) then
              begin
                // В случае, если у файла дата больше текущей на несколько секунд — ставим 0 секунд;
                if (FileAgeDays > -3*ONE_SECOND) then
                  FileAgeDaysAbs := 0
                else
                  // Дата в будущем (больше текущей)
                  DateInFuture := true;
              end;


              // Показываем время в секундах:
              if (FileAgeDaysAbs < ThresholdSec[ModeCurrent]) then
              begin
                TempInt := round(FileAgeDaysAbs * (24*60*60));
                ResultStr := IntToStr(TempInt) + ChooseRightSuffix(TempInt, SuffixSec[ModeCurrent]);
              end

              else
              // В минутах:
              if (FileAgeDaysAbs < ThresholdMin[ModeCurrent]) then
              begin
                TempInt := round(FileAgeDaysAbs * (24*60));
                ResultStr := IntToStr(TempInt) + ChooseRightSuffix(TempInt, SuffixMin[ModeCurrent]);
              end

              else
              // В часах:
              if (FileAgeDaysAbs < ThresholdHour[ModeCurrent]) then
              begin
                TempInt := round(FileAgeDaysAbs * 24);
                ResultStr := IntToStr(TempInt) + ChooseRightSuffix(TempInt, SuffixHour[ModeCurrent]);
              end

              else
              // В днях:
              if (FileAgeDaysAbs < ThresholdDay[ModeCurrent]) then
              begin
                TempInt := round(FileAgeDaysAbs);
                ResultStr := IntToStr(TempInt) + ChooseRightSuffix(TempInt, SuffixDay[ModeCurrent]);
              end

              else
              // В месяцах:
              if (FileAgeDaysAbs < ThresholdMonth[ModeCurrent]) then
              begin
                TempInt := round(FileAgeDaysAbs / 30);
                ResultStr := IntToStr(TempInt) + ChooseRightSuffix(TempInt, SuffixMonth[ModeCurrent]);
              end

              else
              // В годах:
              if (FileAgeDaysAbs < ThresholdYear[ModeCurrent]) then
              begin
                TempInt := round(FileAgeDaysAbs / 365);
                ResultStr := IntToStr(TempInt) + ChooseRightSuffix(TempInt, SuffixYear[ModeCurrent]);
              end

              // Полный формат, напр.: 2013.08.29
              else
              begin
                DateTimeToString(ResultStr, FullDateTimeFormat[ModeCurrent], FileDateTime);
                ResultStr := ResultStr + SuffixFull[ModeCurrent];
                FullDateTimeWasUsed := true;
              end;


              // Если дата файла находится в будущем — добавляем + перед ней
              if (DateInFuture) and (not FullDateTimeWasUsed) then
                ResultStr := '+' + ResultStr;
            end

            else
            begin
              // Если не смогли узнать дату файла — ставим прочерк
              // if ThisIsFolder then
              ResultStr := StrNoDateTime;
            end;
          end;


        // Поле для вывода атрибутов файла/папки
        FIELD_INDEX_ATTR:
          begin
            AtLeastOneAttr := false;
            if (FileAttributes > 0) then
            begin
              if (FileAttributes and FILE_ATTRIBUTES_READONLY) > 0 then   begin ResultStr := ResultStr + 'r'; AtLeastOneAttr := true; end else ResultStr := ResultStr + NoAttributeChar;
              if (not DontShowAttrArchive) then
                if (FileAttributes and FILE_ATTRIBUTES_ARCHIVE) > 0 then  begin ResultStr := ResultStr + 'a'; AtLeastOneAttr := true; end else ResultStr := ResultStr + NoAttributeChar;
              if (FileAttributes and FILE_ATTRIBUTES_HIDDEN) > 0 then     begin ResultStr := ResultStr + 'h'; AtLeastOneAttr := true; end else ResultStr := ResultStr + NoAttributeChar;
              if (FileAttributes and FILE_ATTRIBUTES_SYSTEM) > 0 then     begin ResultStr := ResultStr + 's'; AtLeastOneAttr := true; end else ResultStr := ResultStr + NoAttributeChar;
            end;
            if (not AtLeastOneAttr) then
              ResultStr := '';

            // Пометка групп:
            if (ResultStr = '') and (GroupedShowMode > 0) and (GroupSortPrefixFrw <> MiddleGroupNum) then
            begin
              if GroupedShowMode = 2 then
              begin
                // Название группы
                if (GroupSortPrefixFrw >= 1) and (CurGroupName <> '@') then
                  ResultStr := ResultStr + CurGroupName;
              end

              else
              if GroupedShowMode = 1 then
              begin
                // Символ того, что файл принадлежит к группе (zip, exe и т.п.)
                if GroupSortPrefixFrw < MiddleGroupNum then
                  ResultStr := ResultStr + GroupedStrRaised
                else
                  ResultStr := ResultStr + GroupedStrLowered;
              end;
            end;
          end;


        // Поле для сортировки по столбцу атрибутов файлов/папок (скрытые файлы вниз и т.п.)
        FIELD_INDEX_ATTR_SORT:
          begin
            // A) Первая сортировка по атрибутам
            // Б) Вторая сортировка по группам
            if (ThisIsFolder and GroupsSortPriorityForDirs) or ((not ThisIsFolder) and GroupsSortPriorityForFiles) then
              ResultStr := IntToStrFixed(GroupSortPrefixFrw) + ' ' + IntToStrNoZero(AttrSortPrefixFrw)
            else
              ResultStr := IntToStrNoZero(AttrSortPrefixFrw) + ' ' + IntToStrFixed(GroupSortPrefixFrw);
            ResultStr := Trim(ResultStr);

            if (AttrField_AddFileNameForSort) then
              ResultStr := ResultStr + '_' + FileNameChanged;
          end;


        // Название группы, к которой принадлежит файл/папка
        FIELD_INDEX_GROUP_NAME:
          begin
            if CurGroupName <> '@' then
              ResultStr := CurGroupName;
          end;


        // Поле для сортировки по столбцу времени файлов/папок
        FIELD_INDEX_AGE_SORT:
          begin
            // А) Первая сортировка папок и файлов по атрибутам
            // Б) Вторая сортировка по группам
            if (ThisIsFolder and GroupsSortPriorityForDirs) or ((not ThisIsFolder) and GroupsSortPriorityForFiles) then
              ResultStr := IntToStrFixed(GroupSortPrefixBck) + ' ' + IntToStrNoZero(AttrSortPrefixBck)
            else
              ResultStr := IntToStrNoZero(AttrSortPrefixBck) + ' ' + IntToStrFixed(GroupSortPrefixBck);
            ResultStr := Trim(ResultStr);

            // В) Третья сортировка — по времени
            if (not ThisIsFolder) or (ThisIsFolder and AgeField_SortDirsByTime) then
            begin
              DateTimeToString(TempStr, 'yyyy.mm.dd hh:nn:ss', FileDateTime);
              ResultStr := ResultStr + ' ' + TempStr;
            end
            else
              // Сортируем папки по имени, если отключены другие сортировки
              if (AgeField_AddFileNameForSort) then
                ResultStr := ResultStr + '_' + FileNameChanged;
          end;

      end; // case



      // (7) Пристыковываем к получившейся строке суффиксы/префиксы, касающиеся вычисления новой даты папки
      if ThisIsFolder and
         UseCacheAndProcessDirsOnThisUpdate and
         ((FieldIndex = FIELD_INDEX_UPTODATE) or
         ((FieldIndex = FIELD_INDEX_AGE_UPTODATE) and AllowUptodateDirsByAgeField)) and
         (Flags and CONTENT_DELAYIFSLOW = 0) then
      begin
        if CalculatedOk then
        begin
          if ShowUptodateStatuses then
          case DirDateTimeWasChanged of
            RESULT_DATETIME_WAS_UNCHANGED:
              if DemandBySpace then
              begin
                // Пустая строка при запросе по нажатию пробела
                if UptodateStatusAddToEndOfLine then ResultStr := ResultStr + UptodateStatusNoChangesOnDemand
                                                else ResultStr := UptodateStatusNoChangesOnDemand + ResultStr;
                UseShortTTLFlag := true;
              end
              else
              begin
                // Просто пустая строка (для выравнивания при необходимости)
                if UptodateStatusAddToEndOfLine then ResultStr := ResultStr + UptodateStatusNoChanges
                                                else ResultStr := UptodateStatusNoChanges + ResultStr;
              end;

            RESULT_DATETIME_DIR_WAS_SKIPPED:
              if DemandBySpace then
              begin
                // Папка пропущена (по нажатию пробела)
                if UptodateStatusAddToEndOfLine then ResultStr := ResultStr + UptodateStatusExcludedOnDemand
                                                else ResultStr := UptodateStatusExcludedOnDemand + ResultStr;
                UseShortTTLFlag := true;
              end
              else
              begin
                // Папка пропущена
              end;

            RESULT_DATETIME_WAS_CHANGED_AND_SAVED_YNG:
            begin
              // Дата папки изменена на более свежую
              if UptodateStatusAddToEndOfLine then ResultStr := ResultStr + UptodateStatusDateChangedYng
                                              else ResultStr := UptodateStatusDateChangedYng + ResultStr;
              UseShortTTLFlag := true;
            end;

            RESULT_DATETIME_WAS_CHANGED_AND_SAVED_OLD:
            begin
              // Дата папки изменена на старую
              if UptodateStatusAddToEndOfLine then ResultStr := ResultStr + UptodateStatusDateChangedOld
                                              else ResultStr := UptodateStatusDateChangedOld + ResultStr;
              UseShortTTLFlag := true;
            end;

            RESULT_DATETIME_WAS_CHANGED_AND_NOT_SAVED:
            begin
              // Не удалось изменить дату папки на новую (папка заблокирована для записи)
              if UptodateStatusAddToEndOfLine then ResultStr := ResultStr + UptodateStatusDirLocked
                                              else ResultStr := UptodateStatusDirLocked + ResultStr;
              UseShortTTLFlag := true;
            end;
          end;
        end

        else
        begin
          // Ошибка при обработке папки
          if UptodateStatusAddToEndOfLine then ResultStr := ResultStr + ' err.'
                                          else ResultStr := 'err. ' + ResultStr;
        end;
      end;

    end; // if (not ResultStrFoundInCache)



    // ---------------------------------
    // Возвращаем результат
    if (DelayedResult) then
    begin
      // В случае, если это результат 'временный' (будет последующий вызов функции в отдельном потоке)
      if (ProcessDirsOnChangeDir and not PanelRefreshingByCtrlR) or
         (ProcessDirsOnCtrlR and PanelRefreshingByCtrlR) then
      begin
        // Обычное обновление, либо по Ctrl+R
        if UptodateStatusAddToEndOfLine then ResultStr := ResultStr + UptodateStatusCalculating
                                        else ResultStr := UptodateStatusCalculating + ResultStr;
        Result := FT_DELAYED;
      end
      else
      begin
        if ProcessDirsOnDemand then
          // Обновление по пробелу
          Result := FT_ONDEMAND
        else
          if ResultStr <> '' then Result := FT_STRINGW
                             else Result := FT_FIELDEMPTY;
      end;

      lstrcpynW(FieldValue, PWideChar(WideString(ResultStr)), MaxLen);
    end

    else
    begin
      // Итоговый результат (для полей с длительными операциями), либо просто результат для обычных полей
      if ProcessDirsOnDemand and
         ThisIsFolder and
         AllowSecondOnDemandStatus and
         ((FieldIndex = FIELD_INDEX_UPTODATE) or
         ((FieldIndex = FIELD_INDEX_AGE_UPTODATE) and AllowUptodateDirsByAgeField)) then
        Result := FT_ONDEMAND
      else
        if ResultStr <> '' then Result := FT_STRINGW
                           else Result := FT_FIELDEMPTY;

      lstrcpynW(FieldValue, PWideChar(WideString(ResultStr)), MaxLen);
    end;



    // ---------------------------------
    // Сохраняем результат в кеш
    if CacheArrLength > 0 then
    begin
      if not ResultStrFoundInCache then
      begin
        // 1) Файл не найден в кеше — записываем его
        if FieldIndex in [FIELD_INDEX_AGE_UPTODATE,
                          FIELD_INDEX_ATTR,
                          FIELD_INDEX_ATTR_SORT,
                          FIELD_INDEX_GROUP_NAME,
                          FIELD_INDEX_UPTODATE] then
        begin
          if FileNameWithBaseDir = '' then
            FileNameWithBaseDir := ExtractFileNameWithBaseDir(FileNameWithPath);
          TempCacheNum := FastHashCount(FileNameWithBaseDir, CacheArrLength);

          // Debug
          // if (CacheArr[TempCacheNum].FileNameWithPath = '') then
          //  inc(TempCachedCounter);

          if CacheArr[TempCacheNum].FileNameWithPath <> FileNameWithPath then
          begin
            // Обнуляем кеш, т.к. в этот слот кеша сейчас записывается новый файл
            if not ThisIsFolder then CacheArr[TempCacheNum].Flags := 0
                                else CacheArr[TempCacheNum].Flags := 128;
            CacheArr[TempCacheNum].LastResult := 0;
            CacheArr[TempCacheNum].FileNameWithPath := FileNameWithPath;
          end;

          case FieldIndex of
            FIELD_INDEX_ATTR:
            begin
              CacheArr[TempCacheNum].AttrResult := ResultStr;
              CacheArr[TempCacheNum].Flags := CacheArr[TempCacheNum].Flags or 1;
            end;

            FIELD_INDEX_ATTR_SORT:
            begin
              CacheArr[TempCacheNum].AttrSortResult := ResultStr;
              CacheArr[TempCacheNum].Flags := CacheArr[TempCacheNum].Flags or 2;
            end;

            FIELD_INDEX_UPTODATE:
            begin
              if (not DelayedResult) and
                 CalculatedOk and
                 // не сохраняем в кеш дату, если не удалось изменить время папки (папка не доступна для записи)
                 (DirDateTimeWasChanged <> RESULT_DATETIME_WAS_CHANGED_AND_NOT_SAVED) then
              begin
                CacheArr[TempCacheNum].AgeOrUptodate := ResultStr;
                CacheArr[TempCacheNum].AgeOrUptodateTime := Now;
                CacheArr[TempCacheNum].AgeMode := ModeCurrent;
                CacheArr[TempCacheNum].Flags := (CacheArr[TempCacheNum].Flags and ($FF - 8)) or 16;
                if UseShortTTLFlag then CacheArr[TempCacheNum].Flags := CacheArr[TempCacheNum].Flags or 64
                                   else CacheArr[TempCacheNum].Flags := (CacheArr[TempCacheNum].Flags and ($FF - 64));
              end;
              // Сохраняем последний статус результата, который мы вернули для этого файла
              // (чтобы можно было определить при последующем запросе — нужен ли обычный подсчёт, или подсчёт по нажатию пробела)
              CacheArr[TempCacheNum].LastResult := Result;
            end;

            FIELD_INDEX_AGE_UPTODATE:
            begin
              if AllowUptodateDirsByAgeField and
                 (not DelayedResult) and
                 CalculatedOk and
                 // не сохраняем в кеш дату, если не удалось изменить время папки (папка не доступна для записи)
                 (DirDateTimeWasChanged <> RESULT_DATETIME_WAS_CHANGED_AND_NOT_SAVED) then
              begin
                CacheArr[TempCacheNum].AgeOrUptodate := ResultStr;
                CacheArr[TempCacheNum].AgeOrUptodateTime := Now;
                CacheArr[TempCacheNum].AgeMode := ModeCurrent;
                CacheArr[TempCacheNum].Flags := (CacheArr[TempCacheNum].Flags and ($FF - 16)) or 8;
                if UseShortTTLFlag then CacheArr[TempCacheNum].Flags := CacheArr[TempCacheNum].Flags or 64
                                   else CacheArr[TempCacheNum].Flags := (CacheArr[TempCacheNum].Flags and ($FF - 64));
              end;
              CacheArr[TempCacheNum].LastResult := Result;
            end;
          end;

          if (CurGroupName <> '@') then
          begin
            CacheArr[TempCacheNum].GroupName := CurGroupName;
            CacheArr[TempCacheNum].Flags := CacheArr[TempCacheNum].Flags or 4;
          end;
        end;
      end

      else
      // 2) Даже если файл был найден в кеше — обновляем поле LastResult
      begin
        if ((FieldIndex = FIELD_INDEX_AGE_UPTODATE) and AllowUptodateDirsByAgeField) or
           (FieldIndex = FIELD_INDEX_UPTODATE) then
        begin
          if FileNameWithBaseDir = '' then
            FileNameWithBaseDir := ExtractFileNameWithBaseDir(FileNameWithPath);
          TempCacheNum := FastHashCount(FileNameWithBaseDir, CacheArrLength);
          CacheArr[TempCacheNum].LastResult := Result;
        end;
      end;
    end;


    // Запоминаем время последней активности для любого поля кроме Age Sort
    if FieldIndex <> FIELD_INDEX_AGE_SORT then
      LastActivityTimeForAgeField := Now;

  except
      Result:= FT_FILEERROR;
  end;

  (*
  PInteger(FieldValue)^ := 10;
  Result:= FT_NUMERIC_32;

  PInt64(FieldValue)^ := 10;
  Result := FT_NUMERIC_64;

  lstrcpynW(FieldValue, PWideChar(WideString(FloatToStr(1.0))), MaxLen);
  Result := FT_NUMERIC_FLOATING;

  PdecWDXDateFormat(FieldValue)^ := ...
  Result := FT_DATE;

  PBool(FieldValue)^ := true;
  Result := FT_BOOLEAN;
  *)
end;

{----------------------------------------------------------------------------------------------}

function ContentGetValue(FileName: pAnsiChar;
                         FieldIndex, UnitIndex: integer;
                         FieldValue: PAnsiChar;
                         MaxLen, Flags: integer): integer; stdcall;

var
  ResWideString: WideString;
  ResWideCharPtr: PWideChar;

begin
  SetLength(ResWideString, MaxLen);
  ResWideCharPtr := Addr(ResWideString[1]);
  Result := ContentGetValueW(pWideChar(WideString(FileName)),
                             FieldIndex,
                             UnitIndex,
                             ResWideCharPtr,
                             MaxLen, Flags);
  if Result = FT_STRINGW then
    Result := FT_STRING;
  lstrcpyn(FieldValue, PAnsiChar(AnsiString(ResWideString)), MaxLen);
end;

{----------------------------------------------------------------------------------------------}

function ContentGetSupportedFieldFlags(FieldIndex: integer): integer; stdcall;
begin
  Result := 0;

  // Сообщаем о том, что пусть Тотал Коммандер сам показывает дату, если у плагина нет возможности (архив, FTP и т.п.)
  if (FieldIndex = -1) then
  begin
    // Запрос при первом запуске о поддерживаемых флагах
    Result := ContFlags_SubstMask;
  end

  else
  begin
    // Запрос отдельно для каждого поля
    case FieldIndex of
      FIELD_INDEX_AGE,
      FIELD_INDEX_AGE_UPTODATE:   Result := ContFlags_SubstDateTime;
      FIELD_INDEX_ATTR:           Result := ContFlags_SubstAttributeStr;
    end;
  end;
end;

{----------------------------------------------------------------------------------------------}

// Вызывается при смене папки, либо обновлении
// (при обновлении по Ctrl+R вызывается дважды, сначала ContSt_RefreshPressed, затем ContSt_ReadNewdir)
procedure ContentSendStateInformationW(State: integer; Path: PWideChar); stdcall;
begin
  // Проверяем — нужно ли использовать кеш во время этого апдейта (не используем, если было обновление по CTRL+R)
  if (State = ContSt_RefreshPressed) or (RefreshPressedAMomentAgo) then
  begin
    PanelRefreshingByCtrlR := true;
    UseCacheOnThisUpdateForAttrField := false;
    CurrentAgeOrUptodateCacheTTL := AgeOrUptodateCacheTTLWhenCtrlR;
  end
  else
  begin
    PanelRefreshingByCtrlR := false;
    UseCacheOnThisUpdateForAttrField := true;
    CurrentAgeOrUptodateCacheTTL := AgeOrUptodateCacheTTL;
  end;

  LastUpdatingPath := Path;
  AttrSortField_FilesCounter := 0;


  // Переключение режимов при обновлении с зажатым Shift/Alt/Ctrl
  if (RefreshPressedAMomentAgo) and
     ((not UseSHIFTForChangeMode) or ShiftPressed) and
     ((not UseCTRLForChangeMode) or CtrlPressed) and
     ((not UseALTForChangeMode) or AltPressed) then
  begin
    inc(ModeCurrent);
    if (ModeCurrent > ModesUsed) then
      ModeCurrent := 1;
    UseCacheAndProcessDirsOnThisUpdate := false;
  end
  else
    UseCacheAndProcessDirsOnThisUpdate := true;


  if (not RefreshPressedAMomentAgo) then
  begin
    if ModeResetWhenDirChanged and (State = ContSt_ReadNewdir) then
      ModeCurrent := 1;
  end;


  // Т.к. при обновлении по Ctrl+R эта функция вызывается дважды (сначала State = ContSt_RefreshPressed, затем ContSt_ReadNewdir),
  // то используем RefreshPressedAMomentAgo (если true, то сейчас будет обновление по Ctrl+R, несмотря на то, что State = ContSt_ReadNewdir).
  case State of
    ContSt_ReadNewdir:
      RefreshPressedAMomentAgo := false;

    ContSt_RefreshPressed:
    begin
      RefreshPressedAMomentAgo := true;

      // Загружаем настройки повторно из Ini-файла
      if ReloadIniOnCtrlR then
        LoadIniFile;
    end;

    ContSt_ShowHint:
  end;

  // Запоминаем время последней активности для того чтобы потом отличить запрос на расчёт по нажатию пробела
  LastActivityTimeForAgeField := Now;

  { // Debug
  if (State = ContSt_RefreshPressed) then
  begin
    // ShowMessage('Cached: ' + IntToStr(TempCachedCounter) + ' Found: ' + IntToStr(TempFoundInCache));
    // TempFoundInCache := 0;

    ShowMessage(IntToStr(TempCounter));
    Windows.Beep(500,10);
    TempCounter := 0;
  end;
  TempCounter := 0; }
end;

{----------------------------------------------------------------------------------------------}

// Вызывается один раз при попытке сортировки по какому-либо столбцу
function ContentGetDefaultSortOrder(FieldIndex: integer): integer; stdcall;
begin
  Result := 1;
  if FieldIndex in [FIELD_INDEX_AGE, FIELD_INDEX_AGE_UPTODATE, FIELD_INDEX_AGE_SORT] then
    if (AgeField_ReverseSort) then
      Result := -1;

  // Запоминаем время последней активности для того чтобы потом отличить запрос на расчёт по нажатию пробела
  LastActivityTimeForAgeField := Now;
end;

{----------------------------------------------------------------------------------------------}

// Вызывается сразу после загрузки плагина
procedure ContentSetDefaultParams(Dps: PContentDefaultParamStruct); stdcall;
begin
  // Debug info:
  PluginInterfaceVersion := Dps.PluginInterfaceVersionHi + Dps.PluginInterfaceVersionLow/100;
  // Запрещаем повторное выставление статуса FT_ONDEMAND в TC версии ниже, чем 7.55 (plugin interface verison < 2.10)
  AllowSecondOnDemandStatus := PluginInterfaceVersion >= 2.1;
end;

{----------------------------------------------------------------------------------------------}

// Выгрузка плагина перед закрытием TC
procedure ContentPluginUnloading; stdcall;
begin
  if not ModeResetAfterTCRestart then
    IniSaveIntKey('Age Field Mode Switch', 'ModeCurrent', ModeCurrent);
end;

{----------------------------------------------------------------------------------------------}

// Вызывается при необходимости отмены долгой операции (перешли в другую папку и расчёт уже не нужен)
procedure ContentStopGetValueW(FileName: PWideChar); stdcall;
begin
  StopProcessFolders := True;
end;

{----------------------------------------------------------------------------------------------}

exports
  ContentGetSupportedField,
  ContentGetValue,
  ContentGetValueW,
  ContentStopGetValueW,
  ContentGetSupportedFieldFlags,
  ContentSendStateInformationW,
  ContentGetDefaultSortOrder,
  ContentSetDefaultParams,
  ContentPluginUnloading;

{$R *.res}

begin
  Init;

end.

