' ChooseMediaPlayer = Total Commander selection of files and folders To multi media players.
' ChooseMediaPlayer is a upgrade version of 'TC2MP'
' pjhplace@naver.com
' I'm a PowerBasic beginner...

#COMPILE EXE
#DIM ALL
#RESOURCE "Resources.pbr"
#INCLUDE "Win32API.INC"
#INCLUDE "UTF8.INC" ' Coding by pjhplace@naver.com

$AppTitle = "ChooseMediaPlayer v1.53"
$AutoLangTitle = "ChooseMediaPlayer Automation"
%MaxMessages = 100

DECLARE FUNCTION IsFileNameProper(BYVAL GivenFilename AS STRING, BYVAL TargetSection AS LONG) AS STRING
DECLARE FUNCTION GetShortFileName (BYVAL GivenFileName AS STRING) AS STRING
DECLARE FUNCTION ExeName(Op AS LONG) AS STRING ' Code by "Semen Matusovski" - Power Basic Web Site

DECLARE CALLBACK FUNCTION AppendBox() AS LONG
DECLARE CALLBACK FUNCTION ChooseBox() AS LONG
DECLARE CALLBACK FUNCTION LanguageBox() AS LONG

DECLARE SUB ReadPlayerInformation_Module()

GLOBAL hDlg AS DWORD ' Dialog Box handle
GLOBAL lResult AS LONG ' Dialog Box Result
GLOBAL RunAppHandle AS DWORD ' Not important.. This is just a temporary handle for running APP asynchronously.

GLOBAL CommandLine AS STRING
GLOBAL ChosenPlayer AS STRING
GLOBAL TCListFile AS STRING
GLOBAL CurFolder AS STRING ' Current Foler of TC2MP.EXE
GLOBAL Chosen_TC2MP_INI AS STRING

GLOBAL Dir_ProgramFiles AS STRING
GLOBAL Dir_TotalCommander AS STRING
GLOBAL Dir_Windows AS STRING
GLOBAL Dir_System AS STRING

GLOBAL NativeMessages() AS STRING

GLOBAL TC2MP_INI() AS STRING
GLOBAL TC2MP_INI_N AS LONG

GLOBAL INI_Player AS STRING
GLOBAL INI_Extension AS STRING
GLOBAL INI_Filter AS STRING
GLOBAL INI_WindowState AS LONG
GLOBAL INI_FirstLine AS STRING
GLOBAL INI_CodeLine AS STRING
GLOBAL INI_EndLine AS STRING
GLOBAL INI_CommandLine AS STRING
GLOBAL INI_WritingMode AS LONG
GLOBAL INI_AddPosition AS LONG
GLOBAL INI_RetrieveRegExp AS STRING
GLOBAL INI_RetrieveRegExLeft AS STRING
GLOBAL INI_RetrieveRegExRight AS STRING
GLOBAL INI_Unicode AS LONG

GLOBAL FinalList() AS STRING ' Store only media files to play
GLOBAL FinalListEntryNumber AS LONG

FUNCTION PBMAIN () AS LONG

    DIM NativeMessages(1 TO %MaxMessages) AS GLOBAL STRING
    DIM TC2MP_INI(1 TO 100) AS GLOBAL STRING
    DIM FinalList(1 TO 500) AS GLOBAL STRING ' Store only media files to play

    REGISTER Temp1 AS LONG, Temp2 AS LONG, Temp3 AS LONG, Temp4 AS LONG, TempCounter AS LONG

    DIM Reader AS STRING ' Line Reader For Reading File
    DIM Item AS STRING, Value AS STRING, Value123 AS LONG ' INI file

    CurFolder = ExeName(2) ' Get folder path of running TC2MP.exe

    ' Retrieving Path of Special Folders

    ' Folder path - Program Files

    LOCAL TempAPIString AS STRING * %MAX_PATH, TempAPIString2 AS ASCIIZ * %MAX_PATH
    DIM RegKeyHandle AS DWORD, API_Result AS LONG

    TempAPIString = STRING$(%MAX_PATH, 32)
    API_Result = RegOpenKeyEx(%HKEY_LOCAL_MACHINE, "SOFTWARE\Microsoft\Windows\CurrentVersion", 0, %KEY_READ, RegKeyHandle)
    IF API_Result = %NOERROR THEN
        API_Result = RegQueryValueEx(RegKeyHandle, "ProgramFilesDir", %NULL, %NULL, BYVAL VARPTR(TempAPIString), LEN(TempAPIString))
        IF API_Result = %NOERROR THEN
            Temp1 = INSTR(TempAPIString, CHR$(0))
            IF Temp1 <= 1 THEN
                MSGBOX "CMP can't find the path of 'Program Files' folder in registry.   " & $CRLF & $CRLF & "Check your windows.   ", %MB_ICONWARNING, $AppTitle
                EXIT FUNCTION
            END IF
            Dir_ProgramFiles = LEFT$(TempAPIString, INSTR(TempAPIString, CHR$(0)) - 1)
        END IF
    END IF

    ' Folder path - Total Commander
    TempAPIString = STRING$(%MAX_PATH, 32)
    API_Result = RegOpenKeyEx(%HKEY_LOCAL_MACHINE, "SOFTWARE\Ghisler\Total Commander", 0, %KEY_READ, RegKeyHandle)
    IF API_Result = %NOERROR THEN
        API_Result = RegQueryValueEx(RegKeyHandle, "InstallDir", %NULL, %NULL, BYVAL VARPTR(TempAPIString), LEN(TempAPIString))
        IF API_Result = %NOERROR THEN
            Temp1 = INSTR(TempAPIString, CHR$(0))
            IF Temp1 > 1 THEN
                Dir_TotalCommander = LEFT$(TempAPIString, INSTR(TempAPIString, CHR$(0)) - 1)
            END IF
        END IF
    END IF

    ' Folder path - Windows
    TempAPIString2 = STRING$(%MAX_PATH, 0)
    API_Result = GetWindowsDirectory(TempAPIString2, %MAX_PATH)
    Dir_Windows = TempAPIString2

    ' Folder path - System
    TempAPIString2 = STRING$(%MAX_PATH, 0)
    API_Result = GetSystemDirectory(TempAPIString2, %MAX_PATH)
    Dir_System = TempAPIString2

    RegCloseKey RegKeyHandle

    ' Checking Language file

    IF DIR$(CurFolder & "Default.LNG", %NORMAL OR %READONLY OR %HIDDEN OR %SYSTEM) = "" THEN
        IF DIR$(CurFolder & "Language", %NORMAL OR %READONLY OR %HIDDEN OR %SYSTEM OR %SUBDIR) = "" THEN
            MSGBOX "There is no Language file or folder.   " & $CRLF & $CRLF & "You need to download original ZIP file again.   ", %MB_ICONINFORMATION, $AppTitle
            EXIT FUNCTION
        END IF

        GLOBAL SelectedLanguage AS STRING
        DIM Lang_Num AS LONG
        DIM LangFile(1 TO 10) AS STRING

        Reader = DIR$(CurFolder & "Language\*.LNG", %NORMAL OR %READONLY OR %HIDDEN OR %SYSTEM)
        DO UNTIL Reader = ""
            INCR Lang_Num
            LangFile(Lang_Num) = LEFT$(Reader, LEN(Reader) - 4)
            IF Lang_Num = UBOUND(LangFile) THEN
                REDIM PRESERVE LangFile(1 TO Lang_Num + 10)
            END IF
            Reader = DIR$
        LOOP

        IF Lang_Num = 0 THEN
            MSGBOX "There are no Language files in sub-folder 'Langauge'.   " & $CRLF & $CRLF & "You need to download original ZIP file again.   ", %MB_ICONINFORMATION, $AppTitle
            EXIT FUNCTION
        END IF

        DO
            DIALOG FONT "Times New Roman", 11
            DIALOG NEW PIXELS, 0, $AppTitle, , ,450, 149, &H084C000D4&, 0 TO hDlg
            CONTROL ADD LABEL, hDlg, 0, "Select your language.", 15, 10, 320, 20
            CONTROL ADD LABEL, hDlg, 0, "If you use this tool first, Check TC2MP.INI to modify paths of players.", 15, 32, 440, 20
            CONTROL ADD COMBOBOX, hDlg, 100, LangFile(), 117, 67, 200, 100, %CBS_DROPDOWNLIST OR %CBS_SORT OR %WS_TABSTOP OR %CBS_HASSTRINGS
            CONTROL ADD BUTTON, hDlg, %IDOK, "OK", 117, 108, 95, 30, %WS_TABSTOP
            CONTROL ADD BUTTON, hDlg, %IDCANCEL, "Cancel", 222, 108, 95, 30, %WS_TABSTOP
            DIALOG SHOW MODAL hDlg, CALL LanguageBox() TO lResult

            SELECT CASE lResult
                CASE 1
                    IF SelectedLanguage = "" THEN
                        MSGBOX "Select a Language!   ", %MB_ICONINFORMATION, $AppTitle
                    ELSE
                        EXIT DO
                    END IF
                CASE 2
                    EXIT FUNCTION
            END SELECT
        LOOP

        FILECOPY CurFolder & "Language\" & SelectedLanguage & ".lng", CurFolder & "Default.lng"
        IF DIR$(CurFolder & "Language\" & SelectedLanguage & ".cfg", %NORMAL OR %READONLY OR %HIDDEN OR %SYSTEM) <> "" THEN
            IF DIR$(CurFolder & "TC2MP_Look.INI", %NORMAL OR %READONLY OR %HIDDEN OR %SYSTEM) = "" THEN
                FILECOPY CurFolder & "Language\" & SelectedLanguage & ".cfg", CurFolder & "TC2MP_Look.INI"
            ELSE
                SELECT CASE MSGBOX("TC2MP_Look.INI already exist. Do you want to overwrite it?   ", %MB_YESNO OR %MB_DEFBUTTON1 OR %MB_APPLMODAL, $AppTitle)
                    CASE %IDYES
                        SETATTR CurFolder & "TC2MP_Look.INI", %NORMAL
                        FILECOPY CurFolder & "Language\" & SelectedLanguage & ".cfg", CurFolder & "TC2MP_Look.INI"
                    CASE %IDNO
                END SELECT
            END IF
        END IF
        ERASE LangFile()
    END IF

    ' Reading Language file

    DIM MesIndex AS LONG
    DIM Message AS STRING

    OPEN CurFolder & "Default.LNG" FOR INPUT AS #1
    DO UNTIL EOF(1)
        LINE INPUT #1, Reader
        Temp1 = LEN(Reader)
        Temp2 = INSTR(Reader, "=")
        IF Temp2<=1 OR Temp2>=Temp1 THEN ITERATE DO
        MesIndex = INT(VAL(LEFT$(Reader, Temp2 - 1)))
        IF MesIndex<1 OR MesIndex>%MaxMessages THEN ITERATE DO
        Message = LTRIM$(RIGHT$(Reader, Temp1 - Temp2))
        REPLACE "\n" WITH $CRLF IN Message
        NativeMessages(MesIndex) = Message
    LOOP
    CLOSE #1

    ' Parse CommandLine

    CommandLine = TRIM$(COMMAND$)
    REGEXPR "^[^:]+:[^/]+$" IN CommandLine TO Temp1
    IF Temp1 = 1 THEN
        Temp1 = LEN(CommandLine)
        Temp2 = INSTR(CommandLine, ":")

        IF Temp2<=1 OR Temp2>=Temp1 THEN
            Message = NativeMessages(1)
            REPLACE "[^COMMANDLINE^]" WITH CommandLine IN Message
            MSGBOX Message, %MB_ICONINFORMATION, $AppTitle
            EXIT FUNCTION
        END IF

        Chosen_TC2MP_INI = "TC2MP.INI"
        ChosenPlayer = UCASE$(TRIM$(LEFT$(CommandLine, Temp2-1)))
        TCListFile = TRIM$(RIGHT$(CommandLine, Temp1-Temp2))
    ELSE
        REGEXPR "^[^:]+:[^/]+/[^/]+$" IN CommandLine TO Temp1
        IF Temp1 = 1 THEN
            Temp1 = LEN(CommandLine)
            Temp2 = INSTR(CommandLine, ":")
            Temp3 = INSTR(-1, CommandLine, "/")

            Chosen_TC2MP_INI = TRIM$(RIGHT$(CommandLine, Temp1 - Temp3))
            ChosenPlayer = UCASE$(TRIM$(LEFT$(CommandLine, Temp2-1)))
            TCListFile = TRIM$(MID$(CommandLine, Temp2 + 1, Temp3-Temp2-1))
        ELSE
            Message = NativeMessages(1)
            REPLACE "[^COMMANDLINE^]" WITH CommandLine IN Message
            MSGBOX Message, %MB_ICONINFORMATION, $AppTitle
            EXIT FUNCTION
        END IF
    END IF

    ' Read TC2MP.INI

    IF DIR$(CurFolder & Chosen_TC2MP_INI, %NORMAL OR %READONLY OR %HIDDEN OR %SYSTEM) = "" THEN
        Message = NativeMessages(2)
        REPLACE "[^TC2MP.INI^]" WITH Chosen_TC2MP_INI IN Message
        REPLACE "[^CURFOLDER^]" WITH CurFolder IN Message
        MSGBOX Message, %MB_ICONINFORMATION, $AppTitle
        EXIT FUNCTION
    END IF

    OPEN CurFolder & Chosen_TC2MP_INI FOR INPUT AS #1
    DO UNTIL EOF(1)
        LINE INPUT #1, Reader
        REPLACE $TAB WITH "" IN Reader
        INCR TC2MP_INI_N
        TC2MP_INI(TC2MP_INI_N) = TRIM$(Reader)
        IF TC2MP_INI_N = UBOUND(TC2MP_INI) THEN
            REDIM PRESERVE TC2MP_INI(1 TO TC2MP_INI_N + 100)
        END IF
    LOOP
    CLOSE #1

    IF TC2MP_INI_N = 0 THEN
        MSGBOX NativeMessages(6), %MB_ICONINFORMATION, $AppTitle
        EXIT FUNCTION
    END IF

    ' Read TC2MP_Look.INI

    DIM DefaultFontname AS STRING
    DIM DefaultFontSize AS LONG
    DIM CBBGColor AS DWORD
    DIM CBPosX AS LONG
    DIM CBPosY AS LONG
    DIM Temp_CBWidth AS DWORD
    DIM CBFontName AS STRING
    DIM CBFontSize AS LONG
    DIM CBFontColor AS DWORD
    DIM CBFrame1Visible AS LONG
    DIM CBFrame2Visible AS LONG
    DIM CBFrame3Visible AS LONG
    DIM CBFrame4Visible AS LONG
    DIM CBLRMargin AS DWORD
    DIM CBFrameVisibleNumber AS DWORD
    DIM CBMarginForOthers AS DWORD

    DIM CBButtonFontName AS STRING
    DIM CBButtonFontSize AS LONG
    DIM CBButtonHeight AS DWORD
    DIM CBButtonWidth AS DWORD
    DIM CBButtonInterval AS DWORD
    DIM CBButtonStartTop AS DWORD

    DIM CBLabelPos(1 TO 10, 2) AS LONG
    DIM CBLabelPosX AS LONG, CBLabelPosY AS LONG
    DIM CBLabelFC(1 TO 10) AS DWORD
    DIM CBLabelForeColor AS DWORD
    DIM CBLabelStr(1 TO 10) AS STRING
    DIM CBLabelNum AS LONG
    ARRAY ASSIGN CBLabelFC() = 0,0,0,0,0,0,0,0,0,0

    DefaultFontname = "Times New Roman"
    DefaultFontSize = 11
    CBBGColor = RGB(204,204,153)
    CBFontColor = %BLACK
    CBPosX = 0
    CBPosY = 0
    CBFontName = "Arial"
    CBFontSize = 11
    CBFrame1Visible = 1
    CBFrame2Visible = 1
    CBFrame3Visible = 1
    CBFrame4Visible = 1
    CBLRMargin = 10
    CBFrameVisibleNumber = 0

    CBButtonFontName = "Times New Roman"
    CBButtonFontSize = 20
    CBButtonHeight = 35
    CBButtonWidth = 330
    CBButtonInterval = 5
    CBButtonStartTop = 50

    %FrameHeight = 49

    IF DIR$(CurFolder & "TC2MP_Look.INI", %NORMAL OR %READONLY OR %HIDDEN OR %SYSTEM) <> "" THEN
        OPEN CurFolder & "TC2MP_Look.INI" FOR INPUT AS #1
        DO UNTIL EOF(1)
            LINE INPUT #1, Reader
            Reader = TRIM$(Reader)
            IF LEFT$(Reader, 1) = ";" THEN ITERATE DO ' Skip Comments ּ ǳʶ
            Temp1 = LEN(Reader)
            Temp2 = INSTR(Reader, "=")
            IF Temp2<=1 OR Temp2>=Temp1 THEN ITERATE DO
            Item = UCASE$(TRIM$(LEFT$(Reader, Temp2-1)))
            Value = TRIM$(RIGHT$(Reader, Temp1-Temp2))
            SELECT CASE Item
                CASE "MESSAGEBOX_DEFAULT_FONTNAME"
                    DefaultFontName = Value
                CASE "MESSAGEBOX_DEFAULT_FONTSIZE"
                    Value123 = VAL(Value)
                    IF Value123 => 5 AND Value123 <= 20 THEN DefaultFontSize = Value123
                CASE "CHOOSEBOX_BG_COLOR"
                    Value123 = VAL("&H0" & Value)
                    IF Value123 >= 0 AND Value123 <= RGB(255,255,255) THEN CbBGColor = Value123
                CASE "CHOOSEBOX_FONTCOLOR"
                    Value123 = VAL("&H0" & Value)
                    IF Value123 >= 0 AND Value123 <= RGB(255,255,255) THEN CBFontColor = Value123
                CASE "MESSAGE_X"
                    Value123 = VAL(Value)
                    CBLabelPosX = Value123
                CASE "MESSAGE_Y"
                    Value123 = VAL(Value)
                    CBLabelPosY = Value123
                CASE "MESSAGE_FONTCOLOR"
                    Value123 = VAL("&H0" & Value)
                    IF Value123 >= 0 AND Value123 <= RGB(255,255,255) THEN CBLabelForeColor = Value123
                CASE "PRINT_MESSAGE"
                    INCR CBLabelNum
                    CBLabelStr(CBLabelNum) = Value
                    CBLabelFC(CBLabelNum) = CBLabelForeColor
                    CBLabelPos(CBLabelNum, 1) = CBLabelPosX
                    CBLabelPos(CBLabelNum, 2) = CBLabelPosY
                CASE "CHOOSEBOX_POSX"
                    Value123 = VAL(Value)
                    CBPosX = Value123
                CASE "CHOOSEBOX_POSY"
                    Value123 = VAL(Value)
                    CBPosY = Value123
                CASE "CHOOSEBOX_WIDTH"
                    Value123 = VAL(Value)
                    IF Value123 >= 100 THEN
                        Temp_CBWidth = Value123
                        CBButtonWidth = Temp_CBWidth - CBLRMargin * 2
                    END IF
                CASE "CHOOSEBOX_FONTNAME"
                    CBFontName = Value
                CASE "CHOOSEBOX_FONTSIZE"
                    Value123 = VAL(Value)
                    IF Value123 >= 5 AND Value123 <= 20 THEN CBFontSize = Value123
                CASE "CHOOSEBOX_BUTTON_FONTNAME"
                    CBButtonFontName = Value
                CASE "CHOOSEBOX_BUTTON_FONTSIZE"
                    Value123 = VAL(Value)
                    IF Value123 >= 15 AND Value123 <= 50 THEN CBButtonFontSize = Value123
                CASE "CHOOSEBOX_FRAME1_VISIBLE"
                    IF Value = "0" THEN
                        CBFrame1Visible = 0
                    ELSE
                        INCR CBFrameVisibleNumber
                    END IF
                CASE "CHOOSEBOX_FRAME2_VISIBLE"
                    IF Value = "0" THEN
                        CBFrame2Visible = 0
                    ELSE
                        INCR CBFrameVisibleNumber
                    END IF
                CASE "CHOOSEBOX_FRAME3_VISIBLE"
                    IF Value = "0" THEN
                        CBFrame3Visible = 0
                    ELSE
                        INCR CBFrameVisibleNumber
                    END IF
                CASE "CHOOSEBOX_FRAME4_VISIBLE"
                    IF Value = "0" THEN
                        CBFrame4Visible = 0
                    ELSE
                        INCR CBFrameVisibleNumber
                    END IF
                CASE "CHOOSEBOX_LR_MARGIN"
                    Value123 = VAL(Value)
                    IF Value123 => 1 AND Value123 <= 20 THEN
                        CBLRMargin = Value123
                        IF Temp_CBWidth > 0 THEN CBButtonWidth = Temp_CBWidth - CBLRMargin * 2
                    END IF
                CASE "CHOOSEBOX_BUTTON_HEIGHT"
                    Value123 = VAL(Value)
                    IF Value123 >= 15 AND Value123 <= 100 THEN CBButtonHeight = Value123
                CASE "CHOOSEBOX_BUTTON_INTERVAL"
                    Value123 = VAL(Value)
                    IF Value123 >= 1 AND Value123 <= 20 THEN CBButtonInterval = Value123
                CASE "CHOOSEBOX_BUTTON_STARTTOP"
                    Value123 = VAL(Value)
                    IF Value123 >= 1 AND Value123 <= 100 THEN CBButtonStartTop = Value123
            END SELECT
        LOOP
        CLOSE #1
    ELSE
        MSGBOX NativeMessages(4)
        CBFrameVisibleNumber = 4
    END IF

    IF CBFrameVisibleNumber = 0 THEN
        CBMarginForOthers = 9
    ELSE
        CBMarginForOthers = %FrameHeight * CBFrameVisibleNumber + 19
    END IF

' Check conditions of [Auto Decision] - mini language
' If it fails, Flow goes on Choose mode
' -----------------------------------------------------------------------------------------------------------------
    IF ChosenPlayer = "[AUTO]" THEN

        DIM MiniLang(1 TO 20) AS STRING
        DIM MiniLangN AS LONG
        DIM Collections(1 TO 10) AS STRING
        DIM Elements(1 TO 10) AS STRING
        DIM CollectionsN AS LONG
        DIM Criteria(1 TO 10) AS STRING
        DIM CorrespondingPlayers(1 TO 10) AS STRING
        DIM CriteriaStats(1 TO 10) AS LONG
        DIM CriteriaN AS LONG
        DIM ExceptionStats AS LONG
        DIM BasicPlayer AS STRING

        DIM BasicFilter AS STRING

        DIM IsWithinGroup AS LONG
        DIM CurrentPlayerGroup AS STRING

        DIM AutoPlayers_Number AS LONG
        DIM AutoPlayers_Entry(1 TO 10) AS STRING

        ' List of players available
        FOR TempCounter = 1 TO TC2MP_INI_N
            Reader = TC2MP_INI(TempCounter)
            IF LEFT$(Reader, 1) = ";" THEN ITERATE FOR ' Skip Comments ּ ǳʶ
            IF LEN(Reader)>=3 AND LEFT$(Reader,1)="[" AND RIGHT$(Reader,1)="]" THEN
                Reader = TRIM$(MID$(Reader, 2, LEN(Reader) - 2))
                IF Reader = "" THEN ITERATE FOR
                IF UCASE$(Reader) = "AUTO DECISION" THEN
                    Reader = ""
                    ITERATE FOR
                END IF
                INCR AutoPlayers_Number
                AutoPlayers_Entry(AutoPlayers_Number) = UCASE$(Reader)
                IF AutoPlayers_Number = UBOUND(AutoPlayers_Entry) THEN
                    REDIM PRESERVE AutoPlayers_Entry(1 TO AutoPlayers_Number + 10)
                END IF
            END IF
        NEXT TempCounter

        IF AutoPlayers_Number = 0 THEN
            MSGBOX NativeMessages(3), %MB_ICONINFORMATION, $AppTitle
            RunAppHandle = SHELL("Notepad.exe " & CHR$(34) & CurFolder & Chosen_TC2MP_INI & CHR$(34), 1)
            EXIT FUNCTION
        END IF

        ' Finding the block of [Auto Decision]
        FOR TempCounter = 1 TO TC2MP_INI_N
            Reader = TC2MP_INI(TempCounter)
            IF Reader = "" THEN ITERATE FOR
            IF LEFT$(Reader, 1) = ";" THEN ITERATE FOR ' Skip Comments ּ ǳʶ
            IF LEN(Reader)>=3 AND LEFT$(Reader,1)="[" AND RIGHT$(Reader,1)="]" THEN ' Group Title
                IF IsWithinGroup = 1 THEN
                    EXIT FOR ' If you are within a right group already and then meet another gorup, exit INI file.
                END IF
                CurrentPlayerGroup = UCASE$(TRIM$(MID$(Reader, 2, LEN(Reader) - 2)))
                IF CurrentPlayerGroup <> "" AND CurrentPlayerGroup = "AUTO DECISION" THEN IsWithinGroup = 1 ' You are within a right group.
            ELSE ' Item Line
                IF IsWithinGroup = 0 THEN ITERATE FOR ' IF you are not within a right group, Ignore items.
                INCR MiniLangN
                MiniLang(MiniLangN) = Reader
                IF MiniLangN = UBOUND(MiniLang) THEN
                    REDIM PRESERVE MiniLang(1 TO MiniLangN + 20)
                END IF
            END IF
        NEXT TempCounter

        DIM Keyword AS STRING
        DIM RestWords AS STRING
        DIM CollectionName AS STRING
        DIM SubCollectionName AS STRING
        DIM ElementStr AS STRING
        DIM TempStr AS STRING
        DIM ML_POS AS LONG, ML_LEN AS LONG

        ' Parse and check mini-language
        FOR TempCounter = 1 TO MiniLangN
            Reader = UCASE$(MiniLang(TempCounter))
            Temp1 = LEN(Reader)
            Temp2 = INSTR(Reader, " ")
            IF Temp2 = 0 THEN
                MSGBOX NativeMessages(50) & $CRLF & $CRLF & MCASE$(Reader), %MB_ICONINFORMATION, $AutoLangTitle
                CriteriaN = 0
                GOTO EndOfCheckSyntax
            END IF
            Keyword = TRIM$(LEFT$(Reader, Temp2-1))
            RestWords = TRIM$(RIGHT$(Reader, Temp1-Temp2))
            SELECT CASE Keyword
                CASE "COLLECTION"
                    REGEXPR "^[A-Z0-9]+ *= *[A-Z0-9;]+$" IN RestWords TO ML_POS
                    IF ML_POS = 0 THEN
                        MSGBOX NativeMessages(51) & $CRLF & $CRLF & MCASE$(Reader), %MB_ICONINFORMATION, $AutoLangTitle
                        CriteriaN = 0
                        GOTO EndOfCheckSyntax
                    END IF
                    Temp1 = LEN(RestWords)
                    Temp2 = INSTR(RestWords, "=")
                    CollectionName = TRIM$(LEFT$(RestWords, Temp2-1))
                    ElementStr = TRIM$(RIGHT$(RestWords, Temp1-Temp2))
                    IF RIGHT$(ElementStr, 1) <> ";" THEN ElementStr = ElementStr & ";"
                    IF CollectionsN > 0 THEN
                        FOR Temp1 = 1 TO CollectionsN
                            IF Collections(Temp1) = CollectionName THEN
                                MSGBOX NativeMessages(52) & $CRLF & $CRLF & MCASE$(CollectionName), %MB_ICONINFORMATION, $AutoLangTitle
                                CriteriaN = 0
                                GOTO EndOfCheckSyntax
                            END IF
                        NEXT Temp1
                    END IF
                    INCR CollectionsN
                    Collections(CollectionsN) = CollectionName
                    Elements(CollectionsN) = ElementStr
                    IF CollectionsN = UBOUND(Collections) THEN
                        REDIM PRESERVE Collections(1 TO CollectionsN + 10)
                        REDIM PRESERVE Elements(1 TO CollectionsN + 10)
                    END IF
                CASE "MERGEINTO"
                    REPLACE " " WITH "" IN RestWords
                    REGEXPR "^[A-Z0-9]+=[A-Z0-9][A-Z0-9+]+[A-Z0-9]$" IN RestWords TO ML_POS
                    IF ML_POS = 0 THEN
                        MSGBOX NativeMessages(51) & $CRLF & $CRLF & MCASE$(Reader), %MB_ICONINFORMATION, $AutoLangTitle
                        CriteriaN = 0
                        GOTO EndOfCheckSyntax
                    END IF
                    Temp1 = LEN(RestWords)
                    Temp2 = INSTR(RestWords, "=")
                    CollectionName = TRIM$(LEFT$(RestWords, Temp2-1))
                    TempStr = TRIM$(RIGHT$(RestWords, Temp1-Temp2))
                    IF INSTR(TempStr, "++") > 0 THEN
                        MSGBOX NativeMessages(51) & $CRLF & $CRLF & MCASE$(Reader) & $CRLF & $CRLF & "++", %MB_ICONINFORMATION, $AutoLangTitle
                        CriteriaN = 0
                        GOTO EndOfCheckSyntax
                    END IF
                    IF CollectionsN > 0 THEN
                        FOR Temp1 = 1 TO CollectionsN
                            IF Collections(Temp1) = CollectionName THEN
                                MSGBOX NativeMessages(52) & $CRLF & $CRLF & MCASE$(CollectionName), %MB_ICONINFORMATION, $AutoLangTitle
                                CriteriaN = 0
                                GOTO EndOfCheckSyntax
                            END IF
                        NEXT Temp1
                    END IF
                    Temp1 = PARSECOUNT(TempStr, "+")
                    ElementStr = ""
                    FOR Temp2 = 1 TO Temp1
                        SubCollectionName = PARSE$(TempStr, "+", Temp2)
                        FOR Temp3 = 1 TO CollectionsN
                            IF Collections(Temp3) = SubCollectionName THEN
                                EXIT FOR
                            END IF
                        NEXT Temp3
                        IF Temp3 >= 1 AND Temp3 <= CollectionsN THEN
                            ElementStr = ElementStr & Elements(Temp3)
                        ELSE
                            MSGBOX NativeMessages(53) & $CRLF & $CRLF & MCASE$(Reader) & $CRLF & $CRLF & MCASE$(SubCollectionName), %MB_ICONINFORMATION, $AutoLangTitle
                            CriteriaN = 0
                            GOTO EndOfCheckSyntax
                        END IF
                    NEXT Temp2

                    INCR CollectionsN
                    Collections(CollectionsN) = CollectionName
                    Elements(CollectionsN) = ElementStr

                    IF CollectionsN = UBOUND(Collections) THEN
                        REDIM PRESERVE Collections(1 TO CollectionsN + 10)
                        REDIM PRESERVE Elements(1 TO CollectionsN + 10)
                    END IF
                CASE "SETBASICFILTER"
                    REGEXPR "^TO +[A-Z0-9]+$" IN RestWords TO ML_POS
                    IF ML_POS = 0 THEN
                        MSGBOX NativeMessages(51) & $CRLF & $CRLF & MCASE$(Reader), %MB_ICONINFORMATION, $AutoLangTitle
                        CriteriaN = 0
                        GOTO EndOfCheckSyntax
                    END IF
                    Temp1 = LEN(RestWords)
                    Temp2 = INSTR(-1, RestWords, " ")
                    CollectionName = RIGHT$(RestWords, Temp1-Temp2)
                    FOR Temp3 = 1 TO CollectionsN
                        IF Collections(Temp3) = CollectionName THEN
                            BasicFilter = Elements(Temp3)
                            EXIT FOR
                        END IF
                    NEXT Temp3
                    IF Temp3 = 0 OR Temp3 > CollectionsN THEN
                        MSGBOX NativeMessages(53) & $CRLF & $CRLF & MCASE$(Reader) & $CRLF & $CRLF & MCASE$(CollectionName), %MB_ICONINFORMATION, $AutoLangTitle
                        CriteriaN = 0
                        GOTO EndOfCheckSyntax
                    END IF
                CASE "IFONLY"
                    REGEXPR "^[A-Z0-9]+ *THEN *" & CHR$(34) & "[^" & CHR$(34) & "]+" & CHR$(34) & "$" IN RestWords TO ML_POS
                    IF ML_POS = 0 THEN
                        MSGBOX NativeMessages(51) & $CRLF & $CRLF & MCASE$(Reader), %MB_ICONINFORMATION, $AutoLangTitle
                        CriteriaN = 0
                        GOTO EndOfCheckSyntax
                    END IF
                    Temp1 = LEN(RestWords)
                    Temp2 = INSTR(RestWords, " ")
                    CollectionName = TRIM$(LEFT$(RestWords, Temp2-1))
                    FOR Temp3 = 1 TO CollectionsN
                        IF Collections(Temp3) = CollectionName THEN
                            ElementStr = Elements(Temp3)
                            EXIT FOR
                        END IF
                    NEXT Temp3
                    IF Temp3 = 0 OR Temp3 > CollectionsN THEN
                        MSGBOX NativeMessages(53) & $CRLF & $CRLF & MCASE$(Reader) & $CRLF & $CRLF & MCASE$(CollectionName), %MB_ICONINFORMATION, $AutoLangTitle
                        CriteriaN = 0
                        GOTO EndOfCheckSyntax
                    END IF

                    Temp1 = LEN(RestWords)
                    Temp2 = INSTR(RestWords, CHR$(34))
                    TempStr = TRIM$(MID$(RestWords, Temp2 + 1, Temp1-Temp2-1))
                    IF TempStr = "" THEN
                        MSGBOX NativeMessages(53) & $CRLF & $CRLF & MCASE$(Reader), %MB_ICONINFORMATION, $AutoLangTitle
                        CriteriaN = 0
                        GOTO EndOfCheckSyntax
                    END IF

                    FOR Temp3 = 1 TO AutoPlayers_Number
                        IF AutoPlayers_Entry(Temp3) = TempStr THEN
                            EXIT FOR
                        END IF
                    NEXT Temp3
                    IF Temp3 = 0 OR Temp3 > AutoPlayers_Number THEN
                        MSGBOX NativeMessages(55) & $CRLF & $CRLF & MCASE$(Reader) & $CRLF & $CRLF & MCASE$(TempStr), %MB_ICONINFORMATION, $AutoLangTitle
                        CriteriaN = 0
                        GOTO EndOfCheckSyntax
                    END IF

                    INCR CriteriaN
                    CorrespondingPlayers(CriteriaN) = TempStr
                    Criteria(CriteriaN) = ElementStr
                    IF CriteriaN = UBOUND(Criteria) THEN
                        REDIM PRESERVE Criteria(1 TO CriteriaN + 10)
                        REDIM PRESERVE CorrespondingPlayers(1 TO CriteriaN + 10)
                    END IF
                CASE "IFMIXED"
                    REGEXPR "^THEN +" & CHR$(34) & "[^" & CHR$(34) & "]+" & CHR$(34) & "$" IN RestWords TO ML_POS
                    IF ML_POS = 0 THEN
                        MSGBOX NativeMessages(51) & $CRLF & $CRLF & MCASE$(Reader), %MB_ICONINFORMATION, $AutoLangTitle
                        CriteriaN = 0
                        GOTO EndOfCheckSyntax
                    END IF
                    Temp1 = LEN(RestWords)
                    Temp2 = INSTR(RestWords, CHR$(34))
                    TempStr = TRIM$(MID$(RestWords, Temp2 + 1, Temp1-Temp2-1))
                    IF TempStr = "" THEN
                        MSGBOX NativeMessages(53) & $CRLF & $CRLF & MCASE$(Reader), %MB_ICONINFORMATION, $AutoLangTitle
                        CriteriaN = 0
                        GOTO EndOfCheckSyntax
                    END IF

                    FOR Temp3 = 1 TO AutoPlayers_Number
                        IF AutoPlayers_Entry(Temp3) = TempStr THEN
                            EXIT FOR
                        END IF
                    NEXT Temp3
                    IF Temp3 = 0 OR Temp3 > AutoPlayers_Number THEN
                        MSGBOX NativeMessages(55) & $CRLF & $CRLF & MCASE$(Reader) & $CRLF & $CRLF & MCASE$(TempStr), %MB_ICONINFORMATION, $AutoLangTitle
                        CriteriaN = 0
                        GOTO EndOfCheckSyntax
                    END IF

                    BasicPlayer = TempStr
                CASE ELSE
                    MSGBOX NativeMessages(50) & $CRLF & $CRLF & MCASE$(Keyword), %MB_ICONINFORMATION, $AutoLangTitle
                    CriteriaN = 0
                    EXIT FOR
            END SELECT
        NEXT TempCounter

EndOfCheckSyntax:

        ERASE MiniLang
        ERASE Collections
        ERASE AutoPlayers_Entry

        IF BasicFilter = "" THEN
            MSGBOX NativeMessages(56), %MB_ICONINFORMATION, $AutoLangTitle
            RunAppHandle = SHELL("Notepad.exe " & CHR$(34) & CurFolder & Chosen_TC2MP_INI & CHR$(34), 1)
            EXIT FUNCTION
        END IF

        IF BasicPlayer = "" THEN
            MSGBOX NativeMessages(57), %MB_ICONINFORMATION, $AutoLangTitle
            RunAppHandle = SHELL("Notepad.exe " & CHR$(34) & CurFolder & Chosen_TC2MP_INI & CHR$(34), 1)
            EXIT FUNCTION
        END IF

        IF CriteriaN = 0 THEN ChosenPlayer = "[CHOOSE]"

    END IF

    ' Reading TC Listfile

    DIM TCListBuffer(1 TO 500) AS STRING ' Store TC List File = Files & Folders ex) CMD13.tmp
    DIM TCListEntryNumber AS LONG, TCListCounter AS LONG
    DIM TempExtension AS STRING
    DIM TempSubFolder AS STRING

    IF DIR$(TCListFile, %NORMAL OR %READONLY OR %HIDDEN OR %SYSTEM)="" THEN
        MSGBOX NativeMessages(18), %MB_ICONINFORMATION, $AppTitle
        EXIT FUNCTION
    END IF

    OPEN TCListFile FOR INPUT AS #1
        DO UNTIL EOF(1)
            LINE INPUT #1, Reader
            INCR TCListEntryNumber
            TCListBuffer(TCListEntryNumber) = Reader
            IF TCListEntryNumber = UBOUND(TCListBuffer) THEN
                REDIM PRESERVE TCListBuffer(1 TO TCListEntryNumber + 500)
            END IF
        LOOP
    CLOSE #1

    IF TCListEntryNumber = 0 THEN
        MSGBOX NativeMessages(19), %MB_ICONINFORMATION, $AppTitle
        EXIT FUNCTION
    END IF

' ------------------------------------------------------------------------------------------------------------
    IF ChosenPlayer = "[AUTO]" THEN
' [Auto]------------------------------------------------------------------------------------------------------
' Flow : Scanning TC List -> Determining a player by extensions -> Getting information in TC2MP.INI(SUB)
        ' Scanning files in all sub-folders
        REDIM CriteriaStats(1 TO CriteriaN)

        DO
            INCR TCListCounter
            IF RIGHT$(TCListBuffer(TCListCounter),1) = "\" THEN
                TempSubFolder = DIR$(TCListBuffer(TCListCounter) & "*", %NORMAL OR %READONLY OR %HIDDEN OR %SYSTEM OR %SUBDIR)
                DO UNTIL TempSubFolder = ""
                    INCR TCListEntryNumber
                    IF GETATTR(TCListBuffer(TCListCounter) & TempSubFolder) = %SUBDIR THEN
                        TCListBuffer(TCListEntryNumber) = TCListBuffer(TCListCounter) & TempSubFolder & "\"
                    ELSE
                        TCListBuffer(TCListEntryNumber) = TCListBuffer(TCListCounter) & TempSubFolder
                    END IF
                    IF TCListEntryNumber = UBOUND(TCListBuffer) THEN
                        REDIM PRESERVE TCListBuffer(1 TO TCListEntryNumber + 500)
                    END IF
                    TempSubFolder = DIR$
                LOOP
            ELSE
                Temp1 = LEN(TCListBuffer(TCListCounter))
                Temp2 = INSTR(-1, TCListBuffer(TCListCounter), ".")
                IF Temp2=1 OR Temp2=Temp1 THEN ITERATE DO
                TempExtension = UCASE$(TRIM$(RIGHT$(TCListBuffer(TCListCounter), Temp1-Temp2)))
                IF INSTR(1, BasicFilter, TempExtension & ";") > 0 THEN
                    INCR FinalListEntryNumber
                    FinalList(FinalListEntryNumber) = TCListBuffer(TCListCounter)
                    IF FinalListEntryNumber = UBOUND(FinalList) THEN
                        REDIM PRESERVE FinalList(1 TO FinalListEntryNumber + 500)
                    END IF
                    FOR Temp3 = 1 TO CriteriaN
                        IF INSTR(1, Criteria(Temp3), TempExtension) > 0 THEN
                            INCR CriteriaStats(Temp3)
                            EXIT FOR
                        END IF
                    NEXT Temp3
                    IF Temp3 = 0 OR Temp3 > CriteriaN THEN
                        INCR ExceptionStats
                    END IF
                END IF
            END IF
        LOOP WHILE TCListCounter < TCListEntryNumber

        DIM SumOfTRUE AS LONG
        FOR Temp1 = 1 TO CriteriaN
            IF CriteriaStats(Temp1) > 0 THEN INCR SumOfTRUE
        NEXT Temp1

        IF SumOfTRUE > 1 OR ExceptionStats > 0 THEN
            ChosenPlayer = BasicPlayer
        ELSE
            FOR Temp1 = 1 TO CriteriaN
                IF CriteriaStats(Temp1) > 0 THEN
                    ChosenPlayer = CorrespondingPlayers(Temp1)
                    EXIT FOR
                END IF
            NEXT Temp1
        END IF

        ERASE Criteria
        ERASE CorrespondingPlayers
        ERASE CriteriaStats

        ' If there are no media files? Exit!
        IF FinalListEntryNumber = 0 THEN
            Message = NativeMessages(22)
            REPLACE "[^CHOSENPLAYER^]" WITH ChosenPlayer IN Message
            REPLACE "[^INI_FILTER^]" WITH BasicFilter IN Message
            MSGBOX Message, %MB_ICONINFORMATION, $AppTitle
            EXIT FUNCTION
        END IF

        CALL ReadPlayerInformation_Module
' ------------------------------------------------------------------------------------------------------------
    ELSE
' [Direct Launching Or Choose]--------------------------------------------------------------------------------
' Flow : (Choose Box?) -> Getting information in TC2MP.INI(SUB) -> Scanning TC list

        IF ChosenPlayer = "[CHOOSE]" THEN

            %MaxPlayerN = 10

            DIM Players_Number AS LONG
            DIM Players_Entry(1 TO %MaxPlayerN) AS STRING
            DIM TempPlayer AS STRING

            GLOBAL Choose_WritingMode AS LONG
            GLOBAL Choose_WindowState AS LONG
            GLOBAL Choose_Filter AS LONG
            GLOBAL Choose_ListOrder AS LONG

            Choose_WritingMode = 1

            TempPlayer = ""

            FOR TempCounter = 1 TO TC2MP_INI_N
                Reader = TC2MP_INI(TempCounter)
                IF LEFT$(Reader, 1) = ";" THEN ITERATE FOR ' Skip Comments ּ ǳʶ
                IF LEN(Reader)>=3 AND LEFT$(Reader,1)="[" AND RIGHT$(Reader,1)="]" THEN
                    Reader = TRIM$(MID$(Reader, 2, LEN(Reader) - 2))
                    IF Reader = "" THEN ITERATE FOR
                    IF UCASE$(Reader) = "AUTO DECISION" THEN
                        Reader = ""
                        ITERATE FOR
                    END IF
                    TempPlayer = Reader
                ELSE
                    Temp1 = LEN(Reader)
                    Temp2 = INSTR(Reader, "=")
                    IF Temp2<=1 OR Temp2>=Temp1 THEN ITERATE FOR
                    Item = UCASE$(TRIM$(LEFT$(Reader, Temp2-1)))
                    Value = TRIM$(RIGHT$(Reader, Temp1-Temp2))
                    SELECT CASE Item
                        CASE "BUTTON_DISPLAY"
                            IF Value = "1" AND TempPlayer <> "" THEN
                                INCR Players_Number
                                Players_Entry(Players_Number) = TempPlayer
                                IF Players_Number = %MaxPlayerN THEN EXIT FOR
                            END IF
                    END SELECT
                END IF
            NEXT TempCounter

            IF Players_Number = 0 THEN
                MSGBOX NativeMessages(3), %MB_ICONINFORMATION, $AppTitle
                RunAppHandle = SHELL("Notepad.exe " & CHR$(34) & CurFolder & Chosen_TC2MP_INI & CHR$(34), 1)
                EXIT FUNCTION
            END IF

            %CB_ButtonZero = 100 ' 101 ~ 110
            %CB_Button_EditINI = 116
            %CB_Frame_ExistingPlaylist = 200
            %CB_Opt_Overwrite = 201
            %CB_Opt_Append = 202
            %CB_Frame_WindowState = 204
            %CB_Opt_OwnWindowState = 205
            %CB_Opt_Minimize = 206
            %CB_Opt_Maximize = 207
            %CB_Frame_Filter = 210
            %CB_Opt_OwnFilter = 211
            %CB_Opt_NoFilter = 212
            %CB_Frame_ListOrder = 214
            %CB_Opt_ListInOrder = 215
            %CB_Opt_ListInDisorder = 216
            %CB_LabelZero = 300

            DIM ScreenWidth AS LONG, ScreenHeight AS LONG
            DESKTOP GET CLIENT TO ScreenWidth, ScreenHeight
            ScreenHeight = ScreenHeight - 35
            ScreenWidth = INT(ScreenWidth / 2)

            DIM DialogHeight AS LONG

            IF Players_Number = 1 THEN
                DialogHeight = CBButtonStartTop + CBButtonHeight * 2 + CBButtonInterval * 1 + CBMarginForOthers
            ELSE
                DialogHeight = CBButtonStartTop + CBButtonHeight * (Players_Number + 1)+ CBButtonInterval * Players_Number + CBMarginForOthers
            END IF

            IF DialogHeight >= ScreenHeight THEN
                CBButtonHeight = INT((ScreenHeight - CBButtonStartTop - CBMarginForOthers - CBButtonInterval * Players_Number) / (Players_Number + 1))
                DialogHeight = CBButtonStartTop + CBButtonHeight * (Players_Number + 1)+ CBButtonInterval * Players_Number + CBMarginForOthers
            END IF

            IF CBButtonWidth + CBLRMargin * 2 >= ScreenWidth THEN
                CBButtonWidth = ScreenWidth - CBLRMargin * 2
            END IF

            DIALOG FONT CBFontName, CBFontSize
            IF CBPosX = 0 AND CBPosY = 0 THEN
                DIALOG NEW PIXELS, 0, $AppTitle, , ,CBButtonWidth + CBLRMargin * 2, DialogHeight,, 0 TO hDlg
            ELSE
                DIALOG NEW PIXELS, 0, $AppTitle, CBPosX, CBPosY,CBButtonWidth + CBLRMargin * 2, DialogHeight,, 0 TO hDlg
            END IF
            DIALOG SET COLOR hDlg, CBFontColor, CbBGColor

            IF CBLabelNum > 0 THEN
                FOR Temp1 = 1 TO CBLabelNum
                    CONTROL ADD LABEL, hDlg, %CB_LabelZero + Temp1, CBLabelStr(Temp1), CBLabelPos(Temp1, 1), CBLabelPos(Temp1, 2), CBButtonWidth + CBLRMargin * 2 - CBLabelPos(Temp1, 1), (CBFontSize + 1) * 2
                    CONTROL SET COLOR hDlg, %CB_LabelZero + Temp1, CBLabelFC(Temp1), CbBGColor
                NEXT Temp1
            END IF

            DIM FontHandle AS DWORD
            DIM TempFontname AS STRING

            TempFontName = CBButtonFontName

            FontHandle = CreateFont(CBButtonFontSize,0,0,0,0,0,0,0,%DEFAULT_CHARSET,3,2,1,%VARIABLE_PITCH OR %FF_ROMAN, BYVAL STRPTR(TempFontName))

            IF Players_Number = 1 THEN
                CONTROL ADD BUTTON, hDlg, %CB_ButtonZero + 1, "&" & Players_Entry(1), CBLRMargin, CBButtonStartTop, CBButtonWidth, CBButtonHeight, %BS_DEFAULT OR %WS_TABSTOP
                CONTROL ADD BUTTON, hDlg, %IDCANCEL, "&Cancel", CBLRMargin + (CBButtonWidth + CBButtonInterval) / 2, CBButtonStartTop + CBButtonHeight + CBButtonInterval, (CBButtonWidth - CBButtonInterval) / 2, CBButtonHeight, %WS_TABSTOP
                CONTROL ADD BUTTON, hDlg, %CB_Button_EditINI, "&Edit", CBLRMargin, CBButtonStartTop + CBButtonHeight + CBButtonInterval, (CBButtonWidth - CBButtonInterval) / 2, CBButtonHeight, %WS_TABSTOP
                CONTROL SEND hDlg, %CB_ButtonZero + 1, %WM_SETFONT, FontHandle, %TRUE
                CONTROL SEND hDlg, %IDCANCEL, %WM_SETFONT, FontHandle, %TRUE
                CONTROL SEND hDlg, %CB_Button_EditINI, %WM_SETFONT, FontHandle, %TRUE
            ELSE
                CONTROL ADD BUTTON, hDlg, %CB_ButtonZero + 1, "&" & Players_Entry(1), CBLRMargin, CBButtonStartTop, CBButtonWidth, CBButtonHeight, %BS_DEFAULT OR %WS_TABSTOP
                CONTROL SEND hDlg, %CB_ButtonZero + 1, %WM_SETFONT, FontHandle, %TRUE
                FOR Temp1 = 2 TO Players_Number
                    CONTROL ADD BUTTON, hDlg, %CB_ButtonZero + Temp1, "&" & Players_Entry(Temp1), CBLRMargin, _
                    CBButtonStartTop + (CBButtonHeight + CBButtonInterval) * (Temp1 - 1), CBButtonWidth, CBButtonHeight, %WS_TABSTOP
                    CONTROL SEND hDlg, %CB_ButtonZero + Temp1, %WM_SETFONT, FontHandle, %TRUE
                NEXT Temp1
                CONTROL ADD BUTTON, hDlg, %IDCANCEL, "&Cancel", CBLRMargin + (CBButtonWidth + CBButtonInterval) / 2, CBButtonStartTop + (CBButtonHeight + CBButtonInterval) * Players_Number, (CBButtonWidth - CBButtonInterval) / 2, CBButtonHeight, _
%WS_TABSTOP
                CONTROL SEND hDlg, %IDCANCEL, %WM_SETFONT, FontHandle, %TRUE
                CONTROL ADD BUTTON, hDlg, %CB_Button_EditINI, "&Edit",_
                                    CBLRMargin, CBButtonStartTop + (CBButtonHeight + CBButtonInterval) * Players_Number, (CBButtonWidth - CBButtonInterval) / 2, CBButtonHeight, %WS_TABSTOP
                CONTROL SEND hDlg, %CB_Button_EditINI, %WM_SETFONT, FontHandle, %TRUE
            END IF

            DIM FrameY AS LONG
            DIM OptionWidth AS LONG

            FrameY = CBButtonStartTop + CBButtonHeight * (Players_Number + 1) + CBButtonInterval * Players_Number + 13 - %FrameHeight

            IF CBFrame1Visible <> 0 THEN
                FrameY = FrameY + %FrameHeight
                OptionWidth = (CBButtonWidth - CBLRMargin * 2) / 2

                CONTROL ADD FRAME, hDlg, %CB_Frame_ExistingPlaylist, NativeMessages(27), CBLRMargin, FrameY, CBButtonWidth, 45
                CONTROL ADD OPTION, hDlg, %CB_Opt_Overwrite, NativeMessages(24), CBLRMargin * 2, FrameY + 19, OptionWidth - 5, 24, %WS_GROUP OR %WS_TABSTOP
                CONTROL ADD OPTION, hDlg, %CB_Opt_Append, NativeMessages(25), CBLRMargin * 2 + OptionWidth, FrameY + 19, OptionWidth - 5, 24, %WS_TABSTOP
                CONTROL SET OPTION hDlg, %CB_Opt_Overwrite, %CB_Opt_Overwrite, %CB_Opt_Append

                CONTROL SET COLOR hDlg, %CB_Frame_ExistingPlaylist, CBFontColor, CbBGColor
                CONTROL SET COLOR hDlg, %CB_Opt_Overwrite, CBFontColor, CbBGColor
                CONTROL SET COLOR hDlg, %CB_Opt_Append, CBFontColor, CbBGColor
            END IF

            IF CBFrame2Visible <> 0 THEN
                FrameY = FrameY + %FrameHeight
                OptionWidth = (CBButtonWidth - CBLRMargin * 2) / 2

                CONTROL ADD FRAME, hDlg, %CB_Frame_Filter, NativeMessages(36), CBLRMargin, FrameY, CBButtonWidth, 45
                CONTROL ADD OPTION, hDlg, %CB_Opt_OwnFilter, NativeMessages(37), CBLRMargin * 2, FrameY + 19, OptionWidth - 5, 24, %WS_GROUP OR %WS_TABSTOP
                CONTROL ADD OPTION, hDlg, %CB_Opt_NoFilter, NativeMessages(38), CBLRMargin * 2 + OptionWidth, FrameY + 19, OptionWidth - 5, 24, %WS_TABSTOP
                CONTROL SET OPTION hDlg, %CB_Opt_OwnFilter, %CB_Opt_OwnFilter, %CB_Opt_NoFilter

                CONTROL SET COLOR hDlg, %CB_Frame_Filter, CBFontColor, CbBGColor
                CONTROL SET COLOR hDlg, %CB_Opt_OwnFilter, CBFontColor, CbBGColor
                CONTROL SET COLOR hDlg, %CB_Opt_NoFilter, CBFontColor, CbBGColor
            END IF

            IF CBFrame3Visible <> 0 THEN
                FrameY = FrameY + %FrameHeight
                OptionWidth = (CBButtonWidth - CBLRMargin * 2) / 2

                CONTROL ADD FRAME, hDlg, %CB_Frame_ListOrder, NativeMessages(40), CBLRMargin, FrameY, CBButtonWidth, 45
                CONTROL ADD OPTION, hDlg, %CB_Opt_ListInOrder, NativeMessages(41), CBLRMargin * 2, FrameY + 19, OptionWidth - 5, 24, %WS_GROUP OR %WS_TABSTOP
                CONTROL ADD OPTION, hDlg, %CB_Opt_ListInDisorder, NativeMessages(42), CBLRMargin * 2 + OptionWidth, FrameY + 19, OptionWidth - 5, 24, %WS_TABSTOP
                CONTROL SET OPTION hDlg, %CB_Opt_ListInOrder, %CB_Opt_ListInOrder, %CB_Opt_ListInDisorder

                CONTROL SET COLOR hDlg, %CB_Frame_ListOrder, CBFontColor, CbBGColor
                CONTROL SET COLOR hDlg, %CB_Opt_ListInOrder, CBFontColor, CbBGColor
                CONTROL SET COLOR hDlg, %CB_Opt_ListInDisorder, CBFontColor, CbBGColor
            END IF

            IF CBFrame4Visible <> 0 THEN
                FrameY = FrameY + %FrameHeight
                OptionWidth = (CBButtonWidth - CBLRMargin * 2) / 3

                CONTROL ADD FRAME, hDlg, %CB_Frame_WindowState, NativeMessages(30), CBLRMargin, FrameY, CBButtonWidth, 45
                CONTROL ADD OPTION, hDlg, %CB_Opt_OwnWindowState, NativeMessages(31), CBLRMargin * 2, FrameY + 19, OptionWidth - 5, 24, %WS_GROUP OR %WS_TABSTOP
                CONTROL ADD OPTION, hDlg, %CB_Opt_Minimize, NativeMessages(32), CBLRMargin * 2 + OptionWidth, FrameY + 19, OptionWidth - 5, 24, %WS_TABSTOP
                CONTROL ADD OPTION, hDlg, %CB_Opt_Maximize, NativeMessages(33), CBLRMargin * 2 + OptionWidth * 2, FrameY + 19, OptionWidth - 5, 24, %WS_TABSTOP
                CONTROL SET OPTION hDlg, %CB_Opt_OwnWindowState, %CB_Opt_OwnWindowState, %CB_Opt_Maximize

                CONTROL SET COLOR hDlg, %CB_Frame_WindowState, CBFontColor, CbBGColor
                CONTROL SET COLOR hDlg, %CB_Opt_OwnWindowState, CBFontColor, CbBGColor
                CONTROL SET COLOR hDlg, %CB_Opt_Minimize, CBFontColor, CbBGColor
                CONTROL SET COLOR hDlg, %CB_Opt_Maximize, CBFontColor, CbBGColor
            END IF

            DIALOG SHOW MODAL hDlg, CALL ChooseBox() TO lResult

            DeleteObject FontHandle

            SELECT CASE lResult
                CASE -1
                    RunAppHandle = SHELL("Notepad.exe " & CHR$(34) & CurFolder & Chosen_TC2MP_INI & CHR$(34), 1)
                    EXIT FUNCTION
                CASE 0
                    EXIT FUNCTION
                CASE ELSE
                    ChosenPlayer = UCASE$(Players_Entry(lResult))
            END SELECT

            ERASE Players_Entry()

        END IF

        ERASE CBLabelPos()
        ERASE CBLabelFC()
        ERASE CBLabelStr()

        ' Reading Player Information

        CALL ReadPlayerInformation_Module

        ' Reset Options as you specified in ChooseBox.
        IF Choose_WritingMode > 0 THEN INI_WritingMode = Choose_WritingMode - 1
        SELECT CASE Choose_WindowState
            CASE 0 ' Followiing Own option.
            CASE 1 ' Minimize
                INI_WindowState = 6
            CASE 2 ' Normal
                INI_WindowState = 1
        END SELECT
        IF Choose_Filter = 1 THEN INI_Filter = ""

        ' Scanning files in all sub-folders

        DO
            INCR TCListCounter
            IF RIGHT$(TCListBuffer(TCListCounter),1) = "\" THEN
                TempSubFolder = DIR$(TCListBuffer(TCListCounter) & "*", %NORMAL OR %READONLY OR %HIDDEN OR %SYSTEM OR %SUBDIR)
                DO UNTIL TempSubFolder = ""
                    INCR TCListEntryNumber
                    IF GETATTR(TCListBuffer(TCListCounter) & TempSubFolder) = %SUBDIR THEN
                        TCListBuffer(TCListEntryNumber) = TCListBuffer(TCListCounter) & TempSubFolder & "\"
                    ELSE
                        TCListBuffer(TCListEntryNumber) = TCListBuffer(TCListCounter) & TempSubFolder
                    END IF
                    IF TCListEntryNumber = UBOUND(TCListBuffer) THEN
                        REDIM PRESERVE TCListBuffer(1 TO TCListEntryNumber + 500)
                    END IF
                    TempSubFolder = DIR$
                LOOP
            ELSE
                IF INI_Filter = "" THEN ' No filter means all types of files.
                    INCR FinalListEntryNumber
                    FinalList(FinalListEntryNumber) = TCListBuffer(TCListCounter)
                ELSE
                    Temp1 = LEN(TCListBuffer(TCListCounter))
                    Temp2 = INSTR(-1, TCListBuffer(TCListCounter), ".")
                    IF Temp2=1 OR Temp2=Temp1 THEN ITERATE DO
                    TempExtension = UCASE$(TRIM$(RIGHT$(TCListBuffer(TCListCounter), Temp1-Temp2)))
                    IF INSTR(1, INI_Filter, TempExtension & ";") > 0 THEN
                        INCR FinalListEntryNumber
                        FinalList(FinalListEntryNumber) = TCListBuffer(TCListCounter)
                    END IF
                END IF
                IF FinalListEntryNumber = UBOUND(FinalList) THEN
                    REDIM PRESERVE FinalList(1 TO FinalListEntryNumber + 500)
                END IF
            END IF
        LOOP WHILE TCListCounter < TCListEntryNumber

        ' If there are no media files? Exit!
        IF FinalListEntryNumber = 0 THEN
            Message = NativeMessages(22)
            REPLACE "[^CHOSENPLAYER^]" WITH ChosenPlayer IN Message
            REPLACE "[^INI_FILTER^]" WITH INI_Filter IN Message
            MSGBOX Message, %MB_ICONINFORMATION, $AppTitle
            EXIT FUNCTION
        END IF

' End of Big Blocks - ------------------------------------------------------------------------------------------
    END IF
' --------------------------------------------------------------------------------------------------------------

    ERASE TCListBuffer()

    ' A problem can be occurred if existing playlist file has Read-Only attribute.
    IF DIR$(CurFolder & "TC2MPlaylist." & INI_Extension, %NORMAL OR %READONLY OR %HIDDEN OR %SYSTEM) <> "" THEN
        SETATTR CurFolder & "TC2MPlaylist." & INI_Extension, %NORMAL
    ELSE
        INI_WritingMode = 0
    END IF

    ' Asking User What to do

    IF INI_WritingMode = 2 THEN
        DIALOG FONT DefaultFontName, DefaultFontSize
        DIALOG NEW PIXELS, 0, $AppTitle, , ,372, 90, &H084C000D4&, 0 TO hDlg
        CONTROL ADD LABEL, hDlg, 0, NativeMessages(23), 15, 13, 320, 20
        CONTROL ADD BUTTON, hDlg, 101, NativeMessages(24), 10, 45, 110, 35, %BS_DEFAULT OR %BS_CENTER OR %BS_VCENTER OR %WS_TABSTOP
        CONTROL ADD BUTTON, hDlg, 102, NativeMessages(25), 130, 45, 110, 35, %BS_CENTER OR %BS_VCENTER OR %WS_TABSTOP
        CONTROL ADD BUTTON, hDlg, 103, NativeMessages(26), 250, 45, 110, 35, %BS_CENTER OR %BS_VCENTER OR %WS_TABSTOP
        DIALOG SHOW MODAL hDlg, CALL AppendBox() TO lResult

        SELECT CASE lResult
            CASE 0 ' Cancel Button
                EXIT FUNCTION
            CASE 1 ' Overwrite Button
                INI_WritingMode = 0
            CASE 2 ' Append Button
                INI_WritingMode = 1
        END SELECT
    END IF

    ' Extracting filenames from existing playlist

    DIM ExistEntryNumber AS LONG ' Number of file entry of existing playlist

    IF INI_WritingMode = 1 THEN
        DIM ExistFile(1 TO 500) AS STRING
        DIM iPos AS LONG, iLen AS LONG
        DIM iPosLeft AS LONG, iLenLeft AS LONG
        DIM iRealStart AS LONG
        DIM iPosRight AS LONG, iLenRight AS LONG
        DIM iRealEnd AS LONG

        OPEN CurFolder & "TC2MPlaylist." & INI_Extension FOR INPUT AS #1
        DO UNTIL EOF(1)
            iPos = 0
            LINE INPUT #1, Reader
            Reader = TRIM$(Reader)
            IF INI_RetrieveRegExp = "" THEN
                INCR ExistEntryNumber
                ExistFile(ExistEntryNumber) = Reader
                IF ExistEntryNumber = UBOUND(ExistFile) THEN
                    REDIM PRESERVE ExistFile(1 TO ExistEntryNumber + 500)
                END IF
                ITERATE DO
            END IF
            REGEXPR INI_RetrieveRegExp IN Reader TO iPos, iLen
            IF iPos = 0 THEN ITERATE DO
            IF INI_RetrieveRegExLeft = "" THEN
                iRealStart = iPos ' Start Point of Filename
            ELSE
                REGEXPR INI_RetrieveRegExLeft IN Reader AT iPos TO iPosLeft, iLenLeft
                IF iPosLeft = 0 THEN
                    CLOSE #1
                    Message = NativeMessages(7)
                    REPLACE "[^CHOSENPLAYER^]" WITH ChosenPlayer IN Message
                    REPLACE "[^READER^]" WITH Reader IN Message
                    REPLACE "[^RETRIEVEREGEXP^]" WITH INI_RetrieveRegExp IN Message
                    REPLACE "[^RETRIEVEREGEXLEFT^]" WITH INI_RetrieveRegExLeft IN Message
                    REPLACE "[^RETRIEVEREGEXRIGHT^]" WITH INI_RetrieveRegExRight IN Message
                    MSGBOX Message, %MB_ICONINFORMATION, $AppTitle
                    RunAppHandle = SHELL("Notepad.exe " & CHR$(34) & CurFolder & Chosen_TC2MP_INI & CHR$(34), 1)
                    EXIT FUNCTION
                END IF
                iRealStart = iPos + iLenLeft ' Start Point of Filename
            END IF
            IF INI_RetrieveRegExRight = "" THEN
                iRealEnd = iPos + iLen - 1 ' End Point of Filename
            ELSE
                REGEXPR INI_RetrieveRegExRight IN Reader AT iRealStart TO iPosRight, iLenRight
                IF iPosRight = 0 THEN
                    CLOSE #1
                    Message = NativeMessages(8)
                    REPLACE "[^CHOSENPLAYER^]" WITH ChosenPlayer IN Message
                    REPLACE "[^READER^]" WITH Reader IN Message
                    REPLACE "[^RETRIEVEREGEXP^]" WITH INI_RetrieveRegExp IN Message
                    REPLACE "[^RETRIEVEREGEXLEFT^]" WITH INI_RetrieveRegExLeft IN Message
                    REPLACE "[^RETRIEVEREGEXRIGHT^]" WITH INI_RetrieveRegExRight IN Message
                    MSGBOX Message, %MB_ICONINFORMATION, $AppTitle
                    RunAppHandle = SHELL("Notepad.exe " & CHR$(34) & CurFolder & Chosen_TC2MP_INI & CHR$(34), 1)
                    EXIT FUNCTION
                END IF
                iRealEnd = iPosRight - 1 ' End Point of Filename
            END IF
            IF iRealEnd - iRealStart + 1 <= 0 THEN
                CLOSE #1
                Message = NativeMessages(9)
                REPLACE "[^CHOSENPLAYER^]" WITH ChosenPlayer IN Message
                REPLACE "[^READER^]" WITH Reader IN Message
                REPLACE "[^RETRIEVEREGEXP^]" WITH INI_RetrieveRegExp IN Message
                REPLACE "[^RETRIEVEREGEXLEFT^]" WITH INI_RetrieveRegExLeft IN Message
                REPLACE "[^RETRIEVEREGEXRIGHT^]" WITH INI_RetrieveRegExRight IN Message
                MSGBOX Message, %MB_ICONINFORMATION, $AppTitle
                RunAppHandle = SHELL("Notepad.exe " & CHR$(34) & CurFolder & Chosen_TC2MP_INI & CHR$(34), 1)
                EXIT FUNCTION
            END IF
            INCR ExistEntryNumber
            ExistFile(ExistEntryNumber) = TRIM$(MID$(Reader, iRealStart, iRealEnd - iRealStart + 1))
            IF ExistEntryNumber = UBOUND(ExistFile) THEN
                REDIM PRESERVE ExistFile(1 TO ExistEntryNumber + 500)
            END IF
        LOOP
        CLOSE #1
    END IF

    DIM TotalEntryNumber AS DWORD
    TotalEntryNumber = FinalListEntryNumber + ExistEntryNumber

    ' Randomize index   ϱ

    DIM EntryIndex(1 TO TotalEntryNumber) AS DWORD

    %ArraySeparator = 10000

    IF INI_WritingMode = 1 AND ExistEntryNumber > 0 THEN
        SELECT CASE INI_AddPosition
            CASE 0
                FOR Temp1 = 1 TO ExistEntryNumber
                    EntryIndex(Temp1) = %ArraySeparator + Temp1
                NEXT Temp1

                FOR Temp1 = 1 TO FinalListEntryNumber
                    EntryIndex(ExistEntryNumber + Temp1) = Temp1
                NEXT Temp1
            CASE 1
                FOR Temp1 = 1 TO FinalListEntryNumber
                    EntryIndex(Temp1) = Temp1
                NEXT Temp1

                FOR Temp1 = 1 TO ExistEntryNumber
                    EntryIndex(FinalListEntryNumber + Temp1) = %ArraySeparator + Temp1
                NEXT Temp1
        END SELECT
    ELSE
        FOR Temp1 = 1 TO FinalListEntryNumber
            EntryIndex(Temp1) = Temp1
        NEXT Temp1
    END IF

    RANDOMIZE TIMER

    IF Choose_ListOrder = 1 THEN
        FOR Temp1 = 1 TO TotalEntryNumber
            Temp2 = RND(1, TotalEntryNumber)
            IF Temp2 = Temp1 THEN ITERATE FOR
            SWAP EntryIndex(Temp1), EntryIndex(Temp2)
        NEXT Temp1
    END IF

    ' Coding a Final playlist

    OPEN CurFolder & "TC2MPlaylist." & INI_Extension FOR OUTPUT AS #1

    DIM TempCodeLine AS STRING
    DIM TargetIndex AS DWORD

    SELECT CASE INI_Unicode
        CASE 0 ' ANSI
            IF INI_FirstLine <> "" THEN
                REPLACE "$NUMBEROFFILES_" WITH LTRIM$(STR$(TotalEntryNumber)) IN INI_FirstLine
                REPLACE "$TAB_" WITH $TAB IN INI_FirstLine
                REPLACE "$CRLF_" WITH $CRLF IN INI_FirstLine
                PRINT #1, INI_FirstLine
            END IF

            FOR Temp1 = 1 TO TotalEntryNumber
                TempCodeLine = INI_CodeLine
                TargetIndex = EntryIndex(Temp1)
                IF TargetIndex > %ArraySeparator THEN ' Existing files
                    TargetIndex = TargetIndex - %ArraySeparator
                    REPLACE "$FULLFILENAME_" WITH ExistFile(TargetIndex) IN TempCodeLine
                    REPLACE "$FILENAME_" WITH GetShortFilename(ExistFile(TargetIndex)) IN TempCodeLine
                    REPLACE "$COUNTER_" WITH LTRIM$(STR$(Temp1)) IN TempCodeLine
                    REPLACE "$NUMBEROFFILES_" WITH LTRIM$(STR$(TotalEntryNumber)) IN TempCodeLine
                    REPLACE "$CRLF_" WITH $CRLF IN TempCodeLine
                    REPLACE "$TAB_" WITH $TAB IN TempCodeLine
                ELSE ' New Files
                    REPLACE "$FULLFILENAME_" WITH FinalList(TargetIndex) IN TempCodeLine
                    REPLACE "$FILENAME_" WITH GetShortFilename(FinalList(TargetIndex)) IN TempCodeLine
                    REPLACE "$COUNTER_" WITH LTRIM$(STR$(Temp1)) IN TempCodeLine
                    REPLACE "$NUMBEROFFILES_" WITH LTRIM$(STR$(TotalEntryNumber)) IN TempCodeLine
                    REPLACE "$CRLF_" WITH $CRLF IN TempCodeLine
                    REPLACE "$TAB_" WITH $TAB IN TempCodeLine
                END IF
                PRINT #1, TempCodeLine
            NEXT Temp1

            IF INI_EndLine <> "" THEN
                REPLACE "$NUMBEROFFILES_" WITH LTRIM$(STR$(TotalEntryNumber)) IN INI_EndLine
                REPLACE "$TAB_" WITH $TAB IN INI_EndLine
                REPLACE "$CRLF_" WITH $CRLF IN INI_EndLine
                PRINT #1, INI_EndLine
            END IF
        CASE 1 ' UCS-2
            PRINT #1, CHR$(255) & CHR$(254); ' UNICODE BOM of UCS-2 - Byte Order Mark

            IF INI_FirstLine <> "" THEN
                REPLACE "$NUMBEROFFILES_" WITH LTRIM$(STR$(TotalEntryNumber)) IN INI_FirstLine
                REPLACE "$TAB_" WITH $TAB IN INI_FirstLine
                REPLACE "$CRLF_" WITH $CRLF IN INI_FirstLine
                PRINT #1, UCODE$(INI_FirstLine & $CRLF);
            END IF

            FOR Temp1 = 1 TO TotalEntryNumber
                TempCodeLine = INI_CodeLine
                TargetIndex = EntryIndex(Temp1)
                IF TargetIndex > %ArraySeparator THEN ' Existing files
                    TargetIndex = TargetIndex - %ArraySeparator
                    REPLACE "$FULLFILENAME_" WITH ExistFile(TargetIndex) IN TempCodeLine
                    REPLACE "$FILENAME_" WITH GetShortFilename(ExistFile(TargetIndex)) IN TempCodeLine
                    REPLACE "$COUNTER_" WITH LTRIM$(STR$(Temp1)) IN TempCodeLine
                    REPLACE "$NUMBEROFFILES_" WITH LTRIM$(STR$(TotalEntryNumber)) IN TempCodeLine
                    REPLACE "$CRLF_" WITH $CRLF IN TempCodeLine
                    REPLACE "$TAB_" WITH $TAB IN TempCodeLine
                ELSE ' New Files
                    REPLACE "$FULLFILENAME_" WITH FinalList(TargetIndex) IN TempCodeLine
                    REPLACE "$FILENAME_" WITH GetShortFilename(FinalList(TargetIndex)) IN TempCodeLine
                    REPLACE "$COUNTER_" WITH LTRIM$(STR$(Temp1)) IN TempCodeLine
                    REPLACE "$NUMBEROFFILES_" WITH LTRIM$(STR$(TotalEntryNumber)) IN TempCodeLine
                    REPLACE "$CRLF_" WITH $CRLF IN TempCodeLine
                    REPLACE "$TAB_" WITH $TAB IN TempCodeLine
                END IF
                PRINT #1, UCODE$(TempCodeLine & $CRLF);
            NEXT Temp1

            IF INI_EndLine <> "" THEN
                REPLACE "$NUMBEROFFILES_" WITH LTRIM$(STR$(TotalEntryNumber)) IN INI_EndLine
                REPLACE "$TAB_" WITH $TAB IN INI_EndLine
                REPLACE "$CRLF_" WITH $CRLF IN INI_EndLine
                PRINT #1, UCODE$(INI_EndLine & $CRLF);
            END IF
        CASE 2 ' UTF-8
            PRINT #1, CHR$(&HEF) & CHR$(&HBB) & CHR$(&HBF); ' UNICODE BOM of UTF-8 - Byte Order Mark

            IF INI_FirstLine <> "" THEN
                REPLACE "$NUMBEROFFILES_" WITH LTRIM$(STR$(TotalEntryNumber)) IN INI_FirstLine
                REPLACE "$TAB_" WITH $TAB IN INI_FirstLine
                REPLACE "$CRLF_" WITH $CRLF IN INI_FirstLine
                PRINT #1, UTF8(INI_FirstLine & $CRLF);
            END IF

            FOR Temp1 = 1 TO TotalEntryNumber
                TempCodeLine = INI_CodeLine
                TargetIndex = EntryIndex(Temp1)
                IF TargetIndex > %ArraySeparator THEN ' Existing files
                    TargetIndex = TargetIndex - %ArraySeparator
                    REPLACE "$FULLFILENAME_" WITH ExistFile(TargetIndex) IN TempCodeLine
                    REPLACE "$FILENAME_" WITH GetShortFilename(ExistFile(TargetIndex)) IN TempCodeLine
                    REPLACE "$COUNTER_" WITH LTRIM$(STR$(Temp1)) IN TempCodeLine
                    REPLACE "$NUMBEROFFILES_" WITH LTRIM$(STR$(TotalEntryNumber)) IN TempCodeLine
                    REPLACE "$CRLF_" WITH $CRLF IN TempCodeLine
                    REPLACE "$TAB_" WITH $TAB IN TempCodeLine
                ELSE ' New Files
                    REPLACE "$FULLFILENAME_" WITH FinalList(TargetIndex) IN TempCodeLine
                    REPLACE "$FILENAME_" WITH GetShortFilename(FinalList(TargetIndex)) IN TempCodeLine
                    REPLACE "$COUNTER_" WITH LTRIM$(STR$(Temp1)) IN TempCodeLine
                    REPLACE "$NUMBEROFFILES_" WITH LTRIM$(STR$(TotalEntryNumber)) IN TempCodeLine
                    REPLACE "$CRLF_" WITH $CRLF IN TempCodeLine
                    REPLACE "$TAB_" WITH $TAB IN TempCodeLine
                END IF
                PRINT #1, UTF8(TempCodeLine & $CRLF);
            NEXT Temp1

            IF INI_EndLine <> "" THEN
                REPLACE "$NUMBEROFFILES_" WITH LTRIM$(STR$(TotalEntryNumber)) IN INI_EndLine
                REPLACE "$TAB_" WITH $TAB IN INI_EndLine
                REPLACE "$CRLF_" WITH $CRLF IN INI_EndLine
                PRINT #1, UTF8(INI_EndLine & $CRLF);
            END IF
    END SELECT

    CLOSE #1

    ' Parameters to pass
    REPLACE "$PLAYLIST_" WITH CurFolder & "TC2MPlaylist." & INI_Extension IN INI_CommandLine
    REPLACE "%PROGRAM FILES%" WITH Dir_ProgramFiles IN INI_CommandLine
    REPLACE "%TOTAL COMMANDER%" WITH Dir_TotalCommander IN INI_CommandLine
    REPLACE "%WINDOWS%" WITH Dir_Windows IN INI_CommandLine
    REPLACE "%SYSTEM%" WITH Dir_System IN INI_CommandLine

    ' Run player asynchronously (as a separate process)
    RunAppHandle = SHELL(CHR$(34) & INI_Player & CHR$(34) & " " & INI_CommandLine, INI_WindowState)

END FUNCTION

FUNCTION IsFileNameProper(BYVAL GivenFilename AS STRING, BYVAL TargetSection AS LONG) AS STRING '  ̸ Ѱ ˻

    DIM ProhibitiveChars AS STRING

    SELECT CASE TargetSection
        CASE 1 ' Total Filename = Filename + Extension
            ProhibitiveChars = "*|\:/<>?" & CHR$(34)
        CASE 2 TO 3 ' Filename Only Or Extension Only
            ProhibitiveChars = ".*|\:/<>?" & CHR$(34)
    END SELECT

    GivenFilename = TRIM$(GivenFilename)
    IF GivenFilename = "" THEN
        IsFileNameProper = ""
        EXIT FUNCTION
    END IF

    DIM Temp AS LONG

    FOR Temp = 1 TO LEN(GivenFilename)
        IF INSTR(1, ProhibitiveChars, MID$(GivenFilename, Temp, 1)) > 0 THEN
            IsFileNameProper = MID$(GivenFilename, Temp, 1)
            EXIT FUNCTION
        END IF
    NEXT Temp

    IsFileNameProper = ""

END FUNCTION

' Get only filename without full path
FUNCTION GetShortFileName (BYVAL GivenFileName AS STRING) AS STRING

    DIM POSlash AS LONG, LOFN AS LONG

    POSlash = INSTR(-1, GivenFileName, "\")
    LOFN = LEN(GivenFileName)

    IF POSlash = 0 THEN
        GetShortFileName = GivenFileName
    ELSE
        GetShortFileName = RIGHT$(GivenFileName, LOFN-POSlash)
    END IF

END FUNCTION

' Code by "Semen Matusovski" - Power Basic Web Site
' Get working directory => Equal to 'App.Path' of Visual Basic
FUNCTION ExeName(Op AS LONG) AS STRING
    LOCAL TmpAsciiz AS ASCIIZ * %MAX_PATH
    GetModuleFileName GetModuleHandle(BYVAL 0&), TmpAsciiz, 255
    SELECT CASE Op
        CASE 1: FUNCTION = TmpAsciiz
        CASE 2: FUNCTION = LEFT$(TmpAsciiz, INSTR(-1, TmpAsciiz, "\"))
        CASE 3: FUNCTION = MID$(TmpAsciiz, INSTR(-1, TmpAsciiz, "\") + 1)
    END SELECT
END FUNCTION

CALLBACK FUNCTION LanguageBox() AS LONG
    IF CBMSG = %WM_COMMAND THEN
        SELECT CASE CBCTL
            CASE 100 ' ComboBox
                IF CBCTLMSG = %CBN_SELENDOK THEN
                    COMBOBOX GET TEXT CBHNDL, 100 TO SelectedLanguage
                    FUNCTION = 1
                END IF
            CASE %IDOK TO %IDCANCEL
                IF CBCTLMSG = %BN_CLICKED THEN
                    DIALOG END CBHNDL, CBCTL
                    FUNCTION = 1
                END IF
        END SELECT
    END IF
END FUNCTION

CALLBACK FUNCTION ChooseBox() AS LONG
    IF CBMSG = %WM_COMMAND AND CBCTLMSG = %BN_CLICKED THEN
        SELECT CASE CBCTL
            CASE %IDCANCEL ' 0
                DIALOG END CBHNDL, 0
                FUNCTION = 1
            CASE %CB_ButtonZero + 1 TO %CB_ButtonZero + 10 ' 101 ~ 110
                DIALOG END CBHNDL, CBCTL - %CB_ButtonZero
                FUNCTION = 1
            CASE %CB_Button_EditINI ' TC2MP.INI
                DIALOG END CBHNDL, -1
                FUNCTION = 1
            CASE %CB_Opt_Overwrite ' Overwrite ' 201
                Choose_WritingMode = 1
                FUNCTION = 1
            CASE %CB_Opt_Append   ' Append ' 202
                Choose_WritingMode = 2
                FUNCTION = 1
            CASE %CB_Opt_OwnWindowState
                Choose_WindowState = 0
                FUNCTION = 1
            CASE %CB_Opt_Minimize
                Choose_WindowState = 1
                FUNCTION = 1
            CASE %CB_Opt_Maximize
                Choose_WindowState = 2
                FUNCTION = 1
            CASE %CB_Opt_OwnFilter
                Choose_Filter = 0
                FUNCTION = 1
            CASE %CB_Opt_NoFilter
                Choose_Filter = 1
                FUNCTION = 1
            CASE %CB_Opt_ListInOrder
                Choose_ListOrder = 0
            CASE %CB_Opt_ListInDisorder
                Choose_ListOrder = 1
        END SELECT
    END IF
END FUNCTION

CALLBACK FUNCTION AppendBox() AS LONG
    IF CBMSG = %WM_COMMAND AND CBCTLMSG = %BN_CLICKED THEN
        SELECT CASE CBCTL
            CASE 101 ' Overwrite
                DIALOG END CBHNDL, 1
            CASE 102 ' Append
                DIALOG END CBHNDL, 2
            CASE 103 ' Cancel
                DIALOG END CBHNDL, 0
        END SELECT
        FUNCTION = 1
    END IF
END FUNCTION

SUB ReadPlayerInformation_Module()

    DIM CurrentPlayerGroup AS STRING
    DIM IsWithinGroup AS LONG
    DIM TempCounter AS LONG
    DIM Reader AS STRING
    DIM Temp1 AS LONG, Temp2 AS LONG
    DIM Item AS STRING, Value AS STRING
    DIM Message AS STRING

    INI_WindowState = 1 ' Normal with focus (default)

    FOR TempCounter = 1 TO TC2MP_INI_N
        Reader = TC2MP_INI(TempCounter)
        IF LEFT$(Reader, 1) = ";" THEN ITERATE FOR ' Skip Comments ּ ǳʶ
        IF LEN(Reader)>=3 AND LEFT$(Reader,1)="[" AND RIGHT$(Reader,1)="]" THEN ' Group Title Line ex) [Winamp] ׷
            IF IsWithinGroup = 1 THEN EXIT FOR ' If you are within a right group already and then meet another gorup, exit INI file.
            CurrentPlayerGroup = UCASE$(TRIM$(MID$(Reader, 2, LEN(Reader) - 2)))
            IF CurrentPlayerGroup <> "" AND CurrentPlayerGroup = ChosenPlayer THEN IsWithinGroup = 1 ' You are within a right group.
        ELSE ' Item Line ex) Player = C:\Program Files\Winamp\Winamp.exe ' ׸ = 
            IF IsWithinGroup = 0 THEN ITERATE FOR ' IF you are not within a right group, Ignore items.
            Temp1 = LEN(Reader)
            Temp2 = INSTR(Reader, "=")
            IF Temp2<=1 OR Temp2>=Temp1 THEN ITERATE FOR
            Item = UCASE$(TRIM$(LEFT$(Reader, Temp2-1)))
            Value = TRIM$(RIGHT$(Reader, Temp1-Temp2))
            SELECT CASE Item
                CASE "PLAYER"
                    IF INSTR(Value, "%TOTAL COMMANDER%") > 0 AND Dir_TotalCommander = "" THEN
                        Message = NativeMessages(28)
                        REPLACE "[^CHOSENPLAYER^]" WITH ChosenPlayer IN Message
                        MSGBOX Message, %MB_ICONINFORMATION, $AppTitle
                        CLOSE #1
                        RunAppHandle = SHELL("Notepad.exe " & CHR$(34) & CurFolder & Chosen_TC2MP_INI & CHR$(34), 1)
                        EXIT SUB
                    END IF
                    REPLACE "%PROGRAM FILES%" WITH Dir_ProgramFiles IN Value
                    REPLACE "%TOTAL COMMANDER%" WITH Dir_TotalCommander IN Value
                    REPLACE "%WINDOWS%" WITH Dir_Windows IN Value
                    REPLACE "%SYSTEM%" WITH Dir_System IN Value
                    IF DIR$(Value, %NORMAL OR %READONLY OR %HIDDEN OR %SYSTEM) = "" THEN
                        Message = NativeMessages(10)
                        REPLACE "[^CHOSENPLAYER^]" WITH ChosenPlayer IN Message
                        MSGBOX Message & $CRLF & $CRLF & Value & "   ", %MB_ICONINFORMATION, $AppTitle
                        CLOSE #1
                        RunAppHandle = SHELL("Notepad.exe " & CHR$(34) & CurFolder & Chosen_TC2MP_INI & CHR$(34), 1)
                        EXIT SUB
                    END IF
                    INI_Player = Value
                CASE "EXTENSION"
                    IF IsFileNameProper(Value, 3) <> "" THEN ' Checking rightness of file Extension
                        Message = NativeMessages(11)
                        REPLACE "[^CHOSENPLAYER^]" WITH ChosenPlayer IN Message
                        MSGBOX Message, %MB_ICONINFORMATION, $AppTitle
                        CLOSE #1
                        RunAppHandle = SHELL("Notepad.exe " & CHR$(34) & CurFolder & Chosen_TC2MP_INI & CHR$(34), 1)
                        EXIT SUB
                    END IF
                    INI_Extension = Value
                CASE "FILTER"
                    REPLACE " " WITH "" IN Value
                    IF RIGHT$(Value, 1) <> ";" THEN
                        INI_Filter = UCASE$(Value) & ";"
                    ELSE
                        INI_Filter = UCASE$(Value)
                    END IF
                CASE "WINDOWSTATE"
                    Temp1 = INT(VAL(Value))
                    IF Temp1 < 0 OR Temp1 > 6 THEN
                        Message = NativeMessages(12)
                        REPLACE "[^CHOSENPLAYER^]" WITH ChosenPlayer IN Message
                        MSGBOX Message, %MB_ICONINFORMATION, $AppTitle
                        CLOSE #1
                        RunAppHandle = SHELL("Notepad.exe " & CHR$(34) & CurFolder & Chosen_TC2MP_INI & CHR$(34), 1)
                        EXIT SUB
                    END IF
                    INI_WindowState = Temp1
                CASE "FIRSTLINE"
                    INI_FirstLine = Value
                CASE "CODELINE"
                    INI_CodeLine = Value
                CASE "ENDLINE"
                    INI_EndLine = Value
                CASE "RETRIEVEREGEXP"
                    INI_RetrieveRegExp = Value
                CASE "RETRIEVEREGEXLEFT"
                    INI_RetrieveRegExLeft = Value
                CASE "RETRIEVEREGEXRIGHT"
                    INI_RetrieveRegExRight = Value
                CASE "COMMANDLINE"
                    INI_CommandLine = Value
                CASE "WRITINGMODE"
                    Temp1 = INT(VAL(Value))
                    IF Temp1 < 0 OR Temp1 > 2 THEN
                        Message = NativeMessages(13)
                        REPLACE "[^CHOSENPLAYER^]" WITH ChosenPlayer IN Message
                        MSGBOX Message, %MB_ICONINFORMATION, $AppTitle
                        CLOSE #1
                        RunAppHandle = SHELL("Notepad.exe " & CHR$(34) & CurFolder & Chosen_TC2MP_INI & CHR$(34), 1)
                        EXIT SUB
                    END IF
                    INI_WritingMode = Temp1
                CASE "APPENDPOSITION"
                    Temp1 = INT(VAL(Value))
                    IF Temp1 < 0 OR Temp1 > 1 THEN
                        Message = NativeMessages(20)
                        REPLACE "[^CHOSENPLAYER^]" WITH ChosenPlayer IN Message
                        MSGBOX Message, %MB_ICONINFORMATION, $AppTitle
                        CLOSE #1
                        RunAppHandle = SHELL("Notepad.exe " & CHR$(34) & CurFolder & Chosen_TC2MP_INI & CHR$(34), 1)
                        EXIT SUB
                    END IF
                    INI_AddPosition = Temp1
                CASE "ADDPOSITION"
                    Temp1 = INT(VAL(Value))
                    IF Temp1 < 0 OR Temp1 > 1 THEN
                        Message = NativeMessages(20)
                        REPLACE "[^CHOSENPLAYER^]" WITH ChosenPlayer IN Message
                        MSGBOX Message, %MB_ICONINFORMATION, $AppTitle
                        CLOSE #1
                        RunAppHandle = SHELL("Notepad.exe " & CHR$(34) & CurFolder & Chosen_TC2MP_INI & CHR$(34), 1)
                        EXIT SUB
                    END IF
                    INI_AddPosition = Temp1
                CASE "UNICODE"
                    Temp1 = INT(VAL(Value))
                    IF Temp1 < 0 OR Temp1 > 2 THEN
                        Message = NativeMessages(5)
                        REPLACE "[^CHOSENPLAYER^]" WITH ChosenPlayer IN Message
                        MSGBOX Message, %MB_ICONINFORMATION, $AppTitle
                        CLOSE #1
                        RunAppHandle = SHELL("Notepad.exe " & CHR$(34) & CurFolder & Chosen_TC2MP_INI & CHR$(34), 1)
                        EXIT SUB
                    END IF
                    INI_Unicode = Temp1
            END SELECT
        END IF
    NEXT TempCounter

    IF IsWithinGroup = 0 THEN
        Message = NativeMessages(14)
        REPLACE "[^CHOSENPLAYER^]" WITH ChosenPlayer IN Message
        MSGBOX Message, %MB_ICONINFORMATION, $AppTitle
        RunAppHandle = SHELL("Notepad.exe " & CHR$(34) & CurFolder & Chosen_TC2MP_INI & CHR$(34), 1)
        EXIT SUB
    END IF
    IF INI_Player = "" THEN
        Message = NativeMessages(15)
        REPLACE "[^CHOSENPLAYER^]" WITH ChosenPlayer IN Message
        MSGBOX Message, %MB_ICONINFORMATION, $AppTitle
        RunAppHandle = SHELL("Notepad.exe " & CHR$(34) & CurFolder & Chosen_TC2MP_INI & CHR$(34), 1)
        EXIT SUB
    END IF
    IF INI_Extension = "" THEN
        Message = NativeMessages(16)
        REPLACE "[^CHOSENPLAYER^]" WITH ChosenPlayer IN Message
        MSGBOX Message, %MB_ICONINFORMATION, $AppTitle
        RunAppHandle = SHELL("Notepad.exe " & CHR$(34) & CurFolder & Chosen_TC2MP_INI & CHR$(34), 1)
        EXIT SUB
    END IF
    IF INI_CodeLine = "" THEN
        Message = NativeMessages(17)
        REPLACE "[^CHOSENPLAYER^]" WITH ChosenPlayer IN Message
        MSGBOX Message, %MB_ICONINFORMATION, $AppTitle
        RunAppHandle = SHELL("Notepad.exe " & CHR$(34) & CurFolder & Chosen_TC2MP_INI & CHR$(34), 1)
        EXIT SUB
    END IF
    IF INI_CommandLine = "" THEN INI_CommandLine = CHR$(34) & "$PLAYLIST_" & CHR$(34)
    IF INI_Unicode > 0 THEN INI_WritingMode = 0

END SUB
