FUNCTION UTF8(BYREF GivenStr AS STRING) AS STRING

' Coding by pjhplace@naver.com
' UTF-8 text file needs 'CHR$(&HEF) & CHR$(&HBB) & CHR$(&HBF)' in front of text.
' Without this BOM(=Byte Order Mark), Some text editor may not read the file correctly.
' This function does not provide BOM.

' Basic mechanism of this function : ASCII  UCS-2 (16Bit Unicode)  UTF-8 (Variable-Length Unicode)

    IF GivenStr = "" THEN
        UTF8 = ""
        EXIT FUNCTION
    END IF

    DIM SourceBuffer AS STRING
    DIM ResultBuffer AS STRING * 3000
    DIM ResultBufferPOS AS LONG

    DIM Unicode_Word AS WORD
    DIM UTF8_Byte1 AS BYTE
    DIM UTF8_Byte2 AS BYTE
    DIM UTF8_Byte3 AS BYTE
    DIM ByteCounter AS LONG

    SourceBuffer = UCODE$(GivenStr)

    FOR ByteCounter = 1 TO LEN(SourceBuffer) STEP 2

        Unicode_Word = MAK(WORD, ASC(MID$(SourceBuffer, ByteCounter, 1)), ASC(MID$(SourceBuffer, ByteCounter + 1, 1)))

        SELECT CASE Unicode_Word
            CASE 1 TO 127 ' 1 Byte
        ' &H0000 ~ &H007F = 0xxxxxxx

                INCR ResultBufferPOS
                MID$(ResultBuffer, ResultBufferPOS, 1) = CHR$(Unicode_Word)

            CASE 128 TO 2047 ' 2 Byte
        ' &H0080 ~ &H07FF = 110xxxxx 10xxxxxx

                UTF8_Byte2 = LO(BYTE, Unicode_Word)
                SHIFT RIGHT Unicode_Word, 6
                UTF8_Byte1 = LO(BYTE, Unicode_Word)

                BIT RESET UTF8_Byte1, 5
                BIT SET UTF8_Byte1, 6
                BIT SET UTF8_Byte1, 7

                BIT RESET UTF8_Byte2, 6
                BIT SET UTF8_Byte2, 7

                INCR ResultBufferPOS
                MID$(ResultBuffer, ResultBufferPOS, 1) = CHR$(UTF8_Byte1)
                INCR ResultBufferPOS
                MID$(ResultBuffer, ResultBufferPOS, 1) = CHR$(UTF8_Byte2)

            CASE 2048 TO 65535 ' 3 Byte
        ' &H0800 ~ &HFFFF = 1110xxxx 10xxxxxx 10xxxxxx

                UTF8_Byte3 = LO(BYTE, Unicode_Word)
                SHIFT RIGHT Unicode_Word, 6
                UTF8_Byte2 = LO(BYTE, Unicode_Word)
                SHIFT RIGHT Unicode_Word, 6
                UTF8_Byte1 = LO(BYTE, Unicode_Word)

                BIT RESET UTF8_Byte1, 4
                BIT SET UTF8_Byte1, 5
                BIT SET UTF8_Byte1, 6
                BIT SET UTF8_Byte1, 7

                BIT RESET UTF8_Byte2, 6
                BIT SET UTF8_Byte2, 7

                BIT RESET UTF8_Byte3, 6
                BIT SET UTF8_Byte3, 7

                INCR ResultBufferPOS
                MID$(ResultBuffer, ResultBufferPOS, 1) = CHR$(UTF8_Byte1)
                INCR ResultBufferPOS
                MID$(ResultBuffer, ResultBufferPOS, 1) = CHR$(UTF8_Byte2)
                INCR ResultBufferPOS
                MID$(ResultBuffer, ResultBufferPOS, 1) = CHR$(UTF8_Byte3)

        END SELECT
    NEXT ByteCounter

    UTF8 = LEFT$(ResultBuffer, ResultBufferPOS)

END FUNCTION
