/*
 * Decompiled with CFR 0.152.
 */
package moi.tcplugins;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.RandomAccessFile;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.StringTokenizer;
import moi.date.DatePrinter;
import moi.tcplugins.PluginLogger;
import moi.util.FileCRC;
import plugins.wcx.HeaderData;
import plugins.wcx.OpenArchiveData;
import plugins.wcx.WCXPluginAdapter;

public class DiskDirCrcPlugin
extends WCXPluginAdapter {
    private static PluginLogger log = new PluginLogger();
    private static final String DATE_PATTERN = "yyyy.MM.dd HH:mm.ss";
    private Locale locale = Locale.getDefault();

    public Object openArchive(OpenArchiveData archiveData) {
        if (log.isDebugEnabled()) {
            log.debug(String.valueOf(((Object)((Object)this)).getClass().getName()) + ".openArchive(archiveData)");
        }
        try {
            RandomAccessFile pf = new RandomAccessFile(archiveData.getArcName(), "rw");
            CatalogInfo catalogInfo = new CatalogInfo();
            catalogInfo.file = pf;
            catalogInfo.arcName = archiveData.getArcName();
            catalogInfo.originalDir = null;
            return catalogInfo;
        }
        catch (FileNotFoundException e) {
            log.error(e.getMessage(), e);
            return null;
        }
    }

    public int closeArchive(Object archiveData) {
        if (log.isDebugEnabled()) {
            log.debug(String.valueOf(((Object)((Object)this)).getClass().getName()) + ".closeArchive(archiveData)");
        }
        RandomAccessFile pf = ((CatalogInfo)archiveData).file;
        try {
            pf.close();
            return 0;
        }
        catch (IOException e) {
            log.error(e.getMessage(), e);
            return 17;
        }
    }

    public int processFile(Object archiveData, int operation, String destPath, String destName) {
        if (log.isDebugEnabled()) {
            log.debug(String.valueOf(((Object)((Object)this)).getClass().getName()) + ".processFile(archiveData, operation, destPath, destName)");
        }
        CatalogInfo catalogInfo = (CatalogInfo)archiveData;
        HeaderData headerData = catalogInfo.headerData;
        String fullOriginName = String.valueOf(catalogInfo.originalDir) + headerData.getFileName();
        if (log.isDebugEnabled()) {
            log.debug(String.valueOf(((Object)((Object)this)).getClass().getName()) + ".processFile() headerData = " + headerData.getFileName() + ", destPath = " + destPath + ",  destName = " + destName + ", operation = " + operation + ", fullOriginName=" + fullOriginName);
        }
        try {
            if (operation == 2) {
                String fullDestName = String.valueOf(destPath == null ? "" : destPath) + destName;
                if (log.isDebugEnabled()) {
                    log.debug(String.valueOf(((Object)((Object)this)).getClass().getName()) + ".processFile() EXTRACT " + fullDestName);
                }
                return this.copyFile(new File(fullOriginName), new File(fullDestName), false);
            }
            if (operation == 1) {
                if (log.isDebugEnabled()) {
                    log.debug(String.valueOf(((Object)((Object)this)).getClass().getName()) + ".processFile() TEST " + headerData.getFileName());
                }
                return this.checkFile(new File(fullOriginName), headerData.getFileCRC());
            }
            if (operation == 0 && log.isDebugEnabled()) {
                log.debug(String.valueOf(((Object)((Object)this)).getClass().getName()) + ".processFile() SKIP " + headerData.getFileName());
            }
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), e);
        }
        return 0;
    }

    public int readHeader(Object archiveData, HeaderData headerData) {
        block9: {
            if (log.isDebugEnabled()) {
                log.debug(String.valueOf(((Object)((Object)this)).getClass().getName()) + ".readHeader(archiveData, headerData)");
            }
            try {
                CatalogInfo catalogInfo = (CatalogInfo)archiveData;
                catalogInfo.headerData = headerData;
                RandomAccessFile file = catalogInfo.file;
                headerData.setArcName(catalogInfo.arcName);
                if (catalogInfo.fp != -1L) {
                    file.seek(file.getFilePointer());
                    log.debug("seek to " + file.getFilePointer());
                } else {
                    catalogInfo.fp = file.getFilePointer();
                    log.debug("fp=" + catalogInfo.fp);
                }
                String line = file.readLine();
                if (catalogInfo.originalDir == null) {
                    catalogInfo.originalDir = line;
                    line = file.readLine();
                }
                log.debug("read line=" + line);
                if (line == null) break block9;
                this.parseLine(line, catalogInfo.lastDirRead, headerData);
                if (headerData.getFileName().endsWith(File.separator)) {
                    catalogInfo.lastDirRead = headerData.getFileName();
                }
                log.debug("SUCCESS");
                return 0;
            }
            catch (Throwable e) {
                log.error(e.getMessage(), e);
                if (log.isErrorEnabled()) {
                    log.error(String.valueOf(((Object)((Object)this)).getClass().getName()) + ".readHeader() E_BAD_DATA");
                }
                return 12;
            }
        }
        log.debug("END_OF_ARCHIVE");
        return 10;
    }

    private void parseLine(String line, String lastDir, HeaderData headerData) throws IOException {
        StringTokenizer st = new StringTokenizer(line, "\t");
        int num = st.countTokens();
        String name = st.nextToken();
        if (name.endsWith(File.separator)) {
            if (num != 4) {
                throw new IOException("Error in file format: " + num + " tokens found");
            }
            headerData.setFileAttr(16);
            headerData.setFileName(name);
            headerData.setUnpSize(Long.parseLong(st.nextToken()));
            headerData.setFileTime(this.getFileTime(st.nextToken(), st.nextToken()));
        } else {
            if (num != 5 && num != 4) {
                throw new IOException("Error in file format: " + num + " tokens found");
            }
            headerData.setFileName(String.valueOf(lastDir == null ? "" : lastDir) + name);
            headerData.setUnpSize(Long.parseLong(st.nextToken()));
            headerData.setFileTime(this.getFileTime(st.nextToken(), st.nextToken()));
            if (num == 5) {
                headerData.setFileCRC(Long.parseLong(st.nextToken()));
            } else {
                headerData.setFileCRC(0L);
            }
        }
    }

    private Calendar getFileTime(String day, String hour) {
        SimpleDateFormat df = new SimpleDateFormat();
        df.applyPattern(DATE_PATTERN);
        Calendar cal = Calendar.getInstance(this.locale);
        try {
            cal.setTime(df.parse(String.valueOf(day) + " " + hour));
        }
        catch (ParseException e) {
            log.error(e.getMessage(), e);
        }
        if (log.isDebugEnabled()) {
            log.debug(String.valueOf(((Object)((Object)this)).getClass().getName()) + ".readHeader() time=" + cal);
        }
        return cal;
    }

    public int getPackerCaps() {
        return 37;
    }

    public int packFiles(String packedFile, String subPath, String srcPath, String addList, int flags) {
        try {
            if (log.isDebugEnabled()) {
                log.debug(String.valueOf(DiskDirCrcPlugin.class.getName()) + ".packFiles() packedFile=" + packedFile + " - subPath=" + subPath + " - srcPath=" + srcPath);
            }
            File pf = new File(packedFile);
            PrintWriter writer = new PrintWriter(new BufferedWriter(new FileWriter(pf)));
            writer.println(srcPath);
            StringTokenizer tok = new StringTokenizer(addList, ":");
            while (tok.hasMoreTokens()) {
                String addFilename = tok.nextToken();
                if (addFilename.equals("")) continue;
                String fullName = String.valueOf(srcPath) + addFilename;
                File file = new File(fullName);
                this.printFile(file, addFilename, writer, true);
                if (!log.isDebugEnabled()) continue;
                log.debug(String.valueOf(DiskDirCrcPlugin.class.getName()) + ".packFiles() addFilename=" + addFilename);
            }
            writer.flush();
            writer.close();
        }
        catch (FileNotFoundException e) {
            log.error(e.getMessage(), e);
        }
        catch (IOException e) {
            log.error(e.getMessage(), e);
        }
        return 0;
    }

    private void printFile(File file, String addFileName, PrintWriter pw, boolean calcCRC) throws IOException {
        if (file.isDirectory()) {
            pw.print(String.valueOf(addFileName) + "\t");
        } else {
            pw.print(String.valueOf(file.getName()) + "\t");
        }
        pw.print(String.valueOf(file.length()) + "\t");
        long lastModified = file.lastModified();
        pw.print(DatePrinter.normalDate(new Date(lastModified), "..\t:."));
        long crc = -1L;
        if (calcCRC && !file.isDirectory()) {
            pw.print('\t');
            try {
                crc = FileCRC.calculaCRC(file);
                pw.print(crc);
            }
            catch (Exception e) {
                pw.print(e.getMessage());
            }
        }
        pw.println();
    }

    private int copyFile(File source, File dest, boolean overwrite) {
        if (overwrite) {
            dest.delete();
        }
        if (dest.exists()) {
            return 16;
        }
        FileWriter fw = null;
        FileReader fr = null;
        BufferedReader br = null;
        BufferedWriter bw = null;
        try {
            try {
                fr = new FileReader(source);
                fw = new FileWriter(dest);
                br = new BufferedReader(fr);
                bw = new BufferedWriter(fw);
                int fileLength = (int)source.length();
                char[] charBuff = new char[fileLength];
                while (br.read(charBuff, 0, fileLength) != -1) {
                    bw.write(charBuff, 0, fileLength);
                }
            }
            catch (FileNotFoundException fnfe) {
                try {
                    if (br != null) {
                        br.close();
                    }
                    if (bw != null) {
                        bw.close();
                    }
                }
                catch (IOException ioe) {
                    return 19;
                }
                return 15;
            }
            catch (IOException ioe) {
                try {
                    if (br != null) {
                        br.close();
                    }
                    if (bw != null) {
                        bw.close();
                    }
                }
                catch (IOException ioe2) {
                    return 19;
                }
                return 19;
            }
        }
        finally {
            try {
                if (br != null) {
                    br.close();
                }
                if (bw != null) {
                    bw.close();
                }
            }
            catch (IOException ioe) {
                return 19;
            }
        }
        return 0;
    }

    private int checkFile(File source, long crcInIndex) {
        if (!source.exists()) {
            return 15;
        }
        if (crcInIndex == 0L) {
            return 0;
        }
        try {
            long crc = FileCRC.calculaCRC(source);
            return crc == crcInIndex ? 0 : 12;
        }
        catch (FileNotFoundException fnfe) {
            return 15;
        }
        catch (IOException e) {
            return 18;
        }
    }

    private class CatalogInfo {
        private String arcName;
        private RandomAccessFile file;
        private long fp;
        private HeaderData headerData;
        private String originalDir;
        private String lastDirRead;

        private CatalogInfo() {
        }
    }
}

