/*
 * Decompiled with CFR 0.152.
 */
package moi.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.zip.CRC32;
import moi.util.Print;

public class FileCRC {
    private static int leidosParaPunto = 0x400000;
    private static byte[] buffer = new byte[65536];

    public static synchronized long calculaCRC(Object file) throws IOException {
        try (InputStream fis = null;){
            fis = FileCRC.createInputStream(file);
            long l = FileCRC.calculaCRC(fis);
            return l;
        }
    }

    private static InputStream createInputStream(Object o) throws IOException {
        if (o instanceof File) {
            return new FileInputStream((File)o);
        }
        if (o instanceof Path) {
            return Files.newInputStream((Path)o, new OpenOption[0]);
        }
        throw new RuntimeException("not a File or Path");
    }

    private static long calculaCRC(InputStream fis) throws IOException {
        int i;
        CRC32 crc = new CRC32();
        int leidos = 0;
        while ((i = fis.read(buffer)) != -1) {
            crc.update(buffer, 0, i);
            if ((leidos += i) <= leidosParaPunto) continue;
            leidos = 0;
            Print.p(".");
        }
        return crc.getValue();
    }
}

