// filesys.cpp : Defines the entry point for the DLL application.
//

#include "stdafx.h"
#include "contentplug.h"
#include <sys/types.h>
#include <time.h>
#include <string.h>
#include <stdio.h>
#include "mhash.h"
#include <io.h>
#include <fcntl.h>


#define _detectstring ""

#define fieldcount 26
char* fieldnames[fieldcount]={
	"CRC32","CRC32B","ADLER32","MD2","MD4","MD5","SHA1","SHA224","SHA256","SHA384","SHA512",
	 "HAVAL128","HAVAL160","HAVAL192","HAVAL224","HAVAL256","RIPEMD128","RIPEMD160","RIPEMD256","RIPEMD320",
	"TIGER128","TIGER160","GOST","WHIRLPOOL","SNEFRU128","SNEFRU256"};
int fieldtypes[fieldcount]={
		ft_string,ft_string,ft_string,ft_string,ft_string,ft_string,ft_string,ft_string,ft_string,
		ft_string,ft_string,ft_string,ft_string,ft_string,ft_string,ft_string,ft_string,ft_string,
		ft_string,ft_string,ft_string,ft_string,ft_string,ft_string,ft_string,ft_string};

char* fieldunits_and_multiplechoicestrings[fieldcount]={
		"","","","","","","","","",
		"","","","","","","","","",
		"","","","","","","",""};

BOOL GetValueAborted=false;

BOOL APIENTRY DllMain( HANDLE hModule, 
                       DWORD  ul_reason_for_call, 
                       LPVOID lpReserved
					 )
{
    return TRUE;
}

char* strlcpy(char* p,const char* p2,int maxlen)
{
    if ((int)strlen(p2)>=maxlen) {
        strncpy(p,p2,maxlen);
        p[maxlen]=0;
    } else
        strcpy(p,p2);
    return p;
}

int __stdcall ContentGetDetectString(char* DetectString,int maxlen)
{
	strlcpy(DetectString,_detectstring,maxlen);
	return 0;
}

int __stdcall ContentGetSupportedField(int FieldIndex,char* FieldName,char* Units,int maxlen)
{
	if (FieldIndex<0 || FieldIndex>=fieldcount)
		return ft_nomorefields;
	strlcpy(FieldName,fieldnames[FieldIndex],maxlen-1);
	strlcpy(Units,fieldunits_and_multiplechoicestrings[FieldIndex],maxlen-1);
	return fieldtypes[FieldIndex];
}

int __stdcall ContentGetValue(char* FileName,int FieldIndex,int UnitIndex,void* FieldValue,int maxlen,int flags)
{
	WIN32_FIND_DATA fd;
	//FILETIME lt;
	//SYSTEMTIME st;
	HANDLE fh;
	//HANDLE hashFile;
	//DWORD handle;
	//DWORD dwSize;
	//__int64 filesize;
	GetValueAborted=false;
	char byte_hash[8];
	char final_hash[64]={""};
	FILE *inFile;
	unsigned __int8 digest[MAX_DIGEST_SIZE]; /* enough space to hold digests */
	unsigned char data[1024];
	unsigned long r;
	unsigned __int32 i;
	BOOL found;
	hashid mhashid;
	MHASH td;



	if (flags & CONTENT_DELAYIFSLOW) {
		if (FieldIndex==16)
			return ft_delayed;
		if (FieldIndex==17)
			return ft_ondemand;
	}

	fh=FindFirstFile(FileName,&fd);
	if (fh!=INVALID_HANDLE_VALUE) {
		FindClose(fh);

			for (found = FALSE, mhashid = (enum __hashid)0; (unsigned int)mhashid <= mhash_count();)
			{

				//sprintf (byte_hash,"%d",mhashid);
				//OutputDebugString(byte_hash);
				//OutputDebugString(fieldnames[FieldIndex]);
				if (mhash_get_hash_name_static(mhashid))
				{
			if (! mutils_strcmp((unsigned __int8*) fieldnames[FieldIndex], (unsigned __int8*)mhash_get_hash_name_static(mhashid)))
			{
				found = TRUE;
				break;
			}
				}
			mhashid=(enum __hashid)(mhashid+1);

			}

	if (found == FALSE)
	{
		OutputDebugString("Cannot find hash");
		return -1;
	}

	if (mhash_get_block_size(mhashid) > MAX_DIGEST_SIZE)
		return -1;
	
	td = (__MHASH_INSTANCE *)mhash_init(mhashid);  /* hash file */

//		OutputDebugString(fd.cFileName);


	inFile = fopen (fd.cFileName, "rb");
	if (inFile==NULL) {
		i=sprintf(final_hash,"");
	}
	else {

		

	while ((r = fread (data, 1, 1024, inFile)) != 0) {
		mhash(td, data, r);

	}
    
//		sprintf (byte_hash,"%d",r);
//		OutputDebugString(byte_hash);

	fclose( inFile );
	
	mhash_deinit(td, digest);

	for (i = 0; i < mhash_get_block_size(mhashid); i++)
	{
 			sprintf (byte_hash,"%02x",digest[i]);
			strcat (final_hash,byte_hash);
	}
	}

		strlcpy((char*)FieldValue,final_hash,2*i);



	}
	return fieldtypes[FieldIndex];  // very important!
}

void __stdcall ContentSetDefaultParams(ContentDefaultParamStruct* dps)
{

}

void __stdcall ContentStopGetValue	(char* FileName)
{
	GetValueAborted=true;
}

