#if !defined(__MHASH_H)
#define __MHASH_H

#define MUTILS_USE_MHASH_CONFIG

//#include "mutils/mincludes.h"
//#include "mutils/mglobal.h"
//#include "mutils/mtypes.h"
//#include "mutils/mutils.h"
//#include "mutils/mhash.h"

#include <stdio.h>
#include <stdlib.h>
#include <wtypes.h>
#define MUTILS_USE_MHASH_CONFIG
//#include "mhash.h"

#define MAX_DIGEST_SIZE 256

typedef void (*INIT_FUNC)( void*);
typedef void (*HASH_FUNC)(void*, const void*, int);
typedef void (*FINAL_FUNC)(void*);
typedef void (*DEINIT_FUNC)(void*, unsigned char*);

typedef enum __hashid {
	MHASH_CRC32		=  0,
	MHASH_MD5		=  1,
	MHASH_SHA1		=  2,
	MHASH_HAVAL256		=  3,
	MHASH_RIPEMD160		=  5,
	MHASH_TIGER192		=  7,
	MHASH_GOST		=  8,
	MHASH_CRC32B		=  9,
	MHASH_HAVAL224		= 10,
	MHASH_HAVAL192		= 11,
	MHASH_HAVAL160		= 12,
	MHASH_HAVAL128		= 13,
	MHASH_TIGER128		= 14,
	MHASH_TIGER160		= 15,
	MHASH_MD4		= 16,
	MHASH_SHA256		= 17,
	MHASH_ADLER32		= 18,
	MHASH_SHA224		= 19,
	MHASH_SHA512		= 20,
	MHASH_SHA384		= 21,
	MHASH_WHIRLPOOL		= 22,
	MHASH_RIPEMD128		= 23,
	MHASH_RIPEMD256		= 24,
	MHASH_RIPEMD320		= 25,
	MHASH_SNEFRU128		= 26,
	MHASH_SNEFRU256		= 27,
	MHASH_MD2		= 28,
} hashid;

typedef struct __MHASH_INSTANCE
{
	unsigned __int32 hmac_key_size;
	unsigned __int32 hmac_block;
	unsigned __int8 *hmac_key;

	unsigned __int8 *state;
	unsigned __int32 state_size;
	hashid algorithm_given;

	HASH_FUNC hash_func;
	FINAL_FUNC final_func;
	DEINIT_FUNC deinit_func;
} MHASH_INSTANCE;

typedef MHASH_INSTANCE *MHASH;

#define MHASH_FAILED ((MHASH) 0x0)

extern "C"
{
unsigned __int32 mhash_count(void);
unsigned __int8 *mhash_get_hash_name_static(hashid type);
int mutils_strcmp(const unsigned __int8 *, const unsigned __int8 *);
unsigned __int32 mhash_get_block_size(hashid);
MHASH mhash_init(const hashid);
boolean mhash(MHASH, const void *, unsigned __int32);
void mhash_deinit(MHASH, void *);
}

typedef struct __KEYGEN
{
	hashid		 hash_algorithm[2];
	unsigned __int32	 count;
	void		*salt;
	unsigned __int32	 salt_size;
} KEYGEN;

#endif

