/*
 * Decompiled with CFR 0.152.
 */
package moi.tcplugins.decompiler;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.function.BiFunction;
import java.util.function.BiPredicate;
import java.util.function.Consumer;
import java.util.function.Supplier;
import moi.tcplugins.decompiler.ByteClassLoader;
import moi.tcplugins.decompiler.ItemsPlugin;
import org.benf.cfr.reader.api.CfrDriver;
import org.benf.cfr.reader.api.OutputSinkFactory;
import org.benf.cfr.reader.api.SinkReturns;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import plugins.wcx.HeaderData;

public class Decompiler
extends ItemsPlugin {
    static final Logger log = LoggerFactory.getLogger(Decompiler.class);

    public Decompiler() {
        this.setItems();
    }

    private void setItems() {
        ItemsPlugin.SaverFunction propertiesSaver = (c, f) -> this.save(c, f, c.properties);
        ItemsPlugin.SaverFunction environmentSaver = (c, f) -> this.save(c, f, c.env);
        ItemsPlugin.SaverFunction javaSaver = (c, f) -> this.decompile(new File(c.arcName), f);
        ItemEnum.THROWABLE.set((c, h) -> this.getBlockingThrowable((CatalogInfo)c, (HeaderData)h), (c, f) -> this.save(c, f, c.throwableToShow));
        ItemEnum.THROWABLE.setNextIfSuccess((c, i) -> ItemEnum.FINISH);
        ItemEnum.JAVA_FILE.set((c, h) -> this.getJavaFile(new File(c.arcName), (HeaderData)h), javaSaver);
        ItemEnum.PROPERTIES_DIR.set((c, h) -> this.getVariables((CatalogInfo)c, (HeaderData)h, "properties", ((CatalogInfo)c).properties, ((CatalogInfo)c).propertiesKeys, "property"), propertiesSaver);
        ItemEnum.PROPERTIES_FILE.set((c, h) -> this.getFile((HeaderData)h, "properties.property", ((CatalogInfo)c).properties.size()), propertiesSaver);
        ItemEnum.ENVIRONMENT_DIR.set((c, h) -> this.getVariables((CatalogInfo)c, (HeaderData)h, "environment", ((CatalogInfo)c).env, ((CatalogInfo)c).envKeys, "env"), environmentSaver);
        ItemEnum.ENVIRONMENT_FILE.set((c, h) -> this.getFile((HeaderData)h, "environment.env", ((CatalogInfo)c).env.size()), environmentSaver);
        ItemEnum.PACKAGE.set((c, h) -> this.getPackage((CatalogInfo)c, (HeaderData)h), javaSaver);
        ItemEnum.CLASS_ELEMENTS.set((c, h) -> this.classToDirs((CatalogInfo)c, (HeaderData)h), javaSaver);
    }

    @Override
    protected void onOpenArchive(CatalogInfo catalogInfo) throws Exception {
        ByteClassLoader loader = new ByteClassLoader();
        Path path = Paths.get(catalogInfo.arcName, new String[0]);
        Class<?> clazz = loader.defineClass(null, Files.readAllBytes(path));
        catalogInfo.clazz = clazz;
    }

    private boolean getBlockingThrowable(CatalogInfo catalogInfo, HeaderData headerData) {
        if (catalogInfo.blockingThrowable == null) {
            return false;
        }
        Throwable t = catalogInfo.blockingThrowable;
        String s = t.getMessage().startsWith("Prohibited package") ? "reading classes from package java is not allowed.exception" : String.valueOf(t.getMessage().replaceAll("[^a-zA-Z0-9 ]", "-")) + ".blocking.exception";
        headerData.setFileName(s);
        headerData.setUnpSize((long)s.length());
        catalogInfo.throwableToShow = t;
        return true;
    }

    private boolean getJavaFile(File f, HeaderData h) {
        h.setFileName(String.valueOf(f.getName().substring(0, f.getName().length() - ".class".length())) + ".java");
        h.setUnpSize(f.length());
        return true;
    }

    private boolean getFile(HeaderData h, String fileName, long unpSize) {
        h.setFileName(fileName);
        h.setUnpSize(unpSize);
        return true;
    }

    private boolean getPackage(CatalogInfo catalogInfo, HeaderData headerData) {
        Class<?> clazz = catalogInfo.clazz;
        int index = clazz.getName().lastIndexOf(".");
        if (index == -1) {
            headerData.setFileName("this class has no package defined.package");
        } else {
            String packaje = clazz.getName().substring(0, index);
            headerData.setUnpSize((long)packaje.length());
            headerData.setFileName(String.valueOf(packaje) + ".package");
        }
        catalogInfo.nextItemToShow = catalogInfo.itemToShow.next();
        return true;
    }

    private boolean classToDirs(CatalogInfo catalogInfo, HeaderData headerData) {
        Class<?> clazz = catalogInfo.clazz;
        CatalogInfo catalogInfo2 = catalogInfo;
        int n = catalogInfo2.constructor;
        catalogInfo2.constructor = n + 1;
        if (this.getElement(catalogInfo, headerData, n, catalogInfo.constructors, () -> clazz.getConstructors(), "constructors", false)) {
            return true;
        }
        CatalogInfo catalogInfo3 = catalogInfo;
        int n2 = catalogInfo3.method;
        catalogInfo3.method = n2 + 1;
        if (this.getElement(catalogInfo, headerData, n2, catalogInfo.methods, () -> clazz.getMethods(), "methods", false)) {
            return true;
        }
        CatalogInfo catalogInfo4 = catalogInfo;
        int n3 = catalogInfo4.interfaze;
        catalogInfo4.interfaze = n3 + 1;
        if (this.getElement(catalogInfo, headerData, n3, catalogInfo.interfaces, () -> clazz.getInterfaces(), "interfaces", false)) {
            return true;
        }
        CatalogInfo catalogInfo5 = catalogInfo;
        int n4 = catalogInfo5.field;
        catalogInfo5.field = n4 + 1;
        if (this.getElement(catalogInfo, headerData, n4, catalogInfo.fields, () -> clazz.getFields(), "fields", false)) {
            return true;
        }
        CatalogInfo catalogInfo6 = catalogInfo;
        int n5 = catalogInfo6.memberClass;
        catalogInfo6.memberClass = n5 + 1;
        if (this.getElement(catalogInfo, headerData, n5, catalogInfo.memberClasses, () -> clazz.getClasses(), "memberClasses", false)) {
            return true;
        }
        CatalogInfo catalogInfo7 = catalogInfo;
        int n6 = catalogInfo7.annotation;
        catalogInfo7.annotation = n6 + 1;
        if (this.getAnnotation(catalogInfo, headerData, n6, catalogInfo.annotations, () -> clazz.getAnnotations(), "annotations")) {
            return true;
        }
        CatalogInfo catalogInfo8 = catalogInfo;
        int n7 = catalogInfo8.declaredConstructor;
        catalogInfo8.declaredConstructor = n7 + 1;
        if (this.getElement(catalogInfo, headerData, n7, catalogInfo.declaredConstructors, () -> clazz.getDeclaredConstructors(), "declaredConstructors", true)) {
            return true;
        }
        CatalogInfo catalogInfo9 = catalogInfo;
        int n8 = catalogInfo9.declaredMethod;
        catalogInfo9.declaredMethod = n8 + 1;
        if (this.getElement(catalogInfo, headerData, n8, catalogInfo.declaredMethods, () -> clazz.getDeclaredMethods(), "declaredMethods", true)) {
            return true;
        }
        CatalogInfo catalogInfo10 = catalogInfo;
        int n9 = catalogInfo10.declaredField;
        catalogInfo10.declaredField = n9 + 1;
        if (this.getElement(catalogInfo, headerData, n9, catalogInfo.declaredFields, () -> clazz.getDeclaredFields(), "declaredFields", true)) {
            return true;
        }
        CatalogInfo catalogInfo11 = catalogInfo;
        int n10 = catalogInfo11.declaredClass;
        catalogInfo11.declaredClass = n10 + 1;
        if (this.getElement(catalogInfo, headerData, n10, catalogInfo.declaredClasses, () -> clazz.getDeclaredClasses(), "declaredClasses", true)) {
            return true;
        }
        CatalogInfo catalogInfo12 = catalogInfo;
        int n11 = catalogInfo12.declaredAnnotation;
        catalogInfo12.declaredAnnotation = n11 + 1;
        if (this.getAnnotation(catalogInfo, headerData, n11, catalogInfo.declaredAnnotations, () -> clazz.getDeclaredAnnotations(), "declaredAnnotations")) {
            return true;
        }
        CatalogInfo catalogInfo13 = catalogInfo;
        int n12 = catalogInfo13.everythingCounter;
        catalogInfo13.everythingCounter = n12 + 1;
        if (this.getElement(catalogInfo, headerData, n12, catalogInfo.everything, "everything")) {
            return true;
        }
        CatalogInfo catalogInfo14 = catalogInfo;
        int n13 = catalogInfo14.everythingPublicCounter;
        catalogInfo14.everythingPublicCounter = n13 + 1;
        if (this.getElement(catalogInfo, headerData, n13, catalogInfo.everythingPublic, "everythingPublic")) {
            return true;
        }
        CatalogInfo catalogInfo15 = catalogInfo;
        int n14 = catalogInfo15.everythingDeclaredCounter;
        catalogInfo15.everythingDeclaredCounter = n14 + 1;
        return this.getElement(catalogInfo, headerData, n14, catalogInfo.everythingDeclared, "everythingDeclared");
    }

    private boolean getElement(CatalogInfo catalogInfo, HeaderData headerData, int contador, List<AnnotatedElement> elements, String dir) {
        if (contador < elements.size()) {
            AnnotatedElement elem = elements.get(contador);
            headerData.setFileName(String.valueOf(dir) + "\\" + elem + "." + elem.getClass().getSimpleName().toLowerCase());
            return true;
        }
        return false;
    }

    private boolean getElement(CatalogInfo catalogInfo, HeaderData headerData, int contador, List<AnnotatedElement> elements, Supplier<AnnotatedElement[]> s, String dir, boolean declared) {
        if (contador > 0 && elements.size() == 0) {
            return false;
        }
        if (contador == 0) {
            elements.addAll(Arrays.asList(s.get()));
        }
        if (contador < elements.size()) {
            AnnotatedElement elem = elements.get(contador);
            headerData.setFileName(String.valueOf(dir) + "\\" + elem + "." + elem.getClass().getSimpleName().toLowerCase());
            if (declared) {
                catalogInfo.everythingDeclared.add(elem);
            } else {
                catalogInfo.everythingPublic.add(elem);
            }
            if (!catalogInfo.everything.contains(elem)) {
                catalogInfo.everything.add(elem);
            }
            return true;
        }
        return false;
    }

    private boolean getAnnotation(CatalogInfo catalogInfo, HeaderData headerData, int contador, List<Annotation> elements, Supplier<Annotation[]> s, String dir) {
        if (contador > 0 && elements.size() == 0) {
            return false;
        }
        try {
            if (contador == 0) {
                elements.addAll(Arrays.asList(s.get()));
            }
            if (contador < elements.size()) {
                Annotation elem = elements.get(contador);
                headerData.setFileName(String.valueOf(dir) + "\\" + elem + ".annotation");
                return true;
            }
            return false;
        }
        catch (Throwable t) {
            headerData.setFileName(String.valueOf(dir) + "\\error-retrieving\\" + t.getClass().getSimpleName() + "\\" + t.getMessage());
            return true;
        }
    }

    private boolean getVariables(CatalogInfo catalogInfo, HeaderData headerData, String dir, Map<?, ?> map, Iterator<?> iterator, String ext) {
        headerData.setUnpSize((long)map.size());
        if (iterator.hasNext()) {
            Object key = iterator.next();
            Object value = map.get(key);
            if (log.isDebugEnabled()) {
                log.debug("variable:" + key + "-" + value);
            }
            String sv = value.toString().replace("\\", "[/]");
            headerData.setFileName(String.valueOf(dir) + "\\" + key + "=" + sv + "." + ext);
            return true;
        }
        return false;
    }

    private int decompile(File source, File dest) {
        if (dest.exists()) {
            return 16;
        }
        try (PrintWriter out = null;){
            try {
                out = new PrintWriter(dest);
                PluginSinkFactory mySink = new PluginSinkFactory(out);
                CfrDriver driver = new CfrDriver.Builder().withOutputSink(mySink).build();
                driver.analyse(Collections.singletonList("" + source));
            }
            catch (FileNotFoundException fnfe) {
                if (out != null) {
                    out.close();
                }
                return 15;
            }
        }
        return 0;
    }

    private int save(CatalogInfo catalogInfo, File dest, Map<?, ?> properties) {
        StringBuffer sb = new StringBuffer();
        properties.forEach((k, v) -> {
            StringBuffer stringBuffer2 = sb.append(k).append("=").append(v).append("\n\r");
        });
        return this.save(catalogInfo, dest, sb.toString());
    }

    private int save(CatalogInfo cinfo, File dest, Throwable t) {
        if (log.isWarnEnabled()) {
            log.warn("saving throwable", t);
        }
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        t.printStackTrace(pw);
        pw.flush();
        return this.save(cinfo, dest, sw.toString());
    }

    private int save(CatalogInfo cinfo, File dest, String contents) {
        if (dest.exists()) {
            return 16;
        }
        try (PrintWriter out = null;){
            try {
                out = new PrintWriter(dest);
                out.print(contents);
            }
            catch (FileNotFoundException fnfe) {
                if (out != null) {
                    out.close();
                }
                return 15;
            }
        }
        return 0;
    }

    public static void main(String[] args) {
        if (log.isDebugEnabled()) {
            log.debug(String.valueOf(Decompiler.class.getName()) + ".main");
        }
    }

    static class CatalogInfo
    extends ItemsPlugin.CatalogBase {
        Class<?> clazz;
        private int constructor;
        private int method;
        private int interfaze;
        private int field;
        private int memberClass;
        private int annotation;
        private int declaredConstructor;
        private int declaredMethod;
        private int declaredField;
        private int declaredClass;
        private int declaredAnnotation;
        private int everythingCounter;
        private int everythingPublicCounter;
        private int everythingDeclaredCounter;
        private List<AnnotatedElement> constructors = new ArrayList<AnnotatedElement>();
        private List<AnnotatedElement> methods = new ArrayList<AnnotatedElement>();
        private List<AnnotatedElement> interfaces = new ArrayList<AnnotatedElement>();
        private List<AnnotatedElement> fields = new ArrayList<AnnotatedElement>();
        private List<AnnotatedElement> memberClasses = new ArrayList<AnnotatedElement>();
        private List<Annotation> annotations = new ArrayList<Annotation>();
        private List<AnnotatedElement> declaredConstructors = new ArrayList<AnnotatedElement>();
        private List<AnnotatedElement> declaredMethods = new ArrayList<AnnotatedElement>();
        private List<AnnotatedElement> declaredFields = new ArrayList<AnnotatedElement>();
        private List<AnnotatedElement> declaredClasses = new ArrayList<AnnotatedElement>();
        private List<Annotation> declaredAnnotations = new ArrayList<Annotation>();
        private List<AnnotatedElement> everything = new ArrayList<AnnotatedElement>();
        private List<AnnotatedElement> everythingPublic = new ArrayList<AnnotatedElement>();
        private List<AnnotatedElement> everythingDeclared = new ArrayList<AnnotatedElement>();
        private Properties properties = System.getProperties();
        private Iterator<Object> propertiesKeys = this.properties.keySet().iterator();
        private Map<String, String> env = System.getenv();
        private Iterator<String> envKeys = this.env.keySet().iterator();

        CatalogInfo() {
        }
    }

    protected static enum ItemEnum {
        JAVA_FILE(false),
        PROPERTIES_DIR(true),
        PROPERTIES_FILE(false),
        ENVIRONMENT_DIR(true),
        ENVIRONMENT_FILE(false),
        THROWABLE(true),
        PACKAGE(false),
        CLASS_ELEMENTS(true),
        FINISH(false);

        private static ItemEnum[] vals;
        BiPredicate<CatalogInfo, HeaderData> getter;
        BiFunction<CatalogInfo, ItemEnum, ItemEnum> nextIfSuccess;
        ItemsPlugin.SaverFunction saver;

        static {
            vals = ItemEnum.values();
        }

        private ItemEnum(boolean multiple) {
            this.nextIfSuccess = multiple ? (c, i) -> i : (c, i) -> i.next();
        }

        public static ItemEnum first() {
            return vals[0];
        }

        public ItemEnum next() {
            return vals[this.ordinal() + 1];
        }

        public void set(BiPredicate<CatalogInfo, HeaderData> getter, ItemsPlugin.SaverFunction saver) {
            this.getter = getter;
            this.saver = saver;
        }

        public void setNextIfSuccess(BiFunction<CatalogInfo, ItemEnum, ItemEnum> nextIfSuccess) {
            this.nextIfSuccess = nextIfSuccess;
        }
    }

    public class PluginSinkFactory
    implements OutputSinkFactory {
        PrintWriter out;
        Consumer<SinkReturns.Decompiled> dumpDecompiled = d -> this.out.println(d.getJava());

        public PluginSinkFactory(PrintWriter out) {
            this.out = out;
        }

        @Override
        public List<OutputSinkFactory.SinkClass> getSupportedSinks(OutputSinkFactory.SinkType sinkType, Collection<OutputSinkFactory.SinkClass> collection) {
            System.out.println("CFR wants to sink " + (Object)((Object)sinkType) + ", and I can choose:");
            collection.forEach(System.out::println);
            if (sinkType == OutputSinkFactory.SinkType.JAVA && collection.contains((Object)OutputSinkFactory.SinkClass.DECOMPILED)) {
                return Arrays.asList(OutputSinkFactory.SinkClass.DECOMPILED, OutputSinkFactory.SinkClass.STRING);
            }
            return Collections.singletonList(OutputSinkFactory.SinkClass.STRING);
        }

        @Override
        public <T> OutputSinkFactory.Sink<T> getSink(OutputSinkFactory.SinkType sinkType, OutputSinkFactory.SinkClass sinkClass) {
            if (sinkType == OutputSinkFactory.SinkType.JAVA && sinkClass == OutputSinkFactory.SinkClass.DECOMPILED) {
                return x -> this.dumpDecompiled.accept((SinkReturns.Decompiled)x);
            }
            return ignore -> {};
        }
    }
}

