/*
 * Decompiled with CFR 0.152.
 */
package moi.tcplugins.decompiler;

import java.io.File;
import moi.tcplugins.VersionCheck;
import moi.tcplugins.decompiler.Decompiler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import plugins.wcx.HeaderData;
import plugins.wcx.OpenArchiveData;
import plugins.wcx.WCXPluginAdapter;

public abstract class ItemsPlugin
extends WCXPluginAdapter {
    static final Logger log = LoggerFactory.getLogger(ItemsPlugin.class);
    static final int[] pluginClassLoaderVersion;

    static {
        int[] nArray = new int[3];
        nArray[0] = 2;
        nArray[1] = 2;
        pluginClassLoaderVersion = nArray;
    }

    public Object openArchive(OpenArchiveData archiveData) {
        if (log.isDebugEnabled()) {
            log.debug(".openArchive(archiveData)");
        }
        Decompiler.CatalogInfo catalogInfo = new Decompiler.CatalogInfo();
        catalogInfo.arcName = archiveData.getArcName();
        try {
            VersionCheck.checkPluginClassLoaderVersion(pluginClassLoaderVersion);
            catalogInfo.nextItemToShow = Decompiler.ItemEnum.first();
            this.onOpenArchive(catalogInfo);
        }
        catch (Throwable e) {
            catalogInfo.blockingThrowable = e;
        }
        return catalogInfo;
    }

    protected abstract void onOpenArchive(Decompiler.CatalogInfo var1) throws Exception;

    public int closeArchive(Object archiveData) {
        if (log.isDebugEnabled()) {
            log.debug(".closeArchive(archiveData)");
        }
        return 0;
    }

    public int processFile(Object archiveData, int operation, String destPath, String destName) {
        if (log.isDebugEnabled()) {
            log.debug(String.valueOf(((Object)((Object)this)).getClass().getName()) + ".processFile(archiveData, operation=[" + operation + "], destPath=[" + destPath + "];destName=[" + destName + "]");
        }
        Decompiler.CatalogInfo catalogInfo = (Decompiler.CatalogInfo)archiveData;
        String fullDestName = String.valueOf(destPath == null ? "" : destPath) + destName;
        try {
            if (operation == 2) {
                if (log.isDebugEnabled()) {
                    log.debug(".processFile() EXTRACT from:[" + catalogInfo.arcName + "] to: [" + fullDestName + "]");
                }
                return catalogInfo.itemToShow.saver.apply(catalogInfo, new File(fullDestName));
            }
            if (operation == 1) {
                if (log.isDebugEnabled()) {
                    log.debug(".processFile() TEST " + (destPath == null ? "" : destPath) + destName);
                }
            } else if (operation == 0 && log.isDebugEnabled()) {
                log.debug(".processFile() SKIP " + (destPath == null ? "" : destPath) + destName);
            }
        }
        catch (Throwable t) {
            log.error(t.getMessage(), t);
            try {
                catalogInfo.throwableToShow = t;
                return Decompiler.ItemEnum.THROWABLE.saver.apply(catalogInfo, new File(fullDestName));
            }
            catch (Throwable t2) {
                log.error(t.getMessage(), t2);
                return 19;
            }
        }
        return 0;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int readHeader(Object archiveData, HeaderData headerData) {
        Decompiler.CatalogInfo catalogInfo = (Decompiler.CatalogInfo)archiveData;
        if (log.isDebugEnabled()) {
            log.debug(String.valueOf(((Object)((Object)this)).getClass().getName()) + ".readHeader(archiveData, headerData) " + (Object)((Object)catalogInfo.itemToShow));
        }
        try {
            catalogInfo.itemToShow = catalogInfo.nextItemToShow;
            if (catalogInfo.itemToShow == Decompiler.ItemEnum.FINISH) {
                return 10;
            }
            do {
                if (catalogInfo.itemToShow.getter.test(catalogInfo, headerData)) {
                    catalogInfo.nextItemToShow = catalogInfo.itemToShow.nextIfSuccess.apply(catalogInfo, catalogInfo.itemToShow);
                    if (log.isDebugEnabled()) {
                        log.debug(".readHeader: nextItem:" + (Object)((Object)catalogInfo.nextItemToShow));
                    }
                    return 0;
                }
                catalogInfo.itemToShow = catalogInfo.itemToShow.next();
            } while (catalogInfo.itemToShow != Decompiler.ItemEnum.FINISH);
            return 10;
        }
        catch (Throwable t) {
            if (log.isErrorEnabled()) {
                log.error(t.getMessage(), t);
            }
            String msg = t.getMessage().replaceAll("[^a-zA-Z0-9 ]", "-");
            headerData.setFileName(String.valueOf(msg) + ".exception");
            headerData.setUnpSize((long)msg.length());
            catalogInfo.nextItemToShow = catalogInfo.itemToShow == null ? Decompiler.ItemEnum.FINISH : catalogInfo.itemToShow.next();
            catalogInfo.throwableToShow = t;
            catalogInfo.itemToShow = Decompiler.ItemEnum.THROWABLE;
            if (log.isDebugEnabled()) {
                log.debug(".readHeader: SUCCESS after throwable");
            }
            return 0;
        }
    }

    public int getPackerCaps() {
        return 36;
    }

    protected static class CatalogBase {
        public String arcName;
        public Throwable blockingThrowable;
        public Throwable throwableToShow;
        public Decompiler.ItemEnum itemToShow;
        public Decompiler.ItemEnum nextItemToShow;

        protected CatalogBase() {
        }
    }

    @FunctionalInterface
    public static interface SaverFunction {
        public int apply(Decompiler.CatalogInfo var1, File var2) throws Exception;
    }
}

