/*
 * Decompiled with CFR 0.152.
 */
package tcclassloader;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import moi.tcplugins.PluginLogger;

public class PluginClassLoader
extends ClassLoader {
    private static PluginLogger log = new PluginLogger();
    private static final int CLASSNAME_SUFFIX = ".class".length();
    private static final int BUFFER_SIZE = 8192;
    private HashMap<String, byte[]> classes = new HashMap();
    private HashMap<String, byte[]> others = new HashMap();
    private HashMap<String, URL> urls = new HashMap();
    private String pluginDirectory;
    private String fLibName;
    private static Hashtable<String, PluginClassLoader> classLoaders = new Hashtable();
    private Object pluginObject;
    private static final String JAVALIB = System.getProperty("tc.java.lib");
    private static final PluginClassLoader ROOT_CL = new PluginClassLoader();
    private static final int[] versionNumber = new int[]{2, 3, 2};
    private static final String version = String.valueOf(versionNumber[0]) + "." + versionNumber[1] + "." + versionNumber[2];

    public static int[] getVersionNumber() {
        return versionNumber;
    }

    public static String getVersion() {
        return version;
    }

    public static Object getPlugin(String libName, String className) throws ClassNotFoundException, IOException, InstantiationException, IllegalAccessException {
        if (log.isDebugEnabled()) {
            log.debug("getPlugin: libName=[" + libName + "]; className =[" + className + "]");
        }
        PluginClassLoader cl = PluginClassLoader.getPluginClassLoader(libName);
        if (cl.pluginObject == null) {
            Class<?> pluginClass = cl.findClass(className);
            cl.pluginObject = pluginClass.newInstance();
        }
        return cl.pluginObject;
    }

    public static PluginClassLoader getPluginClassLoader(String libName) throws IOException {
        PluginClassLoader cl;
        if (log.isDebugEnabled()) {
            log.debug("getPluginClassLoader: libName=[" + libName + "]");
        }
        if (classLoaders.get(libName) == null) {
            cl = new PluginClassLoader(libName);
            classLoaders.put(libName, cl);
        } else {
            cl = classLoaders.get(libName);
        }
        return cl;
    }

    private PluginClassLoader() {
        super(PluginClassLoader.class.getClassLoader());
        if (log.isDebugEnabled()) {
            log.debug("PluginClassLoader: JAVALIB=" + JAVALIB);
        }
        try {
            this.pluginDirectory = JAVALIB;
            this.configureFromDirectory(JAVALIB);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public PluginClassLoader(String libName) throws IOException {
        super(ROOT_CL);
        if (log.isDebugEnabled()) {
            log.debug("PluginClassLoader: libName=" + libName);
        }
        File tcLib = new File(libName);
        File cwd = tcLib.getParentFile();
        this.pluginDirectory = cwd.getAbsolutePath();
        this.fLibName = tcLib.getName();
        this.configureFromDirectory(cwd);
        File pluginLib = new File(cwd, "pluginlib");
        if (pluginLib.exists()) {
            this.configureFromDirectory(pluginLib);
        }
    }

    private void configureFromDirectory(String cwd) throws IOException {
        File dir = new File(cwd);
        this.configureFromDirectory(dir);
    }

    private void configureFromDirectory(File dir) throws IOException {
        File[] otherFiles;
        log.debug("configureFromDirectory: dir=" + dir);
        String[] files = dir.list(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.endsWith(".jar");
            }
        });
        int i = 0;
        while (i < files.length) {
            JarFile file = new JarFile(new File(dir, files[i]));
            this.addJar(file);
            ++i;
        }
        File[] fileArray = otherFiles = dir.listFiles(new FilenameFilter(){
            private String[] nonResources = new String[]{".jar", ".zip", ".ini", ".wcx", ".wcx64", ".wfx", ".wfx64", ".wdx", ".wdx64", ".wlx", ".wlx64"};

            @Override
            public boolean accept(File dir, String name) {
                String[] stringArray = this.nonResources;
                int n = this.nonResources.length;
                int n2 = 0;
                while (n2 < n) {
                    String ext = stringArray[n2];
                    if (name.endsWith(ext)) {
                        return false;
                    }
                    ++n2;
                }
                return true;
            }
        });
        int n = otherFiles.length;
        int n2 = 0;
        while (n2 < n) {
            File otherFile = fileArray[n2];
            if (!otherFile.isDirectory()) {
                this.addOtherFile(otherFile);
            }
            ++n2;
        }
    }

    @Override
    public final InputStream getResourceAsStream(String name) {
        byte[] buf;
        InputStream stream;
        if (log.isDebugEnabled()) {
            log.debug("getResourceAsStream: name=" + name);
        }
        if ((stream = this.getParent().getResourceAsStream(name)) == null && (buf = this.others.get(name)) != null) {
            stream = new ByteArrayInputStream(buf);
        }
        return stream;
    }

    @Override
    public final URL getResource(String name) {
        URL url = this.urls.get(name);
        if (url == null) {
            url = super.getResource(name);
        }
        if (log.isDebugEnabled()) {
            log.debug("getResource: name=[" + name + "];URL=[" + this.urls.get(name) + "]");
        }
        return url;
    }

    @Override
    protected final Enumeration<URL> findResources(String name) throws IOException {
        ArrayList<URL> result = new ArrayList<URL>();
        URL url = this.urls.get(name);
        if (url != null) {
            result.add(url);
        }
        if (log.isDebugEnabled()) {
            log.debug("findResources: name=[" + name + "];URL=[" + url + "]");
        }
        return Collections.enumeration(result);
    }

    @Override
    protected final URL findResource(String name) {
        URL url = this.urls.get(name);
        if (log.isDebugEnabled()) {
            log.debug("findResource: name=[" + name + "];URL=[" + url + "]");
        }
        return url;
    }

    public final boolean equals(Object o) {
        if (o instanceof PluginClassLoader) {
            return ((PluginClassLoader)o).getParent() == this.getParent();
        }
        return false;
    }

    public final int hashCode() {
        return this.getParent().hashCode();
    }

    protected final Class<?> defineClass(String name, byte[] b, int len) throws ClassFormatError {
        String pkgname;
        int i = name.lastIndexOf(46);
        if (i != -1 && this.getPackage(pkgname = name.substring(0, i)) == null) {
            this.definePackage(pkgname, null, null, null, null, null, null, null);
        }
        return this.defineClass(name, b, 0, len, null);
    }

    @Override
    public final Class<?> findClass(String name) throws ClassNotFoundException {
        byte[] data;
        if (log.isDebugEnabled()) {
            log.debug("findClass: name=" + name);
        }
        if ((data = this.findClassData(name)) != null) {
            return this.defineClass(name, data, data.length);
        }
        throw new ClassNotFoundException(name);
    }

    public final void addJar(JarFile jar) {
        log.debug("addJar: jar=" + jar.getName());
        Enumeration<JarEntry> entries = jar.entries();
        while (entries.hasMoreElements()) {
            JarEntry entry = entries.nextElement();
            String entryName = entry.getName();
            if (log.isDebugEnabled()) {
                log.debug("addJar: JarInputStream:" + entryName);
            }
            if (entryName.endsWith("/")) continue;
            if (entry.getName().endsWith(".class")) {
                try {
                    this.addClassFile(jar, entry);
                }
                catch (IOException e) {
                    log.error("addJar: on addClassFile", e);
                    e.printStackTrace();
                }
                continue;
            }
            try {
                this.addOtherFile(jar, entry);
            }
            catch (IOException e) {
                log.error("addJar: on addOtherFile", e);
                e.printStackTrace();
            }
        }
    }

    private byte[] findClassData(String name) {
        if (log.isDebugEnabled()) {
            byte[] cd = this.classes.get(name);
            if (cd == null) {
                log.debug("findClassData: name=[" + name + "] is null");
            } else {
                log.debug("findClassData: name=[" + name + "];length=" + cd.length);
            }
        }
        return this.classes.remove(name);
    }

    private void addClassFile(JarFile jar, JarEntry entry) throws IOException {
        if (log.isDebugEnabled()) {
            log.debug("addClassFile: jar=[" + jar.getName() + "];entry[" + entry + "]");
        }
        this.classes.put(PluginClassLoader.getClassName(entry.getName()), PluginClassLoader.getFileBytes(jar, entry));
        this.addUrl(jar, entry);
    }

    private void addUrl(JarFile jar, JarEntry entry) throws MalformedURLException {
        String url = "jar:file:/" + jar.getName() + "!/" + entry.getName();
        if (log.isDebugEnabled()) {
            log.debug("addUrl: jar=[" + jar.getName() + "];entry[" + entry + "];url=[" + url + "]");
        }
        this.urls.put(entry.getName(), new URL(url));
    }

    private void addUrl(File file) throws MalformedURLException {
        if (log.isDebugEnabled()) {
            log.debug("addUrl: file=[" + file + "], url=[" + file.toURI().toURL() + "]");
        }
        this.urls.put(file.getName(), file.toURI().toURL());
    }

    private void addOtherFile(JarFile jar, JarEntry entry) throws IOException {
        if (log.isDebugEnabled()) {
            log.debug("addOtherFile: jar=[" + jar.getName() + "];entry[" + entry + "]");
        }
        this.others.put(entry.getName(), PluginClassLoader.getFileBytes(jar, entry));
        this.addUrl(jar, entry);
    }

    private void addOtherFile(File file) throws IOException {
        if (log.isDebugEnabled()) {
            log.debug("addOtherFile: file=[" + file + "]");
        }
        this.others.put(file.getName(), PluginClassLoader.getFileBytes(file));
        this.addUrl(file);
    }

    private static String getClassName(String fileName) {
        if (log.isDebugEnabled()) {
            log.trace("getClassName: fileName=[" + fileName + "]");
        }
        return fileName.substring(0, fileName.length() - CLASSNAME_SUFFIX).replace('/', '.');
    }

    private static byte[] getFileBytes(JarFile jar, JarEntry entry) throws IOException {
        int count;
        if (log.isDebugEnabled()) {
            log.debug("getFileBytes: jar=[" + jar.getName() + "];entry[" + entry + "]");
        }
        ByteArrayOutputStream stream = new ByteArrayOutputStream((int)entry.getSize());
        byte[] buf = new byte[8192];
        BufferedInputStream in = new BufferedInputStream(jar.getInputStream(entry));
        while ((count = in.read(buf)) > -1) {
            stream.write(buf, 0, count);
        }
        in.close();
        stream.close();
        return stream.toByteArray();
    }

    private static byte[] getFileBytes(File file) throws IOException {
        int count;
        if (log.isDebugEnabled()) {
            log.debug("getFileBytes: file=[" + file + "]");
        }
        ByteArrayOutputStream stream = new ByteArrayOutputStream((int)file.length());
        byte[] buf = new byte[8192];
        BufferedInputStream in = new BufferedInputStream(new FileInputStream(file));
        while ((count = in.read(buf)) > -1) {
            stream.write(buf, 0, count);
        }
        in.close();
        stream.close();
        return stream.toByteArray();
    }

    @Override
    protected final String findLibrary(String libname) {
        if (log.isDebugEnabled()) {
            log.debug("findLibrary: libname=[" + libname + "]");
        }
        if (libname.startsWith("tc.library.name")) {
            String absolutePathName = String.valueOf(this.pluginDirectory) + System.getProperty("file.separator") + this.fLibName;
            return absolutePathName;
        }
        String absolutePathName = String.valueOf(this.pluginDirectory) + System.getProperty("file.separator") + System.mapLibraryName(libname);
        return absolutePathName;
    }
}

