/*
 * Decompiled with CFR 0.152.
 */
package moi.tcplugins;

import java.util.jar.JarInputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tcclassloader.PluginClassLoader;

public class VersionCheck {
    static final Logger log = LoggerFactory.getLogger(VersionCheck.class);
    private static final int[] VERSION_1_7_0;
    private static final int[] VERSION_2_2_0;

    static {
        int[] nArray = new int[3];
        nArray[0] = 1;
        nArray[1] = 7;
        VERSION_1_7_0 = nArray;
        int[] nArray2 = new int[3];
        nArray2[0] = 2;
        nArray2[1] = 2;
        VERSION_2_2_0 = nArray2;
    }

    private static void throwVersionException(int[] minVersion) throws Exception {
        String msg = "PluginClassLoader must be at least version " + minVersion[0] + "." + minVersion[1] + "." + minVersion[2] + ". If you have other java plugins with older versions," + " replace tc-classloader-x.x.jar in every [plugin]/javalib directory with the latest version.";
        throw new Exception(msg);
    }

    public static String getPluginClassLoaderVersion() {
        return VersionCheck.getPluginClassLoaderVersion(VersionCheck.getPluginClassLoaderVersionNumber());
    }

    public static String getPluginClassLoaderVersion(int[] version) {
        return String.valueOf(version[0]) + "." + version[1] + "." + version[2] + ".";
    }

    public static int[] getPluginClassLoaderVersionNumber() {
        int[] version = new int[3];
        try {
            version = PluginClassLoader.getVersionNumber();
        }
        catch (NoSuchMethodError nsme) {
            try {
                PluginClassLoader.class.getMethod("addJar", JarInputStream.class);
                version = VERSION_1_7_0;
            }
            catch (NoSuchMethodException e) {
                version = VERSION_2_2_0;
            }
        }
        if (log.isDebugEnabled()) {
            log.debug(VersionCheck.class + ".getPluginClassLoaderVersion(archiveData)" + VersionCheck.getPluginClassLoaderVersion(version));
        }
        return version;
    }

    public static void checkPluginClassLoaderVersion(int[] version) throws Exception {
        int[] pclVersion = VersionCheck.getPluginClassLoaderVersionNumber();
        if (version[0] > pclVersion[0]) {
            VersionCheck.throwVersionException(version);
        } else if (version[0] == pclVersion[0]) {
            if (version[1] > pclVersion[1]) {
                VersionCheck.throwVersionException(version);
            } else if (version[1] == pclVersion[1] && version[2] > pclVersion[2]) {
                VersionCheck.throwVersionException(version);
            }
        }
    }
}

