{
  WLX TAP Lister Plugin
  (c) 2006 Volker Pohlers
  based on
  WLX Delphi Tutorial Plugin
  (c) 2004 Mutex Ltd. mutex@nm.ru
}

library ListTAP;
{$R *.res} //DLL version info

uses
  SysUtils,
  Windows,
  unMain in 'unMain.pas' {fmMain},
  unAbout in 'unAbout.pas' {fmAbout},
  uKCFile in 'uKCFile.pas';

{$E wlx}

const PARSE_FUNCTION = 'FORCE | (EXT="TAP" | EXT="KCC" | EXT="SSS" | EXT="TTT" | EXT="ZBS" | EXT="KCB")'; SUPPORT_EXT = '.TAP.KCC.SSS.TTT.ZBS.KCB';

procedure ListGetDetectString(DetectString: PChar; MaxLen: integer); stdcall;
begin
  StrLCopy(DetectString, PChar(PARSE_FUNCTION), MaxLen);
end;

function ListLoad(ListerWin: HWND; FileToLoad: PChar; ShowFlags: integer): HWND; stdcall;
begin
  Result := 0;
  if Pos(UpperCase(ExtractFileExt(FileToLoad)), SUPPORT_EXT) = 0 then
    exit
  else
    Result := ShowTAP(ListerWin, FileToLoad);
end;

function ListLoadNext(ParentWin,PluginWin:thandle;FileToLoad:pchar;ShowFlags:integer):integer; stdcall;
begin
  Result := 0;
  if Pos(UpperCase(ExtractFileExt(FileToLoad)), SUPPORT_EXT) = 0 then
    exit
  else
    Result := ShowNextTAP(PluginWin, FileToLoad);
end;

procedure ListCloseWindow(PluginWin: HWND); stdcall;
begin
  HideTAP(PluginWin);
end;

exports
  ListGetDetectString,
  ListLoad,
  ListLoadNext,
  ListCloseWindow;

end.
