unit Unit1;

interface
  const
  PARSE_FUNCTION = 'MULTIMEDIA & ( EXT="AVI" | EXT="MPG" | EXT="OGG" | EXT="MP4" '+
                   '| EXT="WMV" | EXT="MPEG" | EXT="VOB" | EXT="MPEG" | EXT="ASF")';
  lc_copy=1;
  lc_newparams=2;
  lc_selectall=3;
  lc_setpercent=4;

  lcp_wraptext=1;
  lcp_fittowindow=2;
  lcp_ansi=4;
  lcp_ascii=8;
  lcp_variable=12;
  lcp_forceshow=16;

  lcs_findfirst=1;
  lcs_matchcase=2;
  lcs_wholewords=4;
  lcs_backwards=8;

  itm_percent=$FFFE;
  itm_fontstyle=$FFFD;
  itm_wrap=$FFFC;
  itm_fit=$FFFB;
  itm_next=$FFFA;

  LISTPLUGIN_OK=0;
  LISTPLUGIN_ERROR=1;

  function ListLoad(ParentWin:Cardinal;FileToLoad:pchar;ShowFlags:integer):Cardinal; stdcall;
  procedure ListCloseWindow(ListWin: Cardinal); stdcall;
  function ListSendCommand(ListWin:Cardinal;Command,Parameter:integer):integer; stdcall;
  procedure ListGetDetectString(DetectString: pchar; maxlen: integer); stdcall;

implementation
uses Windows, SysUtils, Messages, Unit2;

var hinst: Cardinal;
    NativeWidth,NativeHeight:integer;

Function WindowProc(Window : hWnd; Msg: Cardinal; WParam, LParam : Integer): Integer; StdCall;
  var hdc:Cardinal;
      WRec: TRect;
      brush:HBRUSH;
      ps:TPaintStruct;
      tmp:TMPdata;
      int:Integer;
Begin
  Result := 0;
  Case Msg of
    WM_NCPAINT : begin
                hdc:=BeginPaint(Window,ps);
                GetClientRect(Window,WRec);
                brush:=CreateSolidBrush($00101010);
                FillRect(hdc,WRec,brush);
                EndPaint(Window,ps);
               end;
    WM_CLOSE : PostQuitMessage(0);
    WM_KEYDOWN  :
        begin
          int:=GetWindowLong(Window,GWL_USERDATA);
          tmp:=int2TMPdata(int);
          case WParam of
            VK_SPACE  : SendCommand(tmp,'pause');
               VK_UP  : SendCommand(tmp,'seek +60');
             VK_DOWN  : SendCommand(tmp,'seek -60');
            VK_RIGHT  : SendCommand(tmp,'seek +10');
             VK_LEFT  : SendCommand(tmp,'seek -10');
                  81  : begin
                          SendCommand(tmp,'quit');
                          PostMessage(GetParent(Window),WM_CLOSE,0,0);
                        end;
                  57  : SendCommand(tmp,'volume -1');
           VK_DIVIDE  : SendCommand(tmp,'volume -1');
                  48  : SendCommand(tmp,'volume +1');
         VK_MULTIPLY  : SendCommand(tmp,'volume +1');
                 186  : SendCommand(tmp,'brightness -1');
                 222  : SendCommand(tmp,'brightness +1');
          end;
        end;
  Else Result := DefWindowProc(Window,Msg,WParam,LParam);
  End;
End;

function ListLoad(ParentWin:Cardinal;FileToLoad:pchar;ShowFlags:integer):Cardinal; stdcall;
      var CmdLine : string;
               si : TStartupInfo;
               pi : TProcessInformation;
       DummyPipe1,
       DummyPipe2 : Cardinal;
              sec : TSecurityAttributes;
           hMyWin : HWND;
               WC : TWndClass;
    ClientProcess,
         ReadPipe,
        WritePipe : Cardinal;
              tmp : TMPdata;
              ptm : PTMPdata;
      FirstChance : bool;
                r,
                r1 : TRect;
             MPlayer_path,
             MPlayer_params,
             size:string;
             QuickView:Boolean;
             NHeight,NWidth:Integer;

  begin

  FirstChance:=true;

  With WC do Begin
    Style := CS_OWNDC;
    lpfnWndProc := @WindowProc;
    cbClsExtra := 0;
    cbWndExtra := 4;
    hIcon := LoadIcon(0, IDI_WINLOGO);
    hCursor := LoadCursor(0, IDC_ARROW);
    hbrBackground := 0;
    lpszMenuName := nil;
    lpszClassName := 'MPWinClass';
    hInstance := hinst;
  end;
  Windows.RegisterClass(WC);

 hMyWin:=CreateWindow('MPWinClass', 'MPWin', WS_CHILD or WS_VISIBLE, 0, 0, 0,
                      0, ParentWin, 0, hinst, nil);

  ParseIniFile(ExtractFileDir(GetModuleName(hInstance))+ '\'+'mplayer4tc.ini',MPlayer_path,MPlayer_params,size);

  QuickView:= GetParent(ParentWin)<>0;

  if QuickView then
      CmdLine:=EscapeParam(MPlayer_path) + MPlayer_params + ' -quiet -slave -identify'
          +' -wid '+IntToStr(hMyWin) + ' -colorkey 0x101010'
          +#32+EscapeParam(FileToLoad)
                else
      CmdLine:=EscapeParam(MPlayer_path) + MPlayer_params + ' -quiet -slave -identify'
          +' -nokeepaspect -wid '+IntToStr(hMyWin) + ' -colorkey 0x101010'
          +#32+EscapeParam(FileToLoad);

  with sec do begin
    nLength:=sizeof(sec);
    lpSecurityDescriptor:=nil;
    bInheritHandle:=true;
  end;
  CreatePipe(ReadPipe,DummyPipe1,@sec,0);

  with sec do begin
    nLength:=sizeof(sec);
    lpSecurityDescriptor:=nil;
    bInheritHandle:=true;
  end;
  CreatePipe(DummyPipe2,WritePipe,@sec,0);

  FillChar(si,sizeof(si),0);
  si.cb:=sizeof(si);
  si.dwFlags:=STARTF_USESTDHANDLES;
  si.hStdInput:=DummyPipe2;
  si.hStdOutput:=DummyPipe1;
  si.hStdError:=DummyPipe1;

  if not CreateProcess(nil,PChar(CmdLine),nil,nil,true,DETACHED_PROCESS,nil,nil,si,pi) then
    begin
      MessageBox(0,'Cannot create process',nil,MB_OK);
      Result:=0;
      Exit;
    end;

  CloseHandle(DummyPipe1);
  CloseHandle(DummyPipe2);

  ClientProcess:=pi.hProcess;

  CloseHandle(pi.hProcess);
  CloseHandle(pi.hThread);

  tmp.ClientProcess:=ClientProcess;
  tmp.WritePipe:=WritePipe;
  tmp.ReadPipe:=ReadPipe;
  tmp.FirstChance:=FirstChance;

  GetWidthHeight(ReadPipe, NativeHeight, NativeWidth);

  if not QuickView then
    begin
      GetWindowRect(ParentWin,r);
      GetClientRect(GetDesktopWindow,r1);
      if size='normal' then
         MoveWindow(ParentWin, round((r1.Left+r1.Right-NativeWidth-8)/2),
                    round((r1.Top+r1.Bottom-NativeHeight-46)/2), NativeWidth+8,
                    NativeHeight+46, true);
      if size='double' then
         MoveWindow(ParentWin, round((r1.Left+r1.Right-NativeWidth*2-8)/2),
                    round((r1.Top+r1.Bottom-NativeHeight*2-46)/2), NativeWidth*2+8,
                    NativeHeight*2+46, true);
      if size='scale_height' then
         MoveWindow(ParentWin, round((r1.Left+r1.Right-(r.Right-r.Left))/2),
                    round((r1.Top+r1.Bottom-(r.Right-r.Left-8)*NativeHeight/NativeWidth-46)/2),
                    r.Right-r.Left, round((r.Right-r.Left-8)*NativeHeight/NativeWidth)+46,true);
      if size='scale_width' then
         MoveWindow(ParentWin, round((r1.Left+r1.Right-((r.Bottom-r.Top-46)*NativeWidth/NativeHeight)-8)/2),
                    round((r1.Top+r1.Bottom-(r.Bottom-r.Top))/2),
                    round((r.Bottom-r.Top-46)*NativeWidth/NativeHeight)+8, r.Bottom-r.Top,true);
      if size='smart' then
         begin
            NHeight:=r.Bottom-r.Top;
            NWidth:=round((r.Bottom-r.Top-46)*NativeWidth/NativeHeight)+8;
            if NWidth>0.7*(r1.Right-r1.Left) then
              begin
                NHeight:=round((r.Right-r.Left-8)*NativeHeight/NativeWidth)+46;
                NWidth:=r.Right-r.Left;
              end;
            MoveWindow(ParentWin,round((r1.Left+r1.Right-NWidth)/2),round((r1.Top+r1.Bottom-NHeight)/2),
                        NWidth, NHeight, true)
         end;
    end;

  ptm:=AllocMem(sizeof(tmp));
  ptm^:=tmp;
  SetWindowLong(hMyWin,GWL_USERDATA,integer(ptm));
  SetFocus(hMyWin);
  Result:=hMyWin;

 end;

procedure ListCloseWindow(ListWin: Cardinal); stdcall;
    var hdc:Cardinal;
        tmp:TMPdata;
        int:Integer;
 begin
   int:=GetWindowLong(ListWin,GWL_USERDATA);
   tmp:=int2TMPdata(int);
   ForceStop(tmp);
   hdc:=GetDC(ListWin);
   ReleaseDC(ListWin, hDC);
   DestroyWindow(ListWin);
   FreeMem(pointer(int));
   Windows.UnregisterClass('MPWinClass',HInstance);
 end;

function ListSendCommand(ListWin:Cardinal;Command,Parameter:integer):integer; stdcall;
  var tmp:TMPdata;
      int:Integer;
begin
  int:= GetWindowLong(ListWin,GWL_USERDATA);
  tmp:=int2TMPdata(int);
  if Command=lcp_fittowindow then SendCommand(tmp,'vo_fullscreen');
  Result:=LISTPLUGIN_OK;
end;

procedure ListGetDetectString(DetectString: pchar; maxlen: integer); stdcall;
begin
 StrLCopy(DetectString, PChar(PARSE_FUNCTION), MaxLen)
end;

 end.
