unit Unit2;

interface

type TMPdata=record
  ClientProcess,WritePipe,ReadPipe:Cardinal;
  FirstChance:Boolean;
end;

type PTMPdata=^TMPdata;

function EscapeParam(const Param:string):string;
procedure GetWidthHeight(ReadPipe: Cardinal; var Height: Integer; var Width: Integer);
procedure Terminate(ClientProcess:Cardinal);
function int2TMPdata(var int:integer): TMPdata;
procedure SendCommand(tmp:TMPdata;Command:string);
procedure ForceStop(tmp:TMPdata);
procedure ParseIniFile(IniFileName:string; var MP_path: string; var MP_params: string; var ViewScale: string);

implementation

uses Windows, SysUtils;

function int2TMPdata(var int:integer): TMPdata;
  var pss:PTMPdata;
begin
  pss:=pointer(int);
  Result:=pss^;
end;

procedure SendCommand(tmp:TMPdata;Command:string);
var Dummy:Cardinal;
begin
  if (tmp.ClientProcess=0) OR (tmp.WritePipe=0) then exit;
  Command:=Command+#10;
  WriteFile(tmp.WritePipe,Command[1],length(Command),Dummy,nil);
end;

function EscapeParam(const Param:string):string;
begin
  if Pos(#32,Param)>0 then Result:=#34+Param+#34 else Result:=Param;
end;

procedure Terminate(ClientProcess:Cardinal);
begin
  if ClientProcess=0 then exit;
  TerminateProcess(ClientProcess,cardinal(-1));
end;

procedure ForceStop(tmp:TMPdata);
begin
  if tmp.FirstChance then begin
    SendCommand(tmp,'quit');
    tmp.FirstChance:=false;
    if WaitForSingleObject(tmp.ClientProcess,1000)<>WAIT_TIMEOUT then exit;
  end;
  Terminate(tmp.ClientProcess);
end;

procedure GetWidthHeight(ReadPipe: Cardinal; var Height: Integer; var Width: Integer);
  const BufSize=1024;
  var Data, conte: string;
      BytesRead,aa,bb,cc:Cardinal;
      Buffer:array[0..BufSize]of char;
begin
  Data:='';
  repeat
    BytesRead:=0;
    ReadFile(ReadPipe,Buffer[0],BufSize,BytesRead,nil);
    Buffer[BytesRead]:=#0;
  until Pos('ID_FILENAME',Buffer)<>0;
  data:=data+buffer;
  repeat
    BytesRead:=0;
    ReadFile(ReadPipe,Buffer[0],BufSize,BytesRead,nil);
    Buffer[BytesRead]:=#0;
    Data:=Data+Buffer;
  until Pos('ID_LENGTH',Buffer)<>0;

  aa:=Pos('ID_VIDEO_WIDTH',data);
  delete(data,1,aa+14);
  conte:=copy(data,1,pos(#10,data));
  val(conte,bb,cc);
  Width:=bb;

  aa:=Pos('ID_VIDEO_HEIGHT',data);
  delete(data,1,aa+15);
  conte:=copy(data,1,pos(#10,data));
  val(conte,bb,cc);
  Height:=bb;
end;

procedure ParseIniFile(IniFileName:string; var MP_path: string; var MP_params: string; var ViewScale: string);
  const BufSize=1024;
  var Data: string;
      BytesRead,aa:Cardinal;
      Buffer:array[0..BufSize]of char;
      FileHandle: Cardinal;
begin
  FileHandle:=FileOpen(IniFileName,fmOpenRead);
  Data:='';
  repeat
    BytesRead:=FileRead(FileHandle,Buffer[0],BufSize);
    Buffer[BytesRead]:=#0;
    Data:=Data+Buffer;
  until BytesRead=0;

  aa:=Pos('MPlayer_path',Data);
  Delete(Data,1,aa+13);
  MP_path:=Copy(Data,1,Pos('"',Data)-1);

  aa:=Pos('MPlayer_params',Data);
  Delete(Data,1,aa+15);
  MP_params:=Copy(Data,1,Pos('"',Data)-1);

  aa:=Pos('View_Size',Data);
  Delete(Data,1,aa+10);
  ViewScale:=Copy(Data,1,Pos('"',Data)-1);
  FileClose(FileHandle);
end;

end.
