#include "stdafx.h"

// TODO: argument validity checking!

const int cnBufferSize = 0x2000;

class CItemSearchData
{
  bool      m_bLookForStream;
  IStorage *m_pStg;
  IStream  *m_pStream;
  LPCSTR    m_pPath;
  unsigned int m_nSkip;
public:
  CItemSearchData(LPCSTR pPath, bool bLookForStream) : 
                                   m_bLookForStream(bLookForStream),
                                   m_pStg(NULL), 
                                   m_pStream(NULL),
                                   m_pPath(pPath){ m_nSkip = 0; }
  ~CItemSearchData()
  {
    if(m_pStg) m_pStg->Release();
    if(m_pStream) m_pStream->Release();
  }

  IStorage *Storage(){ return m_pStg; }
  IStream  *Stream(){ return m_pStream; }
  void SetStorage(IStorage *pStg){ if(m_pStg) m_pStg->Release(); m_pStg = pStg; }
  void SetStream(IStream *pStream){ if(m_pStream) m_pStream->Release(); m_pStream = pStream; }
  bool WantsStream(){ return m_bLookForStream; }
  bool WantsStorage(){ return !m_bLookForStream; }
  bool HasSomethingToParse(){ return m_nSkip < strlen(m_pPath); }
  bool CheckName(LPCSTR pStr)
  { 
    bool bRet = false;
    if(!strncmp((m_pPath + m_nSkip), pStr, strlen(pStr)))
    {
      int extra = 0;
      switch((m_pPath + m_nSkip)[strlen(pStr)])
      {
      case '\\': extra++;
      case '\0': 
        m_nSkip += strlen(pStr) + extra;
        bRet = true; 
        break;
      default: break;
      }
    }
    return bRet;
  }
};
 
// pointer on function - handler - gets main params and interface to root storage
typedef HRESULT (*STGHANDLEPROC)(int argc, char* argv[], IStorage *pStgRoot);

 // function enumeration callback - gets interface to parent storage, 
 //                                 STAT info for checked item
 //                                 void pointer on some user-defined data
 // returns: S_OK - to continue enumeration
 //          S_FALSE - to break enumeration
 //          other values - error occured
typedef HRESULT (*STGENUMPROC)(IStorage *pStgParent, STATSTG *pStatStg, LPVOID lParam);

// EnumStg - enumerates items in storage - recursively calls "proc" 
// returns: S_OK - on success 
//          S_FALSE - to break enumeration
//          other values  - on errors .
HRESULT EnumStg(IStorage *pStgParent, STGENUMPROC proc, LPVOID lParam)
{
  HRESULT hRes = E_FAIL;
  IEnumSTATSTG *pEnum = NULL;
  STATSTG ss;

  if(!pStgParent || !proc)
    return E_INVALIDARG;

  if(SUCCEEDED(hRes = pStgParent->EnumElements(0, 0, 0, &pEnum)))
  {
    memset(&ss, 0, sizeof(STATSTG));

    for(;;)
    {
      if(FAILED(hRes = pEnum->Next(1, &ss, 0)))
        break;

      if(hRes == S_FALSE) // Next finished succecfully - do not break enumeration 
      {
         hRes = S_OK;
         break;
      }

      if(FAILED(hRes = proc(pStgParent, &ss, lParam)) || hRes == S_FALSE)
        break;

      ss.pwcsName = NULL;
    }
  }
  return hRes;
}

// EnumStg - overloaded version of previous function
HRESULT EnumStg(const WCHAR *pStr, IStorage *pStgParent, STGENUMPROC proc, LPVOID lParam)
{
  HRESULT hRes = S_OK;
  IStorage *pStg = NULL;
  if(SUCCEEDED(hRes = pStgParent->OpenStorage(pStr, NULL, STGM_READ | STGM_SHARE_EXCLUSIVE, NULL, 0, &pStg)))
  {
    hRes = EnumStg(pStg, proc, lParam);
    pStg->Release();
  }
  return hRes;
}


HRESULT PrintItem(STATSTG *pStatStg, LPCSTR pStrParent, bool bDir)
{
  USES_CONVERSION;  
  HRESULT hRes = S_OK;
  SYSTEMTIME st;
  LPSTR lpStr=W2A(pStatStg->pwcsName);
  char *ch=(char *)pStatStg->pwcsName;
  FileTimeToSystemTime(&pStatStg->mtime, &st);
  printf("%02d/%02d/%04d %02d:%02d %10d %s%s%s\n", st.wDay, st.wMonth, st.wYear, 
                  st.wHour, st.wMinute,
                  pStatStg->cbSize.LowPart,
                  pStrParent,
                  W2A(pStatStg->pwcsName),
                  (bDir) ? "\\" : "");

 
  //printf("%c %c %c\n", ch[0],ch[1],ch[2]);

  return hRes;
}
 // enumeration callback for listing command. Gets parent storage "path" in lParam
HRESULT ListStgEnumProc(IStorage *pStgParent, STATSTG *pStatStg, LPVOID lParam)
{
  USES_CONVERSION;  
  HRESULT hRes = S_OK;
  LPCSTR pStrParent = (LPCSTR)lParam;
  
  switch(pStatStg->type)
  {
  case STGTY_STORAGE:
    {
      if(FAILED(hRes = PrintItem(pStatStg, pStrParent, true)))
        break;

      //IStorage *pStg = NULL;
      //if(SUCCEEDED(hRes = pStgParent->OpenStorage(pStatStg->pwcsName, NULL, STGM_READ | STGM_SHARE_EXCLUSIVE, NULL, 0, &pStg)))
      //{
        LPCSTR lpStgName = W2A(pStatStg->pwcsName);
        LPSTR lpStr = new char[strlen(pStrParent) + strlen(lpStgName) + 2];
        sprintf(lpStr, "%s%s\\", pStrParent, lpStgName);
        
        //hRes = EnumStg(pStg, ListStgEnumProc, lpStr);
        hRes = EnumStg(pStatStg->pwcsName, pStgParent, ListStgEnumProc, lpStr);
        
       // pStg->Release();
        delete[] lpStr;
      //}
    }
    break;
  case STGTY_LOCKBYTES:
    printf("lockbytes ");
  case STGTY_PROPERTY:
    printf("property ");
  case STGTY_STREAM:
    hRes = PrintItem(pStatStg, pStrParent, false);
    break;
  }

  return hRes;
}
 
 // enumeration callback - looks for stream
 // gets in lParam pointer to CItemSearchData,
HRESULT LookForItemEnumProc(IStorage *pStgParent, STATSTG *pStatStg, LPVOID lParam)
{
  USES_CONVERSION;
  HRESULT hRes = S_OK;
  CItemSearchData *pISData = (CItemSearchData *)lParam;

  if(pISData->CheckName(W2A(pStatStg->pwcsName)))
  {
    switch(pStatStg->type)
    {
    case STGTY_STORAGE:
      if(pISData->HasSomethingToParse())
        hRes = EnumStg(pStatStg->pwcsName, pStgParent, LookForItemEnumProc, lParam);
      else
        if(pISData->WantsStorage())
        {
          IStorage *pStg = NULL;
          if(SUCCEEDED(hRes = pStgParent->OpenStorage(pStatStg->pwcsName, NULL, STGM_READ | STGM_SHARE_EXCLUSIVE, NULL, 0, &pStg)))
          {
            pISData->SetStorage(pStg);
            hRes = S_FALSE; // break enumeration -  we found it
          }
        }
        else
          hRes = STG_E_FILENOTFOUND;
      break;
    case STGTY_LOCKBYTES:
      printf("lb\t");
    case STGTY_PROPERTY:
      printf("pr\t");
      break;
    case STGTY_STREAM:
      if(pISData->WantsStream())
      {
        IStream *pStream = NULL;
        if(SUCCEEDED(hRes = pStgParent->OpenStream(pStatStg->pwcsName, NULL, STGM_READ | STGM_SHARE_EXCLUSIVE, NULL, &pStream)))
        {
          pISData->SetStream(pStream);
          hRes = S_FALSE; // break enumeration -  we found it
        }
      }
      else
        if(!pISData->HasSomethingToParse())
          hRes = STG_E_PATHNOTFOUND;
      break;
    }
  }
  return hRes;
}

HRESULT List(int argc, char* argv[], IStorage *pStgRoot)
{
  HRESULT hRes = S_OK;
  printf("----- date time ------ size name ----\n");
  hRes = EnumStg(pStgRoot, ListStgEnumProc, "");
  printf("-------------------------------------\n");
  return (FAILED(hRes)) ? hRes : S_OK;
}

HRESULT Add(int argc, char* argv[], IStorage *pStgRoot)
{
  HRESULT hRes = S_OK;
  printf("Add %s to %s\n", argv[3], argv[2]);
  return hRes;
}

HRESULT Remove(int argc, char* argv[], IStorage *pStgRoot)
{
  HRESULT hRes = S_OK;
  printf("Remove %s from %s\n", argv[3], argv[2]);
  return hRes;
}

HRESULT Extract(int argc, char* argv[], IStorage *pStgRoot)
{
  USES_CONVERSION;
  HRESULT hRes = S_OK;
  printf("Extracting of \"%s\" from \"%s\": ", argv[3], argv[2]);

  CItemSearchData data(argv[3], true);
  hRes = EnumStg(pStgRoot, LookForItemEnumProc, &data);

  if(hRes == S_FALSE) // we found it?
  {
    STATSTG ss;
    memset(&ss, 0, sizeof(STATSTG));
    if(SUCCEEDED(hRes = data.Stream()->Stat(&ss, STATFLAG_DEFAULT)))
    {
      //printf("%s\n", ));
      HANDLE hFile = CreateFile(W2A(ss.pwcsName), GENERIC_WRITE, 0, 0,
                                CREATE_NEW, FILE_ATTRIBUTE_NORMAL, 0);
      
      if(hFile != INVALID_HANDLE_VALUE)
      {
        hRes = S_OK;
        ULONG ulLeft = ss.cbSize.LowPart;
        ULONG ulReaded;
        LPBYTE lpBuff = new BYTE[cnBufferSize];
        
        while(ulLeft)
        {
          ULONG ulSize=min(ulLeft, cnBufferSize);
          if(SUCCEEDED(hRes=data.Stream()->Read(lpBuff, ulSize, &ulReaded)))
          {
            if(ulSize == ulReaded)
            {
              DWORD dwWritten = 0;
              if(WriteFile(hFile, lpBuff, ulReaded, &dwWritten, NULL))
                ulLeft -= ulReaded;
              else
              {
                printf("Error writing data into %s. Requested : %d bytes but written : %d\n", W2A(ss.pwcsName), ulSize, ulReaded);
                hRes = GetLastError();
                break;
              }
            }
            else
            {
              printf("Error reading stream: requested %d bytes but readed %d\n", ulSize, ulReaded);
              hRes = E_FAIL;
              break;
            }
          }
        }

        CloseHandle(hFile);
        delete[] lpBuff;
      }
      else
        hRes = GetLastError();
    }
  }

  printf(FAILED(hRes) ? "failed.\n" : "done!\n");
  return hRes;
}

int main(int argc, char* argv[])
{
  HRESULT hRes = E_FAIL;
  printf("M$ Storage compound documents handler v.0.1.0-ME\n");
  printf("\tCopyright (c) 2002 S.Zharski\n\n");

  if(argc >= 3 && argv[1][0] == '-')
  {
    DWORD dwMode = 0;
    USES_CONVERSION;
    STGHANDLEPROC proc = NULL;
    switch(argv[1][1])
    {
    case 'a': 
      proc = Add; 
      dwMode = STGM_READWRITE | STGM_SHARE_EXCLUSIVE; 
      break;
    case 'd': 
      proc = Remove; 
      dwMode = 0/*STGM_READWRITE | STGM_SHARE_EXCLUSIVE*/; 
      break;
    case 'e': 
      proc = Extract; 
      dwMode = STGM_READ | STGM_SHARE_EXCLUSIVE; 
      break;
    case 'l': 
      proc = List; 
      dwMode = STGM_READ | STGM_SHARE_EXCLUSIVE;
      break;
    default: break;
    }

    IStorage *pstg = NULL;
//    HRESULT hRes = S_OK;
    if(SUCCEEDED(hRes = StgOpenStorage(A2W(argv[2]), NULL, dwMode, NULL, 0, &pstg)))
    {
      if(proc)
        hRes = proc(argc, argv, pstg);
      pstg->Release();
    }

    if(FAILED(hRes))
    {
      LPVOID lpMsgBuf;
      FormatMessage(FORMAT_MESSAGE_ALLOCATE_BUFFER | 
                      FORMAT_MESSAGE_FROM_SYSTEM | FORMAT_MESSAGE_IGNORE_INSERTS,
                        NULL, hRes, MAKELANGID(LANG_NEUTRAL, SUBLANG_DEFAULT),
                          (LPTSTR) &lpMsgBuf, 0, NULL);
  
      printf("An error occured (%x) : %s ", hRes, lpMsgBuf);
      LocalFree( lpMsgBuf );
    }
  }
  
  if(FAILED(hRes))
  {
    printf("Syntax: StgDoc.exe [command] <storage> [file] [path in storage]\n");
    printf(" - where command is:\n");
    printf("\t-a - add file into storage\n");
    printf("\t-d - remove file from storage\n");
    printf("\t-e - extract file (without a path)\n");
    printf("\t-l - view contents of storage\n");
  }

  return (SUCCEEDED(hRes) ? 0 : -1);
}
