  !include "totalcmd.nsh"
;********************************** CUSTOMIZE THIS PART ***********************
  !define PLUGIN_NAME "HTTP Browser"          ;the name of your plugin
  !define PLUGIN_MAIN_FILE "httpbrowser.wfx"  ;The file name of your main dll
  !define PLUGIN_TYPE "WFX"                   ;WFX or WLX
  !define PLUGIN_DETECT_STRING ""             ;only for WLX plugins
;********************************** CUSTOMIZE END *****************************
  
  Name "${PLUGIN_NAME}"
  OutFile "${PLUGIN_NAME}_setup.exe"
  BrandingText "NSIS - Total Commander plugin"
  ShowInstDetails show
  SetCompressor lzma
  InstallColors /windows
  XPStyle On
  InstProgressFlags Smooth
  Icon "tcplugin.ico"
  Page directory
  Page instfiles
;_____________________________________________________________________________________________
Section "Main" SecProgram
;********************************** CUSTOMIZE THIS PART ***********************
  SetOutPath "$INSTDIR"
  ;specify all the files you want to install with your plugin
  File "${PLUGIN_MAIN_FILE}"
;********************************** CUSTOMIZE END *****************************
  !insertmacro RegisterPlugin ${PLUGIN_TYPE} "${PLUGIN_NAME}" "${PLUGIN_MAIN_FILE}" "${PLUGIN_DETECT_STRING}"
SectionEnd
;_____________________________________________________________________________________________
Function .onInit
  Push "InstallDir"
  Call GetKey
  Pop $0
  StrCmp "$0" "" NotFound
  ;Default install Dir for a first installation of the plugin:
  StrCpy $INSTDIR "$0\addons\${PLUGIN_TYPE}\${PLUGIN_NAME}\"
  ;Retrieve install dir if the plugin has already been installed:
  !insertmacro InstallPath "${PLUGIN_TYPE}" "${PLUGIN_NAME}" "${PLUGIN_MAIN_FILE}" "$INSTDIR"
  Pop $INSTDIR
  Goto EndOnInit
  NotFound:
    ;Default install dir if TC registry keys cannot be found:
    StrCpy $INSTDIR "$PROGRAMFILES\${PLUGIN_NAME}\"
  EndOnInit:
FunctionEnd


