Function GetKey
  Pop $0
  ClearErrors
  ReadRegStr $0 HKCU "Software\Ghisler\Total Commander" "$0"
  ifErrors 0 KeyFound
  ReadRegStr $0 HKLM "Software\Ghisler\Total Commander" "$0"
  ifErrors 0 KeyFound
  ReadRegStr $0 HKCU "Software\Ghisler\Windows Commander" "$0"
  ifErrors 0 KeyFound
  ReadRegStr $0 HKLM "Software\Ghisler\Windows Commander" "$0"
  ifErrors KeyNotFound KeyFound
  KeyFound:
    Push $0
    Goto EndGetKey
  KeyNotFound:
    Push ""
  EndGetKey:
FunctionEnd
;____________________________________________________________________________________________________
Function GetIniPath
  Push "InstallDir"
  Call GetKey
  Pop "$1"                         ;$1 = Path de Total Commander
  StrCmp "$1" "" IniPathNotFound
  Push "IniFileName"
  Call GetKey
  Pop "$0"                         ;$0 = Chemin relatif du fichier ini
  StrCmp "$0" "" IniPathNotFound
  StrCpy $2 "$0" 1                 ;$2 = Premier caractre de ce chemin
  StrCmp "$2" "." TCFolder
  StrCmp "$2" "%" UserFolder
  Push "\"
  Push "$0"
  Call Pos
  Pop $2   ;$2 contient la position du 1er caractre '\'
  IntCmp $2 -1 WinFolder
  Goto CustomFolder
  TCFolder:
    StrCpy "$0" "$0" "" 1 ;J'enlve le '.' en dbut de chane
    StrCpy "$0" "$1$0"
    Push "$0"
    Goto EndIniPath
  UserFolder:
    Push "$APPDATA"
    Call ExtractFilePath
    Pop $1                 ;$1 = chemin de "doc&settings\defaultuser\"
    StrCpy $0 "$0" "" 14   ;j'enlve la partie %USERPROFILES% du chemin
    Push "$1$0"
    Goto EndIniPath
  WinFolder:
    Push "$WINDIR\$0"
    Goto EndIniPath
  CustomFolder:
    Push "$0"
    Goto EndIniPath
  IniPathNotFound:
    Push ""
  EndIniPath:
FunctionEnd
;____________________________________________________________________________________________________
!macro RegisterPlugin PLUGIN_TYPE PLUGIN_NAME PLUGIN_FILENAME PLUGIN_DETECT
  Call GetIniPath
  Pop $9 ;$9 = IniPath
  StrCmp "$9" "" EndRegister
  StrCmp "${PLUGIN_TYPE}" "WFX" wfx
  StrCmp "${PLUGIN_TYPE}" "WLX" wlx
  Goto EndRegister
  wfx:
    WriteIniStr "$9" "FileSystemPlugins" "${PLUGIN_NAME}" "$INSTDIR\${PLUGIN_FILENAME}"
    FlushINI "$9"
    Goto EndRegister
  wlx:
    Push "${PLUGIN_FILENAME}"
    Push "$9"
    Call FindWLXPath
    Pop $1 ;path
    Pop $1 ;number
    WriteIniStr "$9" "ListerPlugins" "$1" "$INSTDIR\${PLUGIN_FILENAME}"
    StrCmp "${PLUGIN_DETECT}" "" NoDetect
    WriteIniStr "$9" "ListerPlugins" "$1_detect" "${PLUGIN_DETECT}"
    NoDetect:
    FlushINI "$9"
  EndRegister:
!macroend
;____________________________________________________________________________________________________
!macro InstallPath PLUGIN_TYPE PLUGIN_NAME PLUGIN_MAIN_FILE DEFAULT_PATH
  Call GetIniPath
  Pop "$0" ;Ini FilePath
  Push $0
  StrCmp $0 "" PathNotFound
  StrCmp "${PLUGIN_TYPE}" "WFX" wfx
  StrCmp "${PLUGIN_TYPE}" "WLX" wlx
  wfx:
    Push "${PLUGIN_NAME}"
    Push "$0"
    Call FindWFXPath
    Goto PluginPathFound
  wlx:
    Push "${PLUGIN_MAIN_FILE}"
    Push "$0"
    Call FindWLXPath
  PluginPathFound:
    Pop "$0" ;Plugin main file Path
    StrCmp "$0" "" PathNotFound
    ;On extrait le path du chemin complet
    Push "$0" ; chane principale
    Call ExtractFilePath
    Goto EndInstallPath
  PathNotFound:
    Push ${DEFAULT_PATH}
  EndInstallPath:
!macroend
;______________________________________
Function FindWLXPath
  Pop $0 ;path ini               ;$0 = Chemin du fichier ini
  Pop $1 ;wlx filename           ;$1 = nom du fichier wlx
  StrLen $4 $1                   ;$4 = longueur du nom de fichier
  IntOp $4 $4 + 1                ;On ajoute 1  cette valeur pour compter le dernier '\'
  StrCpy $2 0                    ;$2 = compteur
  ClearErrors
  Loop:
  ReadIniStr $3 "$0" "ListerPlugins" "$2" ;$3 = valeur de la cl dont le nom est $2 (le compteur)
  ifErrors WLXPathNotFound
  StrCpy $5 $3 $4 "-$4" ;on extrait le fin de la cl afin de la comparer au nom du fichier
  StrCmp $5 "\$1" WLXPathFound
  IntOp $2 $2 + 1
  Goto Loop
  WLXPathFound:
    Push $3 ;path complet du fichier wlx
    Call ExtractFilePath
    Pop $0
    Push $2 ;compteur
    Push $0 ;chemin
    Goto EndFindWLX
  WLXPathNotFound:
    Push $2 ;compteur
    Push "" ;chemin
  EndFindWLX:
FunctionEnd
;______________________________________
Function FindWFXPath
  Pop $0 ;path
  Pop $1 ;entry name
  ClearErrors
  ReadIniStr "$2" "$0" "FileSystemPlugins" "$1"
  ifErrors PluginNotFound
  Push $2
  Goto FindWFXEnd
  PluginNotFound:
  Push ""
  FindWFXEnd:
FunctionEnd
;____________________________________________________________________________________________________
Function Pos
  Pop $R0 ;R0 = chaine principale
  Pop $R1 ;R1 = carac recherch
  StrCpy $R2 0            ;R2 = compteur
  StrLen $R3 $R0          ;R3 = Longueur de la chaine principale
  Loop:
    StrCpy $R4 $R0 1 $R2  ;R4 = r2 ime caractre de R0
    StrCmp $R4 $R1 Found
    IntOp $R2 $R2 + 1
    IntCmp $R2 $R3 NotFound Loop NotFound
  Found:
    Push $R2
    Goto EndPos
  NotFound:
    Push -1
  EndPos:
FunctionEnd
;____________________________________________________________________________________________________
Function ExtractFilePath
  Push "\" ;caractre  rechercher
  Push "<" ; sens de la recherche
  Push "<" ;sens de l'extraction
  Push 1 ; on renvoie la chane ?
  Push 0 ; nb d'occurences  rechercher
  Call AdvancedStrStr
FunctionEnd
;____________________________________________________________________________________________________
Function AdvancedStrStr

   # Preparing Variables

   Exch $R9
   Exch
   Exch $R8
   Exch
   Exch 2
   Exch $R7
   Exch 2
   Exch 3
   Exch $R6
   Exch 3
   Exch 4
   Exch $R5
   Exch 4
   Exch 5
   Exch $R4
   Exch 5
   Push $R3
   Push $R2
   Push $R1
   Push $R0
   Push $9
   Push $8
   Push $7
   Push $6
   StrCpy $R2 $R4
   StrCpy $R1 $R5
   StrCpy $R4 ""
   StrCpy $R5 ""
   StrCpy $7 $R2

   # Detect Empty Input

   StrCmp $R1 "" 0 +3
     SetErrors
     Goto granddone

   StrCmp $R2 "" 0 +3
     SetErrors
     Goto granddone

   StrCmp $R6 "" 0 +2
     StrCpy $R6 >

   StrCmp $R7 "" 0 +2
     StrCpy $R7 >

   # Preparing StrStr

   StrCpy $R0 0

   IntCmp $R9 1 +2 0 +2
     StrCpy $R9 0

   IntOp $R9 $R9 + 1

   # Loops and more loops if you want...

     grandloop:

     # Detect if the loops number given by user = code runs...

     StrCpy $R4 0
     StrLen $R3 $R1
     StrCpy $6 $R3
     StrCmp $9 1 0 +4
       StrCmp $R6 "<" 0 +2
         IntOp $R3 $R3 + 1
         IntOp $R4 $R4 + 1

     StrCmp $R6 "<" 0 +5
       IntOp $R3 $R3 * -1
       StrCpy $6 $R3
       IntCmp $R0 0 +2 0 0
         IntOp $6 $6 + 1

     # Searching the string

       loop:

       # RTL...

       StrCmp $R6 "<" 0 EndBack

         IntOp $9 $R4 * -1

         StrCmp $9 0 0 +3
           StrCpy $R5 $R2 "" $R3
           Goto +2
         StrCpy $R5 $R2 $9 $R3
         Goto +2

       EndBack:

       # LTR...

       StrCpy $R5 $R2 $R3 $R4

       # Detect if the value returned is the searched...

       StrCmp $R5 $R1 done

       StrCmp $R5 "" granddone

           # If not, make a loop...

           IntOp $R4 $R4 + 1
           StrCmp $R6 "<" 0 +2
             IntOp $R3 $R3 - 1

       Goto loop

     done:

     StrCmp $R6 "<" 0 +3
       IntOp $8 $9 + $8
         Goto +2
     IntOp $8 $R4 + $8

     # Looping Calculation...

      IntOp $R0 $R0 + 1

     IntCmp $R0 $R9 0 continueloop 0

     # Customizing the string to fit user conditions (supported by loops)...

     # RTL...

       StrCmp $R6 "<" 0 EndBackward
         StrCmp $R7 ">" 0 +7
           StrCmp $8 0 0 +3
             StrCpy $R2 ""
             Goto +2
           StrCpy $R2 $7 "" $8
           StrCpy $R2 $R1$R2
           Goto +3

         StrCmp $9 0 +2
           StrCpy $R2 $R2 $9

         StrCmp $R8 1 EndForward 0
           StrCmp $R7 ">" 0 End>
             Push $6
             IntOp $6 $6 * -1
             StrCpy $R2 $R2 "" $6
             Pop $6
               Goto +2
           End>:
           StrCpy $R2 $R2 $6
             Goto EndForward
       EndBackward:

       # LTR...

       StrCmp $R7 "<" 0 +4
         StrCpy $R2 $7 $8
         StrCpy $R2 $R2$R1
         Goto +2
       StrCpy $R2 $R2 "" $R4
       StrCmp $R8 1 EndForward 0
         StrCmp $R7 "<" 0 End<
           Push $6
           IntOp $6 $6 * 2
           StrCpy $R2 $R2 $6
           Pop $6
             Goto +2
         End<:
         StrCpy $R2 $R2 "" $R3
       EndForward:

       Goto stoploop

     continueloop:

     # Customizing the string to fits user conditions (not supported by loops)...

     # RTL...

     StrCmp $R6 "<" 0 +4
       StrCmp $9 0 +4
       StrCpy $R2 $R2 $9
         Goto +2

     # LTR...

     StrCpy $R2 $R2 "" $R4

     stoploop:

     # Return to grandloop init...

     StrCpy $9 1

     IntCmp $R0 $R9 0 grandloop 0

   StrCpy $R4 $R2

   Goto +2

   granddone:

   # Return the result to user

   StrCpy $R4 ""

   Pop $6
   Pop $7
   Pop $8
   Pop $9
   Pop $R0
   Pop $R1
   Pop $R2
   Pop $R3
   Pop $R9
   Pop $R8
   Pop $R7
   Pop $R6
   Pop $R5
   Exch $R4

  FunctionEnd
