// wcx_ztxt.cpp : Defines the entry point for the DLL application.
//

#include "stdafx.h"

typedef struct t_PdbDataArchive {
	char name[dmDBNameLength + 1];
	FILE *openedFile;
	ztxt *ztxtdb;
	int  cHeaderHelper;
} PdbDataArchive;

BOOL APIENTRY DllMain( HMODULE hModule,
                       DWORD  ul_reason_for_call,
                       LPVOID lpReserved
					 )
{
    return TRUE;
}

static void FreePdbArchive(PdbDataArchive *arch)
{
	if (arch->openedFile != 0)
	{
		fclose(arch->openedFile);
		arch->openedFile = 0;
	}
	if (arch->ztxtdb != 0)
	{
		ztxt_free(arch->ztxtdb);
		arch->ztxtdb = 0;
	}
	arch->cHeaderHelper = 0;
}


// OpenArchive should perform all necessary operations 
// when an archive is to be opened
__declspec(dllexport) HANDLE __stdcall 
OpenArchive (tOpenArchiveData *ArchiveData)
{
	PdbDataArchive *arch = 0;

	//MessageBoxA(0, "OpenArchive", "", MB_OK);

	if (ArchiveData->OpenMode == PK_OM_LIST)
	{
		// read header 
		FILE *f = fopen(ArchiveData->ArcName, "rb" );
		if (f != 0)
		{
			DatabaseHdrType dh;
			fread(&dh, sizeof(DatabaseHdrType), 1, f);
			if (dh.type == htonl(palmid_to_int(ZTXT_TYPE_ID)))
			{
				arch = (PdbDataArchive*)malloc(sizeof(PdbDataArchive));
				memset(arch, 0, sizeof(PdbDataArchive));
				strcpy(arch->name, dh.name);
			}
			if (arch == 0)
				ArchiveData->OpenResult = E_EOPEN;

			fclose(f);
		}
	}
	else if (ArchiveData->OpenMode = PK_OM_EXTRACT)
	{
		arch = (PdbDataArchive*)malloc(sizeof(PdbDataArchive));
		memset(arch, 0, sizeof(PdbDataArchive));

		arch->openedFile = fopen(ArchiveData->ArcName, "rb" );
		arch->ztxtdb		 = ztxt_init();
		if (arch->openedFile != 0 && arch->ztxtdb != 0)
		{
			size_t size;
			struct stat instats;
			u_int filesize;
			char *inputbuf = 0;

			size = stat(ArchiveData->ArcName, &instats);
			if (size != -1)
			{
				if (instats.st_size > 0)
				{
					inputbuf = (char *)malloc(instats.st_size + 1);

					filesize = fread(inputbuf, instats.st_size, 1, arch->openedFile);
					ztxt_set_output(arch->ztxtdb, inputbuf, instats.st_size);
					ztxt_disect(arch->ztxtdb);

					strcpy(arch->name, arch->ztxtdb->dbHeader->name);
				}
			}
		}
		else 
		{
			FreePdbArchive(arch);
			free(arch);
			arch = 0;
			ArchiveData->OpenResult = E_EOPEN;
		}
	}

	return arch;
}

// WinCmd calls ReadHeader to find out what files are in the archive
__declspec(dllexport) int __stdcall 
ReadHeader (HANDLE hArcData, tHeaderData *HeaderData)
{
	PdbDataArchive *arch = (PdbDataArchive *)hArcData;

	//MessageBoxA(0, "ReadHeader", "CLOSE", MB_OK);

	if (arch->cHeaderHelper++ == 1)
		return E_END_ARCHIVE;

	strcpy(HeaderData->FileName, arch->name);
	//strcat(HeaderData->FileName, ".txt\0");
	HeaderData->PackSize = 0;
	HeaderData->UnpSize  = 0;
	HeaderData->FileTime = 0;
	return 0;
}

__declspec(dllexport) int __stdcall 
ProcessFile (HANDLE hArcData, int Operation, char *DestPath, char *DestName)
{
	PdbDataArchive *arch = (PdbDataArchive *)hArcData;
	FILE *f = 0;

	//MessageBoxA(0, "ProcessFile", "CLOSE", MB_OK);
	if (Operation == PK_EXTRACT)
	{
		if (DestName != 0)
		{
			f = fopen(DestName, "wb");
			if (f != 0)
			{
				fwrite(ztxt_get_input(arch->ztxtdb), ztxt_get_inputsize(arch->ztxtdb), 1, f);
				fclose(f);
			}
		}
	}
	return 0;
}

__declspec(dllexport) int __stdcall 
CloseArchive (HANDLE hArcData)
{
	PdbDataArchive *arch = (PdbDataArchive *)hArcData;
	//MessageBoxA(0, "CloseArchive", "CLOSE", MB_OK);
	FreePdbArchive(arch);
	free(arch);
	arch = 0;
}


__declspec(dllexport) int __stdcall 
PackFiles (char *PackedFile, char *SubPath, char *SrcPath, char *AddList, int Flags)
{
	ztxt *db			= 0;
	FILE *inFile  = 0;
	FILE *outFile = 0;
	char *txtFileName = 0;
	size_t lenSrcPath  = strlen(SrcPath);
	size_t lenFileName = strlen(AddList);
	char *inputbuf = 0;
	char *outbuffer = 0;

	txtFileName = (char *)malloc(lenSrcPath + lenFileName + 1);
	strcpy(txtFileName, SrcPath);
	strcat(txtFileName, AddList);
	

	db = ztxt_init();
	inFile = fopen(txtFileName, "rb");
	if (db != 0 && inFile != 0)
	{
		size_t size;
		struct stat instats;
		u_int filesize;

		size = stat(txtFileName, &instats);
		if (size != -1)
		{
			if (instats.st_size > 0)
			{
				long int total = 0;
				long int count = 0;

				inputbuf = (char *)malloc(instats.st_size + 1);
				memset(inputbuf, 0, instats.st_size + 1);

				while(!feof(inFile))
				{
					count = fread(&inputbuf[total], sizeof(char), 100, inFile);
					total += count;
				}

				ztxt_set_data(db, inputbuf, instats.st_size);
				ztxt_set_title(db, AddList);
				ztxt_process(db, 0, 0);
				ztxt_generate_db(db);

				//outbuffer = (char *)malloc(ztxt_get_outputsize(db));
				outbuffer = ztxt_get_output(db);

				outFile = fopen(PackedFile, "wb");
				if (outFile != 0)
					fwrite(outbuffer, ztxt_get_outputsize(db), 1, outFile);
			}
		}
	}

	if (inputbuf != 0)
		free(inputbuf);

	//if (outbuffer != 0)
	//	free(outbuffer);

	if (inFile != 0)
		fclose(inFile);

	if (outFile != 0)
		fclose(outFile);

	if (db != 0)
		ztxt_free(db);

	free(txtFileName);
	
	return 0;
}

__declspec(dllexport) int __stdcall 
GetPackerCaps()
{
	return PK_CAPS_NEW | PK_CAPS_MODIFY | PK_CAPS_BY_CONTENT;
}


__declspec(dllexport) BOOL __stdcall 
CanYouHandleThisFile (char *FileName)
{
	BOOL isValid = FALSE;

	FILE *f = fopen(FileName, "rb" );
	if (f != 0)
	{
		DatabaseHdrType dh;
		if (fread(&dh, sizeof(DatabaseHdrType), 1, f) > 0)
			if (dh.type == htonl(palmid_to_int(ZTXT_TYPE_ID)))
				isValid = TRUE;
		fclose(f);
	}
	return isValid;
}


__declspec(dllexport) void __stdcall 
SetChangeVolProc (HANDLE hArcData, tChangeVolProc pChangeVolProc1)
{
}

__declspec(dllexport) void __stdcall 
SetProcessDataProc (HANDLE hArcData, tProcessDataProc pProcessDataProc)
{
}