use strict;
use vars qw ($ppmrepa $ppmrepc $ppmrepf $ppmrepi $ppmrepl $ppmrepn $ppmrepo $ppmrepr);
use vars qw ($AUTOLOAD);
use TotalCmd::FSPlugin 0.03;
use PPM;
use Win32::GUI;
use Win32::GUI::BitmapInline 0.02;
use Time::Local;
our %Paths;
our %Reps = PPM::ListOfRepositories();
our %InstPackages = PPM::InstalledPackageProperties();
our %RepsPackages;

our $PluginNr;
our $PluginName = "Perl Package Manager";
our $PluginVersion = 0.01;
our %months = (
			Jan => 0,
			Feb => 1,
			Mar => 2,
			Apr => 3,
			May => 4,
			Jun => 5,
			Jul => 6,
			Aug => 7,
			Sep => 8,
			Oct => 9,
			Nov => 10,
			Dec => 11,
);


AUTOLOAD {
#	showError($AUTOLOAD . "not implemented");
}



sub FsInit($) {
	$PluginNr = shift;
	
}

sub FsFindFirst($$){
	my($Path, $FindData) = (shift, shift);
	my $elem;
	my $foo;
	if($Path eq "\\"){
		$elem = [ "Installed Packages", "Repositories", "Search Packages" ];
	}
	elsif($Path =~ /^\\Repositories\\?$/){
		$elem = [ (keys %Reps)];
	}
	elsif($Path eq "\\Search Results"){
		$elem = [];
	}
	elsif($Path eq "\\Installed Packages"){
		$elem = [ (keys %InstPackages) ]; 
	}
	elsif($Path =~ /Repositories/){
		my ($rep) = ($Path =~ m#\\.+\\(.+)#);
		unless($RepsPackages{$Reps{$rep}}){
			my %rep_packages = PPM::RepositoryPackages("location" => $Reps{$rep});
			$RepsPackages{$Reps{$rep}} = $rep_packages{$Reps{$rep}};
		}
		$elem = [@{$RepsPackages{$Reps{$rep}}}] ;
		$RepsPackages{$Reps{$rep}} = undef if !$elem->[0];
	}
	if($Path =~ /^\\Repositories\\.+$/ && !$elem->[0]){
		$elem = [ "." ];
	}
	$Paths{$Path} = $elem;
	return INVALID_HANDLE_VALUE if !FsFindNext($Path, $FindData);
	return $Path;
}

sub FsFindNext($$){
	my($Path, $FindData) = (shift, shift);
	my $elem = shift @{$Paths{$Path}};
	return 0 if !$elem;
	$FindData->{cFileName} = $elem;
	if($Path eq "\\" && $elem ne "Search Packages"){
		$FindData->{dwFileAttributes} = 16;
	}
	elsif($Path eq "\\Repositories"){
		$FindData->{dwFileAttributes} = 16;
	}
	elsif($Path eq "\\Installed Packages"){
		$InstPackages{$elem}{DATE} =~ /([^ ]+)\s+([^ ]+)\s+(\d+)\s+(\d{2}):(\d{2}):(\d{2})\s+(\d{4})/;
		$FindData->{tLastWriteTime} = timelocal($6,$5,$4,$3,$months{$2},$7);
	}
	else{
	}
	return 1;
}

sub FsFindClose($){
	my $Path = shift;
	$Paths{$Path} = undef;
	return 0;
}

sub FsMkDir($){
	return 0 if $_[0] !~ /^.+Repositories\\[^\\]+$/;
	my ($NewRep) = shift =~ /^.+\\(.+)$/;
	return 0 if $Reps{$NewRep};
	my $RepURL = "http://";
	if (RequestProc($PluginNr, RT_URL, "New PPM repository", undef, $RepURL, 256)){
		PPM::AddRepository(repository => $NewRep, location => $RepURL, save => 1);
		%Reps = PPM::ListOfRepositories();
		return 1;
	}
	return 0;
}

sub FsRemoveDir($){
	return 0 if $_[0] !~ /^.+Repositories\\[^\\]+$/;
	my ($Rep) = shift =~ /^.+\\(.+)$/;
	PPM::RemoveRepository(repository => $Rep, save => 1);
	%Reps = PPM::ListOfRepositories();
	return 1;
}

sub FsRenMovFile($$$$$){
	my ($OldName, $NewName, $Move) = (shift, shift, shift);
	if ( $OldName =~ /^.+Repositories\\[^\\]+$/ && $NewName =~ /^.+Repositories\\[^\\]+$/){
		return FS_FILE_NOTSUPPORTED	if !$Move;
		my ($OldRep) = $OldName =~ /^.+\\(.+)$/;
		my ($NewRep) = $NewName =~ /^.+\\(.+)$/;
		return FS_FILE_WRITEERROR if $Reps{$NewRep};
		PPM::AddRepository(repository => $NewRep, location => $Reps{$OldRep}, save => 1);
		FsRemoveDir($OldName);
		%Reps = PPM::ListOfRepositories();
		return FS_FILE_OK;
	}
	elsif($OldName =~ /^.+Repositories\\.+\\.+$/ && $NewName =~ /^.+Installed Packages\\[^\\]+$/){
		my ($RepName, $PackName) = $OldName =~ /^.+Repositories\\([^\\]+)\\(.+)$/;
		if(!$InstPackages{$PackName}){
			if(PPM::InstallPackage(location => $Reps{$RepName}, "package" => $PackName) == 1){
				%InstPackages = PPM::InstalledPackageProperties();
				return FS_FILE_OK;
			}
			else{
				showError("Package install error:\n" . $PPM::PPMERR);
			}
		}
		else{
			showError("Package $PackName already installed");
		}
		
	}
	return FS_FILE_NOTSUPPORTED;
}

sub FsPutFile($$$){
	my($LocalName, $RemoteName, $CopyFlags) = (shift, shift, shift);
	open (FILE, "<$LocalName")  or  return FS_FILE_READERROR;
	if(<FILE> =~ /^\[InternetShortcut\].*$/){
		my $RepLoc = substr <FILE>, 4;
		my ($RepName) = ($RemoteName =~ /^.+Repositories\\([^\\]+)$/);
		return FS_FILE_OK if !$RepName;
		if(!($CopyFlags & FS_COPYFLAGS_OVERWRITE)){
			while(my($rname, $rloc) = each %Reps){
				if($rloc eq $RepLoc){
					showError("Repository with location $RepLoc \nalready registered as $rname!");
					close FILE;
					return FS_FILE_WRITEERROR;
				}
			}
		}
		if($RepName && $RepLoc){
			PPM::AddRepository(repository => $RepName, location => $RepLoc, save => 1);
			%Reps = PPM::ListOfRepositories();
			close FILE;	
			return FS_FILE_OK;		
		}
		close FILE;
		return FS_FILE_WRITEERROR;
	}
	elsif($RemoteName =~ /^\\Installed Packages\\.+$/){
			if(PPM::InstallPackage("package" => $LocalName) == 1){
				%InstPackages = PPM::InstalledPackageProperties();
				close FILE;
				return FS_FILE_OK;
			}
			else{
				showError("Package install error:\n" . $PPM::PPMERR);
			}
	}
	close FILE;
	return FS_FILE_OK;
}

sub FsDeleteFile($){
	my $Path = shift;
	my ($Package, $foo);
	if(($Package) = $Path =~ /^\\Installed Packages\\(.+)$/){
		if(RequestProc($PluginNr, RT_MsgOKCancel, "Removing package $Package", "Are you sure?", $foo, 256)){
			my $force = RequestProc($PluginNr, RT_MsgYesNo, "Removing package $Package", "Force uninstall?", $foo, 256);
			if(PPM::RemovePackage("package" => $Package , "force" => $force) != 1){
				showError("Coudn't remove package $Package:\n" . $PPM::PPMERR);
				return 0;
			}
			%InstPackages = PPM::InstalledPackageProperties();
		}
	}
	return 1;
}
sub FsExtractCustomIcon ($$$){
	if($_[0] =~ /^\\Repositories\\$/){
		$_[2] = $ppmrepa->{-handle};
		return FS_ICON_EXTRACTED;
	}
	elsif(($_[0] =~ /^\\Repositories\\[^\\]+\\$/ && $_[0] ne "\\Repositories\\..\\") || $_[0] eq "\\repository.icon"){
		$_[0] = "\\repository.icon";
		$_[2] = $ppmrepf->{-handle};
		return FS_ICON_EXTRACTED;
	}
	elsif($_[0] =~ /^\\Repositories\\.+\\[^\\]+$/ || $_[0] eq "\\repository package.icon"){
		$_[0] = "\\repository package.icon";
		$_[2] = $ppmrepo->{-handle};
		return FS_ICON_EXTRACTED;
	}
	elsif($_[0] =~ /^\\Installed Packages\\$/){
		$_[2] = $ppmrepl->{-handle};
		return FS_ICON_EXTRACTED;
	}
	elsif($_[0] =~ /^\\Installed Packages\\[^\\]+$/ || $_[0] eq "\\installed package.icon"){
		$_[2] = $ppmrepi->{-handle};
		$_[0] = "\\installed package.icon";
		return FS_ICON_EXTRACTED;
	}
	elsif($_[0] eq "\\Search Packages"){
		$_[2] = $ppmrepr->{-handle};
		return FS_ICON_EXTRACTED;
	}
	return FS_ICON_USEDEFAULT;
}

sub FsGetDefRootName($$){
	$_[0] = substr $PluginName, 0, $_[1];
}

sub FsExecuteFile($$$){
    my ($TotalWin, $RemoteName, $Verb) = @_;
	my $Dialog;
    if($Verb eq "open" || $Verb eq "properties"){
		if($RemoteName eq "\\"){
			$Dialog = ppm_properties();
   			$Dialog->SetIcon($ppmrepn);
		}
		elsif($Verb eq "open" && $RemoteName eq "\\Search Packages"){
			$_[1] = "\\Search Results";
			showError("Not realized yet.");
			return FS_EXEC_SYMLINK;
		}
		elsif($RemoteName =~ /^\\Repositories\\$/){
			return 0;
		}
		elsif($RemoteName =~ /^\\Repositories\\([^\\]+)$/){
			$Dialog = repository_properties($RemoteName, $1);
   			$Dialog->SetIcon($ppmrepf);
		}
		elsif($RemoteName =~ /^\\Repositories\\.+\\([^\\]+)$/){
    		$Dialog = package_properties($RemoteName, $1);
   			$Dialog->SetIcon($ppmrepo);
		}
		elsif($RemoteName =~ /^\\Installed Packages\\([^\\]+)$/){
    		$Dialog = package_properties($RemoteName, $1, 1);
   			$Dialog->SetIcon($ppmrepi);
		}
		else{
			return 0;
		}
    	GUI::Disable($TotalWin);
     	my $dw = Win32::GUI::Width($TotalWin);
    	my $dh = Win32::GUI::Height($TotalWin);
    	my $x = ($dw - $Dialog->Width()+GUI::Left($TotalWin)) / 2;
    	my $y = ($dh - $Dialog->Height()+GUI::Top($TotalWin)) / 2;
    	$Dialog->Move($x, $y);
   		$Dialog->Show();
    	GUI::Dialog();
    	GUI::Enable($TotalWin);
    	GUI::SetForegroundWindow($TotalWin);
    	$Dialog->DestroyWindow();
    }
}





sub package_properties{
	my($RemoteName, $Package, $installed) = (shift, shift, shift);
	my %PackProps;
	my $OperateText;
	my $OperateAction;
	if($installed){
		%PackProps = %{$InstPackages{$Package}};
		$OperateText = "Remove";
		$OperateAction = sub {
			FsDeleteFile($RemoteName);
			return -1;
		};
	}
	else{
		my ($rep) = $RemoteName =~ /^\\Repositories\\([^\\]+)\\[^\\]+$/;
		%PackProps = PPM::RepositoryPackageProperties("package" => $Package, "location" => $Reps{$rep});
		$OperateText = "Install ";
		$OperateAction = sub {
			FsRenMovFile($RemoteName, "\\Installed Packages\\$Package", undef, undef, undef);
			return -1;
		};
	}
	my $PW = new Win32::GUI::DialogBox(
		-name   => "PW",
		-text   => "Package Properties",
		-left   => 110,
		-top    => 110,
		-width  => 300,
		-height => 400,
		-onTerminate => sub{return -1;}
	);

	$PW->AddTextfield(
		-name     => "PPMName",
		-readonly => 1,
		-left     => 10,
		-top      => 10,
		-width    => 200,
		-height   => 22,
		-text     => $PackProps{NAME},
		-prompt   => [ "PPM Name:", 75 ],
	);
	$PW->AddTextfield(
		-name     => "PPMVersion",
		-readonly => 1,
		-left     => 10,
		-top      => 40,
		-width    => 200,
		-height   => 22,
		-text     => $PackProps{VERSION},
		-prompt   => [ "PPM Version:", 75 ],
	);
	$PW->AddTextfield(
		-name     => "PPMAuthor",
		-readonly => 1,
		-left     => 10,
		-top      => 70,
		-width    => 200,
		-height   => 22,
		-text     => $PackProps{AUTHOR},
		-prompt   => [ "Author:", 75 ],
	);
	$PW->AddTextfield(
		-name     => "PPMDate",
		-readonly => 1,
		-left     => 10,
		-top      => 100,
		-width    => 200,
		-height   => 22,
		-text     => $PackProps{DATE},
		-prompt   => [ "Installed:", 75 ],
	);
	$PW->AddTextfield(
		-name      => "PPMAbstract",
	    -readonly  => 1,
		-multiline => 1,
		-left      => 10,
		-top       => 130,
		-width     => 200,
		-height    => 80,
		-text      => $PackProps{ABSTRACT},
		-prompt    => [ "Abstract:", 75 ],
	);
	$PW->AddButton(
		-name     => "Close",
		-left     => 235,
		-top      => 345,
		-text     => "&Close",
		-default  => 1,
		-cancel   => 1,
		-tabstop  => 1,
		-onClick  => sub{return -1;}
	);
	$PW->AddButton(
		-name     => "Operate",
		-left     => 185,
		-top      => 345,
		-text     => $OperateText,
		-ok       => 1,
		-cancel   => 1,
		-tabstop  => 1,
		-onClick  => $OperateAction
		
	);
	return $PW;
}

sub repository_properties{
	my ($RemoteName, $rep_name) = (shift, shift);
	my $RW = new Win32::GUI::DialogBox(
		-name   => "RW",
		-text   => "Repository Properties",
		-left   => 110,
		-top    => 110,
		-width  => 300,
		-height => 130,
	);
	my $new_rep_name = $RW->AddTextfield(
		-name      => "Name",
		-left      => 10,
		-top       => 10,
		-width     => 200,
		-height    => 22,
		-text      => $rep_name,
		-prompt    => [ "Name:", 75 ],
		-tabstop   => 1,
	);
	my $new_rep_loc = $RW->AddTextfield(
		-name      => "Location",
		-left      => 10,
		-top       => 40,
		-width     => 200,
		-height    => 22,
		-text      => $Reps{$rep_name},
		-prompt    => [ "Location:", 75 ],
		-tabstop   => 1,
	);
	$RW->AddButton(
		-name     => "RepOK",
		-left     => 150,
		-top      => 75,
		-width    => 60,
		-text     => "&OK",
		-ok       => 1,
		-default  => 1,
		-tabstop  => 1,
		-onClick  => sub {
			if($new_rep_name->Text() && $new_rep_loc->Text()){
				FsRemoveDir($RemoteName);
				PPM::AddRepository(repository => $new_rep_name->Text(), location => $new_rep_loc->Text(), save => 1);
				%Reps = PPM::ListOfRepositories();
			}
			else{
				showError("Coudn't change repository properties");
			}
			return -1;
		}
	);
	$RW->AddButton(
		-name     => "RepClose",
		-left     => 220,
		-top      => 75,
		-width    => 60,
		-text     => "&Cancel",
		-cancel   => 1,
		-tabstop  => 1,
		-onClick  =>sub{return -1;}
	);
	$RW->AddLabel(
		-name    => "Editing",
		-visible => 0,
	);
	return $RW;
}

sub ppm_properties{
	my %ppm_properties = PPM::GetPPMOptions();
	my $CW = new Win32::GUI::DialogBox(
		-name   => "CW",
		-text   => "PPM Configuration",
		-left   => 110,
		-top    => 110,
		-width  => 300,
		-height => 220,
	);
	my $ppm_root = $CW->AddTextfield(
		-name      => "Root",
		-left      => 10,
		-top       => 10,
		-width     => 200,
		-height    => 22,
		-text      => $ppm_properties{ROOT},
		-prompt    => [ "Install root:", 75 ],
		-tabstop   => 1,
	);
	my $ppm_build = $CW->AddTextfield(
		-name      => "Build",
		-left      => 10,
		-top       => 40,
		-width     => 200,
		-height    => 22,
		-text      => $ppm_properties{'BUILDDIR'},
		-prompt    => [ "Build dir:", 75 ],
		-tabstop   => 1,
	);
	my $ppm_ignorecase = $CW->AddCheckbox(
		-name      => "Case",
		-left      => 10,
		-top       => 70,
		-width     => 200,
		-height    => 22,
		-text      => "Case sensitive search",
		-tabstop   => 1,
		-checked   => !$ppm_properties{'IGNORECASE'}
	);
	my $ppm_clean = $CW->AddCheckbox(
		-name      => "Clean",
		-left      => 10,
		-top       => 100,
		-width     => 200,
		-height    => 22,
		-text      => "Clean temporary after build",
		-tabstop   => 1,
		-checked   => $ppm_properties{'CLEAN'}
	);
	$CW->AddButton(
		-name     => "ConfOK",
		-left     => 150,
		-top      => $CW->Height-55,
		-width    => 60,
		-text     => "&OK",
		-ok       => 1,
		-default  => 1,
		-tabstop  => 1,
		-onClick  => sub {
			$ppm_properties{'ROOT'} = $ppm_root->Text();
			$ppm_properties{'IGNORECASE'} = !($ppm_ignorecase->Checked());
			$ppm_properties{'BUILDDIR'}   = $ppm_build->Text();
			$ppm_properties{'CLEAN'}      = $ppm_clean->Checked();
			$PPM::PPMERR = "";
			PPM::SetPPMOptions(options => \%ppm_properties, save => 1);
			if($PPM::PPMERR){
				 showError("Coudn't save PPM options ". $PPM::PPMERR);  
			}
			else{
				return -1;
			}
		}
	);
	$CW->AddButton(
		-name     => "ConfClose",
		-left     => 220,
		-top      => $CW->Height-55,
		-width    => 60,
		-text     => "&Cancel",
		-cancel   => 1,
		-tabstop  => 1,
		-onClick  => sub {return -1;}
	);
	return $CW;
}






$ppmrepa = newIcon Win32::GUI::BitmapInline( q(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) );
$ppmrepc = newIcon Win32::GUI::BitmapInline( q(
AAABAAEAICAAAAEAGACoDAAAFgAAACgAAAAgAAAAQAAAAAEAGAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAADL4eLL4eLL4eLL
4eLL4eLL4eLL4eLL4eLL4eLL4eKryuF7p+Bol9tok9NoitBoe9BodMlodLp7iLurvtLL4eLL4eLL
4eLL4eLL4eLL4eLL4eLL4eLL4eLL4eLL4eIAAADL4eLL4eLL4eLL4eLL4eLL4eLL4eLL4eLL4eLL
4eKMs+Asbd4GTtUGRsUGM78GFr8GB7AGB5MsMJSMm8PL4eLL4eLL4eLL4eLL4eLL4eLL4eLL4eLL
4eLL4eLL4eIAAADL4eLL4eLL4eLL4eLL4eLL4eLL4eLL4eKqyeF9qeBWieQxaekZTN8HLsgAGb4A
CL4AAK8AAJEVF4lLU6N9i7yqvNLL4eLL4eLL4eLL4eLL4eLL4eLL4eLL4eLL4eIAAADL4eLL4eLL
4eLL4eLL4eLL4eLL4eLL4eKHsOErbd4gXug9afY0TuoPG8sAAr4AAb4AAK8AAJECAoAICYMrMJSH
lsHL4eLL4eLL4eLL4eLL4eLL4eLL4eLL4eLL4eIAAADL4eLL4eLL4eLL4eLL4eLL4eKqyeGAq+BM
gtoSVtMORdYkQt8gLdgJDsYAAL4AAL4AAK8AAJEAAH0AAHoSFIFMVJ2AjripvM/L4eLL4eLL4eLL
4eLL4eLL4eLL4eIAAADL4eLL4eLL4eLL4eLL4eLL4eKEreErbd8MUdMDQ8YCLsIGFcMFB8IBAr8A
AL4AAL4AAK8AAJEAAHwAAHUDA3IMDnYrL4eDkrrL4eLL4eLL4eLL4eLL4eLL4eLL4eIAAADL4eLL
4eLL4eLL4eKqvOGDkuBMZt8PO94ALNIAJ8QAGb4AB74AAL4AAL4ABr4AEb4AFrAAFJUADoEABXUA
AG8AAG8PEXhMVJqDkrmqvM/L4eLL4eLL4eLL4eLL4eIAAADL4eLL4eLL4eLL4eKAj+AqL94QFd4D
DN4ACdIACMQABb4AAb4AAL4AAL4ADb4AKL4AMrIALZsAIYcADXgAAG8AAG8DA3AQEXgqL4eAj7jL
4eLL4eLL4eLL4eLL4eIAAADL4eLL4eKqvOGHluBMVN8MDd4ACNkAE9QADsoAA8EAAL4AAL4DCMQI
Fc8PKdQXQtQbTM0bSL8WOKkIFokAAHMAAHEAAG8AAG8MDXZMVJqHlruqvM/L4eLL4eLL4eIAAADL
4eLL4eJ9i+ArMN4TFd4DA94AFNMALcYAIcEACL4AAL4AAL4HE80UM+ckS/M3XfNBZvFBZe40UdYU
IKAAAHoAAHQAAG8AAG8DA3ATFXkrMId9i7bL4eLL4eLL4eIAAADG2ebC0epqcuQMDd4AAN4AAN4A
ENEAJMIAG74ABr4DCMQIFM4UK94mSvQvVfgzTu46U+1GZPdDYO0qPMMVHZ8JDIMAAG8AAG8AAG4A
BWkIFGpLZZWLs76rytDL4eIAAADAze21uvdiZewLC98AAN4AAN4ABNEACsIAB74AAb4IFM4UM+cl
S/U7X/s3U/EcKtccKdU8Ve5LavlDYO01StIWH5kAAG8AAG8AAWwADWACHlgVRW8sboh7p7XL4eIA
AACwu/CUlf1QUOoJCdcAANQAANQABssAD8ALGsQaJc0kON8qT/UvVfg1Ue8pOuAOE8kMEccnON07
VO9GZPdFYu0qO7wTHJIIDHkAAmMAEVgAIFAAMVsGRWppk6bL4eIAAACZpPBnaP02NuQGBsgAAMUA
AMUAEsIAKb4eRc9HY+dPa/RGafs1UfAcKtcNEsgEBsEDBcEMEcgdKdY6U+1LavhCXuk0S8wXIYoA
AlUAEVIAHk8AJFMGL1tpiJ7L4eIAAACFkOg+P+0fJ9cDEsALGMQZIswZM84VRc4pVdlIZOhKYe0+
Vu0pOuAMEsgAAL4AAL4AAL4AAL4LD8cnN905VOs5WuU1VtQiNqMSHHgIHWYAHlYAHlIGJVRpg5vL
4eIAAAByfdkZGs8LH8cBLL8iRtFKZOlIZu08Y+0vTOIgLtMZIs4VHs4OFMkEBsEAAL4AAL4AAL4A
AL4DBcENE8kUIckUMrcYQbArSsI0TcYYNJMAHmUAHlkGJVRpg5vL4eIAAABxgNcXH8wRLswRRcwt
XNZPdOJLa+k/Wu4mN90JDcYAAL4AAL4AAL4AAL4AAL4AAL4AAL4AAL4AAL4AAL4ABbgAF6UHLKQl
S843XuYdQrcGJ4sDH2sGHlRpf5vL4eIAAACDmuY7U+o3Vus3X+stV9IiTLUcOrwXJcwOFMkDBcEA
AL4AAL4AAL4AAL4AAL4AAL4AAL4AAL4AAL4AAL4AArsACLQCFbQNM8QWStAWRdIUPcwJIosGD1Rp
eJvL4eIAAACatO1piPdbevtPcP0tUdMHLKIAF6YABLkAAL4AAL4AAL4AAL4AAL4AAL4AAL4AAL4A
AL4AAL4AAL4AAL4AAL4AAL4ABr4AHr4CM8IOQdsXR+kLKqcGFW5pe6jL4eIAAAC3z+ajvep8mPNT
c/wtR90HF7YACbQAAbwAAL4AAL4AAL4AAL4AAL4AAL4AAL4AAL4AAL4AAL4AAL4AAL4AAL4AAL4A
Ar4ADL4AGL8FL8kJQtAEO78GOrFpjcrL4eIAAADL4eLL4eKbtexoh/c+U+UUHMwHCsQBAr8AAL4A
AL4AAL4AAL4AAL4AAL4AAL4AAL4AAL4AAL4AAL4AAL4AAL4AAL4AAL4AAL4ABb0AIrkAPLgARcwG
U95pmuHL4eIAAADL4eLL4eK2zuahuutxiek8UuceK9cGCcMAAL4AAL4AAL4AAL4AAL4AAL4AAL4A
AL4AAL4AAL4AAL4AAL4AAL4AAL4AAL4AAL4ABLoAHqwANaMAQsIGU95pmuHL4eIAAADL4eLL4eLL
4eLL4eKdt+toh/c9UuYUHMwGCcMBAr8AAL4AAL4AAL4AAL4AAL4AAL4AAL4AAL4AAL4AAL4AALwA
ArcABLYCB78EDcEHIa4LNaESTMEfZd51o+HL4eIAAADL4eLL4eLL4eLL4eK2zuafuetxiek9UuYe
LNcHC8QAAL4AAL4AAL4AAL4AAL4AAL4AAL4AAL4AAL4AAL4AA7YADJ4CFpgLJcMVMeMjOto0SNNZ
edp+qeClxeHL4eIAAADL4eLL4eLL4eLL4eLL4eLL4eKfuetoh/g6UecQGs0CBcIAAb8AAL4AAL4A
AL4AAL4AAL4AAL4AAb4ABcAADLYAGZMGKoodR8kzXftHXPthZPmXpO3L4eLL4eLL4eIAAADL4eLL
4eLL4eLL4eLL4eLL4eK2zuadt+xngukmQ+QMH9YDCMQAAL4AAL4AAL4AAL4AAL4AAL4ACMIAHsoA
L8sANbsQR7dPe9aEo+2Oo+2Zp+yzxOfL4eLL4eLL4eIAAADL4eLL4eLL4eLL4eLL4eLL4eLL4eLL
4eKRsOtDbvcgQOgSHMsJCr8CA74AAb4AAr4BBL4DBMAGFMgKPdQNV94NV94lad+Bq+HL4eLL4eLL
4eLL4eLL4eLL4eLL4eIAAADL4eLL4eLL4eLL4eLL4eLL4eLL4eLL4eKvyeaJqex4k+VxgtdOV8wZ
G8IACL4AGb4JI8UeKNY3QOBZeeBvnuBvnuB6p+Cnx+HL4eLL4eLL4eLL4eLL4eLL4eLL4eIAAADL
4eLL4eLL4eLL4eLL4eLL4eLL4eLL4eLL4eLL4eLL4eLL4eKRotgyOMYGFr8GM78WRsw8Tuppbfek
s+rL4eLL4eLL4eLL4eLL4eLL4eLL4eLL4eLL4eLL4eLL4eIAAADL4eLL4eLL4eLL4eLL4eLL4eLL
4eLL4eLL4eLL4eLL4eLL4eKuwd1+jNRoe9BoitBwk9eDl+aap+y3yubL4eLL4eLL4eLL4eLL4eLL
4eLL4eLL4eLL4eLL4eLL4eIAAADL4eLL4eLL4eLL4eLL4eLL4eLL4eLL4eLL4eLL4eLL4eLL4eLK
4OHK4OHK4OHK4OHK4OHK4OLK4OLK4OLL4eLL4eLL4eLL4eLL4eLL4eLL4eLL4eLL4eLL4eLL4eIA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAA==
) );
$ppmrepf = newIcon Win32::GUI::BitmapInline( q(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) );
$ppmrepi = newIcon Win32::GUI::BitmapInline( q(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) );
$ppmrepl = newIcon Win32::GUI::BitmapInline( q(
AAABAAEAICAAAAEAGACoDAAAFgAAACgAAAAgAAAAQAAAAAEAGAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAADL4eLL4eLL4eLL
4eLL4eLL4eLL4eLL4eLL4eLL4eLL4eLL4eLL4eLL4eLL4eLL4eLL4eLL4eLL4eLL4eLL4eLL4eLL
4eLL4eLL4eLL4eLL4eLL4eLL4eLL4eLL4eIAAADL4eLL4eLL4eLL4eLL4eLL4eLL4eLL4eLL4eLL
4eLL4eLL4eLL4eLL4eLL4eLL4eLL4eLL4eLL4eLL4eLL4eLL4eLL4eLL4eLL4eLL4eLL4eLL4eLL
4eLL4eLL4eIAAADL4eLL4eKhsrN1gYJve3tve3tve3tve3tve3tve3tve3tve3tve3tve3tve3tv
e3tve3tve3tve3tve3tve3tve3tve3tve3tve3tve3tve3tve3tve3tve3tve3sAAADL4eLL4eJ0
gYIZGxsNDg4NDg4NDg4NDg4NDg4NDg4NDg4NDg4NDg4NDg4NDg4NDg4NDg4NDg4NDg4NDg4NDg4N
Dg4NDg4NDg4NDg4NDg4NDg4NDg4NDg4NDg4NDg4AAACh0tN4xMVSkpIuXFwpVVUpVVUpVVUpVVUp
VVUpVVUpVVUpVVUpVVUpVVUpVVUpVVUpVVUpVVUpVVUpVVUpVVUpVVUpVVUpVVUpVVUpVVUpVVUp
VVUnU1MTKSkAAAAAAABywsMZo6MyrKxUt7dYublYublYublYublYublYublYublYublYublYublY
ublYublYublYublYublYublYublYublYublYublYublYublYublYublVs7MqWVkAAAAAAABpv8AG
nZ0+urqC29uD2N95zt941N943d942d940N9409943N942t940d940d94299319d1w8NvsrJjpaVf
oqJssrJ3wMN3x9N4zd94zd92zd5szdVfx8cvY2MAAAAAAABpv8AGnZ1WxcWz8vKs5veX0feT3feT
8veT6PeT0/eT2veT7veT6/eT1veT1/eT7feR4+OOuLiAkZFkdHRbbGx6kJGRsbeSwNqTzfeTzfeQ
zfV4zeBfx8cvY2MAAAAAAABpv8AGnZ1dyMjA+Pi48f6f4f6X2u2T1NiOxdCKscyItcuIxMuIwsuI
ssuIs8uIw8uKv7+PpqaMkJB/gYF3eXl7gYKCkZePstCbzf6bzf6Xzft8zeNfx8cvY2MAAAAAAABp
v8AGnZ1dyMjA+Pi4+v6f9v6S0teJpKV9j5JzgYhvgIZvhIZvg4Zvf4ZvgIZvhIZ3iYmIkZGWmZmj
paWen593eHlja3GBob+bzf6bzf6Xzft8zeNfx8cvY2MAAAAAAABpv8AGnZ1dyMjA+Pi4/v6f/v6Y
2dmXqamDi4trcXFiaWliaWliaWliaWliaWliaWlpbm52enqHiYmfn5+hoaF7fHxncHSDrMGb2/6b
0/6Xzft8zeNfx8cvY2MAAAAAAABpv8AGnZ1dyMjA+Pi4/v6f/v6k5uewycmUn59qcHBcYWFcYWFc
YWFcYWFcYWFcYWFdYWFgYWFsbGyGhoaSkpKChYV9i4yNxcub8P6b3f6Xzft8zeNfx8cvY2MAAAAA
AABpv8AGnZ1dyMjA+Pi4/v6f/v6k8fGx4eGdubp+iopwdXVrb29pbGxpbGxpbGxpbGxoampnZ2du
bm6CgoKMjY2BhYV+jpCNxM2b7f6b5P6X2vt80+Nfx8cvY2MAAAAAAABpv8AGnZ1dyMjA+Pi4/v6f
/v6e+fqi9PSh2dmgtbWXnZ2Ji4uDg4ODg4ODg4ODg4OCg4OCgoKGhoaOjo6Oj495f39xgYaIscmb
2v6b5/6X8Pt83uNfx8cvY2MAAAAAAABpv8AGnZ1dyMjA+Pi4/v6f/v6b/v6b/v6i5uatxsaprq6e
m5uakJCci4ubh4iYhIiWhouUjpCPj4+EhIR9f397goN+kZaOudCb3P6b5/6X7/t83eNfx8cvY2MA
AAAAAABpv8AGnZ1dyMjA+Pi4/v6f/v6b/v6b/v6f4+OnwMCqq6usoKCvkZG1g4OzeH2qb32jdoOd
jJGMjIxnZ2dcX1+Ejo6iubud2OCb7v6b4/6X2Pt80uNfx8cvY2MAAAAAAABpv8AGnZ1dyMjA+Pi4
/v6f/v6b/v6b/v6e4uKkvb2ppqaxmpq7jYvJg37Ic3O5XWuuY3OkiI6KiopWVlZITk6Fm5yv2Nqj
5u6b8P6b4/6X1/t80eNfx8cvY2MAAAAAAABpv8AGnZ1dyMjA+Pi4/v6f/v6b/v6b/v6e4uKkvb2n
n5+qh4e8gXvYi3raeGvGTFG2TFinf4SKiopUVFRDUFB7q6ui7PCe4vib3f6b5v6X7ft83ONfx8cv
Y2MAAAAAAABpv8AGnZ1dyMjA+Pi4/v6f/v6b/v6b/v6e4uKkvb2mn56ohoS5g3nTkHjWfmjDT0q0
TlKmgIGKiopTU1NBUVF1tbWb+f6b5f6b2f6b5/6X8vt83uNfx8cvY2MAAAAAAABpv8AGnZ1dyMjA
+Pi4/v6f/v6b/v6b/v6e4uKkvb2oqaetoZqwmIuykHqwg2yocGCjc2qgjoqKiopTU1NBUVF1tbWb
/P6b9P6b7P6b5P6X2/t81ONfx8cvY2MAAAAAAABpv8AGnZ1dyMjA+Pi7/v6m/v6j/v6j/v6l5uaq
x8etuLWvs6uppZmdk4CYinaYinaZj3+dmZOLi4tZWVlKWVl9uLij/v6j/v6i+f6e5v6X1Pt80ONf
x8cvY2MAAAAAAABpv8AGnZ1dyMjA+PjF/v68/v67/v67/v689PS+5ua30M+strKkpaCempKclo2c
lo2cmJGenJqRkZFsbm5lc3OXw8O7/v67/v64/P6o9P6X6vt82+Nfx8cvY2MAAAAAAABpv8AGnZ1W
xcWz8vK/9/e/9/e/9/e/9/e/9/e/9/ez39+gurqYqqqXpaWXpKSXpKSUo6OOoKCBlpZrgYFqiIiU
xMSy8fGy8fGv8fGZ8fGD7u5s2dlTwcE2bm4aHB0AAABpv8AGnZ0+urqC29uL39+L39+L39+L39+L
39+L39+G1dV9xMR6vb15u7t5u7t5u7tstLROpaU5mZkvj48vkpJBra1PwcFPwcFNwcFEwcE6wMAw
trYora1Sm5t8iYoAAABywsMYo6Mys7NUxcViy8tu0NBu0dFs0dFs0dFs0dFq0dFo0dFn0dFn0dFj
z89cyspEuroZnZ0DkJANmpoToaEToaEToaEToaEToaEToaEToaEToaEYpKRywsPL4eIAAACh0tN4
xMVSursusbFkxsaq4OCu5uai6Oig6emg6emW6emI6emD6emD6elr2tpAvr4fl5cLYWEWWlpQmZl1
w8R1w8R1w8R1w8R1w8R1w8R1w8R1w8R4xMWh0tPL4eIAAADL4eLL4eJ0w8QZo6NnwcHR6enX8vLE
9va/9/e/9/ew9/eZ9/eR9/eR9/dr3d0lq6sCc3MJNDQxNjaOnZ3L4eLL4eLL4eLL4eLL4eLL4eLL
4eLL4eLL4eLL4eLL4eIAAADL4eLL4eKh0tN1w8NvwsJvw8NnxcVex8dcx8dcx8dVx8dKx8dGx8dG
x8czpqYSZ2cZUVJObGyAjo+twMHL4eLL4eLL4eLL4eLL4eLL4eLL4eLL4eLL4eLL4eLL4eIAAADL
4eLL4eLL4eLL4eJ4xMQYo6MGnZ0GnZ0GnZ0GnZ0GnZ0GnZ0GnZ0GnZ0GdnYGLS0yNziRoqPL4eLL
4eLL4eLL4eLL4eLL4eLL4eLL4eLL4eLL4eLL4eLL4eLL4eIAAADL4eLL4eLL4eLL4eKh0tNxwsJo
v79ov79ov79ov79ov79ov79ov79ov79oq6xoh4d+jI2uwcLL4eLL4eLL4eLL4eLL4eLL4eLL4eLL
4eLL4eLL4eLL4eLL4eLL4eIAAADL4eLL4eLL4eLL4eLK4OHK4OHK4OHK4OHK4OHK4OHK4OHK4OHK
4OHK4OHK4OHK4OHK4OHK4OHL4eLL4eLL4eLL4eLL4eLL4eLL4eLL4eLL4eLL4eLL4eLL4eLL4eIA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA
AAAAAAAAAAAAAAAAAA==
) );
$ppmrepn = newIcon Win32::GUI::BitmapInline( q(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) );
$ppmrepo = newIcon Win32::GUI::BitmapInline( q(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) );
$ppmrepr = newIcon Win32::GUI::BitmapInline( q(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) );

