/*
//Copyright (C) 2002 Peter Bakota
========================================
 $Name:         main.c

 $Desc:         Plugin for Windows Commander to handle PowerPacker packed files

 $Author:       Peter Bakota <bakota@tippnet.co.yu>
 $Revision:     1
 $Date:         13.01.2002 8:34:54 PM
 $Comments:     
========================================
*/
#include <string.h>
#include <stdio.h>

#include "wcxapi.h"
#include "ppunpack.h"
#include "resource.h"

#ifdef __cplusplus
extern "C" {
#endif

// Max. nyithato pp adatallomany
#define MAX_OPEN_PP_FILES 20

// A nyitott allomanyok szamlaloja
unsigned pp_count = 0;

// Az allomanyok adatai
struct handle_t {
	unsigned char	pp_name[260];
	unsigned char	pp_archname[260];
	unsigned long	pp_usize;
	BOOL			end_of_archive;
} handle[MAX_OPEN_PP_FILES];

/*
========================================
Function name	: base_name
Description	    : strip out the base name
Return type		: static char* 
Date-Time       : 13.01.2002 8:35:31 PM
Argument        : const char *src
Argument        : char *dest
========================================
*/
static char* base_name(const char *src, char *dest)
{
	char *s1 = strrchr(src, '\\'), *s2;
	if(s1!=NULL)
	{
		strcpy(dest, s1);
		s2 = strrchr(dest, '.');
		if(s2!=NULL)
			s2[0]='\0';
		return dest;
	}
	return NULL;
}

/*
========================================
Function name	: tack_on
Description	    : Merge path + basename
Return type		: static char* 
Date-Time       : 13.01.2002 8:35:51 PM
Argument        : char *s1
Argument        : const char *s2
========================================
*/
static char* tack_on(char *s1, const char *s2)
{
	if(s1[strlen(s1)-1]!='\\') strcat(s1, "\\");
	strcat(s1, s2);
	return s1;
}

WCX_API HANDLE STDCALL OpenArchive(tOpenArchiveData *ArchiveData)
{
	if(pp_count<MAX_OPEN_PP_FILES)
	{
		if(ppIsPPFile(ArchiveData->ArcName))
		{
			++pp_count;
			base_name(ArchiveData->ArcName, handle[pp_count-1].pp_name);
			strcpy(handle[pp_count-1].pp_archname, ArchiveData->ArcName);
			ppGetUSizeFromFile(ArchiveData->ArcName, &handle[pp_count-1].pp_usize);
			handle[pp_count-1].end_of_archive = FALSE;
			return((HANDLE)&handle[pp_count-1]);
		}
		ArchiveData->OpenResult = E_UNKNOWN_FORMAT;
		return 0;
	}
	ArchiveData->OpenResult = E_TOO_MANY_FILES;
	return 0;
}

WCX_API int	STDCALL ReadHeader(HANDLE hArcData, tHeaderData *HeaderData)
{
	if(((struct handle_t*)hArcData)->end_of_archive==FALSE)
	{
		strcpy(HeaderData->FileName, ((struct handle_t*)hArcData)->pp_name );
		HeaderData->FileTime = 0;
		HeaderData->PackSize = 100;
		HeaderData->UnpSize  = ((struct handle_t*)hArcData)->pp_usize;
		((struct handle_t*)hArcData)->end_of_archive = TRUE;
		return 0;
	}
	else
		return E_END_ARCHIVE;
}

WCX_API int	STDCALL ProcessFile(HANDLE hArcData, int Operation, char *DestPath, char *DestName)
{
	switch(Operation)
	{
		case PK_SKIP:
			return 0;
		case PK_TEST:
		case PK_EXTRACT:
			if(ppDecrunchFile(((struct handle_t*)hArcData)->pp_archname, DestName)==PP_LOADOK) return 0;
			return E_BAD_DATA;
	}
	return 0;
}

WCX_API int	STDCALL CloseArchive(HANDLE hArcData)
{
	if(pp_count)
	{
		--pp_count;
		return 0;
	}
	else
		return E_ECLOSE;
}

WCX_API int	STDCALL PackFiles (char *PackedFile, char *SubPath, char *SrcPath, char *AddList, int Flags)
{
	return E_NOT_SUPPORTED;
}

WCX_API int	STDCALL DeleteFiles (char *PackedFile, char *DeleteList)
{
	return E_NOT_SUPPORTED;
}

WCX_API int	STDCALL GetPackerCaps(void)
{
	return PK_CAPS_OPTIONS|PK_CAPS_NEW;
}

/*
========================================
Function name	: DialogProc
Description	    : About dialog CALLBACK
Return type		: BOOL CALLBACK 
Date-Time       : 13.01.2002 8:36:30 PM
Argument        : HWND hwndDlg
Argument        : UINT  uMsg
Argument        : WPARAM wParam
Argument        : LPARAM  lParam
========================================
*/
BOOL CALLBACK DialogProc(HWND hwndDlg,UINT  uMsg,WPARAM wParam,LPARAM  lParam)
{
	switch (uMsg) {
	 case WM_COMMAND:
	   switch (LOWORD(wParam)) {
		 case IDOK:		   /* OK  */
			EndDialog(hwndDlg,1);
		 case IDCANCEL:		/* CANCEL */
			EndDialog(hwndDlg,0);
	   }
	 break;
	}
	return FALSE;
}

WCX_API void STDCALL ConfigurePacker (HWND Parent, HINSTANCE DllInstance)
{
   DialogBox((HINSTANCE)DllInstance,(LPCTSTR)IDD_ABOUTDLG,(HWND)Parent,(DLGPROC)&DialogProc);
}

WCX_API void STDCALL SetChangeVolProc(HANDLE hArcData, tChangeVolProc pChangeVolProc1)
{
}

WCX_API void STDCALL SetProcessDataProc(HANDLE hArcData, tProcessDataProc pProcessDataProc)
{
}

#ifdef __cplusplus
}
#endif
