#include "ListerPlugin.h"
#include <stdio.h>

HINSTANCE inst=NULL;
ThreadParameter param;
HANDLE hThreadHandle=NULL;

LRESULT CALLBACK WndProc(HWND hWnd,UINT iMsg,WPARAM wParam,LPARAM lParam)
{
 switch (iMsg)
 {
  case WM_CREATE:
  {
   SetTimer(hWnd,666,100,NULL);
   return 0;
  }
  case WM_TIMER:
  {
   RECT rect;
   GetWindowRect(hWnd,&rect);
   if ((IsWindowVisible(hWnd))&&(!IsIconic(hWnd))&&((rect.right-rect.left)>0)&&((rect.bottom-rect.top)>0))
   {
    RECT puttyrect;
    GetWindowRect(param.hWnd,&puttyrect);
    if ((rect.left!=puttyrect.left)||(rect.right!=puttyrect.right)||(rect.top!=puttyrect.top)||(rect.bottom!=puttyrect.bottom))
     MoveWindow(param.hWnd,rect.left,rect.top,rect.right-rect.left,rect.bottom-rect.top,TRUE);
   }
   if (!IsWindowVisible(hWnd))
   {
    if (IsWindowVisible(param.hWnd))
     ShowWindow(param.hWnd,SW_HIDE);
   }
   else
   {
    if (!IsWindowVisible(param.hWnd))
     ShowWindow(param.hWnd,SW_SHOW);
   }
   return 0;
  }
  case WM_MOUSEMOVE:
  case WM_MOVE:
  case WM_SIZE:
  {
   RECT rect;
   GetWindowRect(hWnd,&rect);
   if ((IsWindowVisible(hWnd))&&(!IsIconic(hWnd))&&((rect.right-rect.left)>0)&&((rect.bottom-rect.top)>0))
   {
    MoveWindow(param.hWnd,rect.left,rect.top,rect.right-rect.left,rect.bottom-rect.top,TRUE);
    SetForegroundWindow(param.hWnd);
   }
   return 0;
  }
  case WM_DESTROY:
  {
   KillTimer(hWnd,666);
   return 0;
  }
 }
 return DefWindowProc(hWnd,iMsg,wParam,lParam);
}

DWORD WINAPI ThreadProc(LPVOID lpParameter)
{
 return PuttyWLXMain();
}

HWND _stdcall ListLoad(HWND ParentWin,char* FileToLoad,int ShowFlags)
{
 int w,h,l;
 RECT rect;
 WNDCLASSEX WndClass;
 DWORD threadID;
 if (param.hWnd==NULL)
 {
  param.ListLoadReturn=0;
  param.hWnd=NULL;
  param.PanelWin=NULL;
  param.ParentWin=ParentWin;
  param.FileToLoad=FileToLoad;

  l=strlen(param.FileToLoad)-1;
  while ((l>0)&&(param.FileToLoad[l]!='\\')&&(param.FileToLoad[l]!='/'))
   l--;
  param.FileToLoad=param.FileToLoad+l+((l==0)?0:1);

  WndClass.cbSize        = sizeof(WndClass);
  WndClass.style         = CS_HREDRAW|CS_VREDRAW|CS_DBLCLKS;
  WndClass.lpfnWndProc   = WndProc;
  WndClass.cbClsExtra    = 0;
  WndClass.cbWndExtra    = 0;
  WndClass.hInstance     = inst;
  WndClass.hIcon         = LoadIcon(NULL,IDI_APPLICATION);
  WndClass.hCursor       = LoadCursor(NULL,IDC_ARROW);
  WndClass.hbrBackground = (HBRUSH)GetStockObject(LTGRAY_BRUSH);
  WndClass.lpszMenuName  = NULL;
  WndClass.lpszClassName = "PuttyWindow";
  WndClass.hIconSm       = LoadIcon(NULL,IDI_APPLICATION);
  RegisterClassEx(&WndClass);
  GetClientRect(param.ParentWin,&rect);
  w=rect.right-rect.left;
  h=rect.bottom-rect.top;
  param.PanelWin=CreateWindow("PuttyWindow","Putty",WS_CHILD|WS_VISIBLE,0,0,w,h,param.ParentWin,NULL,inst,NULL);
  hThreadHandle=CreateThread(NULL,0,ThreadProc,NULL,0,&threadID);
  while (!param.ListLoadReturn) Sleep(1);
  return param.PanelWin;
 }
 else
 {
  MessageBox(NULL,"Only one instance of Putty.wlx is allowed!","Putty.wlx",MB_ICONWARNING|MB_OK);
  return NULL;
 }
}

void __stdcall ListCloseWindow(HWND ListWin)
{
 if (param.hWnd!=NULL)
  DestroyWindow(param.hWnd);
 if (param.PanelWin!=NULL)
  DestroyWindow(param.PanelWin);
 if (hThreadHandle!=NULL)
 {
  TerminateThread(hThreadHandle,0);
  hThreadHandle=NULL;
 }
 param.ListLoadReturn=0;
 param.hWnd=NULL;
 param.PanelWin=NULL;
 param.ParentWin=NULL;
 param.FileToLoad=NULL;
}

BOOL WINAPI DllMain(HINSTANCE hinstDLL,DWORD fdwReason,LPVOID lpvReserved)
{
 switch (fdwReason)
 {
  case DLL_PROCESS_ATTACH:
  inst=hinstDLL;
  param.ListLoadReturn=0;
  param.hWnd=NULL;
  param.PanelWin=NULL;
  param.ParentWin=NULL;
  param.FileToLoad=NULL;
  break;
  case DLL_PROCESS_DETACH:
  ListCloseWindow(param.PanelWin);
  break;
  default: break;
 }
 return TRUE;
}
