// reginfo.cpp : Defines the entry point for the DLL application.
//

#include "stdafx.h"
#include "contentplug.h"

#define _detectstring ""

#define fieldcount 4
char* fieldnames[fieldcount]={
	"Nazwa","Default", "Content Type","file type"};

int fieldtypes[fieldcount]={
		ft_string,ft_string,ft_string,ft_multiplechoice};

char* fieldunits_and_multiplechoicestrings[fieldcount]={
		"","","","plik|folder|reparse point"};
	
char* multiplechoicevalues[3]={
	"plik","folder","reparse point"
};

BOOL GetValueAborted=false;

BOOL APIENTRY DllMain( HANDLE hModule, 
                       DWORD  ul_reason_for_call, 
                       LPVOID lpReserved
					 )
{
    return TRUE;
}

char* strlcpy(char* p,const char* p2,int maxlen)
{
    if ((int)strlen(p2)>=maxlen) {
        strncpy(p,p2,maxlen);
        p[maxlen]=0;
    } else
        strcpy(p,p2);
    return p;
}

int __stdcall ContentGetDetectString(char* DetectString,int maxlen)
{
	strlcpy(DetectString,_detectstring,maxlen);
	return 0;
}

int __stdcall ContentGetSupportedField(int FieldIndex,char* FieldName,char* Units,int maxlen)
{
	if (FieldIndex<0 || FieldIndex>=fieldcount)
		return ft_nomorefields;
	strlcpy(FieldName,fieldnames[FieldIndex],maxlen-1);
	strlcpy(Units,fieldunits_and_multiplechoicestrings[FieldIndex],maxlen-1);
	return fieldtypes[FieldIndex];
}

int __stdcall ContentGetValue(char* FileName,int FieldIndex,int UnitIndex,void* FieldValue,int maxlen,int flags)
{
	WIN32_FIND_DATA fd;
	FILETIME lt;
	SYSTEMTIME st;
	HANDLE fh;
	DWORD handle;
	DWORD dwSize;
	__int64 filesize;
	HKEY klucz;	
	DWORD rozm = 30;
	GetValueAborted=false;
	unsigned char * odczytane;

	if (flags & CONTENT_DELAYIFSLOW) {
		if (FieldIndex==16)
			return ft_delayed;
		if (FieldIndex==17)
			return ft_ondemand;
	}
	
	char* rozsz=strrchr(FileName,'\\');
	if (rozsz)
		rozsz=strrchr(rozsz,'.');  // get extension
	if (!rozsz) return ft_fileerror;

	HKEY key;
	LPCTSTR str = rozsz;

	fh=FindFirstFile(FileName,&fd);
	
	if (fh!=INVALID_HANDLE_VALUE) {
		FindClose(fh);
		switch (FieldIndex) {
		case 0:  //	"nazwa"
			strlcpy((char*)FieldValue,fd.cFileName,maxlen-1);
			break;
		case 1: //Default
			if(RegOpenKeyEx(HKEY_CLASSES_ROOT,str,0,KEY_ALL_ACCESS,&key)==ERROR_SUCCESS) {
				DWORD dwSize;
				if(RegQueryValueEx(key,NULL,0,NULL,NULL,&dwSize)==ERROR_SUCCESS) {
					char * buffer=new char[dwSize];
					if(RegQueryValueEx(key,NULL,0,NULL,(LPBYTE)buffer,&dwSize)==ERROR_SUCCESS) {						
						strlcpy((char*)FieldValue,buffer,maxlen-1);						
					}
					delete buffer;
				}
			RegCloseKey(key);
			}		
			break;
		case 2: //content
			if(RegOpenKeyEx(HKEY_CLASSES_ROOT,str,0,KEY_ALL_ACCESS,&key)==ERROR_SUCCESS) {
				DWORD dwSize;
				if(RegQueryValueEx(key,TEXT("Content Type"),0,NULL,NULL,&dwSize)==ERROR_SUCCESS) {
					char * buffer=new char[dwSize];
					if(RegQueryValueEx(key,TEXT("Content Type"),0,NULL,(LPBYTE)buffer,&dwSize)==ERROR_SUCCESS) {						
						strlcpy((char*)FieldValue,buffer,maxlen-1);						
					}
					delete buffer;
				}
			RegCloseKey(key);
			}		
			break;
		case 3: // "file type"
			if ((fd.dwFileAttributes & FILE_ATTRIBUTE_DIRECTORY)==0)
				strlcpy((char*)FieldValue,multiplechoicevalues[0],maxlen-1);
			else if ((fd.dwFileAttributes & FILE_ATTRIBUTE_REPARSE_POINT)==0)
				strlcpy((char*)FieldValue,multiplechoicevalues[1],maxlen-1);
			else
				strlcpy((char*)FieldValue,multiplechoicevalues[2],maxlen-1);
			break;
		default:
			return ft_nosuchfield;
		}
	} else
	return ft_fileerror;
	return fieldtypes[FieldIndex];  // very important!
}

void __stdcall ContentSetDefaultParams(ContentDefaultParamStruct* dps)
{

}

void __stdcall ContentStopGetValue	(char* FileName)
{
	GetValueAborted=true;
}