//{$define DD} //debug

unit unProj;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, ComCtrls, ImgList, ExtCtrls, Menus,

  TntForms, TntClasses, TntComCtrls, TntDialogs,
  TB2Item, TB2Dock, TB2Toolbar,
  SpTBXItem, SpTbxMDIMRU,

  DKLang,
  unProgress, unProc;

var
  SMsgProjNew: Widestring = 'Untitled';
  SMsgProjDefault: Widestring = '(Default)';
  SMsgProjNewFolder: Widestring = 'New folder';
  SMsgProjFolderName: Widestring = 'Enter folder name:';
  SMsgProjCaption: Widestring = 'SynWrite';
  SMsgProjSaveCfm: Widestring = 'Project "%s" has been modified.'#13#13'Save changes?';
  SMsgProjSortCfm: Widestring = 'Project now contains over %d new items, their sorting will be slow.'#13#13'Do you want to sort added items?';

type
  TListProc = procedure(Sender: TObject; Files: TTntStrings) of object;
  TMruListProc = procedure(MruList: TSynMruList) of object;
  TProjPreviewProc = procedure(Sender: TObject; const AFilename: Widestring; AToggle: boolean) of object;
  TProjToolProc = procedure(const ATool: TSynTool) of object;
  TProjSort = (srNone, srName, srExt, srDate, srSize, srDateDesc, srSizeDesc, srFullPath);

type
  TProjectOpts = record
    WorkDir: Widestring;
    MainFN: Widestring;
    DefLexer: string;
    DefLineEnds: integer;
    DefEnc: integer;
    SortType: TProjSort;
    SearchDirs: Widestring;
    UserVars: Widestring;
    MasksInclude,
    MasksExclude: Widestring;
  end;

type
  TfmProj = class(TForm)
    TreeProj: TTntTreeView;
    tbProject: TSpTbxToolbar;
    TBXItemProjOpen: TSpTbxSubmenuItem;
    TBXItemProjSave: TSpTbxItem;
    TBXItemProjAddVirtDir: TSpTbxItem;
    TBXItemProjAddFiles: TSpTbxItem;
    TBXItemProjDelFiles: TSpTbxItem;
    TBXItemProjRename: TSpTbxItem;
    ImageList1: TImageList;
    ODFile: TTntOpenDialog;
    TimerHint: TTimer;
    TBXItemProjOpenFiles: TSpTbxItem;
    ImageListTool: TImageList;
    TBXItemProjProp: TSpTBXSubmenuItem;
    PopupProj: TSpTbxPopupMenu;
    TbxItemMnuAdd: TSpTbxSubmenuItem;
    TbxItemMnuAddFiles: TSpTbxItem;
    TbxItemMnuAddDir: TSpTbxItem;
    TbxItemMnuAddVDir: TSpTbxItem;
    TbxItemMnuRename: TSpTbxItem;
    TbxItemMnuRemove: TSpTbxItem;
    TBXSeparatorItem1: TSpTbxSeparatorItem;
    TBXItemMnuProjSaveAs: TSpTbxItem;
    TBXItemMnuProjSave: TSpTbxItem;
    TBXItemMnuProjOpen: TSpTbxItem;
    TBXItemMnuProjClose: TSpTbxItem;
    TBXItemMnuProjProp: TSpTbxItem;
    TBXSeparatorItem2: TSpTbxSeparatorItem;
    TBXItemMnuOpenFiles: TSpTbxItem;
    ODProj: TOpenDialog;
    SDProj: TSaveDialog;
    TBXItemProjAddFilesDir: TSpTbxItem;
    TBXSeparatorItem3: TSpTbxSeparatorItem;
    TBXItemMnuAddOpenedFiles: TSpTbxItem;
    TBXItemMnuAddCurrFile: TSpTbxItem;
    TBXItemMnuSetMain: TSpTbxItem;
    TBXSeparatorItem4: TSpTbxSeparatorItem;
    TBXItemMnuCollapse: TSpTbxItem;
    TBXItemMnuExpand: TSpTbxItem;
    TBXSubmenuItemSort: TSpTbxSubmenuItem;
    TBXItemMnuSortByName: TSpTbxItem;
    TBXItemMnuSortByExt: TSpTbxItem;
    DKLanguageController1: TDKLanguageController;
    TBXItemMnuSortBySizeDesc: TSpTbxItem;
    TBXItemMnuSortByDateDesc: TSpTbxItem;
    TBXItemMnuSortBySize: TSpTbxItem;
    TBXItemMnuSortByDate: TSpTbxItem;
    TBXItemMnuProps: TSpTbxItem;
    TBXSeparatorItem5: TSpTbxSeparatorItem;
    TBXItemProjClearRecent: TSpTbxItem;
    TBXItemProjMRU: TSpTbxMRUListItem;
    SpTBXDock1: TSpTBXDock;
    TBXItemMnuProjGoto: TSpTBXItem;
    TBXItemMnuTogglePaths: TSpTBXItem;
    TBXItemMnuSortByPath: TSpTBXItem;
    TbxItemMnuTogglePreview: TSpTBXItem;
    TbxItemProjOptions: TSpTBXItem;
    TbxItemProjTools: TSpTBXItem;
    SpTBXSeparatorItem1: TSpTBXSeparatorItem;
    TbxItemMnuProjUpdate: TSpTBXItem;
    procedure TBXItemProjAddVirtDirClick(Sender: TObject);
    procedure TBXItemProjDelFilesClick(Sender: TObject);
    procedure TBXItemProjAddFilesClick(Sender: TObject);
    procedure TBXItemProjRenameClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
    procedure TreeProjEditing(Sender: TObject; Node: TTreeNode;
      var AllowEdit: Boolean);
    procedure TreeProjDragDrop(Sender, Source: TObject; X, Y: Integer);
    procedure TreeProjDragOver(Sender, Source: TObject; X, Y: Integer;
      State: TDragState; var Accept: Boolean);
    procedure TreeProjMouseMove(Sender: TObject; Shift: TShiftState; X,
      Y: Integer);
    procedure TimerHintTimer(Sender: TObject);
    procedure TreeProjDblClick(Sender: TObject);
    procedure TBXItemProjOpenFilesClick(Sender: TObject);
    procedure TBXItemProjNewClick(Sender: TObject);
    procedure TbxItemMnuAddFilesClick(Sender: TObject);
    procedure TbxItemMnuAddVDirClick(Sender: TObject);
    procedure TbxItemMnuAddDirClick(Sender: TObject);
    procedure TbxItemMnuRenameClick(Sender: TObject);
    procedure TbxItemMnuRemoveClick(Sender: TObject);
    procedure TBXItemProjOpenClick(Sender: TObject);
    procedure TBXItemProjSaveClick(Sender: TObject);
    procedure PopupProjPopup(Sender: TObject);
    procedure TreeProjContextPopup(Sender: TObject; MousePos: TPoint;
      var Handled: Boolean);
    procedure TBXItemMnuProjPropClick(Sender: TObject);
    procedure TBXItemProjPropClick(Sender: TObject);
    procedure TBXItemMnuOpenFilesClick(Sender: TObject);
    procedure TBXItemMnuProjOpenClick(Sender: TObject);
    procedure TBXItemMnuProjSaveClick(Sender: TObject);
    procedure TBXItemMnuProjSaveAsClick(Sender: TObject);
    procedure TBXItemMnuProjCloseClick(Sender: TObject);
    procedure TBXItemProjAddFilesDirClick(Sender: TObject);
    procedure TBXItemMnuAddCurrFileClick(Sender: TObject);
    procedure TBXItemMnuAddOpenedFilesClick(Sender: TObject);
    procedure TBXItemMnuSetMainClick(Sender: TObject);
    procedure TBXItemMnuSortByNameClick(Sender: TObject);
    procedure TBXItemMnuExpandClick(Sender: TObject);
    procedure TBXItemMnuCollapseClick(Sender: TObject);
    procedure TBXItemMnuSortByExtClick(Sender: TObject);
    procedure TreeProjEdited(Sender: TObject; Node: TTntTreeNode;
      var S: WideString);
    procedure TBXItemMnuSortByDateClick(Sender: TObject);
    procedure TBXItemMnuSortBySizeClick(Sender: TObject);
    procedure TBXItemMnuSortByDateDescClick(Sender: TObject);
    procedure TBXItemMnuSortBySizeDescClick(Sender: TObject);
    procedure TBXItemMnuPropsClick(Sender: TObject);
    procedure TBXItemProjClearRecentClick(Sender: TObject);
    procedure FormShow(Sender: TObject);
    procedure TBXItemProjOpenPopup(Sender: TTBCustomItem;
      FromLink: Boolean);
    procedure TBXItemProjMRUClick(Sender: TObject;
      const Filename: WideString);
    procedure TBXItemMnuProjGotoClick(Sender: TObject);
    procedure TreeProjChange(Sender: TObject; Node: TTreeNode);
    procedure TBXItemMnuTogglePathsClick(Sender: TObject);
    procedure TBXItemMnuSortByPathClick(Sender: TObject);
    procedure TbxItemMnuTogglePreviewClick(Sender: TObject);
    procedure TbxItemProjOptionsClick(Sender: TObject);
    procedure TbxItemProjToolsClick(Sender: TObject);
    procedure TBXItemProjPropPopup(Sender: TTBCustomItem;
      FromLink: Boolean);
    procedure TbxItemMnuProjUpdateClick(Sender: TObject);
  private
    { Private declarations }
    FProjectFN: Widestring;
    FModified: boolean;
    FProjectTools: TSynToolList;
    FShowPaths: boolean;
    FMruList: TSynMruList;
    FIcoList: TStringList;
    FPathList: TTntStringList;
    FOldItemsCount: integer;
    FOnPreview: TProjPreviewProc;
    FOnRunTool: TProjToolProc;
    FOnGotoProj: TNotifyEvent;
    FOnProjectOpen: TNotifyEvent;
    FOnProjectClose: TNotifyEvent;
    FOnFileOpen: TListProc;
    FOnUpdateMRU: TMruListProc;
    FOnLoadMRU: TMruListProc;
    FOnAddEditorFile: TListProc;
    FOnAddEditorFilesAll: TListProc;
    FOnGetLexer: TListProc;
    FOnGetLexers: TListProc;
    FOnGetWorkDir: TListProc;
    FOnGetProjDir: TListProc;
    FOnSetProjDir: TListProc;
    FShellIcons: boolean;
    fmProgress: TfmProgress;
    function GetExtensionsMask: Widestring;
    function GetRealDirFromDir(Node: TTntTreeNode): Widestring;
    function GetCurrentLexer: string;
    function GetFileNodeCaption(const fn: Widestring): Widestring;
    function GetCollapsedList: string;
    procedure SetCollapsedList(S: Widestring);
    function DoConfirmSort: boolean;
    procedure ShowProgress(M: TProgressType);
    procedure HideProgress;
    function IsProgressStopped(Cnt, CntAll: integer): boolean;
    procedure SetModified;
    function RootNode: TTntTreeNode;
    function GetWorkDir: Widestring;
    function GetProjDir: Widestring;
    procedure DoUpdateMRU;
    procedure DoLoadMRU;
    procedure SetProjDir(const Dir: string);
    procedure DoUpdateSort(Node: TTntTreeNode);
    procedure DoAddDirDlg(const SDir: Widestring);
    procedure DoSortBy(Mode: TProjSort);
    procedure DoSortDir(Node: TTntTreeNode; Subdirs: boolean; SortType: TProjSort);
    function CanRename(Node: TTntTreeNode): boolean;
    procedure DoSaveProjectAs;
    procedure DoConfigProject;
    procedure DoConfigProjectTools;
    procedure DoAddRecentItem(const fn: Widestring);
    procedure DoLoadProjectFromFile(const fn: Widestring);
    procedure DoSaveProjectToFile(const fn: string);
    procedure DoWriteNodesToList(L: TStringList; Node: TTntTreeNode; Level: integer);
    function DirForNode(Node: TTntTreeNode): TTntTreeNode;
    function DoAddDirWithSubdirs(Node: TTntTreeNode; const SDir: Widestring;
      SubDirs, NoBinary: boolean; const ExtInc, ExtExc: string): TTntTreeNode;
    procedure AddFilesToList(L: TTntStringList; Node: TTntTreeNode);
    function IsRoot(Node: TTntTreeNode): boolean;
    function IsFilenameListed(Node: TTntTreeNode; const fn: Widestring): boolean;
    function DoAddFile(Sel: TTntTreeNode; const fn: Widestring): TTntTreeNode;
    function DoAddDir(Sel: TTntTreeNode; S: Widestring;
      DoExpand: boolean = true): TTntTreeNode;
    procedure UpdateProjectToolsMenu;
    procedure DoRunProjectTool(Sender: TObject);
    function DoCollapseFN(const fn: Widestring): Widestring;
    function DoExpandFN(const fn: Widestring): Widestring;
  public
    { Public declarations }
    FOpts: TProjectOpts;
    FDirToolsPresets: string;
    procedure DoAddFiles;
    procedure DoAddFilesDir;
    procedure DoAddVirtualDir;
    procedure DoPreview(Toggle: boolean);
    procedure DoUpdateNodeCaptions;
    procedure DoToggleShowPaths;
    function IsDirSelected: boolean;
    procedure DoOpenFiles;
    procedure DoRefresh;
    procedure DoRename;
    procedure DoRemoveFile(const fn: Widestring);
    procedure DoRenameFile(const fn, fn_new: Widestring);
    procedure DoRenameFileNode(Node: TTntTreeNode);
    procedure DoRemove;
    procedure DoOpenProject;
    procedure DoNewProject;
    procedure DoSaveProject;
    procedure DoUpdateProject;
    procedure DoAddEditorFiles(All: boolean);
    procedure ReplaceUserVars(var SValue: Widestring;
      const AVarName: Widestring; var AVarValue: Widestring);
    function GetUserVarValue(const AVarName: Widestring): Widestring;
    function GetFN(Node: TTntTreeNode): Widestring;
    function GetImageIndex(const fn: Widestring): integer;
    function ProjectTitle: Widestring;
    property ProjectFN: Widestring read FProjectFN write DoLoadProjectFromFile;
    property Modified: boolean read FModified;
    property OnPreview: TProjPreviewProc read FOnPreview write FOnPreview;
    property OnRunTool: TProjToolProc read FOnRunTool write FOnRunTool;
    property OnFileOpen: TListProc read FOnFileOpen write FOnFileOpen;
    property OnProjectOpen: TNotifyEvent read FOnProjectOpen write FOnProjectOpen;
    property OnProjectClose: TNotifyEvent read FOnProjectClose write FOnProjectClose;
    property OnUpdateMRU: TMruListProc read FOnUpdateMRU write FOnUpdateMRU;
    property OnLoadMRU: TMruListProc read FOnLoadMRU write FOnLoadMRU;
    property OnAddEditorFile: TListProc read FOnAddEditorFile write FOnAddEditorFile;
    property OnAddEditorFilesAll: TListProc read FOnAddEditorFilesAll write FOnAddEditorFilesAll;
    property OnGetLexer: TListProc read FOnGetLexer write FOnGetLexer;
    property OnGetLexers: TListProc read FOnGetLexers write FOnGetLexers;
    property OnGetWorkDir: TListProc read FOnGetWorkDir write FOnGetWorkDir;
    property OnGetProjDir: TListProc read FOnGetProjDir write FOnGetProjDir;
    property OnSetProjDir: TListProc read FOnSetProjDir write FOnSetProjDir;
    property OnGotoProjFile: TNotifyEvent read FOnGotoProj write FOnGotoProj;
    //
    function DoConfirmClose(ClearModified: boolean = false): boolean;
    procedure UpdateTitle;
    procedure DoDropItem(const fn: Widestring);
    procedure DoSaveProjectIfNeeded;
  end;

procedure SStringToList(s: Widestring; L: TTntStrings);
procedure SListToString(L: TTntStrings; var S: Widestring);

implementation

uses
  CommCtrl,
  IniFiles,
  ATxFProc,
  AtxSProc,
  ATxIconProc,
  TntWideStrUtils,
  TntFileCtrl,
  TntSysUtils,
  unFrame,
  unProjAddDir,
  unProjProps;

{$R *.dfm}

const
  cProjVar = '{Proj}'; //used in Proj files
  cMainMark = ' *';
  cHintTimer = 2000;

const
  cImgRoot = 0;
  cImgDir = 1;
  cImgFile = 2;
  cImgMissed = 3;

procedure MsgBeep;
begin
  MessageBeep(mb_iconwarning);
end;

function IsDir(Node: TTntTreeNode): boolean;
begin
  if Node=nil then
    raise Exception.Create('node nil');
  Result:= Node.ImageIndex<=1;
end;

procedure SListToString(L: TTntStrings; var S: Widestring);
var
  i: Integer;
begin
  S:= '';
  for i:= 0 to L.Count-1 do
    if Trim(L[i])<>'' then
      S:= S+L[i]+';';
end;

procedure SStringToList(s: Widestring; L: TTntStrings);
var
  ss: Widestring;
begin
  L.Clear;
  repeat
    ss:= SGetItem(s, ';');
    if Trim(ss)='' then Break;
    L.Add(ss);
  until false;
end;

function TfmProj.DirForNode(Node: TTntTreeNode): TTntTreeNode;
begin
  if IsDir(Node) then
    Result:= Node
  else
    Result:= Node.Parent;
end;

procedure TfmProj.DoNewProject;
begin
  if not DoConfirmClose then Exit;

  if FProjectFN<>'' then
    if Assigned(FOnProjectClose) then
      FOnProjectClose(Self);

  with TreeProj do
  begin
    Items.Clear;
    with Items.Add(nil, '') do
    begin
      ImageIndex:= cImgRoot;
      SelectedIndex:= ImageIndex;
    end;
    Selected:= RootNode;
  end;

  FProjectFN:= '';
  FModified:= false;
  FOpts.MainFN:= '';
  FOpts.WorkDir:= '';
  FOpts.DefLexer:= '';
  FOpts.DefLineEnds:= 0;
  FOpts.DefEnc:= 0;
  FOpts.SortType:= srExt;
  FOpts.SearchDirs:= '';
  FOpts.UserVars:= '';
  FOpts.MasksInclude:= '';
  FOpts.MasksExclude:= 'exe,dll,lnk,zip,rar';

  FPathList.Clear;
  UpdateTitle;

  //clear tools
  DoTool_LoadList(FProjectTools, '??', '');

  {$ifdef DD}
  {
  DoAddDir(RootNode, 'Test');
  DoAddDir(RootNode, 'ATest');
  DoAddFile(RootNode, 'd:\t\history.txt');
  DoAddFile(RootNode, 'd:\z.txt');
  DoAddFile(RootNode, 'd:\dd.txt');
  //DoAddDirWithSubdirs(TreeProj.Items[1], 'd:\work\Dir');
  //DoSort(TreeProj.Selected);
  }
  {$endif}
end;

procedure TfmProj.TBXItemProjAddVirtDirClick(Sender: TObject);
begin
  DoAddVirtualDir;
end;

procedure TfmProj.DoAddVirtualDir;
var
  S: Widestring;
begin
  SMsgProjNewFolder:= DKLangConstW('zNewFolder');
  SMsgProjFolderName:= DKLangConstW('zNewFolderName');

  S:= SMsgProjNewFolder;
  if not DoInputString(SMsgProjFolderName, S) then Exit;

  with TreeProj do
  begin
    DoAddDir(Selected, S);
    DoUpdateSort(Selected);
  end;

  SetModified;
end;

function TfmProj.DoAddDir(Sel: TTntTreeNode; S: Widestring; DoExpand: boolean = true): TTntTreeNode;
begin
  Result:= nil;
  if sel=nil then Exit;
  if S='' then S:= '?';

  with TreeProj do
  begin
    Result:= Items.AddChild(DirForNode(sel), S);
    with Result do
    begin
      ImageIndex:= cImgDir;
      SelectedIndex:= ImageIndex;
    end;
  end;

  if DoExpand then
    sel.Expand(false);
  SetModified;
end;

procedure TfmProj.TBXItemProjDelFilesClick(Sender: TObject);
begin
  DoRemove;
end;

procedure TfmProj.DoRemove;
var i: Integer;
begin
  with TreeProj do
    if Selected=nil then
      MsgBeep
    else  
    if RootNode.Selected then //root selected
      MsgBeep
    else
    if SelectionCount=0 then //none selected
      MsgBeep
    else
    begin
      if not MsgConfirm(WideFormat(DKLangConstW('zMDelMany'), [SelectionCount]), Self.Handle) then Exit;
      for i:= SelectionCount-1 downto 0 do
        Items.Delete(Selections[i]);
      SetModified;
    end;  
end;

procedure TfmProj.TBXItemProjAddFilesClick(Sender: TObject);
begin
  DoAddFiles;
end;

procedure TfmProj.DoAddFiles;
var
  i: Integer;
  Node: TTntTreeNode;
begin
  ODFile.InitialDir:= GetWorkDir;
  if not ODFile.Execute then Exit;
  Node:= nil;
  for i:= 0 to ODFile.Files.Count-1 do
    Node:= DoAddFile(TreeProj.Selected, ODFile.Files[i]);
  if Node<>nil then
  begin
    DoUpdateSort(TreeProj.Selected);
    Node.MakeVisible;
  end;
end;

procedure TfmProj.TBXItemProjRenameClick(Sender: TObject);
begin
  DoRename;
end;

procedure TfmProj.DoRenameFileNode(Node: TTntTreeNode);
var
  SDir, SPrevFN, SNewFN: Widestring;
begin
  SPrevFN:= GetFN(Node);
  if not IsFileExist(SPrevFN) then
    begin MsgBeep; Exit end;

  SDir:= WideExtractFileDir(SPrevFN);
  SPrevFN:= WideExtractFileName(SPrevFN);
  SNewFN:= SPrevFN;
  if not DoInputString(DKLangConstW('zMRename'), SNewFN) then Exit;

  if not FFileMove(SDir+'\'+SPrevFN, SDir+'\'+SNewFN) then
  begin
    MsgRenameError(SPrevFN, SNewFN, Handle);
    Exit
  end;
  DoRenameFile(SDir+'\'+SPrevFN, SDir+'\'+SNewFN);
end;

procedure TfmProj.DoRename;
begin
  with TreeProj do
    if (Selected<>nil) and (SelectionCount=1) and not IsRoot(Selected) then
    begin
      if IsDir(Selected) or IsRoot(Selected) then
        //inplace rename of folder or root
        TreeView_EditLabel(Handle, Selected.ItemId)
      else
        //rename file
        DoRenameFileNode(Selected)
    end
    else
      MsgBeep;
end;

function TfmProj.IsRoot(Node: TTntTreeNode): boolean;
begin
  if Node=nil then
    raise Exception.Create('node nil');
  Result:= (Node.Parent=nil);
end;

function TfmProj.DoAddFile(Sel: TTntTreeNode; const fn: Widestring): TTntTreeNode;
var
  SCaption: Widestring;
begin
  Result:= nil;
  if Sel=nil then Exit;
  if IsFilenameListed(Sel, fn) then Exit;

  with TreeProj do
    begin
      SCaption:= GetFileNodeCaption(fn);
      if IsDir(Sel) then
        Result:= Items.AddChild(Sel, SCaption)
      else
        Result:= Items.Add(Sel, SCaption);

      with Result do
      begin
        ImageIndex:= GetImageIndex(fn);
        SelectedIndex:= ImageIndex;
        Data:= Pointer(FPathList.Add(fn));
      end;
    end;
  SetModified;
end;


function TfmProj.GetImageIndex(const fn: Widestring): integer;
var
  ext: string;
  useCache: boolean;
  N: Integer;
begin
  if not IsFileExist(fn) then
  begin
    Result:= cImgMissed;
    Exit
  end;
  if not FShellIcons then
  begin
    Result:= cImgFile;
    Exit
  end;

  ext:= LowerCase(WideExtractFileExt(fn));
  useCache:= (ext<>'') and not SFileExtensionMatch(fn, 'exe,lnk,dll,ocx,scr');

  if useCache then
    N:= FIcoList.IndexOf(ext)
  else
    N:= -1;  
  if (N>=0) then
    Result:= Integer(FIcoList.Objects[N])
  else
  begin
    GetIcon(fn, ImageList1);
    Result:= ImageList1.Count-1;
    FIcoList.AddObject(ext, TObject(Result));
  end;  
end;

procedure TfmProj.FormCreate(Sender: TObject);
begin
  FixImageList32bit(ImageList1);

  FMruList:= TSynMruList.Create;
  FShowPaths:= false;
  FShellIcons:= true; //todo
  FIcoList:= TStringList.Create;
  FPathList:= TTntStringList.Create;
  fmProgress:= nil;

  DoNewProject;
end;

procedure TfmProj.FormDestroy(Sender: TObject);
begin
  FreeAndNil(FMruList);
  FreeAndNil(FPathList);
  FreeAndNil(FIcoList);
end;

procedure TfmProj.TreeProjEditing(Sender: TObject; Node: TTreeNode;
  var AllowEdit: Boolean);
begin
  AllowEdit:= CanRename(TTntTreeNode(Node));
end;


(*
procedure TfmProj.MoveNode(TargetNode, SourceNode: TTntTreeNode);
var
  nodeTmp: TTntTreeNode;
  i: Integer;
begin
  with TreeProj do
  begin
    if IsDir(TargetNode) then
      nodeTmp:= Items.AddChild(TargetNode, SourceNode.Text)
    else
      nodeTmp:= Items.Add(TargetNode, SourceNode.Text);
  end;

  nodeTmp.ImageIndex:= SourceNode.ImageIndex;
  nodeTmp.SelectedIndex:= SourceNode.SelectedIndex;
  nodeTmp.Data:= SourceNode.Data;

  for i:= 0 to SourceNode.Count - 1 do
    MoveNode(nodeTmp, SourceNode.Item[i]);
end;
*)

function IsAltPressed: boolean;
begin
  Result:= GetKeyState(vk_menu) < 0;
end;

procedure TfmProj.TreeProjDragDrop(Sender, Source: TObject; X, Y: Integer);
var
  TargetNode, SourceNode: TTntTreeNode;
  Frame: TEditorFrame;
  List: TList;
  Str: Widestring;
  i: Integer;
begin
  //drag-drop of tab
  if (Source is TEditorFrame) then
  begin
    Frame:= Source as TEditorFrame;
    if Frame.IsFtp then
      begin MsgBeep; Exit end;
    Str:= Frame.FileName;
    if Str<>'' then
    begin
      TargetNode:= TreeProj.GetNodeAt(X, Y);
      if TargetNode<>nil then
        TreeProj.Selected:= TargetNode;
      DoAddFile(TreeProj.Selected, Str);
    end
    else
      MsgBeep;
    Exit;
  end;

  //drag-drop of another tree node
  with TreeProj do
  begin
    TargetNode:= GetNodeAt(X, Y);
    SourceNode:= Selected;
    if (TargetNode=nil) or IsRoot(SourceNode) then
    begin
      EndDrag(False);
      MsgBeep;
      Exit;
    end;

    List:= TList.Create;
    try
      for i:= 0 to SelectionCount-1 do
        List.Add(Selections[i]);

      if IsAltPressed or not IsDir(TargetNode) then
      begin
        if IsRoot(TargetNode) then
          MsgBeep
        else
        for i:= 0 to List.Count-1 do
        begin
          SourceNode:= List[i];
          SourceNode.MoveTo(TargetNode, naInsert);
        end;  
      end
      else
      begin
        for i:= 0 to List.Count-1 do
        begin
          SourceNode:= List[i];
          SourceNode.MoveTo(TargetNode, naAddChild);
        end;
      end;
    finally
      FreeAndNil(List);
    end;

    SetModified;    
  end;
end;

procedure TfmProj.TreeProjDragOver(Sender, Source: TObject; X, Y: Integer;
  State: TDragState; var Accept: Boolean);
{var
  Node: TTntTreeNode;
  P: TPoint;}
begin
  Accept:=
    ((Sender = TreeProj) and (Source = TreeProj))
    or (Source is TTntPageControl);

  //Application.MainForm.Caption:= (Source as TComponent).Name;
  {
  if Accept then
  begin
    Node:= TreeProj.GetNodeAt(X, Y);
    if Node=nil then Exit;
    if not (IsAltPressed or not IsDir(Node)) then Exit;
    P:= TreeProj.ScreenToClient(Point(X, Y));
    TreeProj.Canvas.Pen.Color:= clNavy;
    TreeProj.Canvas.MoveTo(20, P.Y);
    TreeProj.Canvas.MoveTo(TreeProj.Width-20, P.Y);
  end;
  }
end;


procedure TfmProj.TreeProjMouseMove(Sender: TObject; Shift: TShiftState; X,
  Y: Integer);
var
  Node: TTntTreeNode;
  P: TPoint;
begin
  P:= Point(X, Y);
  Node:= TreeProj.GetNodeAt(P.X, P.Y);
  if (Node<>nil) and not IsDir(Node) then
  begin
    TreeProj.Hint:= GetFN(Node);
    TimerHint.Interval:= cHintTimer;
    TimerHint.Enabled:= true;
  end
  else
  begin
    TreeProj.Hint:= '';
    TimerHint.Enabled:= false;
    Application.HideHint;
  end;
end;

procedure TfmProj.TimerHintTimer(Sender: TObject);
begin
  TimerHint.Enabled:= false;
  Application.ActivateHint(Mouse.CursorPos);
end;

function TfmProj.GetFN(Node: TTntTreeNode): Widestring;
var
  N: Integer;
begin
  Result:= '';
  if not IsDir(Node) then
  begin
    N:= Integer(Node.Data);
    if (N>=0) and (N<FPathList.Count) then
      Result:= FPathList[N]
    else
      raise Exception.Create('Bad FN index');
  end;
end;

procedure TfmProj.DoOpenFiles;
var
  L: TTntStringList;
  i: Integer;
begin
  if Assigned(FOnFileOpen) then
    with TreeProj do
      if (SelectionCount>0) then
      begin
        L:= TTntStringList.Create;
        try
          for i:= 0 to SelectionCount-1 do
          begin
            if IsDir(Selections[i]) then
              AddFilesToList(L, Selections[i])
            else
              L.Add(GetFN(Selections[i]));
          end;    

          if L.Count>0 then
            FOnFileOpen(Self, L)
          else
            MsgBeep;  
        finally
          FreeAndNil(L);
        end;
      end;
end;

procedure TfmProj.TreeProjDblClick(Sender: TObject);
begin
  with TreeProj do
    if Selected<>nil then
      if not IsDir(Selected) then
        DoOpenFiles;
end;

procedure TfmProj.TBXItemProjOpenFilesClick(Sender: TObject);
begin
  DoOpenFiles;
end;

procedure TfmProj.AddFilesToList(L: TTntStringList; Node: TTntTreeNode);
var
  N: TTntTreeNode;
begin
  N:= Node.GetFirstChild;
  while N<>nil do
  begin
    if IsDir(N) then
      AddFilesToList(L, N)
    else
      L.Add(GetFN(N));
    N:= Node.GetNextChild(N);
  end;
end;

function TfmProj.IsFilenameListed(Node: TTntTreeNode; const fn: Widestring): boolean;
var
  N: TTntTreeNode;
begin
  Result:= false;

  if not IsDir(Node) then
    if Node.Parent<>nil then
    begin
      Result:= IsFilenameListed(Node.Parent, fn);
      Exit
    end;

  N:= Node.GetFirstChild;
  while N<>nil do
  begin
    if not IsDir(N) then
      if WideUpperCase(fn) = WideUpperCase(GetFN(N)) then
        begin Result:= true; Exit end;
    N:= Node.GetNextChild(N);
  end;
end;


procedure TfmProj.TBXItemProjNewClick(Sender: TObject);
begin
  DoNewProject;
end;

procedure TfmProj.DoRefresh;
var
  i: Integer;
begin
  Screen.Cursor:= crHourGlass;
  try
    with TreeProj do
    for i:= 0 to Items.Count-1 do
      if not IsDir(Items[i]) then
      begin
        Items[i].ImageIndex:= GetImageIndex(GetFN(Items[i]));
        Items[i].SelectedIndex:= Items[i].ImageIndex;
      end;
  finally
    Screen.Cursor:= crDefault;
  end;
end;

procedure TfmProj.TbxItemMnuAddFilesClick(Sender: TObject);
begin
  DoAddFiles;
end;

procedure TfmProj.TbxItemMnuAddVDirClick(Sender: TObject);
begin
  DoAddVirtualDir;
end;

procedure TfmProj.TbxItemMnuAddDirClick(Sender: TObject);
begin
  DoAddFilesDir;
end;

procedure TfmProj.DoAddFilesDir;
var
  S: Widestring;
  Node: TTntTreeNode;
begin
  S:= GetWorkDir;
  if WideSelectDirectory('', '', S) then
  begin
    Node:= TreeProj.Selected;
    DoAddDirDlg(S);
    DoUpdateSort(Node);
  end;
end;

procedure TfmProj.ShowProgress(M: TProgressType);
begin
  StopFind:= false;
  Application.MainForm.Enabled:= false;
  if not Assigned(fmProgress) then
    fmProgress:= TfmProgress.Create(Self);
  fmProgress.SetMode(M);
  fmProgress.Show;
end;

procedure TfmProj.HideProgress;
begin
  StopFind:= false;
  Application.MainForm.Enabled:= true;
  if Assigned(fmProgress) then
    FreeAndNil(fmProgress);
end;

function TfmProj.IsProgressStopped(Cnt, CntAll: integer): boolean;
var
  NPro: Integer;
begin
  Result:= StopFind;
  if Result then Exit;

  if Assigned(fmProgress) then
  begin
    NPro:= (TreeProj.Items.Count - FOldItemsCount) div 10 * 10;
    fmProgress.labCount.Caption:= IntToStr(NPro);
    fmProgress.Pro.Progress:= Int64(Cnt) * 100 div CntAll;
    Application.ProcessMessages;
  end;
  Result:= StopFind;
end;

function TfmProj.DoConfirmSort: boolean;
const
  cItems = 1000;
begin
  if FOpts.SortType=srNone then
    begin Result:= false; Exit end;
  if TreeProj.Items.Count - FOldItemsCount < cItems then
    begin Result:= true; Exit end;

  SMsgProjSortCfm:= DKLangConstW('zMSortProj');
  Result:= MsgConfirm(
    WideFormat(SMsgProjSortCfm, [cItems]),
    Handle);
end;

procedure TfmProj.DoAddDirDlg(const SDir: Widestring);
var
  SubDirs, NoBin: boolean;
  Node: TTntTreeNode;
begin
  with TfmProjAddDir.Create(nil) do
  try
    edDir.Text:= SDir;
    edInc.Text:= FOpts.MasksInclude;
    edExc.Text:= FOpts.MasksExclude;
    if ShowModal<>mrOk then Exit;
    FOpts.MasksInclude:= edInc.Text;
    FOpts.MasksExclude:= edExc.Text;
    SubDirs:= cbSubdir.Checked;
    NoBin:= cbNoBin.Checked;
  finally
    Free
  end;

  Screen.Cursor:= crHourGlass;
  TreeProj.Items.BeginUpdate;
  FOldItemsCount:= TreeProj.Items.Count;

  try
    ShowProgress(proAddFolders);
    Node:= DoAddDirWithSubdirs(
      DirForNode(TreeProj.Selected),
      SDir, SubDirs, NoBin,
      FOpts.MasksInclude, FOpts.MasksExclude);
    HideProgress;

    if (Node<>nil) and DoConfirmSort then
    begin
      ShowProgress(proSortFolders);
      DoSortDir(Node, true, FOpts.SortType);
      HideProgress;
      Node.Expand(false);
    end;
  finally
    HideProgress;
    TreeProj.Items.EndUpdate;
    Screen.Cursor:= crDefault;
  end;

  if Node<>nil then
  begin
    TreeProj.Selected:= Node;
    TreeProj.Selected.MakeVisible;
  end
  else
    MsgWarn(DKLangConstW('zMProjNotAdded'), Handle);
end;


function TfmProj.DoAddDirWithSubdirs(Node: TTntTreeNode; const SDir: Widestring;
  SubDirs, NoBinary: boolean; const ExtInc, ExtExc: string): TTntTreeNode;
var
  NodeDir: TTntTreeNode;
  Rec: TSearchRecW;
  fn: Widestring;
begin
  if IsProgressStopped(1, 1) then
    begin Result:= nil; Exit; end;
    
  NodeDir:= DoAddDir(Node, WideExtractFileName(SDir));

  FillChar(Rec, SizeOf(Rec), 0);
  if WideFindFirst(SDir+'\*.*', faAnyFile, Rec)=0 then
  repeat
    if (Rec.Name='.') or (Rec.Name='..') then Continue;
    fn:= SDir+'\'+Rec.Name;
    if (Rec.Attr and faDirectory)<>0 then
    begin
      if SubDirs then
        DoAddDirWithSubdirs(NodeDir, fn, SubDirs, NoBinary, ExtInc, ExtExc);
    end
    else
    begin
      if (ExtExc<>'') and SFileExtensionMatch(fn, ExtExc) then Continue;
      if (ExtInc<>'') and not SFileExtensionMatch(fn, ExtInc) then Continue;
      if NoBinary and not IsFileText(fn) then Continue;
      DoAddFile(NodeDir, fn);
    end;  
  until WideFindNext(Rec)<>0;
  WideFindClose(Rec);

  if NodeDir.GetFirstChild=nil then
    FreeAndNil(NodeDir);
  Result:= NodeDir;
end;

procedure TfmProj.TbxItemMnuRenameClick(Sender: TObject);
begin
  DoRename;
end;

procedure TfmProj.TbxItemMnuRemoveClick(Sender: TObject);
begin
  DoRemove;
end;

procedure TfmProj.DoOpenProject;
var
  fn: string;
begin
  ODProj.InitialDir:= GetProjDir;
  ODProj.FileName:= '';
  if not ODProj.Execute then Exit;

  if not FileExists(ODProj.FileName) then
    if not MsgConfirm(WideFormat(DKLangConstW('MCre'), [WideExtractFileName(ODProj.FileName)]), Handle) then Exit;

  SetProjDir(ExtractFileDir(ODProj.FileName));
  fn:= ODProj.FileName;
  DoLoadProjectFromFile(fn);
end;

procedure TfmProj.DoAddRecentItem(const fn: Widestring);
begin
  if fn<>'' then
  begin
    FMruList.AddItem(fn);
    DoUpdateMRU;
  end;
end;

procedure TfmProj.DoLoadProjectFromFile(const fn: Widestring);
var
  L: TStringList;
  i, j, n: integer;
  Level, LevelDir, SelItem: integer;
  S, SFolded: string;
  SName: Widestring;
  dir: boolean;
  Node, NodeDir: TTntTreeNode;
begin
  DoNewProject;
  FProjectFN:= fn;
  DoAddRecentItem(fn);

  NodeDir:= RootNode;
  LevelDir:= -1;

  //1) load project options
  with TIniFile.Create(fn) do
  try
    FOpts.WorkDir:= DoExpandFN(UTF8Decode(ReadString('Ini', 'WorkDir', '')));
    FOpts.MainFN:= DoExpandFN(UTF8Decode(ReadString('Ini', 'MainFile', '')));
    FOpts.DefLexer:= ReadString('Ini', 'DefLexer', '');
    FOpts.DefLineEnds:= ReadInteger('Ini', 'DefLineEnds', 0);
    FOpts.DefEnc:= ReadInteger('Ini', 'DefEnc', 0);
    FOpts.SortType:= TProjSort(ReadInteger('Ini', 'SortType', Ord(srExt)));
    FOpts.SearchDirs:= UTF8Decode(ReadString('Ini', 'SearchDirs', ''));
    FOpts.UserVars:= UTF8Decode(ReadString('Ini', 'UserVars', ''));
    FOpts.MasksInclude:= UTF8Decode(ReadString('Ini', 'MasksInc', UTF8Encode(FOpts.MasksInclude)));
    FOpts.MasksExclude:= UTF8Decode(ReadString('Ini', 'MasksExc', UTF8Encode(FOpts.MasksExclude)));

    SFolded:= ReadString('Ini', 'Folded', '');
    SelItem:= ReadInteger('Ini', 'SelItem', 0);
  finally
    Free
  end;

  //2) load project tree
  Screen.Cursor:= crHourGlass;
  TreeProj.Items.BeginUpdate;
  L:= TStringList.Create;
  try
    FReadIniSection(fn, 'Nodes', L);
    for i:= 0 to L.Count-1 do
    begin
      S:= L[i];
      n:= Pos('\', S);
      if n=0 then Continue;
      Level:= n-1;
      Delete(S, 1, n);
      if S='' then Continue;
      dir:= S[1]=':';
      if dir then Delete(S, 1, 1);
      SName:= UTF8Decode(S);

      //new item is deeper than NodeDir
      if Level>LevelDir then
      begin
        if (Level-LevelDir)>1 then
          MsgError('Bad level for node in project-file:'#13+L[i], Handle);
        Node:= NodeDir;
      end
      else
      begin
        //new item is at same level or higher than NodeDir
        Node:= NodeDir;
        for j:= 1 to (LevelDir-Level)+1 do
        begin
          Node:= Node.Parent;
          if Node=nil then Break;
        end;
      end;
      if Node=nil then Continue;
      if dir then
      begin
        NodeDir:= DoAddDir(Node, SName, false);
        LevelDir:= Level;
      end
      else
        DoAddFile(Node, DoExpandFN(SName));
    end;
  finally
    FreeAndNil(L);
    Screen.Cursor:= crDefault;
    TreeProj.Items.EndUpdate;
  end;

  //2b) expand needed tree nodes
  RootNode.Expand(false);
  SetCollapsedList(SFolded);

  if SelItem>=0 then
    TreeProj.Selected:= TreeProj.Items[SelItem]
  else
    TreeProj.Selected:= RootNode;
  TreeProj.Selected.MakeVisible;

  //3) load project tools
  DoTool_LoadList(FProjectTools, fn, 'Tools');

  //finalize
  FModified:= false;
  UpdateTitle;

  if Assigned(FOnProjectOpen) then
    FOnProjectOpen(Self);
end;

procedure TfmProj.DoSaveProjectIfNeeded;
begin
  if FModified then
    if FProjectFN<>'' then
      DoSaveProjectToFile(FProjectFN);
end;

procedure TfmProj.DoSaveProject;
begin
  if FProjectFN<>'' then
    DoSaveProjectToFile(FProjectFN)
  else
    DoSaveProjectAs;

  if FProjectFN<>'' then
    DoAddRecentItem(FProjectFN);
end;

procedure TfmProj.DoSaveProjectAs;
begin
  SDProj.InitialDir:= GetProjDir;
  SDProj.FileName:= '';
  if not SDProj.Execute then Exit;
  SetProjDir(ExtractFileDir(SDProj.FileName));
  DoSaveProjectToFile(SDProj.FileName);
  DoAddRecentItem(SDProj.FileName);
end;

procedure TfmProj.DoSaveProjectToFile(const fn: string);
var
  List, ListNodes: TStringList;
  //
  procedure Write(const Id, S: string);
  begin
    List.Add(Id+'='+S);
  end;
  //
const
  cUtfSign = #$EF#$BB#$BF;
begin
  FProjectFN:= fn;
  FModified:= false;
  UpdateTitle;

  List:= TStringList.Create;
  try
    List.Add(cUtfSign);
    List.Add('[Ini]');
    Write('WorkDir', UTF8Encode(DoCollapseFN(FOpts.WorkDir)));
    Write('MainFile', UTF8Encode(DoCollapseFN(FOpts.MainFN)));
    Write('DefLexer', FOpts.DefLexer);
    Write('DefLineEnds', IntToStr(FOpts.DefLineEnds));
    Write('DefEnc', IntToStr(FOpts.DefEnc));
    Write('SortType', IntToStr(Ord(FOpts.SortType)));
    Write('SearchDirs', UTF8Encode(FOpts.SearchDirs));
    Write('UserVars', UTF8Encode(FOpts.UserVars));

    Write('MasksInc', UTF8Encode(FOpts.MasksInclude));
    Write('MasksExc', UTF8Encode(FOpts.MasksExclude));

    Write('Folded', GetCollapsedList);
    if TreeProj.Selected<>nil then
      Write('SelItem', IntToStr(TreeProj.Selected.AbsoluteIndex))
    else
      Write('SelItem', '0');

    List.Add('');
    List.Add('[Nodes]');

    ListNodes:= TStringList.Create;
    try
      DoWriteNodesToList(ListNodes, RootNode, 0);
      List.AddStrings(ListNodes);
    finally
      FreeAndNil(ListNodes);
    end;
        
    List.SaveToFile(fn);
  finally
    FreeAndNil(ListNodes);
    FreeAndNil(List);
  end;

  DoTool_SaveList(FProjectTools, fn, 'Tools');
end;

function TfmProj.DoCollapseFN(const fn: Widestring): Widestring;
var
  dir: Widestring;
begin
  Result:= fn;
  dir:= WideExtractFilePath(FProjectFN);
  if SBegin(WideLowerCase(fn), WideLowerCase(dir)) then
  begin
    Delete(Result, 1, Length(dir));
    Insert(cProjVar+'\', Result, 1);
  end;
end;

function TfmProj.DoExpandFN(const fn: Widestring): Widestring;
var
  dir: Widestring;
begin
  Result:= fn;
  if SBegin(Result, cProjVar) then
  begin
    dir:= WideExcludeTrailingBackslash(WideExtractFileDir(FProjectFN));
    SReplaceW(Result, cProjVar, dir);
  end;
end;


procedure TfmProj.DoWriteNodesToList(L: TStringList; Node: TTntTreeNode; Level: integer);
var
  N: TTntTreeNode;
  pre: string;
begin
  pre:= StringOfChar('.', Level)+'\';
  N:= Node.GetFirstChild;
  while N<>nil do
  begin
    if IsDir(N) then
    begin
      L.Add(pre+':'+UTF8Encode(N.Text));
      DoWriteNodesToList(L, N, Level+1);
    end
    else
      L.Add(pre+UTF8Encode(DoCollapseFN(GetFN(N))));

    N:= Node.GetNextChild(N);
  end;
end;

procedure TfmProj.TBXItemProjOpenClick(Sender: TObject);
begin
  DoOpenProject;
end;

procedure TfmProj.TBXItemProjSaveClick(Sender: TObject);
begin
  DoSaveProject;
end;

procedure TfmProj.PopupProjPopup(Sender: TObject);
var
  pr, dir: boolean;
begin
  pr:= IsRoot(TreeProj.Selected);
  dir:= IsDir(TreeProj.Selected);

  TbxItemMnuProjOpen.Visible:= pr;
  TbxItemMnuProjSave.Visible:= pr;
  TbxItemMnuProjSaveAs.Visible:= pr;
  TbxItemMnuProjClose.Visible:= pr;
  TbxItemMnuProjProp.Visible:= pr;
  TbxItemMnuProjUpdate.Visible:= pr;

  TbxItemMnuRename.Enabled:= not pr;
  TbxItemMnuRemove.Enabled:= not pr;
  TbxItemMnuSetMain.Enabled:= not dir;
  TbxItemMnuProps.Enabled:= not dir;
  TbxItemMnuExpand.Enabled:= dir;
  TbxItemMnuCollapse.Enabled:= dir;

  TBXItemMnuTogglePaths.Checked:= FShowPaths;
end;

procedure TfmProj.TreeProjContextPopup(Sender: TObject; MousePos: TPoint;
  var Handled: Boolean);
var
  Node: TTntTreeNode;
begin
  Node:= TreeProj.GetNodeAt(MousePos.X, MousePos.Y);
  if Node<>nil then
    TreeProj.Selected:= Node;
end;

procedure TfmProj.TBXItemMnuProjPropClick(Sender: TObject);
begin
  DoConfigProject;
end;

procedure TfmProj.TBXItemProjPropClick(Sender: TObject);
begin
  DoConfigProject;
end;

procedure TfmProj.DoConfigProject;
var
  L: TTntStringList;
begin
  with TfmProjProps.Create(nil) do
  try
    SMsgProjDefault:= DKLangConstW('zDefault');
    cbEnc.Items.Insert(0, SMsgProjDefault);
    cbEnds.Items.Insert(0, SMsgProjDefault);
    cbLexer.Items.Insert(0, '  '+SMsgProjDefault);

    L:= TTntStringList.Create;
    try
      if Assigned(FOnGetLexers) then
        FOnGetLexers(Self, L);
      cbLexer.Items.AddStrings(L);
    finally
      FreeAndNil(L);
    end;

    Caption:= Caption+' - '+ProjectTitle;
    if FOpts.DefLexer='' then
      cbLexer.ItemIndex:= 0
    else
      cbLexer.ItemIndex:= cbLexer.Items.IndexOf(FOpts.DefLexer);
    cbEnds.ItemIndex:= FOpts.DefLineEnds;
    cbEnc.ItemIndex:= FOpts.DefEnc;
    edWorkDir.Text:= FOpts.WorkDir;
    edMainFN.Text:= FOpts.MainFN;
    cbSort.ItemIndex:= Ord(FOpts.SortType);
    SStringToList(FOpts.SearchDirs, edDirs.Lines);
    SStringToList(FOpts.UserVars, edVars.Lines);

    if ShowModal=mrOk then
    begin
      SetModified;
      if cbLexer.ItemIndex>0 then
        FOpts.DefLexer:= cbLexer.Text
      else
        FOpts.DefLexer:= '';
      FOpts.DefLineEnds:= cbEnds.ItemIndex;
      FOpts.DefEnc:= cbEnc.ItemIndex;
      FOpts.WorkDir:= edWorkDir.Text;
      FOpts.SortType:= TProjSort(cbSort.ItemIndex);
      SListToString(edDirs.Lines, FOpts.SearchDirs);
      SListToString(edVars.Lines, FOpts.UserVars);
    end;
  finally
    Free;
  end;
end;

procedure TfmProj.TBXItemMnuOpenFilesClick(Sender: TObject);
begin
  DoOpenFiles;
end;

procedure TfmProj.TBXItemMnuProjOpenClick(Sender: TObject);
begin
  DoOpenProject;
end;

procedure TfmProj.TBXItemMnuProjSaveClick(Sender: TObject);
begin
  DoSaveProject;
end;

procedure TfmProj.TBXItemMnuProjSaveAsClick(Sender: TObject);
begin
  DoSaveProjectAs;
end;

procedure TfmProj.TBXItemMnuProjCloseClick(Sender: TObject);
begin
  DoNewProject;
end;

function TfmProj.RootNode: TTntTreeNode;
begin
  Result:= TreeProj.Items.GetFirstNode;
end;
  
procedure TfmProj.UpdateTitle;
var
  S: Widestring;
begin
  Caption:= FProjectFN;
  if FProjectFN='' then
    S:= SMsgProjNew
  else
    S:= ExtractFileName(FProjectFN);
  if Modified then
    S:= S+' *';
  RootNode.Text:= S;
end;

function TfmProj.CanRename(Node: TTntTreeNode): boolean;
begin
  Result:= (Node<>nil) and IsDir(Node) and not IsRoot(Node);
end;

procedure TfmProj.TBXItemProjAddFilesDirClick(Sender: TObject);
begin
  DoAddFilesDir;
end;

procedure TfmProj.TBXItemMnuAddCurrFileClick(Sender: TObject);
begin
  DoAddEditorFiles(false);
end;

procedure TfmProj.TBXItemMnuAddOpenedFilesClick(Sender: TObject);
begin
  DoAddEditorFiles(true);
end;

procedure TfmProj.DoAddEditorFiles(All: boolean);
var
  L: TTntStringList;
  i: integer;
begin
  L:= TTntStringList.Create;
  try
    if not All then
    begin
      if Assigned(FOnAddEditorFile) then
        FOnAddEditorFile(Self, L);
    end
    else
    begin
      if Assigned(FOnAddEditorFilesAll) then
        FOnAddEditorFilesAll(Self, L);
    end;

    with TreeProj do
    begin
      for i:= 0 to L.Count-1 do
        DoAddFile(Selected, L[i]);
      if IsDir(Selected) then
        Selected.Expand(false);
     end;   
  finally
    FreeAndNil(L);
  end;
end;

procedure TfmProj.TBXItemMnuSetMainClick(Sender: TObject);
begin
  with TreeProj do
    if Selected<>nil then
      if not IsDir(Selected) then
      begin
        FOpts.MainFN:= GetFN(Selected);
        DoUpdateNodeCaptions;
        SetModified;
      end;
end;

//----------
var
  _SortMode: TProjSort = srName;
  _SortForm: TfmProj = nil;

function _NodeCompare(Item1, Item2: Pointer): Integer;
var
  N1, N2: TTntTreeNode;
  s1, s2, ext1, ext2: Widestring;
  Dir1, Dir2: boolean;
  fn1, fn2: Widestring;
  size1, size2: Int64;
  date1, date2: TDateTime;
begin
  N1:= TTntTreeNode(Item1);
  N2:= TTntTreeNode(Item2);
  s1:= N1.Text;
  s2:= N2.Text;
  Dir1:= IsDir(N1);
  Dir2:= IsDir(N2);
  if Dir1 then ext1:= '' else ext1:= WideExtractFileExt(s1);
  if Dir2 then ext2:= '' else ext2:= WideExtractFileExt(s2);

  if Dir1 and not Dir2 then Result:= -1 else
   if not Dir1 and Dir2 then Result:= 1 else
    if not Dir1 then
    begin
      //compare files
      case _SortMode of
      srName:
        Result:= WStrIComp(PWChar(s1), PWChar(s2));
      srExt:
        begin
          Result:= WStrIComp(PWChar(ext1), PWChar(ext2));
          if Result=0 then
            Result:= WStrIComp(PWChar(s1), PWChar(s2));
        end;
      srSize,
      srSizeDesc:
        begin
          fn1:= _SortForm.GetFN(N1);
          fn2:= _SortForm.GetFN(N2);
          size1:= FGetFileSize(fn1);
          size2:= FGetFileSize(fn2);
          Result:= Integer(size1-size2);
          if _SortMode=srSizeDesc then
            Result:= -Result;
        end;
      srDate,
      srDateDesc:
        begin
          fn1:= _SortForm.GetFN(N1);
          fn2:= _SortForm.GetFN(N2);

          if IsFileExist(fn1) then
            date1:= FileDateToDateTime(WideFileAge(fn1))
          else
            date1:= 0;
          if IsFileExist(fn2) then
            date2:= FileDateToDateTime(WideFileAge(fn2))
          else
            date2:= 0;

          if date1<date2 then Result:= -1 else
           if date1>date2 then Result:= 1 else
            Result:= 0;
          if _SortMode=srDateDesc then
            Result:= -Result;
        end;
      srFullPath:
        begin
          fn1:= _SortForm.GetFN(N1);
          fn2:= _SortForm.GetFN(N2);
          Result:= WStrIComp(PWChar(fn1), PWChar(fn2));
        end;
      else
        Result:= 0;
      end;
    end
    else
    begin
      //compare dirs
      case _SortMode of
      srNone:
        Result:= 0;
      else
        Result:= WStrIComp(PWChar(s1), PWChar(s2));
      end;
    end;
end;

procedure TfmProj.DoSortDir(Node: TTntTreeNode; Subdirs: boolean; SortType: TProjSort);
var
  N: TTntTreeNode;
  L: TList;
  i: Integer;
begin
  if IsProgressStopped(Node.AbsoluteIndex, TreeProj.Items.Count) then
    Exit;

  L:= TList.Create;
  try
    N:= Node.GetFirstChild;

    while N<>nil do
    begin
      if IsProgressStopped(N.AbsoluteIndex, TreeProj.Items.Count) then
        Exit;
      if IsDir(N) and Subdirs then
        DoSortDir(N, Subdirs, SortType);
      L.Add(N);
      N:= Node.GetNextChild(N);
    end;

    if StopFind then
      Exit;

    _SortMode:= SortType;
    _SortForm:= Self;
    L.Sort(_NodeCompare);

    for i:= 0 to L.Count-1 do
      if i<Node.Count then
        TTntTreeNode(L[i]).MoveTo(Node.Item[i], naInsert);
  finally
    FreeAndNil(L);
  end;
  
  SetModified;
end;

procedure TfmProj.DoSortBy(Mode: TProjSort);
begin
  with TreeProj do
    if Selected<>nil then
    try
      Screen.Cursor:= crHourGlass;
      DoSortDir(DirForNode(Selected), false, Mode);
    finally  
      Screen.Cursor:= crDefault;
      Selected.MakeVisible;
    end;
end;

procedure TfmProj.TBXItemMnuSortByNameClick(Sender: TObject);
begin
  DoSortBy(srName);
end;

procedure TfmProj.TBXItemMnuSortByExtClick(Sender: TObject);
begin
  DoSortBy(srExt);
end;

procedure TfmProj.TBXItemMnuExpandClick(Sender: TObject);
begin
  with TreeProj do
    if Selected<>nil then
    begin
      Selected.Expand(true);
      Selected.MakeVisible;
    end;
end;

procedure TfmProj.TBXItemMnuCollapseClick(Sender: TObject);
begin
  with TreeProj do
    if Selected<>nil then
    begin
      Selected.Collapse(true);
      Selected.MakeVisible;
    end;
end;


procedure TfmProj.DoDropItem(const fn: Widestring);
var
  Node: TTntTreeNode;
begin
  with TreeProj do
    if Selected<>nil then
      if IsFileExist(fn) then
      begin
        Node:= DoAddFile(Selected, fn);
        if Node<>nil then
          Node.MakeVisible;
      end
      else
      if IsDirExist(fn) then
        DoAddDirDlg(fn);
end;


procedure TfmProj.TreeProjEdited(Sender: TObject; Node: TTntTreeNode;
  var S: WideString);
begin
  SetModified;
end;

procedure TfmProj.SetModified;
begin
  FModified:= true;
  UpdateTitle;
end;

function TfmProj.DoConfirmClose(ClearModified: boolean): boolean;
var
  fn, msg: Widestring;
  res: Integer;
begin
  Result:= true;
  if not Modified then Exit;

  if FProjectFN='' then
    fn:= SMsgProjNew
  else
    fn:= WideExtractFileName(FProjectFN);

  SMsgProjSaveCfm:= DKLangConstW('zMSaveProj');
  msg:= WideFormat(SMsgProjSaveCfm, [fn]);
  res:= MsgConfirmYesNoCancel(msg, Handle, true);

  case res of
    id_yes: DoSaveProject;
    id_cancel: begin Result:= false; Exit end;
  end;  

  if ClearModified then
    FModified:= false;
end;

function TfmProj.GetWorkDir: Widestring;
var
  L: TTntStringList;
begin
  Result:= FOpts.WorkDir;
  
  if Result='' then
    if Assigned(FOnGetWorkDir) then
    begin
      L:= TTntStringList.Create;
      try
        FOnGetWorkDir(Self, L);
        if L.Count>0 then
          Result:= L[0];
      finally
        FreeAndNil(L);
      end;
    end;

  if Result='' then
    Result:= GetProjDir;  
end;

function TfmProj.GetProjDir: Widestring;
var
  L: TTntStringList;
begin
  Result:= '';
  if Assigned(FOnGetProjDir) then
  begin
    L:= TTntStringList.Create;
    try
      FOnGetProjDir(Self, L);
      if L.Count>0 then
        Result:= L[0];
    finally
      FreeAndNil(L);
    end;
  end;
end;

procedure TfmProj.SetProjDir(const Dir: string);
var
  L: TTntStringList;
begin
  if Assigned(FOnSetProjDir) then
  begin
    L:= TTntStringList.Create;
    try
      L.Add(Dir);
      FOnSetProjDir(Self, L);
    finally
      FreeAndNil(L);
    end;
  end;
end;

procedure TfmProj.DoUpdateSort(Node: TTntTreeNode);
begin
  if (Node<>nil) and (FOpts.SortType<>srNone) then
  begin
    if not IsDir(Node) then
      Node:= Node.Parent;
    DoSortDir(Node, false{SubDirs}, FOpts.SortType);
  end;
end;

procedure TfmProj.TBXItemMnuSortByDateClick(Sender: TObject);
begin
  DoSortBy(srDate);
end;

procedure TfmProj.TBXItemMnuSortBySizeClick(Sender: TObject);
begin
  DoSortBy(srSize);
end;

procedure TfmProj.TBXItemMnuSortByDateDescClick(Sender: TObject);
begin
  DoSortBy(srDateDesc);
end;

procedure TfmProj.TBXItemMnuSortBySizeDescClick(Sender: TObject);
begin
  DoSortBy(srSizeDesc);
end;

procedure TfmProj.TBXItemMnuPropsClick(Sender: TObject);
var
  fn: Widestring;
begin
  with TreeProj do
    if Selected<>nil then
      if not IsDir(Selected) then
      begin
        fn:= GetFN(Selected);
        if IsFileExist(fn) then
          FShowProperties(fn, Self.Handle)
        else
          MsgBeep;  
      end;
end;

procedure TfmProj.DoUpdateMRU;
begin
  if Assigned(FOnUpdateMRU) then
    FOnUpdateMRU(FMruList);
end;

procedure TfmProj.DoLoadMRU;
begin
  if Assigned(FOnLoadMRU) then
    FOnLoadMRU(FMruList);
end;

procedure TfmProj.TBXItemProjClearRecentClick(Sender: TObject);
begin
  FMruList.Items.Clear;
  DoUpdateMRU;
end;

procedure TfmProj.FormShow(Sender: TObject);
begin
  DoLoadMRU;
end;

procedure TfmProj.TBXItemProjOpenPopup(Sender: TTBCustomItem;
  FromLink: Boolean);
var
  i: Integer;
begin
  with TBXItemProjMRU do
  begin
    Clear;
    for i:= FMruList.Items.Count-1 downto 0 do
      MRUAdd(FMruList.Items[i]);
  end;    

  TBXItemProjClearRecent.Enabled:= FMruList.Items.Count>0;
end;

function TfmProj.GetCollapsedList: string;
var
  i: Integer;
begin
  Result:= '';
  for i:= 0 to TreeProj.Items.Count-1 do
    with TreeProj.Items[i] do
      if Expanded then
        Result:= Result+ IntToStr(i) + ',';
end;


procedure TfmProj.SetCollapsedList(S: Widestring);
var
  SItem: string;
  N: Integer;
begin
  TreeProj.Items.BeginUpdate;
  try
    repeat
      SItem:= SGetItem(S, ',');
      if SItem='' then Break;
      N:= StrToIntDef(SItem, -1);
      if (N>=0) and (N<TreeProj.Items.Count) then
        TreeProj.Items[N].Expanded:= true;
    until false;
  finally
    TreeProj.Items.EndUpdate;
  end;
end;

procedure TfmProj.TBXItemProjMRUClick(Sender: TObject;
  const Filename: WideString);
begin
  if IsFileExist(Filename) then
    DoLoadProjectFromFile(Filename)
  else
    MessageBeep(mb_iconerror);  
end;

procedure TfmProj.ReplaceUserVars(var SValue: Widestring;
  const AVarName: Widestring; var AVarValue: Widestring);
var
  S, SOption, SVarId, SVarValue: Widestring;
begin
  SOption:= FOpts.UserVars;
  AVarValue:= '';
  repeat
    S:= SGetItem(SOption, ';');
    if S='' then Break;
    SVarId:= SGetItem(S, '=');
    SVarValue:= SGetItem(S, '=');
    if SVarId='' then Continue;
    SReplaceAllW(SValue, '{'+SVarId+'}', SVarValue);
    if SVarId=AVarName then
      AVarValue:= SVarValue;
  until false;
end;

function TfmProj.GetUserVarValue(const AVarName: Widestring): Widestring;
var
  S: Widestring;
begin
  S:= '';
  ReplaceUserVars(S, AVarName, Result);
end;

procedure TfmProj.TBXItemMnuProjGotoClick(Sender: TObject);
begin
  if Assigned(FOnGotoProj) then
    FOnGotoProj(Self);
end;

procedure TfmProj.DoPreview(Toggle: boolean);
var
  fn: Widestring;
begin
  fn:= '';
  with TreeProj do
    if Selected<>nil then
      if not IsDir(Selected) then
        fn:= GetFN(Selected);

  if Assigned(FOnPreview) then
    FOnPreview(Self, fn, Toggle);
end;

procedure TfmProj.TreeProjChange(Sender: TObject; Node: TTreeNode);
begin
  DoPreview(false);
end;

function TfmProj.GetFileNodeCaption(const fn: Widestring): Widestring;
var
  SPath: Widestring;
begin
  if not FShowPaths then
    Result:= WideExtractFileName(fn)
  else
  begin
    Result:= fn;
    //if file path begins with project's path, trim it
    SPath:= WideExtractFilePath(FProjectFN);
    if SBegin(Result, SPath) then
      Delete(Result, 1, Length(SPath)-1);
  end;

  if fn=FOpts.MainFN then
    Result:= Result+cMainMark;
end;

procedure TfmProj.DoUpdateNodeCaptions;
var
  i: Integer;
begin
  with TreeProj do
    for i:= 0 to Items.Count-1 do
      if not IsDir(Items[i]) then
        Items[i].Text:= GetFileNodeCaption(GetFN(Items[i]));
end;

procedure TfmProj.DoToggleShowPaths;
begin
  FShowPaths:= not FShowPaths;
  DoUpdateNodeCaptions;
end;

procedure TfmProj.TBXItemMnuTogglePathsClick(Sender: TObject);
begin
  DoToggleShowPaths;
end;

procedure TfmProj.TBXItemMnuSortByPathClick(Sender: TObject);
begin
  DoSortBy(srFullPath);
end;

procedure TfmProj.DoRemoveFile(const fn: Widestring);
var
  i: Integer;
begin
  with TreeProj do
    for i:= Items.Count-1 downto 0 do
      if WideUpperCase(GetFN(Items[i])) = WideUpperCase(fn) then
      begin
        Items.Delete(Items[i]);
        SetModified;
      end;
end;

procedure TfmProj.DoRenameFile(const fn, fn_new: Widestring);
var
  i: Integer;
begin
  with TreeProj do
    for i:= 0 to Items.Count-1 do
      if WideUpperCase(GetFN(Items[i])) = WideUpperCase(fn) then
      begin
        FPathList[Integer(Items[i].Data)]:= fn_new;
        Items[i].Text:= GetFileNodeCaption(fn_new);
        SetModified;
      end;
end;

function TfmProj.IsDirSelected: boolean;
begin
  Result:= IsDir(TreeProj.Selected);
end;  


procedure TfmProj.TbxItemMnuTogglePreviewClick(Sender: TObject);
begin
  DoPreview(true);
end;

procedure TfmProj.TbxItemProjOptionsClick(Sender: TObject);
begin
  DoConfigProject;
end;

procedure TfmProj.TbxItemProjToolsClick(Sender: TObject);
begin
  DoConfigProjectTools;
end;

procedure TfmProj.DoConfigProjectTools;
var
  L: TTntStringList;
begin
  L:= TTntStringList.Create;
  try
    if Assigned(FOnGetLexers) then
      FOnGetLexers(Self, L);
    if DoTool_ConfigList(FProjectTools, Self, L, false,
      GetCurrentLexer,
      FDirToolsPresets,
      ProjectTitle
      ) then
    begin
      SetModified;
    end;
  finally
    FreeAndNil(L);
  end;
end;

function TfmProj.ProjectTitle: Widestring;
begin
  Result:= RootNode.Text;
end;

procedure TfmProj.UpdateProjectToolsMenu;
var
  i: Integer;
  Item: TSpTbxItem;
  SLexer: string;
begin
  SLexer:= GetCurrentLexer;

  with TbxItemProjProp do
    for i:= Count-1 downto 0 do
      if Items[i].Tag>0 then
        Items[i].Free;

  for i:= Low(TSynToolList) to High(TSynToolList) do
    with FProjectTools[i] do
      if ToolCaption<>'' then
      begin
        Item:= TSpTbxItem.Create(Self);
        Item.Caption:= ToolCaption;
        Item.Tag:= i;
        Item.OnClick:= DoRunProjectTool;
        Item.Enabled:= (ToolLexer='') or (SLexer=ToolLexer);
        TbxItemProjProp.Add(Item);
      end;
end;

procedure TfmProj.DoRunProjectTool(Sender: TObject);
var
  N: Integer;
begin
  N:= (Sender as TComponent).Tag;
  if (N>=Low(TSynToolList)) and (N<=High(TSynToolList)) then
  begin
    if Assigned(FOnRunTool) then
      FOnRunTool(FProjectTools[N]);
  end
  else
    MsgError('Incorrect tool index: '+IntToStr(N), Handle);
end;

function TfmProj.GetCurrentLexer: string;
var
  L: TTntStringList;
begin
  L:= TTntStringList.Create;
  try
    if Assigned(FOnGetLexer) then
      FOnGetLexer(Self, L);
    if L.Count>0 then
      Result:= L[0]
    else
      Result:= '';
  finally
    FreeAndNil(L);
  end;
end;

procedure TfmProj.TBXItemProjPropPopup(Sender: TTBCustomItem;
  FromLink: Boolean);
begin
  UpdateProjectToolsMenu;
end;

function TfmProj.GetRealDirFromDir(Node: TTntTreeNode): Widestring;
var
  N: TTntTreeNode;
begin
  Result:= '';
  N:= Node.GetLastChild;
  if N<>nil then
    if not IsDir(N) then
    begin
      Result:= WideExtractFileDir(GetFN(N));
      Result:= WideExcludeTrailingPathDelimiter(Result);
    end;
end;

function TfmProj.GetExtensionsMask: Widestring;
var
  List: TStringList;
  S: string;
  i: Integer;
begin
  Result:= '';
  List:= TStringList.Create;
  try
    List.Sorted:= true;
    List.Duplicates:= dupIgnore;

    with TreeProj do
      for i:= 0 to Items.Count-1 do
        if not IsDir(Items[i]) then
        begin
          S:= LowerCase(ExtractFileExt(GetFN(Items[i])));
          if S<>'' then
            if Pos(' ', S)=0 then
              List.Add(S);
        end;

    for i:= 0 to List.Count-1 do
      Result:= Result + '*' + List[i] + ' ';
  finally
    FreeAndNil(List);
  end;
end;  

procedure TfmProj.DoUpdateProject;
var
  Dir, Masks: Widestring;
  List: TTntStringList;
  i, j, FileCount: Integer;
begin
  FileCount:= 0;
  Masks:= GetExtensionsMask;
  //MsgInfo('masks: '+Masks, Handle);

  with TreeProj do
    for i:= Items.Count-1 downto 0 do
      if IsDir(Items[i]) then
      begin
        Dir:= GetRealDirFromDir(Items[i]);
        if Dir<>'' then
        begin
          //MsgInfo('Dir: '+Dir, Handle);
          List:= TTntStringList.Create;
          try
            FFindToList(List, Dir, Masks, '', false, false, false, false);
            for j:= 0 to List.Count-1 do
              if not IsFilenameListed(Items[i], List[j]) then
              begin
                DoAddFile(Items[i], List[j]);
                Inc(FileCount);
              end;
          finally
            FreeAndNil(List);
          end;
        end;
      end;

  if FileCount>0 then
    MsgInfo(WideFormat(DKLangConstW('zMProjUpdate'), [FileCount]), Handle)
  else
    MsgInfo(DKLangConstW('zMProjNotAdded'), Handle);      
end;


procedure TfmProj.TbxItemMnuProjUpdateClick(Sender: TObject);
begin
  DoUpdateProject;
end;

end.

