#
# linter.py
# Linter for SynLint
#
# Original by Jon Surrell
# Copyright (c) 2014 Jon Surrell
# Changed for SynLint by Alexey T.
#
# License: MIT
#

"""This module exports the Golint plugin class."""

import os
from SublimeLinter.lint import Linter, util

_exe = os.path.join(os.path.dirname(__file__), 'golint', 'golint.exe')

class GoLint(Linter):
    """Provides an interface to golint."""

    syntax = 'Go'
    cmd = (_exe, )
    regex = r'^.+:(?P<line>\d+):(?P<col>\d+):\s+(?P<message>.+)'
    tempfile_suffix = 'go'
    error_stream = util.STREAM_STDERR
