from sw import *
from .format_case import do_conv_string
from .format_case import MODE_SNAKE, MODE_UPPER, MODE_CAMEL, MODE_PAS, MODES_STR  


class Command:
    def do_conv(self, mode):
        x, y = ed.get_caret_xy()
        offset, length, text = ed.get_word(x, y)
        if text=='':
            msg_status('Place caret under a word');
            msg_box(BEEP_WARN)
            return
        text2 = do_conv_string(text, mode)
        if text==text2:
            msg_status('Word is already formatted: '+MODES_STR[mode]);
            msg_box(BEEP_WARN)
            return
            
        ed.replace(offset, length, text2)
        ed.set_caret_pos(offset)
        msg_status('Word formatted: '+MODES_STR[mode])
        

    def conv_snake(self):
        self.do_conv(MODE_SNAKE)
        
    def conv_upper(self):
        self.do_conv(MODE_UPPER)
        
    def conv_camel(self):
        self.do_conv(MODE_CAMEL)
        
    def conv_pascal(self):
        self.do_conv(MODE_PAS)
