#Author: Alexey (Synwrite)
#License: MIT

from sw import *

class Command:
    def run(self):
        p = ed.get_carets()
        if not p: 
            msg_box(MSG_WARN, 'Place several carets first')
            return

        s = dlg_input_ex(4, 'Carets numbering', 
          'Starting number:', '1', 
          'Digits:', '1',
          'Text before numbers:', '',
          'Text after numbers:', '')
        if not s: return
        try:
            n_start = int(s[0])
        except:
            msg_box(MSG_ERROR, 'Incorrect number entered: '+s[0])
            return
        try:
            n_len = int(s[1])
        except:
            msg_box(MSG_ERROR, 'Incorrect number entered: '+s[1])
            return
            
        text_before = s[2]
        text_after = s[3]
        
        p = [ed.xy_pos(l[0], l[1]) for l in p]
        p = sorted(p, reverse=True)
        
        ed.lock()
        for i, pos in enumerate(p):
            num = (len(p)-i+n_start-1)
            text = text_before + ('%0'+str(n_len)+'d') % num + text_after
            ed.replace(pos, 0, str(text))
        ed.unlock()
            
        msg_status('Inserted %d numbers' % len(p))
        