from sw import *

class Command:
    def __init__(self):
        self.color1 = 0x0000A0
        self.color2 = ed.get_prop(PROP_COLOR, PROP_COLOR_MARGIN)

    def maxlen(self, ed):
        nlen = 0
        for i in range(ed.get_line_count()):
            n1, n2 = ed.get_line_prop(i)
            x, y = ed.xy_log(n1, i)
            nlen = max(nlen, x)
        return nlen

    def run(self):
        msg_status('max len '+str(self.maxlen(ed)))
      
    def on_change_slow(self, ed):
        nlen = self.maxlen(ed)
        nmargin = ed.get_prop(PROP_MARGIN)
        color = self.color1 if nlen > nmargin else self.color2
        val = PROP_COLOR_MARGIN+','+str(color)
        ed.set_prop(PROP_COLOR, val)
