#Author: Alexey T
#License: MIT

import os
import string
from sw import *
from .pytils import numeral
from .getcaretword import *


def do_num_words(mode, rubles):
    chars = string.digits + ',.'
    nstart, nlen, text = do_get_word_caret(chars)
    if not text:
        msg_status('Place caret under number')
        msg_box(BEEP_WARN)
        return
                   
    try:            
        num = int(text)
    except:
        try:
            text = text.replace(',', '.')
            num = float(text)
        except:
            msg_status('Place caret under number')
            msg_box(BEEP_WARN)
            return

    if rubles:
        text = numeral.rubles(num)
    else:
        text = numeral.in_words(num)
    if not text: return

    if mode=='newtab':
        file_open('')
        ed.insert(text)
    elif mode=='replace':
        ed.set_caret_pos(nstart)
        ed.replace(nstart, nlen, text)
    else:
        raise Exception('Mode?')
            

class Command:
    def num_new_tab(self):
        do_num_words('newtab', False)
    def num_replace(self):
        do_num_words('replace', False)
    def rubles_new_tab(self):
        do_num_words('newtab', True)
    def rubles_replace(self):
        do_num_words('replace', True)
