from sw import *
from sw_cmd import *
import sys
import json
from urllib.request import urlopen
from urllib.parse import urlencode

URL_W3C = 'http://validator.w3.org/check'
URL_CSS = 'http://jigsaw.w3.org/css-validator/validator'

def do_validate(ed, format, validator_url):
    text = ed.get_text_all()
    params = {'fragment': text, 'doctype': format, 'output': 'json'}
    encoded_params = urlencode(params)
   
    encoded_params = encoded_params.encode('utf-8')
    output = urlopen(validator_url, encoded_params).read()
    output = output.decode('utf-8')
    results = json.loads(output)

    app_log(LOG_SET_PANEL, LOG_PANEL_VALIDATE)
    app_log(LOG_CLEAR, '')

    if not results['messages']:
        msg_box(MSG_INFO, 'Document successfully checked as %s' % format)
        return

    app_log(LOG_SET_REGEX, r'Line (\d+):.+')
    app_log(LOG_SET_LINE_ID, '1')
    app_log(LOG_SET_NAME_ID, '0')
    app_log(LOG_SET_FILENAME, ed.get_filename())
    app_log(LOG_SET_ZEROBASE, '0') 
    
    app_log(LOG_ADD, 'Errors found while checking document as %s:' % format)
    app_log(LOG_ADD, '')
    for message in results['messages']:
        app_log(LOG_ADD, 'Line %s: %s' % (message['lastLine'], message['message']))
        
    ed.focus()
    ed.cmd(cmd_ToggleFocusValidate)

class Command:
    def validate_html5(self):
        do_validate(ed, 'HTML5', URL_W3C)
    def validate_html4_strict(self):
        do_validate(ed, 'HTML 4.01 Strict', URL_W3C)
    def validate_html4_tran(self):
        do_validate(ed, 'HTML 4.01 Transitional', URL_W3C)
    def validate_svg(self):
        do_validate(ed, 'SVG 1.1', URL_W3C)
    def validate_svg_tiny(self):
        do_validate(ed, 'SVG 1.1 Tiny', URL_W3C)
    def validate_svg_basic(self):
        do_validate(ed, 'SVG 1.1 Basic', URL_W3C)
    def validate_css(self):
        do_validate(ed, 'css3', URL_CSS)
