#
# linter.py
# Linter for SynLint
#
# Original by Aparajita Fishman
# Copyright (c) 2013 Aparajita Fishman
# Change for SynLint: Alexey T.
#
# License: MIT
#

"""This module exports the Lua plugin class."""

from SublimeLinter.lint import Linter, util
import os

_exe = os.path.join(os.path.dirname(__file__), 'lua52', 'luac52.exe')

class Lua(Linter):
    """Provides an interface to luac -p."""

    syntax = 'Lua'
    cmd = (_exe, '-p', '*', '-')
    regex = r'^.+?:.+?:(?P<line>\d+): (?P<message>.+?(?:near (?P<near>\'.+\')|$))'
    error_stream = util.STREAM_STDERR
