(function() {
  var Autoprefixer, Browsers, Prefixes, autoprefixer, infoCache, isPlainObject, postcss,
    __slice = [].slice,
    __bind = function(fn, me){ return function(){ return fn.apply(me, arguments); }; };

  postcss = require('postcss');

  Browsers = require('./browsers');

  Prefixes = require('./prefixes');

  infoCache = null;

  isPlainObject = function(obj) {
    return Object.prototype.toString.apply(obj) === '[object Object]';
  };

  autoprefixer = function() {
    var options, reqs;
    reqs = 1 <= arguments.length ? __slice.call(arguments, 0) : [];
    if (reqs.length === 1 && isPlainObject(reqs[0])) {
      options = reqs[0];
      reqs = void 0;
    } else if (reqs.length === 0 || (reqs.length === 1 && (reqs[0] == null))) {
      reqs = void 0;
    } else if (reqs.length <= 2 && (reqs[0] instanceof Array || (reqs[0] == null))) {
      options = reqs[1];
      reqs = reqs[0];
    } else if (typeof reqs[reqs.length - 1] === 'object') {
      options = reqs.pop();
    }
    if ((options != null ? options.browsers : void 0) != null) {
      reqs = options.browsers;
    }
    return new Autoprefixer(autoprefixer.data, reqs, options);
  };

  autoprefixer.data = {
    browsers: require('../data/browsers'),
    prefixes: require('../data/prefixes')
  };

  Autoprefixer = (function() {
    function Autoprefixer(data, reqs, options) {
      this.data = data;
      this.reqs = reqs;
      this.options = options != null ? options : {};
      this.postcss = __bind(this.postcss, this);
    }

    Autoprefixer.prototype.process = function(str, options) {
      if (options == null) {
        options = {};
      }
      return postcss(this.postcss).process(str, options);
    };

    Autoprefixer.prototype.postcss = function(css) {
      var prefixes;
      prefixes = this.prefixes({
        from: css.source.input.file
      });
      if (this.options.remove !== false) {
        prefixes.processor.remove(css);
      }
      return prefixes.processor.add(css);
    };

    Autoprefixer.prototype.prefixes = function(opts) {
      var browsers;
      browsers = new Browsers(autoprefixer.data.browsers, this.reqs, opts);
      return new Prefixes(autoprefixer.data.prefixes, browsers, this.options);
    };

    Autoprefixer.prototype.info = function(opts) {
      infoCache || (infoCache = require('./info'));
      return infoCache(this.prefixes(opts));
    };

    return Autoprefixer;

  })();

  autoprefixer.loadDefault = function() {
    return this.defaultCache || (this.defaultCache = autoprefixer({
      browsers: this["default"]
    }));
  };

  autoprefixer.process = function(str, options) {
    if (options == null) {
      options = {};
    }
    return this.loadDefault().process(str, options);
  };

  autoprefixer.postcss = function(css) {
    return autoprefixer.loadDefault().postcss(css);
  };

  autoprefixer.info = function() {
    return this.loadDefault().info();
  };

  module.exports = autoprefixer;

}).call(this);
