"use strict";

var _get = function get(object, property, receiver) {
  var desc = Object.getOwnPropertyDescriptor(object, property);

  if (desc === undefined) {
    var parent = Object.getPrototypeOf(object);

    if (parent === null) {
      return undefined;
    } else {
      return get(parent, property, receiver);
    }
  } else if ("value" in desc && desc.writable) {
    return desc.value;
  } else {
    var getter = desc.get;
    if (getter === undefined) {
      return undefined;
    }
    return getter.call(receiver);
  }
};

var _inherits = function (child, parent) {
  if (typeof parent !== "function" && parent !== null) {
    throw new TypeError("Super expression must either be null or a function, not " + typeof parent);
  }
  child.prototype = Object.create(parent && parent.prototype, {
    constructor: {
      value: child,
      enumerable: false,
      writable: true,
      configurable: true
    }
  });
  if (parent) child.__proto__ = parent;
};

var Node = require("./node");

// CSS comment between declarations or rules
var Comment = (function () {
  var _Node = Node;
  var Comment = function Comment(defaults) {
    this.type = "comment";
    _get(Object.getPrototypeOf(Comment.prototype), "constructor", this).call(this, defaults);
  };

  _inherits(Comment, _Node);

  // Stringify declaration
  Comment.prototype.stringify = function (builder) {
    var before = this.style("before");
    if (before) builder(before);
    var left = this.style("left", "commentLeft");
    var right = this.style("right", "commentRight");
    builder("/*" + left + this.text + right + "*/", this);
  };

  return Comment;
})();

module.exports = Comment;