"use strict";

var _get = function get(object, property, receiver) {
  var desc = Object.getOwnPropertyDescriptor(object, property);

  if (desc === undefined) {
    var parent = Object.getPrototypeOf(object);

    if (parent === null) {
      return undefined;
    } else {
      return get(parent, property, receiver);
    }
  } else if ("value" in desc && desc.writable) {
    return desc.value;
  } else {
    var getter = desc.get;
    if (getter === undefined) {
      return undefined;
    }
    return getter.call(receiver);
  }
};

var _inherits = function (child, parent) {
  if (typeof parent !== "function" && parent !== null) {
    throw new TypeError("Super expression must either be null or a function, not " + typeof parent);
  }
  child.prototype = Object.create(parent && parent.prototype, {
    constructor: {
      value: child,
      enumerable: false,
      writable: true,
      configurable: true
    }
  });
  if (parent) child.__proto__ = parent;
};

var Node = require("./node");
var vendor = require("./vendor");

// CSS declaration like “color: black” in rules
var Declaration = (function () {
  var _Node = Node;
  var Declaration = function Declaration(defaults) {
    this.type = "decl";
    _get(Object.getPrototypeOf(Declaration.prototype), "constructor", this).call(this, defaults);
  };

  _inherits(Declaration, _Node);

  // Stringify declaration
  Declaration.prototype.stringify = function (builder, semicolon) {
    var before = this.style("before");
    if (before) builder(before);

    var between = this.style("between", "colon");
    var string = this.prop + between + this.stringifyRaw("value");

    if (this.important) {
      string += this._important || " !important";
    }

    if (semicolon) string += ";";
    builder(string, this);
  };

  return Declaration;
})();

module.exports = Declaration;