#
# linter.py
# Linter for SynLint
#
# Original by Jon Surrell
# Copyright (c) 2014 Jon Surrell
# Changed for SynLint by Alexey T.
#
# License: MIT
#

"""This module exports the Gotype plugin class."""

import os
from SublimeLinter.lint import Linter, util

_exe = os.path.join(os.path.dirname(__file__), 'gotype', 'gotype.exe')

class Gotype(Linter):
    """Provides an interface to gotype."""

    syntax = 'Go'
    cmd = (_exe, '-e')
    regex = r'^.+:(?P<line>\d+):(?P<col>\d+):\s+(?P<message>.+)'
    error_stream = util.STREAM_STDERR
