from sw import *
import os

EXT = '.synw-filestyles'

class Command:
    def on_open(self, ed):
        fn = ed.get_filename() + EXT
        if not os.path.isfile(fn): return
        with open(fn, 'r') as f:
            text = f.readline()
        if not text: return
        
        ed_caret, ed_len = ed.get_sel()
        items = text.split(';')
        for item in items:
            (n1, n2, nfont, nback, st) = item.split(',')
            ed.set_sel(int(n1), int(n2)-int(n1), True)
            ed.set_attr(ATTRIB_COLOR_FONT, int(nfont))
            ed.set_attr(ATTRIB_COLOR_BG, int(nback))
            if 'b' in st: ed.set_attr(ATTRIB_SET_BOLD, 0)
            if 'i' in st: ed.set_attr(ATTRIB_SET_ITALIC, 0)
            if 'u' in st: ed.set_attr(ATTRIB_SET_UNDERLINE, 0)
            if 's' in st: ed.set_attr(ATTRIB_SET_STRIKEOUT, 0)
        
        ed.set_sel(ed_caret, ed_len, True)    
        msg_status('Restored %d styled blocks' % len(items))
            

    def on_save(self, ed):
        fn = ed.get_filename() + EXT
        items = ed.get_attr()
        if not items:
            if os.path.isfile(fn):
                os.remove(fn)
            return    
            
        text = ';'.join(['%d,%d,%d,%d,%s' % tuple(item) for item in items])
        with open(fn, 'w') as f:
            f.write(text)
        msg_status('Saved file styles too')
        

                
