#Author: Alexey T. (Synwrite)
#License: MIT

import sys
import os
import shutil
import json
from sw import *
from . import format_proc
from .node_proc import *

format_proc.INI = 'syn_csscomb_options.json'
format_proc.MSG = '[CSScomb] '

ini = os.path.join(os.path.dirname(__file__), 'syn_csscomb_options.json')
ini0 = os.path.join(os.path.dirname(__file__), 'syn_csscomb_options.sample.json')
if os.path.isfile(ini0) and not os.path.isfile(ini):
    shutil.copyfile(ini0, ini)
             
tool_js = os.path.join(os.path.dirname(__file__), 'csscomb.js')

def get_syntax():
    lexer = ed.get_prop(PROP_LEXER_FILE)
    syntax = 'scss' if lexer=='SCSS' else 'less' if lexer=='LESS' else 'css'
    return syntax
    
def get_config():
    fn = format_proc.ini_filename()
    text = open(fn).read()
    j = json.loads(text)
    return json.dumps(j)

def do_format(text):
    return run_node(text, [tool_js, get_syntax(), get_config()]) 

class Command:
    def config_global(self):
        format_proc.config_global()

    def config_local(self):
        format_proc.config_local()

    def run(self):
        try:
            format_proc.run(do_format)
        except Exception as e:
            msg_box(MSG_ERROR, str(e))
