import subprocess

def run_node(text, params_list):
    startupinfo = subprocess.STARTUPINFO()
    startupinfo.dwFlags |= subprocess.STARTF_USESHOWWINDOW
    startupinfo.wShowWindow = subprocess.SW_HIDE
    enc = 'utf8'
    try:
        p = subprocess.Popen(['node'] + params_list, 
          startupinfo=startupinfo, 
          stdout=subprocess.PIPE, 
          stdin=subprocess.PIPE, 
          stderr=subprocess.PIPE)
    except OSError:
        raise Exception("Cannot find Node.js. Make sure it's in your PATH by running 'node -v' in command-line.")

    stdout, stderr = p.communicate(text.encode(enc))
    if stdout:
        return stdout.decode(enc)
    else:
        raise Exception('Error:\n' + stderr.decode(enc))
