#Author: Alexey (Synwrite)
#License: MIT

import os
import webbrowser
from sw import *
from .run_proc import *
from .profiles_list import *

fn_script = os.path.join(os.path.dirname(__file__), 'run.wsf')
fn_ini = os.path.join(app_ini_dir(), 'Syn.ini')
ini_section = 'Setup'
ini_key_profile = 'EmmetProfile'
text_quote = '%Q%'

lexers_xml = ['XML', 'XSL', 'XSLT']
lexers_css = ['CSS', 'SCSS', 'SASS', 'Sass', 'Stylus', 'LESS']

help_url = 'http://docs.emmet.io/cheat-sheet/'

def get_syntax():
    lexer = ed.get_prop(PROP_LEXER_CARET)
    if lexer in lexers_xml:
        return 'xsl'
    elif lexer in lexers_css: 
        return 'css'
    else:
        return 'html'
    
def get_profile():
    return ini_read(fn_ini, ini_section, ini_key_profile, profiles[0])
    

def do_find_abbrev():
    x, y = ed.get_caret_xy()
    text = ed.get_text_line(y)
    if not text: return
    text = text[:x]
    if not text: return

    try:
        return run_with_text('', [
            'cscript.exe',
            '/NoLogo',
            fn_script, 
            'extract', 
            text.replace('"', text_quote)
            ])
    except Exception as e:
        msg_box(MSG_ERROR, str(e))
        return
    

def do_expand_abbrev(text_ab):
    msg_status('Expanding: %s (profile %s)' % (text_ab, get_profile()))
        
    try:
        text = run_with_text('', [
            'cscript.exe',
            '/NoLogo',
            fn_script, 
            'expand', 
            text_ab.replace('"', text_quote), 
            get_syntax(), 
            get_profile()
            ])
    except Exception as e:
        msg_box(MSG_ERROR, str(e))
        return

    if not text or text=='?':
        msg_status('Cannot expand Emmet abbreviation: '+text_ab)
        return
        
    return text


class Command:
    def profiles(self):
        n = dlg_menu(MENU_SIMPLE, 'Emmet profiles', '\n'.join(profiles))
        if n is None: return
        item = profiles[n]
        ini_write(fn_ini, ini_section, ini_key_profile, item)

    def help(self):
        webbrowser.open_new_tab(help_url)
        msg_status('Opened browser')

    def wrap_abbrev(self):
        nstart, nlen = ed.get_sel()
        text_sel = ed.get_text_sel()
        if not nlen:
            msg_status('Text not selected')
            return
            
        text_ab = dlg_input('Emmet abbreviation:', 'div', '', '')
        if not text_ab:
            return
        
        text = do_expand_abbrev(text_ab)
        if not text: return
                                               
        text = text.replace('\n', '\r')
        text = text.replace('${0}', '${1}'+text_sel, 1)
        text = text.replace('${0}', '${2}', 1)
        text = text.replace('${0}', '${3}', 1)
        text = text.replace('${0}', '${4}', 1)
        text = text.replace('${0}', '${5}', 1)
        text = text.replace('${0}', '${6}', 1)
        text = text.replace('${0}', '${7}', 1)
        text = text.replace('${0}', '${8}', 1)
        text = text.replace('${0}', '${9}', 1)
        text = text.replace('${0}', '')
        
        ed.lock()
        ed.set_caret_pos(nstart)
        ed.replace(nstart, nlen, '')
        ed.insert_snippet(text)
        ed.unlock()
        

    def expand_abbrev(self):
        text_ab = do_find_abbrev()
        if not text_ab:
            msg_status('Cannot find Emmet abbreviation')
            msg_box(BEEP_WARN)
            return

        text = do_expand_abbrev(text_ab)
        if not text: return                                               

        text = text.replace('\n', '\r') #snippets need fixed \r 
        
        #replace first N tabstops with snippets tabstops, del others            
        text = text.replace('${0}', '${1}', 1)
        text = text.replace('${0}', '${2}', 1)
        text = text.replace('${0}', '${3}', 1)
        text = text.replace('${0}', '${4}', 1)
        text = text.replace('${0}', '${5}', 1)
        text = text.replace('${0}', '${6}', 1)
        text = text.replace('${0}', '${7}', 1)
        text = text.replace('${0}', '${8}', 1)
        text = text.replace('${0}', '${9}', 1)
        text = text.replace('${0}', '')
                                        
        nlen = len(text_ab)
        nstart = ed.get_caret_pos()-nlen
        
        ed.lock()
        ed.set_caret_pos(nstart)
        ed.replace(nstart, nlen, '')
        ed.insert_snippet(text)
        ed.unlock()
