#Author: Alexey T
#License: MIT

import os
import string
from sw import *
from .num2words import num2words, CONVERTER_CLASSES as langs
from .getcaretword import *

ini_fn = os.path.join(app_ini_dir(), 'Syn.ini')
ini_section = 'Setup'
ini_key_lang = 'NumToWordLang'


def do_num_words(mode):
    chars = string.digits + ',.'
    nstart, nlen, text = do_get_word_caret(chars)
    if not text:
        msg_status('Place caret under number')
        msg_box(BEEP_WARN)
        return
                   
    try:            
        num = int(text)
    except:
        try:
            text = text.replace(',', '.')
            num = float(text)
        except:
            msg_status('Place caret under number')
            msg_box(BEEP_WARN)
            return

    lang = ini_read(ini_fn, ini_section, ini_key_lang, 'en')

    text = num2words(num, lang=lang)
    if not text: return

    if mode=='newtab':
        file_open('')
        ed.insert(text)
    elif mode=='replace':
        ed.set_caret_pos(nstart)
        ed.replace(nstart, nlen, text)
    else:
        raise Exception('Mode?')
            

class Command:
    def num_new_tab(self):
        do_num_words('newtab')
    def num_replace(self):
        do_num_words('replace')

    def langs(self):
        items = sorted(list(langs.keys()))
        n = dlg_menu(MENU_SIMPLE, 'NumToWords language', '\n'.join(items))
        if n is None: return
        ini_write(ini_fn, ini_section, ini_key_lang, items[n])
