from sw import *
from .lorem import *
import string

prompt = '"4" for 4 sentences; "4p" for 4 paragraphs; "4t" for 4 paragraphs with tags'
max_count = 1000

class Command:
    def run(self):
        s = dlg_input(prompt, '', '', '')
        if not s: return
        is_tags = s.endswith('t')
        is_para = is_tags or s.endswith('p')
        
        try:
            count = int(s.strip(string.ascii_letters))
        except:
            msg_box(MSG_WARN, 'Incorrect input: '+s)
            return
           
        if count<1:
            msg_box(MSG_WARN, 'Incorrect number: '+str(count))
            return

        if count>max_count:
            msg_box(MSG_WARN, 'Too big number: '+str(count))
            return
            
        text = gettext(count, is_para, is_tags)
        ed.insert(text)
        
        msg = 'Inserted %d paragraphs' if is_para else 'Inserted %d sentences'
        msg_status(msg % count)
