from sw import *
import sys
import os
import shutil

from . import pyastyle
from . import format_proc

format_proc.INI = 'syn_astyle.cfg'
format_proc.MSG = '[AStyle Format] '

def options():
    ini = format_proc.ini_filename()
    if os.path.isfile(ini):
        s = open(ini).read()
    else:
        s = ''
    return s

def do_format(text):
    opt = options()
    #print('AStyle options:', opt)
    return pyastyle.format(text, opt)

class Command:
    def config_global(self):
        format_proc.config_global()

    def config_local(self):
        format_proc.config_local()

    def run(self):
        format_proc.run(do_format)
