import sys
import os
import json
import shutil

from sw import *
from . import format_proc
from .node_proc import *

ini = os.path.join(os.path.dirname(__file__), 'syn_autoprefixer_options.py')
ini0 = os.path.join(os.path.dirname(__file__), 'syn_autoprefixer_options.sample.py')
if os.path.isfile(ini0) and not os.path.isfile(ini):
    shutil.copyfile(ini0, ini)

js_path = os.path.join(os.path.dirname(__file__), 'autoprefixer.js')

format_proc.INI = 'syn_autoprefixer_options.py'
format_proc.MSG = '[CSS AutoPrefixer] '

def do_format(text):
    fn = format_proc.ini_filename()
    opt = eval(open(fn).read())
    opt = json.dumps(opt)
    return run_node(text, [js_path, opt])

class Command:
    def config_global(self):
        format_proc.config_global()

    def config_local(self):
        format_proc.config_local()

    def run(self):
        try:
            format_proc.run(do_format)
        except Exception as e:
            msg_box(MSG_ERROR, str(e))
