"use strict";

var _prototypeProperties = function (child, staticProps, instanceProps) {
  if (staticProps) Object.defineProperties(child, staticProps);
  if (instanceProps) Object.defineProperties(child.prototype, instanceProps);
};

var MapGenerator = require("./map-generator");

// Object with processed CSS
var Result = function Result(root) {
  var opts = arguments[1] === undefined ? {} : arguments[1];
  this.root = root;
  this.opts = opts;
};

// Return CSS string on any try to print
Result.prototype.toString = function () {
  return this.css;
};

// Generate CSS and map
Result.prototype.stringify = function () {
  var map = new MapGenerator(this.root, this.opts);
  var generated = map.generate();
  this.cssCached = generated[0];
  this.mapCached = generated[1];
};

_prototypeProperties(Result, null, {
  map: {

    // Lazy method to return source map
    get: function () {
      if (!this.cssCached) this.stringify();
      return this.mapCached;
    },
    enumerable: true
  },
  css: {

    // Lazy method to return CSS string
    get: function () {
      if (!this.cssCached) this.stringify();
      return this.cssCached;
    },
    enumerable: true
  }
});

module.exports = Result;