#
# linter.py
# Linter for SynLint
#
# Original: by Aparajita Fishman
# Copyright (c) 2015 The SublimeLinter Community
# Changed for SynLint: Alexey T
#
# License: MIT
#

"""This module exports the GJSLint plugin linter class."""

import os
from SublimeLinter.lint import Linter

_lint_dir = os.path.join(os.path.dirname(__file__), 'google_closure_linter')
_lint_bat = os.path.join(os.path.dirname(__file__), 'lint.bat')

class GJSLint(Linter):
    """Provides an interface to the gjslint."""

    syntax = 'JavaScript'
    cmd = (_lint_bat, _lint_dir)
    regex = r'^Line (?P<line>\d+), (?:(?P<error>E)|(?P<warning>W)):\d+: (?P<message>[^"]+(?P<near>"[^"]+")?.*$)'
    comment_re = r'\s*/[/*]'
    tempfile_suffix = 'js'
    defaults = {
        '--jslint_error:,+': '',
        '--disable:,': '',
        '--max_line_length:': None
    }
