#
# linter.py
# Linter for SynLint
#
# Original by Jon Surrell
# Copyright (c) 2014 Jon Surrell
# Change for SynLint: Alexey T
#
# License: MIT
#

"""This module exports the GoVet plugin class."""

from SublimeLinter.lint import Linter, util


class GoVet(Linter):
    """Provides an interface to go vet."""

    syntax = 'Go'
    cmd = ('go', 'tool', 'vet')
    regex = r'^.+:(?P<line>\d+):\s+(?P<message>.+)'
    tempfile_suffix = 'go'
    error_stream = util.STREAM_STDERR
