from sw import *

def do_jump(is_next):
    s = ed.get_prop(PROP_COL_MARKERS)
    if s:
        s = s.split(' ')
        s = list(map(int, s))
    else:
        s = []
        
    s += [0, ed.get_prop(PROP_MARGIN)]
    s = sorted(s)
    
    x, y = ed.get_caret_xy()
    
    if is_next:
        while s and s[0]<=x: del s[0]
        x = s[0] if s else -1
    else:
        while s and s[-1]>=x: del s[-1]
        x = s[-1] if s else -1
        
    if x<0:
        msg_status('Cannot jump to marker')
        msg_box(BEEP_WARN)
        return
        
    ed.set_caret_xy(x, y)
    msg_status('Jumped to column %d' % (x+1))
        

class Command:
    def set_markers(self):
        s = ed.get_prop(PROP_COL_MARKERS)
        s = dlg_input('Column markers (space separated):', s, 'SynHistory.ini', 'ColumnMarkers')
        if s is None: return 
        ed.set_prop(PROP_COL_MARKERS, s)
        ed_bro.set_prop(PROP_COL_MARKERS, s)

    def jump_left(self):
        do_jump(False)
    def jump_right(self):
        do_jump(True)
